/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCopyWithStrictTransformer;
import com.intellij.lang.javascript.psi.JSDocTextStringBuilder;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSExtendingTypeImpl;
import com.intellij.lang.javascript.psi.types.JSExternalGenericId;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    protected final List<JSRecordType.TypeMember> myAllTypeMembers;
    @NotNull
    protected final List<JSRecordType.CallSignature> myCallSignatures;
    @Nullable
    protected final JSRecordType.IndexSignature myStringIndexer;
    @Nullable
    protected final JSRecordType.IndexSignature myNumericIndexer;
    @NotNull
    protected final Map<String, JSRecordType.PropertySignature> myProperties;
    protected final boolean myIsWeakType;
    protected final List<JSRecordType.PropertySignature> myComputedProperties;

    protected JSRecordTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(1);
        }
        this(source2, JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.read(source2, inputStream));
    }

    public JSRecordTypeImpl(@NotNull JSTypeSource source2, @NotNull List<? extends JSRecordType.TypeMember> typeMembers) {
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(2);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(3);
        }
        super(source2);
        THashMap nameToPropertySignature = new THashMap();
        ArrayList<JSRecordType.TypeMember> allMembers = new ArrayList<JSRecordType.TypeMember>(typeMembers.size());
        JSRecordType.IndexSignature stringIndex = null;
        JSRecordType.IndexSignature numericIndex = null;
        ArrayList<JSRecordType.CallSignature> callSignatures = null;
        ArrayList<ComputedPropertySignatureImpl> computedProperties = null;
        TObjectIntHashMap propertyIndices = new TObjectIntHashMap();
        boolean isPossiblyWeak = true;
        int positionInAllMembers = -1;
        for (JSRecordType.TypeMember typeMember : typeMembers) {
            if (typeMember instanceof JSRecordType.PropertySignature) {
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
                if (!propertySignature.isOptional()) {
                    isPossiblyWeak = false;
                }
                if (propertySignature instanceof ComputedPropertySignatureImpl) {
                    if (computedProperties == null) {
                        computedProperties = new ArrayList<ComputedPropertySignatureImpl>();
                    }
                    computedProperties.add((ComputedPropertySignatureImpl)propertySignature);
                    ++positionInAllMembers;
                    allMembers.add(propertySignature);
                    continue;
                }
                String name = propertySignature.getMemberName();
                JSRecordType.PropertySignature storedSignature = (JSRecordType.PropertySignature)nameToPropertySignature.get(name);
                if (storedSignature != null) {
                    JSRecordType.PropertySignature mergedSignature = JSRecordTypeImpl.mergeSignatures(name, propertySignature, storedSignature, source2);
                    int index = propertyIndices.get((Object)name);
                    allMembers.set(index, mergedSignature);
                    nameToPropertySignature.put(name, mergedSignature);
                    continue;
                }
                nameToPropertySignature.put(name, propertySignature);
                propertyIndices.put((Object)name, positionInAllMembers + 1);
            } else {
                if (typeMember instanceof JSRecordType.IndexSignature) {
                    JSRecordType.IndexSignatureKind kind = ((JSRecordType.IndexSignature)typeMember).getIndexSignatureKind();
                    switch (kind) {
                        case NUMERIC: {
                            numericIndex = numericIndex == null ? (JSRecordType.IndexSignature)typeMember : numericIndex;
                            break;
                        }
                        case STRING: {
                            stringIndex = stringIndex == null ? (JSRecordType.IndexSignature)typeMember : stringIndex;
                            break;
                        }
                    }
                } else if (typeMember instanceof JSRecordType.CallSignature) {
                    if (callSignatures == null) {
                        callSignatures = new ArrayList<JSRecordType.CallSignature>();
                    }
                    callSignatures.add((JSRecordType.CallSignature)typeMember);
                }
                isPossiblyWeak = false;
            }
            ++positionInAllMembers;
            allMembers.add(typeMember);
        }
        this.myIsWeakType = isPossiblyWeak && !allMembers.isEmpty();
        this.myStringIndexer = stringIndex;
        this.myNumericIndexer = numericIndex;
        this.myCallSignatures = callSignatures == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(callSignatures);
        this.myAllTypeMembers = Collections.unmodifiableList(allMembers);
        this.myProperties = Collections.unmodifiableMap(nameToPropertySignature);
        this.myComputedProperties = computedProperties == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(computedProperties);
    }

    protected JSRecordTypeImpl(@NotNull JSTypeSource source2, @NotNull List<JSRecordType.TypeMember> allTypeMembers, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable JSRecordType.IndexSignature stringIndexer, @Nullable JSRecordType.IndexSignature numericIndexer, @NotNull Map<String, JSRecordType.PropertySignature> properties2, @NotNull List<JSRecordType.PropertySignature> computedProperties, boolean isWeakType) {
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(4);
        }
        if (allTypeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(5);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(6);
        }
        if (properties2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(7);
        }
        if (computedProperties == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(8);
        }
        super(source2);
        this.myAllTypeMembers = allTypeMembers;
        this.myCallSignatures = callSignatures;
        this.myStringIndexer = stringIndexer;
        this.myNumericIndexer = numericIndexer;
        this.myProperties = properties2;
        this.myComputedProperties = computedProperties;
        this.myIsWeakType = isWeakType;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(9);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.write(this.myAllTypeMembers, outputStream);
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeSignatures(@NotNull String name, @NotNull JSRecordType.PropertySignature newSignature, @NotNull JSRecordType.PropertySignature stored, @NotNull JSTypeSource source2) {
        boolean isReadonly;
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(10);
        }
        if (newSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(11);
        }
        if (stored == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(12);
        }
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(13);
        }
        boolean isOptional = newSignature.isOptional() && stored.isOptional();
        boolean bl = isReadonly = newSignature.isConst() && stored.isConst();
        if (stored instanceof JSCompositeFunctionPropertySignatureImpl) {
            return JSRecordTypeImpl.addPropertyToCompositeFunctions(name, (JSCompositeFunctionPropertySignatureImpl)stored, newSignature, source2, isOptional, isReadonly);
        }
        if (newSignature instanceof JSCompositeFunctionPropertySignatureImpl) {
            return JSRecordTypeImpl.addPropertyToCompositeFunctions(name, (JSCompositeFunctionPropertySignatureImpl)newSignature, stored, source2, isOptional, isReadonly);
        }
        if (stored instanceof JSFunctionItem && newSignature instanceof JSFunctionItem && (((JSFunctionItem)((Object)stored)).isGetProperty() && ((JSFunctionItem)((Object)newSignature)).isSetProperty() || ((JSFunctionItem)((Object)stored)).isSetProperty() && ((JSFunctionItem)((Object)newSignature)).isGetProperty())) {
            return JSRecordTypeImpl.mergeAccessors(name, stored, newSignature);
        }
        if (!(stored.getJSType() instanceof JSFunctionTypeImpl)) {
            JSRecordType.PropertySignature propertySignature = stored;
            if (propertySignature == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(14);
            }
            return propertySignature;
        }
        return new JSCompositeFunctionPropertySignatureImpl(name, ContainerUtil.newArrayList((Object[])new JSRecordType.PropertySignature[]{stored, newSignature}), isOptional, isReadonly, source2);
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeAccessors(String name, JSRecordType.PropertySignature getter, JSRecordType.PropertySignature setter) {
        return new PropertySignatureImpl(name, getter.getJSType(), getter.isOptional() && setter.isOptional(), false, JSRecordMemberSourceFactory.createSource(ContainerUtil.concat(getter.getMemberSource().getAllSourceElements(), setter.getMemberSource().getAllSourceElements()), JSRecordType.MemberSourceKind.MergedAccessor));
    }

    @NotNull
    private static JSRecordType.PropertySignature addPropertyToCompositeFunctions(@NotNull String name, @NotNull JSCompositeFunctionPropertySignatureImpl composite, @NotNull JSRecordType.PropertySignature newProperty, @NotNull JSTypeSource source2, boolean isOptional, boolean isReadonly) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(15);
        }
        if (composite == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(16);
        }
        if (newProperty == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(17);
        }
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(18);
        }
        List<JSRecordType.PropertySignature> members = composite.getMembers();
        ArrayList<JSRecordType.PropertySignature> list2 = new ArrayList<JSRecordType.PropertySignature>(members.size() + 1);
        list2.addAll(members);
        if (newProperty instanceof JSCompositeFunctionPropertySignatureImpl) {
            list2.addAll(((JSCompositeFunctionPropertySignatureImpl)newProperty).getMembers());
        } else {
            list2.add(newProperty);
        }
        return new JSCompositeFunctionPropertySignatureImpl(name, list2, isOptional, isReadonly, source2);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(20);
        }
        builder.append("{");
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript() && !(builder instanceof JSDocTextStringBuilder);
        String prefix = "";
        String nextPrefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        String separator = this.getTypeSeparator();
        char quote = this.getQuote();
        for (int i2 = 0; i2 < this.myAllTypeMembers.size(); ++i2) {
            JSRecordType.TypeMember typeMember = this.myAllTypeMembers.get(i2);
            builder.append(prefix);
            if (i2 > 10 && format == JSType.TypeTextFormat.PRESENTABLE) {
                builder.append("...");
                builder.append("}");
                return;
            }
            typeMember.appendMemberPresentation(format, builder, separator, quote);
            prefix = nextPrefix;
        }
        builder.append("}");
    }

    protected char getQuote() {
        String quote = JSSymbolPresentationProvider.getDefaultQuote(this.getSource().getSourceElement());
        return quote.charAt(0);
    }

    @Override
    protected final boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(21);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(22);
        }
        if (this.isTypeScript() && this.hasIndexers() && elementType instanceof JSPrimitiveType && ((JSPrimitiveType)elementType).isPrimitive()) {
            return false;
        }
        if (JSRecordTypeImpl.canSubstitute(elementType)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                return this.isDirectlyAssignableType(substitute, processingContext);
            }
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(elementType);
        }
        if (elementType instanceof JSArrayType) {
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(((JSArrayType)elementType).asGenericType());
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        if (!this.hasMembers() && elementType.isJavaScript()) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    private static JSType convertToRecordTypeIfPossible(@NotNull JSType elementType) {
        JSRecordType recordTypeCandidate;
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(23);
        }
        JSType jSType = (recordTypeCandidate = elementType.asRecordType()) == JSTypeCastUtil.NO_RECORD_TYPE ? elementType : recordTypeCandidate;
        if (jSType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    protected static boolean canSubstitute(@NotNull JSType elementType) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(25);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            return true;
        }
        return elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl || elementType instanceof JSAliasTypeImpl || elementType instanceof JSUnionOrIntersectionType || elementType instanceof JSExtendingTypeImpl;
    }

    private static boolean isObject(@NotNull JSRecordType recordType) {
        PsiElement sourceElement;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(26);
        }
        return (sourceElement = recordType.getSource().getSourceElement()) instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)sourceElement).getQualifiedName());
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        boolean rTypeWithCallSignatures;
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(27);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(28);
        }
        List<JSRecordType.CallSignature> rTypeCallSignatures = sourceType.getCallSignatures();
        boolean hasMembers = sourceType.hasMembers();
        boolean bl = rTypeWithCallSignatures = !rTypeCallSignatures.isEmpty();
        if (!this.checkWeakTypeCondition(sourceType, hasMembers)) {
            return false;
        }
        if (!this.checkCallSignatureExistence(rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkStringIndexerTypes(sourceType, processingContext)) {
            return false;
        }
        if (!this.checkNumericIndexerTypes(sourceType, processingContext)) {
            return false;
        }
        if (!this.checkPropertyTypes(sourceType, rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkCallSignatureTypes(processingContext, rTypeCallSignatures)) {
            return false;
        }
        return this.checkObjectLiteralProperties(sourceType, processingContext);
    }

    private boolean checkObjectLiteralProperties(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(30);
        }
        if (!JSRecordTypeImpl.isObjectLiteralType(this) || !JSRecordTypeImpl.isObjectType(sourceType) || processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) == null) {
            return true;
        }
        for (JSRecordType.PropertySignature property : sourceType.getProperties()) {
            JSType type;
            if (this.hasProperty(property.getMemberName()) || (type = property.getJSType()) instanceof JSUndefinedType) continue;
            return false;
        }
        return true;
    }

    private boolean checkWeakTypeCondition(@NotNull JSRecordType recordType, boolean hasMembers) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(31);
        }
        if (this.myIsWeakType && hasMembers && !JSRecordTypeImpl.isObject(recordType)) {
            Set<String> rNames = recordType.getPropertyNames();
            HashSet<String> lNames = new HashSet<String>(this.getPropertyNames());
            lNames.retainAll(rNames);
            if (lNames.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureExistence(boolean rTypeWithCallSignatures, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(32);
        }
        if (!this.myCallSignatures.isEmpty() && !rTypeWithCallSignatures) {
            JSTypeAssignableErrorMessage.addMessageToContext(processingContext, "javascript.no.call.signatures", new String[0]);
            return false;
        }
        return true;
    }

    private boolean checkPropertyTypes(@NotNull JSRecordType sourceType, boolean hasCallSignatures, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(33);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(34);
        }
        boolean subtyping = processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null && !JSRecordTypeImpl.isExpressionBasedType(sourceType);
        JSUndefinedType undefinedType = null;
        JSRecordType additionalMembers = null;
        ArrayList<PropertyTypeChecker> toCheck = null;
        Collection<JSRecordType.PropertySignature> properties2 = this.getProperties();
        for (JSRecordType.PropertySignature lProperty : properties2) {
            String lPropName = lProperty.getMemberName();
            JSRecordType.PropertySignature rProperty = sourceType.findPropertySignature(lPropName);
            if (rProperty == lProperty) continue;
            if (rProperty != null && rProperty.isOptional() && !lProperty.isOptional() && this.isTypeScript()) {
                return false;
            }
            if (rProperty == null && (!lProperty.isOptional() || subtyping)) {
                if (this.isJavaScript() && sourceType.isJavaScript()) {
                    if (undefinedType == null) {
                        undefinedType = new JSUndefinedType(sourceType.getSource());
                    }
                    if (JSRecordTypeImpl.isUndefinedProperty(lProperty, undefinedType, processingContext)) continue;
                }
                if (hasCallSignatures) {
                    if (additionalMembers == null) {
                        additionalMembers = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement());
                    }
                    if (additionalMembers != null && this.checkFunctionInterfaceProperties(processingContext, additionalMembers, lProperty)) continue;
                }
                return false;
            }
            if (rProperty == null) continue;
            JSType rType = rProperty.getJSType();
            JSType lType = lProperty.getJSType();
            if (rType instanceof JSPrimitiveType && lType instanceof JSPrimitiveType) {
                if (this.checkPropertySignatureAssignable(lProperty, rProperty, processingContext)) continue;
                return false;
            }
            if (toCheck == null) {
                toCheck = new ArrayList<PropertyTypeChecker>(properties2.size());
            }
            toCheck.add(context -> this.checkPropertySignatureAssignable(lProperty, rProperty, context));
        }
        if (toCheck != null) {
            for (PropertyTypeChecker checker : toCheck) {
                if (checker.check(processingContext)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureTypes(@NotNull ProcessingContext processingContext, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(35);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(36);
        }
        for (JSRecordType.CallSignature lCallSignature : this.myCallSignatures) {
            if (JSRecordTypeImpl.checkCallSignaturesAssignable(lCallSignature, callSignatures, processingContext)) continue;
            return false;
        }
        return true;
    }

    private boolean checkStringIndexerTypes(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        JSRecordType.IndexSignature numericIndexSignature;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(37);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(38);
        }
        if (this.myStringIndexer == null) {
            return true;
        }
        JSType memberType = this.myStringIndexer.getMemberType();
        JSRecordType.IndexSignature stringIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        if (stringIndexSignature != null) {
            return memberType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext);
        }
        if (JSTypeComparingContextService.isSubtyping(processingContext) && (numericIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC)) != null && numericIndexSignature.getMemberType().isDirectlyAssignableType(memberType, processingContext)) {
            return true;
        }
        return (JSRecordTypeImpl.isObjectType(recordType) || memberType instanceof JSAnyType || memberType instanceof JSGenericParameterType) && !this.hasPropertyNotAssignableToIndexer(recordType, p -> true, this.myStringIndexer, processingContext);
    }

    private boolean checkNumericIndexerTypes(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(39);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(40);
        }
        if (this.myNumericIndexer == null) {
            return true;
        }
        JSRecordType.IndexSignature stringIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        JSRecordType.IndexSignature numericIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
        JSType memType = this.myNumericIndexer.getMemberType();
        if (numericIndexSignature != null) {
            return memType.isDirectlyAssignableType(numericIndexSignature.getMemberType(), processingContext);
        }
        if (stringIndexSignature != null) {
            if (!memType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext)) {
                return false;
            }
            if (JSRecordTypeImpl.isObjectType(recordType) && this.hasPropertyNotAssignableToIndexer(recordType, p -> true, this.myNumericIndexer, processingContext)) {
                return false;
            }
        } else if (!JSRecordTypeImpl.isObjectType(recordType) && !(memType instanceof JSAnyType) && !(memType instanceof JSGenericParameterType) || this.hasPropertyNotAssignableToIndexer(recordType, JSRecordTypeImpl::isNumericallyNamedProperty, this.myNumericIndexer, processingContext)) {
            return false;
        }
        return true;
    }

    private static boolean isNumericallyNamedProperty(@NotNull JSRecordType.PropertySignature p) {
        if (p == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(41);
        }
        if (p instanceof TypeScriptEnumField) {
            return true;
        }
        String memberName = p.getMemberName();
        return JSStringUtil.isNumericValueStart(memberName, false) && JSNumberParser.tryParseNumericValue(memberName, false) != null;
    }

    private static boolean isExpressionBasedType(@NotNull JSRecordType type) {
        PsiElement sourceElement;
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(42);
        }
        return (sourceElement = type.getSourceElement()) instanceof JSObjectLiteralExpression || sourceElement instanceof JSArrayLiteralExpression;
    }

    public static boolean isObjectType(@NotNull JSRecordType type) {
        PsiElement sourceElement;
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(43);
        }
        return (sourceElement = type.getSourceElement()) instanceof JSObjectLiteralExpression || sourceElement instanceof TypeScriptObjectType || sourceElement instanceof TypeScriptEnum || sourceElement instanceof TypeScriptMappedType;
    }

    private static boolean isObjectLiteralType(@NotNull JSRecordType type) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(44);
        }
        return type.getSourceElement() instanceof JSObjectLiteralExpression;
    }

    private boolean hasPropertyNotAssignableToIndexer(@NotNull JSRecordType recordType, @NotNull Predicate<JSRecordType.PropertySignature> propertyFilter, @NotNull JSRecordType.IndexSignature typeMember, @NotNull ProcessingContext oldProcessingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(45);
        }
        if (propertyFilter == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(46);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(47);
        }
        if (oldProcessingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(48);
        }
        return JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)processingContext -> {
            JSType memberType = typeMember.getMemberType();
            return recordType.getProperties().stream().filter(propertyFilter).map(v -> v.getJSType()).anyMatch(t -> t != null && !memberType.isDirectlyAssignableType((JSType)t, (ProcessingContext)processingContext));
        }), oldProcessingContext, this.getSource(), false);
    }

    private static boolean isUndefinedProperty(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSType undefinedType, @Nullable ProcessingContext processingContext) {
        JSType propertyType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(49);
        }
        if (undefinedType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(50);
        }
        return (propertyType = typeMember.getJSType()) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext);
    }

    private boolean checkPropertySignatureAssignable(@NotNull JSRecordType.PropertySignature signature, @NotNull JSRecordType.PropertySignature otherSignature, @Nullable ProcessingContext processingContext) {
        if (signature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(51);
        }
        if (otherSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(52);
        }
        if (signature.isEquivalentTo(otherSignature, processingContext, true)) {
            return true;
        }
        JSType type = signature.getJSTypeWithOptionality();
        JSType otherType = otherSignature.getJSTypeWithOptionality();
        return this.skipTypeChecking(type) || this.skipTypeChecking(otherType) || type.isDirectlyAssignableType(otherType, processingContext);
    }

    private static boolean checkCallSignaturesAssignable(@NotNull JSRecordType.CallSignature currentSignature, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable ProcessingContext processingContext) {
        if (currentSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(53);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(54);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            if (!currentSignature.isEquivalentTo(callSignature, processingContext, true)) continue;
            return true;
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) || callSignatures.size() == 1) {
            return JSRecordTypeImpl.simpleCheckCallSignatureAssignable(currentSignature, callSignatures, processingContext);
        }
        int size = currentSignature.getParameterTypeDecorators().size();
        SmartList rest = new SmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            List<JSParameterTypeDecorator> params = signature.getParameterTypeDecorators();
            if (params.size() != size) {
                rest.add(signature);
                continue;
            }
            if (!JSRecordTypeImpl.checkAssignableForCallSignatures(currentSignature, processingContext, signature)) continue;
            return true;
        }
        return JSRecordTypeImpl.simpleCheckCallSignatureAssignable(currentSignature, (List<JSRecordType.CallSignature>)rest, processingContext);
    }

    private static boolean simpleCheckCallSignatureAssignable(@NotNull JSRecordType.CallSignature currentSignature, @NotNull List<JSRecordType.CallSignature> rest, @Nullable ProcessingContext processingContext) {
        if (currentSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(55);
        }
        if (rest == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(56);
        }
        for (JSRecordType.CallSignature callSignature : rest) {
            if (!JSRecordTypeImpl.checkAssignableForCallSignatures(currentSignature, processingContext, callSignature)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAssignableForCallSignatures(@NotNull JSRecordType.CallSignature typeMember, @Nullable ProcessingContext processingContext, @NotNull JSRecordType.CallSignature callSignature) {
        JSFunctionType otherFunctionType;
        JSFunctionType functionType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(57);
        }
        if (callSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(58);
        }
        return typeMember.hasNew() == callSignature.hasNew() && JSRecordTypeImpl.checkFunctionsArgumentsAndReturnType(functionType = typeMember.getFunctionType(), otherFunctionType = callSignature.getFunctionType(), processingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFunctionsArgumentsAndReturnType(@NotNull JSFunctionType functionType, @NotNull JSFunctionType otherFunctionType, @Nullable ProcessingContext processingContext) {
        if (functionType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(59);
        }
        if (otherFunctionType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(60);
        }
        boolean oldCallEnv = false;
        if (processingContext != null) {
            oldCallEnv = processingContext.get(JSTypeBaseImpl.CALL_ENV_KEY) == Boolean.TRUE;
            JSTypeComparingContextService.setCallEnvironment(processingContext, true);
        }
        try {
            if (!JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !functionType.isTypeScript(), functionType.isTypeScript())) {
                boolean bl = false;
                return bl;
            }
            JSType returnType = functionType.getReturnType();
            JSType otherReturnType = otherFunctionType.getReturnType();
            if (returnType == null || returnType instanceof JSVoidType) {
                boolean bl = true;
                return bl;
            }
            boolean bl = returnType.isDirectlyAssignableType(otherReturnType, processingContext);
            return bl;
        }
        finally {
            if (processingContext != null) {
                MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping;
                List<TypeScriptGenericDeclarationTypeImpl> declarations;
                JSGenericMappings mappings = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
                if (mappings != null && otherFunctionType instanceof TypeScriptJSFunctionTypeImpl && !(declarations = ((TypeScriptJSFunctionTypeImpl)otherFunctionType).getGenericDeclarations()).isEmpty() && !(mapping = mappings.getMapping()).containsKey((Object)JSExternalGenericId.INSTANCE)) {
                    mapping.putValue((Object)JSExternalGenericId.INSTANCE, (Object)JSCompositeTypeFactory.createUnionType(otherFunctionType.getSource(), declarations));
                }
                JSTypeComparingContextService.setCallEnvironment(processingContext, oldCallEnv);
            }
        }
    }

    private boolean checkFunctionInterfaceProperties(@NotNull ProcessingContext processingContext, @NotNull JSRecordType functionRecord, @NotNull JSRecordType.PropertySignature typeMember) {
        JSRecordType.PropertySignature signature;
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(61);
        }
        if (functionRecord == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(62);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(63);
        }
        if ((signature = functionRecord.findPropertySignature(typeMember.getMemberName())) == null) {
            return false;
        }
        if (JSRecordTypeImpl.checkSources(typeMember, signature, processingContext)) {
            return true;
        }
        return this.checkPropertySignatureAssignable(typeMember, signature, processingContext);
    }

    private static boolean checkSources(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSRecordType.TypeMember member, @NotNull ProcessingContext processingContext) {
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(64);
        }
        if (member == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(65);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(66);
        }
        JSRecordType.MemberSource source2 = member.getMemberSource();
        PsiElement memberSource = source2.getSingleElement();
        JSRecordType.MemberSource typeMemberSource = typeMember.getMemberSource();
        return memberSource != null && memberSource.isEquivalentTo(typeMemberSource.getSingleElement()) || typeMember.isEquivalentTo(member, processingContext, true);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(67);
        }
        JSRecordType otherType = (JSRecordType)type;
        List<JSRecordType.TypeMember> otherMembers = otherType.getTypeMembers();
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        return JSRecordTypeImpl.areMembersEqual(otherMembers, members, processingContext, allowResolve);
    }

    protected static boolean areMembersEqual(@NotNull List<? extends JSRecordType.TypeMember> otherMembers, @NotNull List<? extends JSRecordType.TypeMember> members, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (otherMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(68);
        }
        if (members == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(69);
        }
        if (otherMembers.size() != members.size()) {
            return false;
        }
        for (int i2 = 0; i2 < members.size(); ++i2) {
            ProgressManager.checkCanceled();
            JSRecordType.TypeMember otherMember = otherMembers.get(i2);
            JSRecordType.TypeMember member = members.get(i2);
            if (otherMember.isEquivalentTo(member, processingContext, allowResolve)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list2 = this.myAllTypeMembers;
        if (list2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(70);
        }
        return list2;
    }

    @Override
    public final boolean hasProperty(@NotNull String name) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(71);
        }
        if (this.myProperties.containsKey(name)) {
            return true;
        }
        return this.myComputedProperties.stream().anyMatch(p -> name.equals(p.getMemberName()));
    }

    @Override
    public final boolean hasIndexers() {
        return this.myStringIndexer != null || this.myNumericIndexer != null;
    }

    @Override
    @NotNull
    public final List<JSRecordType.CallSignature> getCallSignatures() {
        List<JSRecordType.CallSignature> list2 = this.myCallSignatures;
        if (list2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(72);
        }
        return list2;
    }

    @Override
    @NotNull
    public final Set<String> getPropertyNames() {
        Set<String> keys = this.myProperties.keySet();
        if (this.myComputedProperties.isEmpty()) {
            Set<String> set = keys;
            if (set == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(73);
            }
            return set;
        }
        Set strings = ContainerUtil.map2Set(this.myComputedProperties, p -> p.getMemberName());
        strings.addAll(keys);
        Set set = strings;
        if (set == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(74);
        }
        return set;
    }

    @Override
    @NotNull
    public final Collection<JSRecordType.PropertySignature> getProperties() {
        Collection<JSRecordType.PropertySignature> props = this.myProperties.values();
        if (this.myComputedProperties.isEmpty()) {
            Collection<JSRecordType.PropertySignature> collection = props;
            if (collection == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(75);
            }
            return collection;
        }
        ArrayList<JSRecordType.PropertySignature> result2 = new ArrayList<JSRecordType.PropertySignature>(props.size() + this.myComputedProperties.size());
        result2.addAll(props);
        result2.addAll(this.myComputedProperties);
        ArrayList<JSRecordType.PropertySignature> arrayList = result2;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(76);
        }
        return arrayList;
    }

    @Override
    public final boolean hasMembers() {
        return !this.myAllTypeMembers.isEmpty();
    }

    @Override
    public final boolean hasProperties() {
        return !this.myProperties.isEmpty() || !this.myComputedProperties.isEmpty();
    }

    @Override
    @Nullable
    public final JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        JSRecordType.PropertySignature signature;
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(77);
        }
        if ((signature = this.myProperties.get(name)) != null || this.myComputedProperties.isEmpty()) {
            return signature;
        }
        for (JSRecordType.PropertySignature property : this.myComputedProperties) {
            if (!name.equals(property.getMemberName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public final void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(78);
        }
        visitor.visitJSRecordType(this);
    }

    private boolean skipTypeChecking(@Nullable JSType type) {
        return type == null || this.isTypeScript() && !type.isSourceStrict();
    }

    @Override
    public final void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(79);
        }
        for (JSRecordType.TypeMember typeMember : this.myAllTypeMembers) {
            typeMember.acceptChildren(visitor);
        }
    }

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(80);
        }
        if (newSource == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(81);
        }
        List<JSRecordType.TypeMember> oldMembers = this.getTypeMembers();
        ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>(oldMembers.size());
        for (JSRecordType.TypeMember member : oldMembers) {
            newMembers.add(member.copyTypeHierarchy(childTransform));
        }
        if (ContainerUtil.equalsIdentity(oldMembers, newMembers)) {
            JSRecordTypeImpl jSRecordTypeImpl = this;
            if (jSRecordTypeImpl == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(82);
            }
            return jSRecordTypeImpl;
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(newSource, newMembers, true, childTransform instanceof JSCopyWithStrictTransformer);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(83);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected JSRecordTypeImpl createInstance(@NotNull JSTypeSource source2, @NotNull List<JSRecordType.TypeMember> newMembers, boolean membersChanged, boolean strictnessOnly) {
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(84);
        }
        if (newMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(85);
        }
        return membersChanged ? new JSRecordTypeImpl(source2, newMembers) : new JSRecordTypeImpl(source2, this.myAllTypeMembers, this.myCallSignatures, this.myStringIndexer, this.myNumericIndexer, this.myProperties, this.myComputedProperties, this.myIsWeakType);
    }

    @Override
    @NotNull
    protected final JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(86);
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(source2, this.myAllTypeMembers, false, false);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(87);
        }
        return jSRecordTypeImpl;
    }

    @Override
    @Nullable
    public final JSRecordType.IndexSignature findIndexer(@NotNull JSRecordType.IndexSignatureKind kind) {
        if (kind == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(88);
        }
        switch (kind) {
            case STRING: {
                return this.myStringIndexer;
            }
            case NUMERIC: {
                return this.myNumericIndexer;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(89);
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(90);
        }
        Stream<JSType> stream = this.getCallSignatures().stream().filter(typeMember -> typeMember.hasNew() == newCallSignatures).map(JSRecordType.CallSignature::getFunctionType);
        if (stream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(91);
        }
        return stream;
    }

    @Override
    protected int hashCodeImpl() {
        return JSTypeHashCodeUtil.getMembersHashCode(this.getTypeMembers());
    }

    @Override
    public final boolean isWeak() {
        return this.myIsWeakType;
    }

    @NotNull
    public static JSRecordType.MemberSource getUpdatedTypeMemberSource(@NotNull JSRecordType.MemberSource oldMemberSource, @NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (oldMemberSource == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(92);
        }
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(93);
        }
        if (childTransform instanceof JSTypeBaseImpl.SourceTransformer && ((JSTypeBaseImpl.SourceTransformer)childTransform).isNullizeRecordMemberSource()) {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource((PsiElement)null, oldMemberSource.getSourceKind());
            if (memberSource == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(94);
            }
            return memberSource;
        }
        JSRecordType.MemberSource memberSource = oldMemberSource;
        if (memberSource == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(95);
        }
        return memberSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 24: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 94: 
            case 95: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 24: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 94: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTypeMembers";
                break;
            }
            case 6: 
            case 36: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedProperties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 10: 
            case 15: 
            case 71: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSignature";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 14: 
            case 24: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProperty";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 61: 
            case 66: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 26: 
            case 31: 
            case 37: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyFilter";
                break;
            }
            case 47: 
            case 49: 
            case 57: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldProcessingContext";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undefinedType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSignature";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSignature";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignature";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherFunctionType";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionRecord";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMembers";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 80: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMemberSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSignatures";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRecordTypeIfPossible";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMembers";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedTypeMemberSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeSignatures";
                break;
            }
            case 14: 
            case 24: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 94: 
            case 95: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyToCompositeFunctions";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convertToRecordTypeIfPossible";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableRecordType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectLiteralProperties";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkWeakTypeCondition";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureExistence";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyTypes";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureTypes";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkStringIndexerTypes";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkNumericIndexerTypes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isNumericallyNamedProperty";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionBasedType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isObjectType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteralType";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasPropertyNotAssignableToIndexer";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedProperty";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySignatureAssignable";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignaturesAssignable";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "simpleCheckCallSignatureAssignable";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableForCallSignatures";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionsArgumentsAndReturnType";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionInterfaceProperties";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "checkSources";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "areMembersEqual";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySignature";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findIndexer";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedTypeMemberSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 24: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 82: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 94: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PropertySignatureImpl
    implements PropertySignatureCommonImpl {
        @NotNull
        private final String name;
        @Nullable
        private final JSType type;
        private final boolean optional;
        private final boolean isReadonly;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        @Deprecated
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(0);
            }
            this(name, type, optional, false, singleSource);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(1);
            }
            this(name, type, optional, isReadonly, JSRecordMemberSourceFactory.createSource(singleSource));
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @NotNull JSRecordType.MemberSource source2) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(2);
            }
            if (source2 == null) {
                PropertySignatureImpl.$$$reportNull$$$0(3);
            }
            this(name, type, optional, false, source2);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly, @NotNull JSRecordType.MemberSource source2) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(4);
            }
            if (source2 == null) {
                PropertySignatureImpl.$$$reportNull$$$0(5);
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.mySource = source2;
            this.isReadonly = isReadonly;
        }

        @Deprecated
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(6);
            }
            this(name, type, optional, false);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(7);
            }
            this(name, type, optional, isReadonly, JSRecordMemberSourceFactory.createEmptySource());
        }

        @Override
        @NotNull
        public String getMemberName() {
            String string = this.name;
            if (string == null) {
                PropertySignatureImpl.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @Nullable
        public JSType getJSType() {
            return this.type;
        }

        @Override
        @Nullable
        public JSType getJSTypeWithOptionality() {
            JSType type = this.getJSType();
            if (this.isOptional() && type != null) {
                return TypeScriptTypeGuard.wrapWithUndefined(type, type.getSource());
            }
            return type;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                PropertySignatureImpl.$$$reportNull$$$0(9);
            }
            return memberSource;
        }

        public String toString() {
            return "PropertySignatureImpl@" + this.name;
        }

        @Override
        public boolean isConst() {
            return this.isReadonly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class FunctionSignatureImpl
    extends PropertySignatureImpl
    implements JSRecordType.FunctionMember {
        public FunctionSignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly) {
            if (name == null) {
                FunctionSignatureImpl.$$$reportNull$$$0(0);
            }
            super(name, type, optional, isReadonly);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$FunctionSignatureImpl", "<init>"));
        }
    }

    public static final class ComputedPropertySignatureImpl
    implements JSRecordType.PropertySignature,
    JSRecordType.ComputedMember {
        @NotNull
        private final String nameRef;
        @Nullable
        private final JSType type;
        private final boolean optional;
        private final boolean isReadonly;
        @NotNull
        private final JSRecordType.MemberSource mySource;
        private static final String INVALID_NAME = "[unknown]";

        public ComputedPropertySignatureImpl(@NotNull String propertyNameRef, @Nullable JSType type, boolean optional, boolean isReadonly, @NotNull JSRecordType.MemberSource source2) {
            if (propertyNameRef == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(0);
            }
            if (source2 == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(1);
            }
            this.nameRef = propertyNameRef;
            this.type = type;
            this.optional = optional;
            this.isReadonly = isReadonly;
            this.mySource = source2;
        }

        @Override
        @NotNull
        public String getMemberName() {
            return this.computeValue(this.mySource.getSingleElement());
        }

        @Override
        public boolean isConst() {
            return this.isReadonly;
        }

        @Override
        public boolean hasValidName() {
            return this.getMemberName() != INVALID_NAME;
        }

        @NotNull
        private String computeValue(@Nullable PsiElement context) {
            if (context == null || !context.isValid()) {
                return INVALID_NAME;
            }
            JSType type = TypeScriptLiteralKeyUtil.getTypeForComputedName(context, this.nameRef);
            String string = (String)ObjectUtils.coalesce((Object)TypeScriptTypeMemberParser.getComputedPropNameFromType(type), (Object)INVALID_NAME);
            if (string == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public JSType getJSType() {
            return this.type;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(3);
            }
            return memberSource;
        }

        public String toString() {
            return "ComputedPropertySignatureImpl@" + this.nameRef;
        }

        @Override
        @NotNull
        public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
            if (childTransform == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(4);
            }
            JSType oldType = this.getJSType();
            JSType type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
            JSRecordType.MemberSource oldMemberSource = this.getMemberSource();
            JSRecordType.MemberSource memberSource = JSRecordTypeImpl.getUpdatedTypeMemberSource(oldMemberSource, childTransform);
            if (oldType == type && oldMemberSource == memberSource) {
                ComputedPropertySignatureImpl computedPropertySignatureImpl = this;
                if (computedPropertySignatureImpl == null) {
                    ComputedPropertySignatureImpl.$$$reportNull$$$0(5);
                }
                return computedPropertySignatureImpl;
            }
            return new ComputedPropertySignatureImpl(this.nameRef, type, this.isOptional(), this.isConst(), memberSource);
        }

        @Override
        public int getMemberHashCode() {
            return Objects.hash(this.getClass(), this.nameRef, JSTypeHashCodeUtil.getHashCodeSafe(this.getJSType()), this.isOptional());
        }

        @Override
        public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context, boolean allowResolve) {
            return ComputedPropertySignatureImpl.arePropertySignaturesEqual(this, other, context, allowResolve);
        }

        static boolean arePropertySignaturesEqual(@NotNull ComputedPropertySignatureImpl first, @Nullable JSRecordType.TypeMember otherRaw, @Nullable ProcessingContext processingContext, boolean allowResolve) {
            PsiElement otherSource;
            if (first == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(6);
            }
            if (otherRaw == first) {
                return true;
            }
            if (!(otherRaw instanceof ComputedPropertySignatureImpl)) {
                return false;
            }
            ComputedPropertySignatureImpl other = (ComputedPropertySignatureImpl)otherRaw;
            PsiElement firstSource = first.getMemberSource().getSingleElement();
            if (!Objects.equals(firstSource, otherSource = otherRaw.getMemberSource().getSingleElement())) {
                return false;
            }
            JSType firstType = first.getJSType();
            JSType otherType = other.getJSType();
            return Objects.equals(first.nameRef, other.nameRef) && (firstType != null ? firstType.isEquivalentTo(otherType, processingContext, allowResolve) : otherType == null) && first.isOptional() == other.isOptional();
        }

        @Override
        public void appendMemberPresentation(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder, @NotNull String typeSeparator, char quote) {
            if (format == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(7);
            }
            if (builder == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(8);
            }
            if (typeSeparator == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(9);
            }
            PropertySignatureCommonImpl.appendPresentation(this, format, builder, typeSeparator, quote, (String)(format == JSType.TypeTextFormat.PRESENTABLE ? this.getMemberName() : "[" + this.nameRef + "]"));
        }

        @Override
        public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
            JSType type;
            if (visitor == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(10);
            }
            if ((type = this.getJSType()) != null) {
                type.accept(visitor);
            }
        }

        @Override
        @NotNull
        public String getNameRef() {
            String string = this.nameRef;
            if (string == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyNameRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$ComputedPropertySignatureImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTransform";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeSeparator";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$ComputedPropertySignatureImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyTypeHierarchy";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "copyTypeHierarchy";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "arePropertySignaturesEqual";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "appendMemberPresentation";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class IndexSignatureImpl
    implements IndexSignatureCommonImpl {
        @Nullable
        private final JSType parameterType;
        @Nullable
        private final JSType type;
        private final boolean myIsForComputedProperty;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @Nullable PsiElement singleSource, boolean isForComputedProperty) {
            this(parameterType, type, JSRecordMemberSourceFactory.createSource(singleSource), isForComputedProperty);
        }

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @NotNull JSRecordType.MemberSource source2, boolean isForComputedProperty) {
            if (source2 == null) {
                IndexSignatureImpl.$$$reportNull$$$0(0);
            }
            this.mySource = source2;
            this.parameterType = parameterType;
            this.type = type;
            this.myIsForComputedProperty = isForComputedProperty;
        }

        @Override
        @NotNull
        public JSType getMemberParameterType() {
            JSType jSType = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (jSType == null) {
                IndexSignatureImpl.$$$reportNull$$$0(1);
            }
            return jSType;
        }

        @Override
        @NotNull
        public JSRecordType.IndexSignatureKind getIndexSignatureKind() {
            return IndexSignatureImpl.getIndexerKindFromType(this.getMemberParameterType());
        }

        @Override
        @NotNull
        public JSType getMemberType() {
            JSType jSType = this.type != null ? this.type : JSAnyType.get(null, false);
            if (jSType == null) {
                IndexSignatureImpl.$$$reportNull$$$0(2);
            }
            return jSType;
        }

        @Override
        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                IndexSignatureImpl.$$$reportNull$$$0(3);
            }
            return memberSource;
        }

        @Override
        public boolean isForComputedProperty() {
            return this.myIsForComputedProperty;
        }

        @NotNull
        public static JSRecordType.IndexSignatureKind getIndexerKindFromType(@Nullable JSType memberParameterType) {
            if (memberParameterType instanceof JSStringType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.STRING;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(4);
                }
                return indexSignatureKind;
            }
            if (memberParameterType instanceof JSNumberType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.NUMERIC;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(5);
                }
                return indexSignatureKind;
            }
            JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.UNKNOWN;
            if (indexSignatureKind == null) {
                IndexSignatureImpl.$$$reportNull$$$0(6);
            }
            return indexSignatureKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberParameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexerKindFromType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class CallSignatureImpl
    implements CallSignatureCommonImpl {
        private final boolean hasNew;
        @NotNull
        private final JSFunctionType functionType;

        public CallSignatureImpl(boolean hasNew, @NotNull JSFunctionType functionType) {
            if (functionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(0);
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        @Override
        public boolean hasNew() {
            return this.hasNew;
        }

        @Override
        @NotNull
        public JSFunctionType getFunctionType() {
            JSFunctionType jSFunctionType = this.functionType;
            if (jSFunctionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(1);
            }
            return jSFunctionType;
        }

        @Override
        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(this.functionType.getSource().getSourceElement());
            if (memberSource == null) {
                CallSignatureImpl.$$$reportNull$$$0(2);
            }
            return memberSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface PropertyTypeChecker {
        public boolean check(@NotNull ProcessingContext var1);
    }
}

