/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubElementTypeHolder {
    private final String mySerializedType;
    private final JSType myJSType;
    private JSType myTypeOrFromSerialized;

    public JSStubElementTypeHolder(@NotNull String serializedType) {
        if (serializedType == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(0);
        }
        this.mySerializedType = serializedType;
        this.myJSType = null;
    }

    public JSStubElementTypeHolder(@NotNull JSType type) {
        if (type == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(1);
        }
        this.mySerializedType = null;
        this.myJSType = type;
    }

    @NotNull
    public String getSerializedTypeString() {
        String string = this.mySerializedType != null ? this.mySerializedType : Objects.requireNonNull(JSTypeUtils.serializeType(this.myJSType));
        if (string == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    JSType getJSType() {
        return this.myJSType;
    }

    @NotNull
    JSType getTypeOrFromSerialized() {
        JSType typeOrFromSerialized = this.myTypeOrFromSerialized;
        if (typeOrFromSerialized != null) {
            JSType jSType = typeOrFromSerialized;
            if (jSType == null) {
                JSStubElementTypeHolder.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        this.myTypeOrFromSerialized = typeOrFromSerialized = this.myJSType != null ? this.myJSType : JSTypeParser.parseSerializedType(this.mySerializedType, JSTypeSource.EMPTY);
        JSType jSType = typeOrFromSerialized;
        if (jSType == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    public static void serialize(@Nullable JSStubElementTypeHolder holder, @NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            return;
        }
        String typeString = holder.mySerializedType != null ? holder.mySerializedType : JSTypeUtils.serializeType(holder.myJSType);
        dataStream.writeUTFFast(typeString);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSStubElementTypeHolder fromJSType(@Nullable JSType type) {
        return type != null ? new JSStubElementTypeHolder(type) : null;
    }

    @NotNull
    public static JSStubElementTypeHolder fromDataStream(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            JSStubElementTypeHolder.$$$reportNull$$$0(6);
        }
        String name = dataStream.readUTFFast();
        return new JSStubElementTypeHolder(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubElementTypeHolder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSStubElementTypeHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedTypeString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOrFromSerialized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromDataStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

