/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.NullableEnumStructureElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFileCachedData {
    private static final EnumStructureElement<JSModuleStatusOwner.ModuleStatus> MODULE_STATUS_FLAG = new EnumStructureElement<JSModuleStatusOwner.ModuleStatus>(JSModuleStatusOwner.ModuleStatus.class);
    private static final NullableEnumStructureElement<JSTestFileType> TEST_FILE_FLAG = new NullableEnumStructureElement<JSTestFileType>(JSTestFileType.class);
    private static final BooleanStructureElement HAS_ES6_SYNTAX_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_FLOW_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(MODULE_STATUS_FLAG, TEST_FILE_FLAG, HAS_ES6_SYNTAX_FLAG, HAS_FLOW_FLAG);
    private byte myFlags;
    private Set<String> myReferencedPaths;

    public void applyModuleStatus(@NotNull JSModuleStatusOwner.ModuleStatus moduleStatus) {
        JSModuleStatusOwner.ModuleStatus prevModuleStatus;
        JSModuleStatusOwner.ModuleStatus newModuleStatus;
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(0);
        }
        if ((newModuleStatus = JSFileCachedData.combineModuleStatuses(prevModuleStatus = this.getModuleStatus(), moduleStatus)) != prevModuleStatus) {
            this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, MODULE_STATUS_FLAG, newModuleStatus, this.myFlags);
        }
    }

    @NotNull
    private static JSModuleStatusOwner.ModuleStatus combineModuleStatuses(@NotNull JSModuleStatusOwner.ModuleStatus s1, @NotNull JSModuleStatusOwner.ModuleStatus s2) {
        if (s1 == null) {
            JSFileCachedData.$$$reportNull$$$0(1);
        }
        if (s2 == null) {
            JSFileCachedData.$$$reportNull$$$0(2);
        }
        if (s1 == JSModuleStatusOwner.ModuleStatus.ES6 || s2 == JSModuleStatusOwner.ModuleStatus.ES6) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.ES6;
            if (moduleStatus == null) {
                JSFileCachedData.$$$reportNull$$$0(3);
            }
            return moduleStatus;
        }
        if (s1 == JSModuleStatusOwner.ModuleStatus.COMMONJS || s2 == JSModuleStatusOwner.ModuleStatus.COMMONJS) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.COMMONJS;
            if (moduleStatus == null) {
                JSFileCachedData.$$$reportNull$$$0(4);
            }
            return moduleStatus;
        }
        if (s1 == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS || s2 == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS) {
            JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
            if (moduleStatus == null) {
                JSFileCachedData.$$$reportNull$$$0(5);
            }
            return moduleStatus;
        }
        JSModuleStatusOwner.ModuleStatus moduleStatus = JSModuleStatusOwner.ModuleStatus.NONE;
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(6);
        }
        return moduleStatus;
    }

    public void setTestFileType(@Nullable JSTestFileType testFileType) {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, testFileType, this.myFlags);
    }

    public void setHasES6Syntax() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, true, this.myFlags);
    }

    public void setReferencedPaths(Set<String> referencedPaths) {
        this.myReferencedPaths = referencedPaths;
    }

    @NotNull
    public JSModuleStatusOwner.ModuleStatus getModuleStatus() {
        JSModuleStatusOwner.ModuleStatus moduleStatus = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, MODULE_STATUS_FLAG, this.myFlags);
        if (moduleStatus == null) {
            JSFileCachedData.$$$reportNull$$$0(7);
        }
        return moduleStatus;
    }

    @Nullable
    public JSTestFileType getTestFileType() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, this.myFlags);
    }

    public boolean hasES6Syntax() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, this.myFlags);
    }

    public void setHasFlowFlag(boolean hasFlowFlag) {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_FLOW_FLAG, hasFlowFlag, this.myFlags);
    }

    public boolean hasFlowFlag() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_FLOW_FLAG, this.myFlags);
    }

    @NotNull
    public Set<String> getReferencedPaths() {
        Set<String> set = this.myReferencedPaths != null ? this.myReferencedPaths : Collections.emptySet();
        if (set == null) {
            JSFileCachedData.$$$reportNull$$$0(8);
        }
        return set;
    }

    public void addReferencedPath(String filePath) {
        if (this.myReferencedPaths == null) {
            this.myReferencedPaths = new HashSet<String>();
        }
        this.myReferencedPaths.add(filePath);
    }

    public void serialize(@NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            JSFileCachedData.$$$reportNull$$$0(9);
        }
        dataStream.writeByte((int)this.myFlags);
        Set<String> referencedPaths = this.getReferencedPaths();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)referencedPaths.size());
        for (String referencedFile : referencedPaths) {
            dataStream.writeUTFFast(referencedFile);
        }
    }

    public static JSFileCachedData deserialize(StubInputStream dataStream) throws IOException {
        JSFileCachedData cachedData = new JSFileCachedData();
        cachedData.myFlags = dataStream.readByte();
        int referencedFilesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        HashSet<String> referencedPaths = new HashSet<String>(referencedFilesCount);
        for (int i2 = 0; i2 < referencedFilesCount; ++i2) {
            String referencedFile = dataStream.readUTFFast();
            referencedPaths.add(referencedFile);
        }
        cachedData.setReferencedPaths(referencedPaths);
        return cachedData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStatus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "combineModuleStatuses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyModuleStatus";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineModuleStatuses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

