/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionStubImpl
extends JSQualifiedObjectStubBase<JSDefinitionExpression>
implements JSDefinitionExpressionStub,
JSTypeHolderOwner {
    private static final BooleanStructureElement TYPE_STRICT = new BooleanStructureElement();
    private static final BooleanStructureElement IS_DECLARATION = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement KEEPS_INITIALIZER_STUB_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_TYPE_FROM_JSDOC = new BooleanStructureElement();
    private static final BooleanStructureElement IS_UNDER_CONDITION = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, TYPE_STRICT, IS_DECLARATION, HAS_TYPE_FLAG, HAS_INDEXING_DATA_FLAG, KEEPS_INITIALIZER_STUB_FLAG, IS_TYPE_FROM_JSDOC, IS_UNDER_CONDITION);
    @Nullable
    private final JSStubElementTypeHolder myTypeHolder;
    @Nullable
    private final JSElementIndexingDataStructure myIndexingDataStructure;

    public JSDefinitionExpressionStubImpl(JSDefinitionExpression clazz, StubElement parent) {
        super(clazz, parent, JSStubElementTypes.DEFINITION_EXPRESSION);
        JSType type = clazz.getJSType();
        this.myTypeHolder = JSStubElementTypeHolder.fromJSType(type);
        this.writeFlag(TYPE_STRICT, type != null && type.isSourceStrict());
        JSElementIndexingData indexingData = clazz.getIndexingData();
        this.myIndexingDataStructure = indexingData != null && !indexingData.isEmpty() ? indexingData.toStructure() : null;
        this.writeFlag(IS_DECLARATION, clazz.isDeclaration());
        this.writeFlag(HAS_TYPE_FLAG, this.myTypeHolder != null);
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingDataStructure != null);
        this.writeFlag(KEEPS_INITIALIZER_STUB_FLAG, JSStubIndexingUtils.keepsInitializerStub(clazz));
        this.writeFlag(IS_TYPE_FROM_JSDOC, JSStubIndexingUtils.isAstBasedTypeFromJSDoc(type));
        this.writeFlag(IS_UNDER_CONDITION, clazz.isUnderCondition());
    }

    public JSDefinitionExpressionStubImpl(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSDefinitionExpressionStubImpl.$$$reportNull$$$0(0);
        }
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
        this.myTypeHolder = this.readFlag(HAS_TYPE_FLAG) != false ? JSStubElementTypeHolder.fromDataStream(dataStream) : null;
        this.myIndexingDataStructure = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataStructureImpl.deserialize(dataStream) : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSStubElementTypeHolder.serialize(this.myTypeHolder, dataStream);
        }
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataStructureImpl.serialize(this.myIndexingDataStructure, dataStream);
        }
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        JSElementIndexingDataStructureImpl.index(this, sink);
    }

    @Override
    public JSDefinitionExpression createPsi() {
        return new JSDefinitionExpressionImpl(this);
    }

    @Override
    @Nullable
    public String getSerializedTypeString() {
        return this.myTypeHolder != null ? this.myTypeHolder.getSerializedTypeString() : null;
    }

    @Override
    public boolean isTypeStrict() {
        return this.readFlag(TYPE_STRICT);
    }

    @Override
    @Nullable
    public JSElementIndexingDataStructure getIndexingDataStructure() {
        return this.myIndexingDataStructure;
    }

    @Override
    public boolean isDeclaration() {
        return this.readFlag(IS_DECLARATION);
    }

    @Override
    public boolean keepsInitializerStub() {
        return this.readFlag(KEEPS_INITIALIZER_STUB_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSDefinitionExpressionStubImpl.$$$reportNull$$$0(1);
        }
        return flagsStructure;
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isExportedWithDefault() {
        return false;
    }

    @Override
    @Nullable
    public JSStubElementTypeHolder getJSTypeHolder() {
        return this.myTypeHolder;
    }

    @Override
    public boolean isTypeFromJSDoc() {
        return this.readFlag(IS_TYPE_FROM_JSDOC);
    }

    @Override
    public boolean isUnderCondition() {
        return this.readFlag(IS_UNDER_CONDITION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSDefinitionExpressionStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSDefinitionExpressionStubImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

