/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptMergedTypeImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSExtendingTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedItemProcessor<T extends ResultSink>
extends SinkResolveProcessor<T>
implements JSQualifiedItemProcessor,
JSModuleElementsProcessor {
    protected final boolean myEcma;
    protected final boolean myTypeScript;
    public TypeResolveState resolved = TypeResolveState.Unknown;

    public QualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ObjectUtils.coalesce((Object)this.place, (Object)containingFile));
        this.myEcma = holder != null && holder.isECMA4;
        this.myTypeScript = holder != null && holder.isTypeScript;
        this.setToProcessHierarchy(true);
    }

    protected void forceResolvedState() {
        this.resolved = TypeResolveState.Resolved;
    }

    @Override
    public final void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (type instanceof JSAnyType && type.getSource().isEcma()) {
            boolean currentIsNotResolved = this.isActionScriptDummyResolve();
            TypeResolveState typeResolveState = this.resolved = currentIsNotResolved ? TypeResolveState.PrefixUnknown : TypeResolveState.Unknown;
        }
        if (type instanceof JSModuleTypeImpl) {
            JSExecutionScope module = ((JSModuleTypeImpl)type).getModule();
            if (!ES6PsiUtil.processExportDeclarationInScope(module, this, evaluateContext, ((JSModuleTypeImpl)type).isFromRequire(), null)) {
                this.forceResolvedState();
            }
            return;
        }
        if (type instanceof JSClassExpressionType) {
            boolean isStatic = ((JSClassExpressionType)type).getJSContext() == JSContext.STATIC;
            JSClassExpression element = ((JSClassExpressionType)type).findAssociatedExpression();
            if (element != null) {
                AccessibilityProcessingHandler.processWithStatic(this, isStatic, () -> element.processDeclarations(this, ResolveState.initial(), element, this.place));
                if (this.myTypeScript && type.isSourceStrict() && !this.isTypeContext() && this.resolved != TypeResolveState.PrefixUnknown) {
                    this.forceResolvedState();
                }
            }
            return;
        }
        this.processImpl(type.substitute(), evaluateContext);
        if (this.resolved == TypeResolveState.Undefined || this.resolved == TypeResolveState.Unknown) {
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                if (!handler.useOnlyCompleteMatch(type, evaluateContext)) continue;
                this.forceResolvedState();
                break;
            }
        }
    }

    protected void processImpl(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        Object element;
        JSType constraintType;
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null) {
            type = constraintType;
        }
        if (type instanceof JSRecordType) {
            this.processRecordTypeImpl((JSRecordType)type);
            if (this.myTypeScript && type.isSourceStrict() && this.resolved != TypeResolveState.PrefixUnknown) {
                this.forceResolvedState();
            }
            return;
        }
        if ((type instanceof JsonElementType || type instanceof JSCustomElementType) && !QualifiedItemProcessor.processResolvedElement(element = ((JSTypeOfPsiElementBase)type).getElement(), this)) {
            this.forceResolvedState();
        }
        if (type instanceof JSExtendingTypeImpl) {
            JSExtendingTypeImpl extendingType = (JSExtendingTypeImpl)type;
            JSEvaluationRecursionGuard.evaluateWithGuard(type, evaluateContext, () -> {
                this.process(extendingType.getType(), evaluateContext);
                int level = ((ResultSink)this.getResultSink()).getNestingLevel();
                ((ResultSink)this.getResultSink()).setNestingLevel(level + 1);
                this.process(extendingType.getParentType(), evaluateContext);
                ((ResultSink)this.getResultSink()).setNestingLevel(level);
                return null;
            });
            return;
        }
        if (!JSTypeUtils.processExpandedType(this, type, evaluateContext)) {
            return;
        }
        this.processActionScriptClass(type, evaluateContext);
    }

    private void processActionScriptClass(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (!this.myEcma) {
            return;
        }
        String typeString = JSTypeUtils.getQualifiedNameMatchingType(type, true);
        if (type instanceof JSAnyType || typeString == null) {
            return;
        }
        PsiElement placeParent = this.place.getParent();
        boolean setTypeContext = placeParent instanceof JSReferenceListMember;
        PsiElement clazz = JSClassResolver.findClassFromNamespace(typeString, this.place);
        if (!(clazz instanceof XmlBackedJSClass)) {
            JSClass resolvedFromType = type.resolveClass();
            if (clazz == null || resolvedFromType instanceof XmlBackedJSClass) {
                clazz = resolvedFromType;
            }
        }
        if (clazz instanceof JSClass) {
            PsiElement typeSource = evaluateContext.getSource();
            JSClass finalClass = (JSClass)clazz;
            AccessibilityProcessingHandler.processWithStatic(this, false, () -> {
                this.addTypeFromClass(type, evaluateContext, typeString, typeSource, setTypeContext, finalClass);
                return true;
            });
        }
        if (type instanceof JSObjectType) {
            this.resolved = TypeResolveState.Unknown;
        } else if (!(clazz instanceof JSQualifiedNamedElement) && type.isSourceStrict()) {
            this.forceResolvedState();
        }
    }

    @Override
    public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        this.process(type, evaluateContext);
    }

    private static boolean processResolvedElement(@NotNull PsiElement element, @NotNull JSResolveProcessor processor) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        if (element instanceof JsonElement) {
            JsonValue value = null;
            if (element instanceof JsonFile) {
                JsonFile file2 = (JsonFile)element;
                value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> file2.getTopLevelValue());
            } else if (element instanceof JsonProperty) {
                value = ((JsonProperty)element).getValue();
            } else if (element instanceof JsonValue) {
                value = (JsonValue)element;
            }
            if (value instanceof JsonObject) {
                String name = processor.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                        return false;
                    }
                } else {
                    List list2 = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list2) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                }
            }
        } else {
            if (element instanceof StylesheetFile) {
                CssStylesheet stylesheet = ((StylesheetFile)element).getStylesheet();
                if (stylesheet != null) {
                    QualifiedItemProcessor.processCssClasses(stylesheet, processor);
                }
                return false;
            }
            if (element instanceof JSPackageWrapper) {
                element.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, element);
                return false;
            }
        }
        return true;
    }

    private static void processCssClasses(@NotNull CssStylesheet stylesheet, @NotNull JSResolveProcessor processor) {
        if (stylesheet == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        MultiMap stylesheetClasses = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)stylesheet, () -> {
            MultiMap classes = new MultiMap();
            for (CssRuleset cssRuleset : stylesheet.getRulesets()) {
                QualifiedItemProcessor.collectCssClasses(cssRuleset, (MultiMap<String, CssClass>)classes);
            }
            return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{stylesheet.getContainingFile()});
        });
        Collection classes = processor.getName() != null ? stylesheetClasses.get((Object)processor.getName()) : stylesheetClasses.values();
        for (CssClass cssClass : classes) {
            ProgressManager.checkCanceled();
            processor.execute((PsiElement)cssClass, ResolveState.initial());
        }
    }

    private static void collectCssClasses(@NotNull CssRuleset cssRuleset, @NotNull MultiMap<String, CssClass> classes) {
        if (cssRuleset == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        if (classes == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        for (CssSelector cssSelector : cssRuleset.getSelectors()) {
            if (cssSelector.isAmpersandSelector()) {
                cssSelector.processAmpersandEvaluatedSelectors(effectiveSelector -> {
                    QualifiedItemProcessor.collectCssClasses(effectiveSelector, classes);
                    return true;
                });
                continue;
            }
            QualifiedItemProcessor.collectCssClasses(cssSelector, classes);
        }
        for (CssSelector cssSelector : cssRuleset.getNestedRulesets()) {
            QualifiedItemProcessor.collectCssClasses((CssRuleset)cssSelector, classes);
        }
    }

    private static void collectCssClasses(@NotNull CssSelector selector, @NotNull MultiMap<String, CssClass> classes) {
        if (selector == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        if (classes == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
            for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                String name;
                if (!(selectorSuffix instanceof CssClass) || (name = ResolveProcessor.getName((PsiElement)selectorSuffix)) == null) continue;
                classes.putValue((Object)name, (Object)((CssClass)selectorSuffix));
            }
        }
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type) {
        JSRecordType.IndexSignature indexer;
        List<PsiElement> results;
        String name;
        if (type == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(16);
        }
        if (type == JSTypeCastUtil.NO_RECORD_TYPE) {
            return;
        }
        PsiElement sourceElement = type.getSourceElement();
        if (sourceElement == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Logger.getInstance(this.getClass()).error((Throwable)((Object)new AssertionError((Object)"Record type source must be not empty")));
        }
        boolean isSimpleRecordWithDefinedSource = type instanceof JSSimpleRecordTypeImpl && sourceElement != null && sourceElement.isValid();
        boolean isTypeScriptObjectType = sourceElement instanceof TypeScriptObjectType;
        if (isSimpleRecordWithDefinedSource && (sourceElement instanceof JSClassExpression || isTypeScriptObjectType)) {
            boolean processBaseDeclarations;
            Stream<JSType> constructors = JSTypeUtils.getFunctionType(type, true, this.place);
            this.getAccessibilityProcessingHandler().setProcessStatics(constructors.findAny().isPresent());
            boolean bl = processBaseDeclarations = sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place) || isTypeScriptObjectType && QualifiedItemProcessor.hasOnlyIndexers(this.getResults());
            if (processBaseDeclarations && isTypeScriptObjectType) {
                boolean hasCallSignature = false;
                boolean hasConstructSignature = false;
                for (TypeScriptTypeMember typeMember : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    hasCallSignature |= typeMember instanceof JSRecordType.CallSignature && !((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                    hasConstructSignature |= typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                }
                this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
            }
            return;
        }
        if (isSimpleRecordWithDefinedSource && sourceElement instanceof JSObjectLiteralExpression) {
            for (JSProperty property : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                if (this.execute((PsiElement)property, ResolveState.initial())) continue;
                return;
            }
        }
        boolean isDynamicResolve = !isSimpleRecordWithDefinedSource && this.getResultSink() instanceof ResolveResultSink && (sourceElement == null || !DialectDetector.isTypeScript(sourceElement));
        for (JSRecordType.TypeMember typeMember : type.getProperties()) {
            String name2 = this.getName();
            if (name2 != null && !name2.equals(typeMember.getMemberName())) continue;
            if (!type.isSourceStrict()) {
                typeMember = typeMember.copyTypeHierarchy(t -> t.copyWithStrict(false));
            }
            if (this.processRecordTypeMember(sourceElement, isSimpleRecordWithDefinedSource, isDynamicResolve, typeMember)) continue;
            return;
        }
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement) && !ES6PsiUtil.isExternalModule(sourceElement)) {
            boolean hasCallSignature = false;
            boolean hasConstructSignature = false;
            List<JSRecordType.CallSignature> signatures = type.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures) {
                hasCallSignature |= !signature.hasNew();
                hasConstructSignature |= signature.hasNew();
            }
            this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
        }
        if ((name = this.getName()) != null && type.hasIndexers() && ((results = this.getResults()) == null || results.isEmpty()) && (indexer = type.findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null && !indexer.isForComputedProperty()) {
            PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)indexer.getMemberSource().getSingleElement(), (Object)sourceElement);
            if (element == null) {
                return;
            }
            this.execute((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), element, false), ResolveState.initial());
        }
    }

    public static boolean hasOnlyIndexers(List<PsiElement> results) {
        return results != null && results.stream().allMatch(e -> e instanceof TypeScriptIndexSignature);
    }

    private boolean processRecordTypeMember(@Nullable PsiElement sourceElement, boolean isSimpleRecordWithDefinedSource, boolean isDynamicResolve, @NotNull JSRecordType.TypeMember typeMember) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(17);
        }
        Collection<PsiElement> elements = QualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, !isSimpleRecordWithDefinedSource);
        boolean added = false;
        for (PsiElement element : elements) {
            if (element == null) continue;
            if (isDynamicResolve) {
                this.addPossibleCandidateResult(element, null);
                continue;
            }
            if (element instanceof JSImplicitElement && !(element instanceof TypeScriptProxyImplicitElement)) {
                this.addResult(element);
                continue;
            }
            if (this.execute(element, ResolveState.initial())) continue;
            added = true;
        }
        return !added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(@NotNull PsiElement sourceElement, boolean hasCallSignature, boolean hasConstructSignature) {
        if (sourceElement == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(18);
        }
        int level = ((ResultSink)this.getResultSink()).getNestingLevel();
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        ((ResultSink)this.getResultSink()).setNestingLevel(10);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature || hasConstructSignature ? JSTypeUtils.getFunctionTypeName(sourceElement.getContainingFile(), hasConstructSignature) : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, (PsiElement)object);
            }
        }
        finally {
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    @NotNull
    public static Collection<PsiElement> getElementsForTypeMember(@NotNull JSRecordType.TypeMember typeMember, @Nullable PsiElement sourceElement, boolean createImplicitElement) {
        if (typeMember == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(19);
        }
        if (typeMember instanceof PsiElement) {
            List<PsiElement> list2 = Collections.singletonList((PsiElement)typeMember);
            if (list2 == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(20);
            }
            return list2;
        }
        if (typeMember instanceof JSCompositeFunctionPropertySignatureImpl) {
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            for (JSRecordType.PropertySignature signature : ((JSCompositeFunctionPropertySignatureImpl)typeMember).getMembers()) {
                results.addAll(QualifiedItemProcessor.getElementsForTypeMember(signature, sourceElement, createImplicitElement));
            }
            ArrayList<PsiElement> arrayList = results;
            if (arrayList == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(21);
            }
            return arrayList;
        }
        JSRecordType.MemberSource ownSource = typeMember.getMemberSource();
        if (createImplicitElement && typeMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
            JSType propertySignatureType = propertySignature.getJSType();
            return QualifiedItemProcessor.createImplicitElements(sourceElement, propertySignature, propertySignatureType);
        }
        List list3 = ContainerUtil.createMaybeSingletonList((Object)ownSource.getSingleElement());
        if (list3 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(22);
        }
        return list3;
    }

    @NotNull
    private static Collection<PsiElement> createImplicitElements(@Nullable PsiElement sourceElement, @NotNull JSRecordType.PropertySignature propertySignature, @Nullable JSType propertySignatureType) {
        JSRecordType.MemberSource source2;
        if (propertySignature == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(23);
        }
        if (!(source2 = propertySignature.getMemberSource()).isMerged()) {
            PsiElement propertySource = source2.getSingleElement();
            final boolean hasType = propertySignatureType != null;
            final boolean isConst = propertySignature.isConst();
            PsiElement provider = (PsiElement)ObjectUtils.coalesce((Object)propertySource, (Object)sourceElement);
            if (provider == null) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    QualifiedItemProcessor.$$$reportNull$$$0(24);
                }
                return list2;
            }
            String name = propertySignature.getMemberName();
            JSLocalImplicitElementImpl element = new JSLocalImplicitElementImpl(name, propertySignatureType, provider, null){

                @Override
                public boolean hasMinorImportance() {
                    return !hasType;
                }

                @Override
                public boolean isConst() {
                    return isConst;
                }
            };
            List list3 = ContainerUtil.createMaybeSingletonList((Object)element);
            if (list3 == null) {
                QualifiedItemProcessor.$$$reportNull$$$0(25);
            }
            return list3;
        }
        List<PsiElement> elements = source2.getAllSourceElements();
        boolean readonly = propertySignature.isConst() || source2.isReadonly() || source2.isForceReadonly();
        boolean optional = propertySignature.isOptional() || source2.isForceOptional();
        boolean hasSingleDoc = source2.hasSingleDocumentation();
        Collection collection = elements.stream().filter(e -> e != null).map(e -> new TypeScriptMergedTypeImplicitElementImpl(propertySignature.getMemberName(), propertySignatureType, (PsiElement)e, readonly, optional, hasSingleDoc, source2.getSourceKind())).collect(Collectors.toList());
        if (collection == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(26);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeFromClass(JSType type, JSEvaluateContext evaluateContext, String typeString, PsiElement typeSource, boolean setTypeContext, JSQualifiedNamedElement jsClass) {
        JSExpression placeQualifier;
        JSReferenceExpression evaluateQualifier;
        if ("RemoteObject".equals(jsClass.getName()) && typeSource instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)typeSource).getType() == JSImplicitElement.Type.Tag) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)((JSOffsetBasedImplicitElement)typeSource).getElementAtOffset(), XmlTag.class);
            for (XmlTag method : tag.findSubTags("method", tag.getNamespace())) {
                if (!this.execute((PsiElement)method, ResolveState.initial())) break;
            }
            this.forceResolvedState();
            return;
        }
        boolean statics = false;
        if (!(!JSPsiImplUtils.isTheSameClass(typeSource, jsClass) || (evaluateQualifier = evaluateContext.getProcessedExpression()) == null || (placeQualifier = evaluateQualifier.getQualifier()) instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSCallExpression || evaluateQualifier.getParent() instanceof JSParenthesizedExpression || placeQualifier instanceof JSParenthesizedExpression)) {
            statics = true;
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            statics = true;
        }
        this.getAccessibilityProcessingHandler().setProcessStatics(statics);
        if (statics) {
            this.setTypeName(jsClass.getQualifiedName());
        }
        boolean saveSetTypeContext = this.isTypeContext();
        boolean saveToProcessMembers = this.isToProcessMembers();
        if (setTypeContext) {
            this.setTypeContext(setTypeContext);
            this.setToProcessMembers(false);
        }
        try {
            JSAttributeList attrList;
            if (!this.resolved.isResolved() && ("XML".equals(typeString) || "XMLList".equals(typeString))) {
                this.resolved = TypeResolveState.PrefixUnknown;
            }
            if (!jsClass.processDeclarations(this, ResolveState.initial(), (PsiElement)jsClass, this.place)) {
                this.forceResolvedState();
            }
            if (this.myEcma && ((attrList = ((JSAttributeListOwner)((Object)jsClass)).getAttributeList()) == null || !attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC))) {
                this.forceResolvedState();
            }
        }
        finally {
            if (setTypeContext) {
                this.setTypeContext(saveSetTypeContext);
                this.setToProcessMembers(saveToProcessMembers);
            }
        }
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(27);
        }
        if (state2 == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(28);
        }
        if (this.needPackages() && !(element instanceof JSPackageWrapper)) {
            return true;
        }
        if (this.resolved == TypeResolveState.PrefixUnknown && this.myName != null && element instanceof JSFunction && !(this.place.getParent() instanceof JSCallExpression)) {
            return true;
        }
        boolean b = super.execute(element, state2);
        if (this.myEcma && this.getResult() != null) {
            this.forceResolvedState();
        }
        return b;
    }

    @Override
    public void prefixResolved() {
        if (this.myEcma || this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    @Override
    protected void elementIsNotAccessible(PsiElement element) {
        super.elementIsNotAccessible(element);
        if (this.myEcma || this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    private boolean isActionScriptDummyResolve() {
        if (this.place instanceof JSReferenceExpressionImpl) {
            JSExpression originalQualifier = BaseJSSymbolProcessor.getOriginalQualifier(((JSReferenceExpressionImpl)this.place).getResolveQualifier());
            if (originalQualifier instanceof JSCallExpression) {
                originalQualifier = ((JSCallExpression)originalQualifier).getMethodExpression();
            }
            if (originalQualifier instanceof JSReferenceExpression && ((JSReferenceExpression)originalQualifier).multiResolve(false).length == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean noMoreResultsPossible() {
        return this.resolved == TypeResolveState.Resolved || this.resolved == TypeResolveState.Undefined && (this.myTypeScript || this.myEcma) || this.resolved == TypeResolveState.PrefixUnknown && this.myEcma;
    }

    public void evaluateExpressionOrElementType(@NotNull PsiElement element, @Nullable PsiFile targetFile) {
        if (element == null) {
            QualifiedItemProcessor.$$$reportNull$$$0(29);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes(element, targetFile, this, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 8: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssRuleset";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/QualifiedItemProcessor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForTypeMember";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplicitElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processActionScriptClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processCssClasses";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectCssClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeMember";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassMembers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForTypeMember";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitElements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeResolveState {
        Unknown,
        Resolved,
        ResolvedAllowsExtras,
        Undefined,
        PrefixUnknown;


        public boolean isResolved() {
            return this == Resolved || this == ResolvedAllowsExtras;
        }

        public boolean isSuitableForReferenceResolve() {
            return this.isResolved() || this == Undefined;
        }
    }
}

