/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSMergeResolveProcessor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSSuperMemberResolveProcessor
extends ResolveProcessor {
    private final PsiElement myContext;
    private final boolean myOnlyFunctions;
    private final String myNamespace;
    private boolean acceptGetter;
    private boolean acceptSetter;
    private boolean isStaticContext;
    private final JSMergeResolveProcessor processor;

    JSSuperMemberResolveProcessor(@NotNull String name, @Nullable PsiElement context, boolean onlyFunctions, @Nullable String namespace) {
        if (name == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(0);
        }
        super(name, context);
        this.myContext = context;
        this.processor = new JSMergeResolveProcessor(name, false);
        this.myOnlyFunctions = onlyFunctions;
        this.myNamespace = namespace;
        this.acceptGetter = false;
        this.acceptSetter = false;
        this.isStaticContext = false;
        if (context instanceof JSFunction && JSPsiImplUtils.isGetterOrSetter((JSFunction)context)) {
            this.acceptGetter = ((JSFunction)context).isGetProperty();
            this.acceptSetter = ((JSFunction)context).isSetProperty();
        }
        if (context instanceof JSFunction || context instanceof JSField) {
            this.isStaticContext = ((JSQualifiedNamedElement)context).getJSContext() == JSContext.STATIC;
        }
        this.setLocalResolve(true);
        this.setToProcessHierarchy(true);
        this.setToProcessActionScriptImplicits(false);
    }

    @NotNull
    List<PsiElement> getResults() {
        List<PsiElement> list2 = this.processor.getResults();
        if (list2 == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(2);
        }
        if (state2 == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(3);
        }
        if (element instanceof JSFunction) {
            JSFunction jsFunction = (JSFunction)element;
            if (jsFunction.isConstructor()) {
                return true;
            }
            if (jsFunction.isGetProperty() && !this.acceptGetter && !(this.myContext instanceof JSField)) {
                return true;
            }
            if (jsFunction.isSetProperty() && !this.acceptSetter && !(this.myContext instanceof JSField)) {
                return true;
            }
        }
        if (this.isAcceptableElement(element)) {
            boolean currentStatic;
            boolean bl = currentStatic = ((JSQualifiedNamedElement)element).getJSContext() == JSContext.STATIC;
            if (currentStatic != this.isStaticContext) {
                return true;
            }
            if (!JSInheritanceUtil.isRealOverride((JSAttributeListOwner)element, this.myNamespace, this.myContext)) {
                return true;
            }
            return this.processor.execute(element, state2);
        }
        return true;
    }

    private boolean isAcceptableElement(@NotNull PsiElement element) {
        if (element == null) {
            JSSuperMemberResolveProcessor.$$$reportNull$$$0(4);
        }
        return !this.myOnlyFunctions && (element instanceof JSField || element instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) || element instanceof JSFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSSuperMemberResolveProcessor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSSuperMemberResolveProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

