/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocCommentCachedDataBuilder
implements JSDocumentationProcessor {
    @NotNull
    private final JSDocCommentCachedData myCachedData;
    private String myNameTag;
    private String myMemberOfTag;

    JSDocCommentCachedDataBuilder(@NotNull JSDocCommentCachedData cachedData) {
        if (cachedData == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(0);
        }
        this.myCachedData = cachedData;
    }

    @Override
    public boolean needsPlainCommentData() {
        return false;
    }

    @Override
    public boolean onCommentLine(@NotNull String line) {
        if (line == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName2, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
        if (type == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(2);
        }
        if (line == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(3);
        }
        if (patternMatched == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(4);
        }
        if (type == JSDocumentationProcessor.MetaDocType.TYPEDEF) {
            this.myCachedData.addTypedef(matchName2, matchValue);
            this.myCachedData.setIsInterface();
        } else if (type == JSDocumentationProcessor.MetaDocType.TYPE) {
            this.myCachedData.setType(matchValue);
        } else if (type == JSDocumentationProcessor.MetaDocType.ALIAS) {
            this.myNameTag = matchName2;
            this.myCachedData.setAlias(matchName2);
        } else if (type == JSDocumentationProcessor.MetaDocType.NAME || type == JSDocumentationProcessor.MetaDocType.EXTERNAL) {
            this.myNameTag = matchName2;
        } else if (type == JSDocumentationProcessor.MetaDocType.CALLBACK) {
            this.myNameTag = matchName2;
            this.myCachedData.setIsInterface();
            this.myCachedData.setSeemsToBeFunction();
            this.myCachedData.addTypedef(matchName2, "Function");
        } else if (type == JSDocumentationProcessor.MetaDocType.FUNCTION || type == JSDocumentationProcessor.MetaDocType.METHOD) {
            if (matchName2 != null) {
                this.myNameTag = matchName2;
            }
            this.myCachedData.setSeemsToBeFunction();
            if (type == JSDocumentationProcessor.MetaDocType.METHOD) {
                this.myCachedData.setIsMember(true);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.MEMBER_OF) {
            this.myMemberOfTag = matchName2;
        } else if (type == JSDocumentationProcessor.MetaDocType.CLASS || type == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR) {
            if (matchName2 != null) {
                this.myCachedData.setClassName(JSQualifiedNameImpl.fromNamepath(matchName2));
            }
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.NAMESPACE) {
            this.myCachedData.setHasNamespaceTag();
            if (matchName2 != null) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromNamepath(matchName2);
                this.myCachedData.setExplicitName(qName.getName());
                this.myCachedData.setNamespace(qName.getParent());
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PROPERTY && matchName2 != null) {
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.fromNamepath(matchName2);
            this.myCachedData.addProperty(prop, matchValue);
        } else if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && matchName2 != null) {
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.fromQualifiedName(matchName2);
            this.myCachedData.setOptional(prop);
        } else if (type == JSDocumentationProcessor.MetaDocType.TEMPLATE && matchName2 != null) {
            List generics = StringUtil.split((String)matchName2, (String)",");
            for (String generic : generics) {
                this.myCachedData.addGenericParameter(generic.trim(), matchValue);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PRIVATE) {
            this.myCachedData.setAccessType(JSAttributeList.AccessType.PRIVATE);
            if (matchName2 != null) {
                this.myCachedData.setType(matchName2);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PROTECTED) {
            this.myCachedData.setAccessType(JSAttributeList.AccessType.PROTECTED);
            if (matchName2 != null) {
                this.myCachedData.setType(matchName2);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PUBLIC) {
            this.myCachedData.setAccessType(JSAttributeList.AccessType.PUBLIC);
            if (matchName2 != null) {
                this.myCachedData.setType(matchName2);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.STATIC) {
            this.myCachedData.setContext(JSContext.STATIC);
        } else if (type == JSDocumentationProcessor.MetaDocType.EXTENDS || type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS) {
            if (matchName2 != null) {
                this.myCachedData.addBaseType(matchName2);
            }
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.MIXES) {
            if (matchName2 != null) {
                String instanceType = JSBaseTypesIndex.serializeHierarchyElement(JSQualifiedNameImpl.fromQualifiedName(matchName2), JSContext.INSTANCE);
                String staticType = JSBaseTypesIndex.serializeHierarchyElement(JSQualifiedNameImpl.fromQualifiedName(matchName2), JSContext.STATIC);
                this.myCachedData.addBaseType(instanceType);
                this.myCachedData.addBaseType(staticType);
                this.myCachedData.addStaticBaseType(instanceType);
                this.myCachedData.addStaticBaseType(staticType);
            }
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.ENUM) {
            this.myCachedData.setEnumType(matchValue == null || matchValue.isEmpty() ? "number" : matchValue);
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.CONFIG) {
            this.myCachedData.setExplicitName(matchName2);
        } else if (type == JSDocumentationProcessor.MetaDocType.LENDS) {
            this.myCachedData.setLendsTagValue(matchName2);
        } else if (type == JSDocumentationProcessor.MetaDocType.INTERFACE) {
            this.myCachedData.setIsInterface();
            if (matchName2 != null) {
                this.applyNamepath(matchName2);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.MIXIN) {
            if (matchName2 != null) {
                this.applyNamepath(matchName2);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
            this.myCachedData.setHasDeprecatedTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.CONSTRUCTS) {
            this.myCachedData.setHasConstructsTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.RETURN) {
            this.myCachedData.setReturnType(matchValue);
        } else if (type == JSDocumentationProcessor.MetaDocType.BROWSER) {
            if ("ie".equalsIgnoreCase(remainingLineContent)) {
                this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.IE);
            } else if ("gecko".equalsIgnoreCase(remainingLineContent)) {
                this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.GECKO);
            } else if ("opera".equalsIgnoreCase(remainingLineContent)) {
                this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.OPERA);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.GLOBAL) {
            this.myCachedData.setNamespace(null);
            this.myCachedData.setHasGlobalTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.MEMBER) {
            if (matchName2 != null) {
                this.myNameTag = matchName2;
            }
            this.myCachedData.setType(matchValue);
            this.myCachedData.setIsMember(true);
        } else if (type == JSDocumentationProcessor.MetaDocType.PARAMETER || type == JSDocumentationProcessor.MetaDocType.FIELD) {
            if (matchName2 != null) {
                JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(matchName2);
                this.myCachedData.addParameter(name, matchValue);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.DEFAULT) {
            if (matchName2 != null) {
                this.myCachedData.addDefaultValue(JSQualifiedNameImpl.fromQualifiedName(matchName2), remainingLineContent);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.THIS) {
            this.myCachedData.setThisType(matchValue);
        } else if (type == JSDocumentationProcessor.MetaDocType.ABSTRACT) {
            this.myCachedData.setHasAbstractTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.FINAL) {
            this.myCachedData.setHasConstTag();
            if (matchName2 != null) {
                this.myNameTag = matchName2;
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.EVENT) {
            if (matchName2 != null) {
                this.myNameTag = JSDocumentationUtils.appendPrefixToName(matchName2, "event:");
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.MODULE || type == JSDocumentationProcessor.MetaDocType.EXPORTS) {
            boolean looksLikeYuiModuleTag;
            boolean looksLikeAngularRequiredModuleTag = type == JSDocumentationProcessor.MetaDocType.MODULE && this.myNameTag != null;
            boolean bl = looksLikeYuiModuleTag = type == JSDocumentationProcessor.MetaDocType.MODULE && this.myCachedData.getClassName() != null;
            if (matchName2 != null && !looksLikeAngularRequiredModuleTag && !looksLikeYuiModuleTag) {
                this.myNameTag = JSDocumentationUtils.appendPrefixToName(matchName2, "module:");
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.INSTANCE) {
            this.myCachedData.setContext(JSContext.INSTANCE);
            this.myCachedData.setHasInstanceTag();
        }
        if (type == JSDocumentationProcessor.MetaDocType.PARAMETER || type == JSDocumentationProcessor.MetaDocType.RETURN) {
            this.myCachedData.setSeemsToBeFunction();
        }
        return true;
    }

    private void applyNamepath(@NotNull String matchName2) {
        if (matchName2 == null) {
            JSDocCommentCachedDataBuilder.$$$reportNull$$$0(5);
        }
        JSNamespace namespace = JSNamedTypeFactory.fromNamepath(matchName2, true);
        JSQualifiedName qName = namespace.getQualifiedName();
        assert (qName != null);
        this.myCachedData.setExplicitName(qName.getName());
        JSQualifiedName parent = qName.getParent();
        this.myCachedData.setNamespace(parent);
        this.myCachedData.setContext(namespace.getJSContext());
    }

    @Override
    public void postProcess() {
        if (this.myNameTag != null || this.myMemberOfTag != null) {
            JSContext context = JSContext.STATIC;
            JSQualifiedName namespace = null;
            if (this.myNameTag != null) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromNamepath(this.myNameTag);
                String name = qName.getName();
                this.myCachedData.setExplicitName(name);
                namespace = qName.getParent();
                if (this.myNameTag.length() > name.length()) {
                    char lastSeparator = this.myNameTag.charAt(this.myNameTag.length() - name.length() - 1);
                    if (lastSeparator == '#') {
                        context = JSContext.INSTANCE;
                    } else if (lastSeparator == '~') {
                        context = JSContext.UNKNOWN;
                    }
                }
            }
            if (this.myMemberOfTag != null) {
                String memberOf = this.myMemberOfTag;
                if (memberOf.endsWith("#")) {
                    context = JSContext.INSTANCE;
                    memberOf = memberOf.substring(0, memberOf.length() - 1);
                }
                namespace = JSQualifiedNameImpl.fromNamepath(memberOf);
            }
            this.myCachedData.setNamespace(namespace);
            if (this.myCachedData.getContext() == JSContext.UNKNOWN) {
                this.myCachedData.setContext(context);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMatched";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onCommentLine";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onPatternMatch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNamepath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

