/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterImpl
extends JSParameterImpl
implements TypeScriptParameter {
    public TypeScriptParameterImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean isConst() {
        JSAttributeList list2;
        if (TypeScriptPsiUtil.isFieldParameter(this) && (list2 = this.getAttributeList()) != null) {
            return list2.hasModifier(JSAttributeList.ModifierType.READONLY);
        }
        return super.isConst();
    }

    public TypeScriptParameterImpl(JSParameterStub stub) {
        super(stub, TypeScriptStubElementTypes.TYPESCRIPT_PARAMETER);
    }

    @Override
    public JSType calculateDeclarationTypeStubSafe() {
        JSType type = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (type != null) {
            return this.isRest() ? TypeScriptParameterImpl.getFromRestType(type) : type;
        }
        JSType paired = this.tryGetTypeFromPairedAccessor();
        if (paired != null) {
            return paired;
        }
        PsiElement parent = this.getContext();
        if (JSDestructuringUtil.isDestructuring(parent)) {
            return JSWidenType.createWidening(new JSDestructuringTypeImpl(this), this);
        }
        return this.tryGetTypeFromPairedAccessor();
    }

    @Nullable
    private JSType tryGetTypeFromPairedAccessor() {
        JSFunction function2 = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSFunction.class});
        if (function2 == null || !function2.isSetProperty()) {
            return null;
        }
        PsiElement context = function2.getContext();
        if (!(context instanceof JSElement)) {
            return null;
        }
        for (PsiElement element : JSStubBasedPsiTreeUtil.getChildrenByType((JSElement)context, JSElementTypes.FUNCTIONS)) {
            if (!(element instanceof JSFunction) || !((JSFunction)element).isGetProperty() || !ES6PsiUtil.checkNamesEquivalent((JSFunction)element, function2)) continue;
            return ((JSFunction)element).getReturnType();
        }
        return null;
    }

    private static JSType getFromRestType(@NotNull JSType type) {
        JSGenericTypeImpl genericType;
        if (type == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(0);
        }
        if (type instanceof JSArrayType && !((JSArrayType)type).isPrimitive()) {
            return ((JSArrayType)type).getType();
        }
        if (type instanceof JSGenericTypeImpl && JSArrayType.isGenericArray(genericType = (JSGenericTypeImpl)type)) {
            return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
        }
        return new JSRestTypeImpl(type, type.getSource());
    }

    @Override
    @Nullable
    public JSType calculateType() {
        JSType type = this.calculateDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        JSExpression initializer = this.getInitializer();
        if (initializer != null) {
            JSType indexing = JSDialectSpecificHandlersFactory.forElement(this).getTypeHelper().getTypeForIndexing(initializer, this);
            type = JSWidenType.createWidening(indexing, this);
        }
        return type;
    }

    @Override
    public boolean isOptional() {
        JSParameterStub parameterStub = (JSParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        if (this.isDeclaredOptional()) {
            return true;
        }
        if (this.getInitializer() == null) {
            return false;
        }
        return this.isOptionalForParameterWithInitializer();
    }

    public boolean isDeclaredOptional() {
        return this.getNode().findChildByType(JSTokenTypes.QUEST) != null;
    }

    private boolean isOptionalForParameterWithInitializer() {
        JSFunction function2 = this.getDeclaringFunction();
        if (function2 == null) {
            return true;
        }
        boolean checkCurrent = false;
        for (JSParameterListElement parameter : function2.getParameters()) {
            if (parameter == this) {
                checkCurrent = true;
                continue;
            }
            if (!checkCurrent) continue;
            if (parameter.isOptional() || parameter.isRest()) break;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JSClass parentClass;
        if (TypeScriptPsiUtil.isFieldParameter(this) && (parentClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this, JSClass.class)) != null) {
            JSAttributeList.AccessType accessType = this.getAccessType();
            Object object = accessType == JSAttributeList.AccessType.PRIVATE ? new LocalSearchScope((PsiElement)parentClass) : parentClass.getUseScope();
            if (object == null) {
                TypeScriptParameterImpl.$$$reportNull$$$0(1);
            }
            return object;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getExplicitAccessType();
            if (type != null) {
                JSAttributeList.AccessType accessType = type;
                if (accessType == null) {
                    TypeScriptParameterImpl.$$$reportNull$$$0(3);
                }
                return accessType;
            }
            if (TypeScriptPsiUtil.isFieldParameter(this)) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    TypeScriptParameterImpl.$$$reportNull$$$0(4);
                }
                return accessType;
            }
        }
        JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptParameterImpl.$$$reportNull$$$0(5);
        }
        return accessType;
    }

    @Override
    @Nullable
    public JSType getInferredType() {
        JSType overridden = this.getSimpleType();
        return this.isOptional() ? TypeScriptTypeGuard.wrapWithUndefined(overridden, null) : overridden;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    protected boolean isTypeStrict() {
        return true;
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return false;
    }

    @Override
    public boolean isDecoratorRest() {
        return this.isRest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFromRestType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

