/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.presentable;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementKind;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSNamedElementPresenter {
    private final JSNamedElementKind myKind;
    private final Capitalization myCapitalization;
    private final boolean myAddElementKind;
    @NlsSafe
    private String myShortName;
    @NlsSafe
    private String myQualifiedName;
    private final PsiElement myElement;

    public JSNamedElementPresenter(@NotNull PsiElement element) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(0);
        }
        this(element, Capitalization.LowerCase);
    }

    public JSNamedElementPresenter(@NotNull PsiElement element, @NotNull Capitalization capitalization) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(1);
        }
        if (capitalization == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(2);
        }
        this(element, capitalization, true);
    }

    public JSNamedElementPresenter(@NotNull PsiElement element, @NotNull Capitalization capitalization, boolean addElementKind) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(3);
        }
        if (capitalization == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(4);
        }
        this.myKind = JSNamedElementKind.kind(element);
        this.myCapitalization = capitalization;
        this.myAddElementKind = addElementKind;
        this.myElement = element;
    }

    void overrideShortName(@NotNull String name) {
        if (name == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(5);
        }
        this.myShortName = name;
    }

    @NotNull
    @NlsSafe
    public String getQualifiedName() {
        if (this.myQualifiedName != null) {
            String string = this.myQualifiedName;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(6);
            }
            return string;
        }
        this.myQualifiedName = this.computePresentableName(true);
        if (this.myQualifiedName == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(7);
        }
        return this.myQualifiedName;
    }

    @NotNull
    @NlsSafe
    public String getShortName() {
        if (this.myShortName != null) {
            String string = this.myShortName;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(8);
            }
            return string;
        }
        this.myShortName = this.computePresentableName(false);
        if (this.myShortName == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(9);
        }
        return this.myShortName;
    }

    @NotNull
    @Nls
    public String describeElementKind() {
        String message = JavaScriptBundle.message(this.myKind.humanReadableKey(), new Object[0]);
        switch (this.myCapitalization) {
            case UpperCase: {
                String string = StringUtil.capitalize((String)message);
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(10);
                }
                return string;
            }
            case LowerCase: {
                String string = message;
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = StringUtil.capitalizeWords((String)message, (boolean)true);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @Nls
    private String computePresentableName(boolean qualified) {
        if (qualified) {
            String name;
            if (this.myElement instanceof JSQualifiedNamedElement && (name = ((JSQualifiedNamedElement)this.myElement).getQualifiedName()) != null) {
                String string = name;
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = this.getShortName();
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(14);
            }
            return string;
        }
        String name = null;
        if (this.myElement instanceof JSPsiNamedElementBase) {
            name = this.myElement instanceof JSImplicitElementImpl ? ((JSImplicitElementImpl)this.myElement).getName() : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)this.myElement, true);
        } else if (this.myElement instanceof PsiNamedElement) {
            name = ((PsiNamedElement)this.myElement).getName();
        }
        String string = name != null ? name : JSFormatUtil.getAnonymousName(this.myElement);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @Nls
    public String describeWithShortName() {
        String string = this.describeWithShortName(false);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    @Nls
    public String describeWithShortName(boolean htmlEmphasize) {
        String elementKind = this.describeElementKind();
        if (this.myKind == JSNamedElementKind.ES6_DEFAULT_EXPORT) {
            return this.myAddElementKind ? elementKind : "";
        }
        @Nls String name = this.getShortName();
        if (this.myKind == JSNamedElementKind.CONSTRUCTOR && "constructor".equals(name)) {
            return this.myAddElementKind ? elementKind : "";
        }
        if (htmlEmphasize) {
            Object result2 = StringUtil.htmlEmphasize((String)name);
            if (this.myAddElementKind) {
                result2 = elementKind + " " + (String)result2;
            }
            String string = result2;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(17);
            }
            return string;
        }
        Object object = this.myAddElementKind ? elementKind + " '" + name + "'" : name;
        if (object == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(18);
        }
        return object;
    }

    @NotNull
    public String describeWithQualifiedName() {
        if (this.myKind == JSNamedElementKind.ES6_DEFAULT_EXPORT) {
            return this.myAddElementKind ? this.describeElementKind() : "";
        }
        Object object = this.myAddElementKind ? this.describeElementKind() + " " + this.getQualifiedName() : this.getQualifiedName();
        if (object == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(19);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalization";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/presentable/JSNamedElementPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/presentable/JSNamedElementPresenter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "describeElementKind";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentableName";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithShortName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "overrideShortName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

