/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSNodeModulesHandlerScope;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.CommonJSImportCandidate;
import com.intellij.lang.javascript.modules.imports.ES6FixedImportCandidate;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ImportDeclarationPartIndex;
import com.intellij.lang.javascript.psi.stubs.JSLazyIndexedPackagesIndex;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportedCandidatesProvider
extends JSImportCandidatesBase {
    @Nullable
    private MultiMap<String, JSElement> myAllRegularExternalModules;
    @Nullable
    private MultiMap<String, Pair<JSElement, String>> myElementsFromResolvedPackages;
    @NotNull
    private final Predicate<? super JSElement> myPlaceWithAcceptableForImportFilter;
    @NotNull
    private final Predicate<? super JSElement> myPlaceFilter;
    @NotNull
    private final GlobalSearchScope myExportedElementsScope;
    @NotNull
    private final GlobalSearchScope myProjectImportsScope;
    @NotNull
    private final Set<String> myPackageJsonModules;
    @Nullable
    private final VirtualFile myModuleRootDirectory;

    protected ES6ExportedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
        PsiElement place = placeInfo.getPlace();
        Project project = place.getProject();
        boolean isTypeScript = DialectDetector.isTypeScript(place);
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(project);
        JSCompletionPlaceFilter filter = JSCompletionPlaceFilter.forPlace(place);
        this.myPlaceFilter = el -> {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)el);
            return !(file2 == null || el instanceof JSPsiElementBase && !filter.isAcceptable((JSPsiElementBase)el) || libraries.contains(file2) || ES6ExportedCandidatesProvider.needToCheckConfigAccess((PsiElement)el, isTypeScript) && !TypeScriptConfigService.Provider.isAccessible(project, placeInfo.getFile(), file2));
        };
        this.myPlaceWithAcceptableForImportFilter = element -> this.myPlaceFilter.test((JSElement)element) && ES6ExportedCandidatesProvider.isAcceptableForImport(placeInfo, placeInfo.importContext(), element);
        this.myExportedElementsScope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, place);
        this.myPackageJsonModules = JSNodeModulesHandlerScope.getAcceptableModules(project, placeInfo.getFile());
        this.myModuleRootDirectory = ES6ExportedCandidatesProvider.getRoot(placeInfo);
        this.myProjectImportsScope = new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(place)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && !NodeModuleUtil.hasNodeModulesDirInPath(file2, null) && (ES6ExportedCandidatesProvider.this.myModuleRootDirectory == null || VfsUtilCore.isAncestor((VirtualFile)ES6ExportedCandidatesProvider.this.myModuleRootDirectory, (VirtualFile)file2, (boolean)true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider$1", "contains"));
            }
        };
    }

    @NotNull
    private MultiMap<String, Pair<JSElement, String>> getElementsFromResolvedPackages() {
        if (this.myElementsFromResolvedPackages != null) {
            MultiMap<String, Pair<JSElement, String>> multiMap = this.myElementsFromResolvedPackages;
            if (multiMap == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(1);
            }
            return multiMap;
        }
        PsiElement place = this.myPlaceInfo.getPlace();
        MultiMap result2 = MultiMap.createSet();
        List toProcess = ContainerUtil.filter(this.myPackageJsonModules, el -> !JSLazyIndexedPackagesIndex.LAZY_PACKAGES.contains(el));
        for (String module : toProcess) {
            CompletionResultSink sink = new CompletionResultSink(place, null);
            Collection<PsiElement> elements = JSFileReferencesUtil.resolveModuleReference(place, module);
            List tsElements = ((StreamEx)StreamEx.of(ES6PsiUtil.convertWithExportAssignments(elements)).select(JSElement.class).filter(el -> TypeScriptUtil.isDefinitionFile(el.getContainingFile()))).toList();
            if (tsElements.isEmpty()) continue;
            ES6PsiUtil.processExportedSymbols(place, tsElements, sink);
            List<PsiElement> results = sink.getResults();
            if (results == null) continue;
            for (PsiElement candidate : results) {
                JSElement jsElement;
                String name;
                if (!(candidate instanceof JSElement) || StringUtil.isEmpty((String)(name = (jsElement = (JSElement)candidate).getName())) || !this.myPlaceFilter.test(jsElement)) continue;
                result2.putValue((Object)name, (Object)Pair.create((Object)jsElement, (Object)module));
            }
        }
        this.myElementsFromResolvedPackages = result2;
        MultiMap multiMap = result2;
        if (multiMap == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @Override
    public boolean processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        PsiElement place;
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (!(place = this.myPlaceInfo.getPlace()).isValid()) {
            return true;
        }
        Project project = place.getProject();
        ArrayList<JSElement> candidates = new ArrayList<JSElement>();
        this.addExportedElements(name, project, this.myExportedElementsScope, candidates);
        this.addExportedDefaultAssignmentElements(name, project, this.myExportedElementsScope, candidates);
        this.addExternalModuleNames(name, candidates);
        Collection<JSElement> result2 = this.removeOverloads(candidates);
        StreamEx exported = ((StreamEx)((StreamEx)StreamEx.of(result2).filter(this.myPlaceWithAcceptableForImportFilter)).distinct()).flatMap(el -> ES6ExportedCandidatesProvider.createCandidates(name, el, this.myPlaceInfo, forCompletion)).nonNull();
        List<JSImportCandidate> defaultExport = this.getProjectImports(name);
        List<JSImportCandidate> directElements = this.getDirectExportedFromPackages(name);
        exported.forEach(processor::processCandidate);
        defaultExport.forEach(processor::processCandidate);
        directElements.forEach(processor::processCandidate);
        return true;
    }

    @NotNull
    private List<JSImportCandidate> getDirectExportedFromPackages(@NotNull String name) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(5);
        }
        if (this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.BINDING) {
            List<JSImportCandidate> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(6);
            }
            return list2;
        }
        MultiMap<String, Pair<JSElement, String>> packages = this.getElementsFromResolvedPackages();
        Collection pairs = packages.get((Object)name);
        if (pairs.isEmpty()) {
            List<JSImportCandidate> list3 = Collections.emptyList();
            if (list3 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(7);
            }
            return list3;
        }
        ArrayList<JSImportCandidate> result2 = new ArrayList<JSImportCandidate>();
        PsiElement place = this.myPlaceInfo.getPlace();
        for (Pair pair : pairs) {
            NodeModuleUtil.NodeModuleStructure structure;
            String moduleName = (String)pair.second;
            JSElement element = this.expandElementAndFilter((PsiElement)pair.first, this.myPlaceInfo.getPlace()).orElse(null);
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file2 == null || (structure = NodeModuleUtil.getNodeModuleStructure(this.myPlaceInfo.getProject(), file2)) == null || !this.isFromIndirectPackage(element, file2, structure) && element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExported()) continue;
            if (moduleName.startsWith("@types/")) {
                moduleName = ES6CreateImportUtil.convertScopedTypesName(moduleName.substring("@types/".length()));
            }
            result2.add(new ES6FixedImportCandidate(name, element, place, ES6ImportPsiUtil.ImportExportType.SPECIFIER, moduleName));
        }
        ArrayList<JSImportCandidate> arrayList = result2;
        if (arrayList == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private boolean isFromIndirectPackage(JSElement element, VirtualFile file2, NodeModuleUtil.NodeModuleStructure structure) {
        return ES6ExportedCandidatesProvider.hasNodeModulesInPath((PsiElement)element) && !NodeCoreLibraryManager.getInstance(this.getProject()).isCoreLibraryFile(file2) && !this.myPackageJsonModules.isEmpty() && !this.myPackageJsonModules.contains(structure.getPackageName()) && !this.myPackageJsonModules.contains(structure.getOriginalPackageName());
    }

    @NotNull
    public static Stream<JSImportCandidate> createCandidates(@NotNull String name, @NotNull JSElement el, @NotNull JSImportPlaceInfo placeInfo, boolean forCompletion) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(9);
        }
        if (el == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(10);
        }
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(11);
        }
        PsiElement place = placeInfo.getPlace();
        PsiFile placeFile = place.getContainingFile();
        PsiFile elementFile = el.getContainingFile();
        ES6ImportCandidate es6ImportCandidate = null;
        if (ES6ExportedCandidatesProvider.isES6ImportAllowed(place)) {
            es6ImportCandidate = new ES6ImportCandidate(name, el, place, placeInfo.importContext(), ES6ExportedCandidatesProvider.isUseImport(el, forCompletion, placeInfo));
        }
        CommonJSImportCandidate commonJSImportCandidate = null;
        if (es6ImportCandidate == null || !(place instanceof JSXmlLiteralExpression) && placeFile instanceof JSFile && DialectDetector.isJavaScript((PsiElement)placeFile) && !((JSFile)placeFile).hasFlowFlag() && ((JSFile)placeFile).getModuleStatus() != JSModuleStatusOwner.ModuleStatus.ES6 && !CommonJSUtil.isMjsFile(placeFile) && !ES6ExportedCandidatesProvider.isImportedInProject(el.getName(), placeInfo.getProject()) && (ES6ExportedCandidatesProvider.hasNodeModulesInPath((PsiElement)el) || elementFile instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)elementFile).getModuleStatus() != JSModuleStatusOwner.ModuleStatus.ES6)) {
            commonJSImportCandidate = new CommonJSImportCandidate(name, el, place);
        }
        StreamEx streamEx = StreamEx.of((Object[])new JSImportCandidate[]{es6ImportCandidate, commonJSImportCandidate}).nonNull();
        if (streamEx == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(12);
        }
        return streamEx;
    }

    public static boolean isES6ImportAllowed(@NotNull PsiElement place) {
        PsiFile placeFile;
        if (place == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(13);
        }
        return !((placeFile = place.getContainingFile()) instanceof JSModuleStatusOwner) || ((JSModuleStatusOwner)placeFile).getModuleStatus() != JSModuleStatusOwner.ModuleStatus.COMMONJS || !DialectDetector.isJavaScript(place);
    }

    private static boolean isImportedInProject(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(14);
        }
        GlobalSearchScope scope = ProjectScope.getProjectScope((Project)project);
        return name != null && !JSIndexBasedResolveUtil.hasLessFilesInScope(scope, project, name, ES6ImportDeclarationPartIndex.KEY, 0);
    }

    private static boolean isUseImport(@NotNull JSElement el, boolean forCompletion, @NotNull JSImportPlaceInfo placeInfo) {
        if (el == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(15);
        }
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(16);
        }
        PsiElement place = placeInfo.getPlace();
        PsiFile file2 = place.getContainingFile();
        boolean skipNodeModulesImport = !DialectDetector.isTypeScript(place) && !(file2 instanceof JSFile);
        return placeInfo.importContext() == JSImportPlaceInfo.ImportContext.TAG || !forCompletion || !skipNodeModulesImport || !ES6ExportedCandidatesProvider.hasNodeModulesInPath((PsiElement)el);
    }

    public void addExportedDefaultAssignmentElements(@NotNull String name, Project project, GlobalSearchScope scope, List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(17);
        }
        if (this.myPlaceInfo.importContext() != JSImportPlaceInfo.ImportContext.SPECIFIER) {
            Processor assignmentProcessor = CommonProcessors.processAll(toProcess -> {
                JSElement expression = toProcess.getStubSafeElement();
                if (expression instanceof JSQualifiedNamedElement) {
                    if (expression.getName() == null) {
                        candidates.add(expression);
                    }
                } else {
                    candidates.add((JSElement)toProcess);
                }
            });
            StubIndex.getInstance().processElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)name, project, scope, JSExportAssignment.class, assignmentProcessor);
        }
    }

    public void addExportedElements(@NotNull String name, Project project, GlobalSearchScope scope, List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(18);
        }
        ArrayList exportSpecifiers = new ArrayList();
        HashSet scopesWithSpecifierExports = new HashSet();
        Processor processor = CommonProcessors.processAll(toProcess -> {
            if (toProcess instanceof ES6ExportSpecifier) {
                exportSpecifiers.add((ES6ExportSpecifier)toProcess);
                return;
            }
            if (ES6CreateImportUtil.isAvailableForImport((PsiElement)toProcess, this.myPlaceInfo)) {
                JSElement exportScope;
                JSPsiElementBase element;
                candidates.add((JSElement)toProcess);
                if (toProcess instanceof JSPsiElementBase && (element = (JSPsiElementBase)toProcess).isExported() && ES6PsiUtil.isExternalModule((PsiElement)(exportScope = ES6PsiUtil.getExportScope((PsiElement)element)))) {
                    scopesWithSpecifierExports.add(exportScope);
                }
            }
        });
        StubIndex.getInstance().processElements(ES6ExportedNamesIndex.KEY, (Object)name, project, scope, JSElement.class, processor);
        for (ES6ExportSpecifier specifier : exportSpecifiers) {
            JSElement exportScope = ES6PsiUtil.getExportScope((PsiElement)specifier);
            if (exportScope == null || scopesWithSpecifierExports.contains(exportScope) || exportScope == this.myPlaceInfo.getContainer() || !ES6CreateImportUtil.isAcceptableExportSpecifier(specifier)) continue;
            candidates.add(specifier);
        }
    }

    private static boolean hasNodeModulesInPath(@NotNull PsiElement element) {
        VirtualFile file2;
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(19);
        }
        return (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && NodeModuleUtil.hasNodeModulesDirInPath(file2, null);
    }

    @Override
    @NotNull
    public Set<String> getNames(@NotNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(20);
        }
        Project project = this.myPlaceInfo.getPlace().getProject();
        Set namedKeys = StubIndex.getInstance().getAllKeys(ES6ExportedNamesIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        ProgressManager.checkCanceled();
        Set defaultAssignmentKeys = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6DefaultAssignmentModuleIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        Set existingDefaultImportNames = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6ImportDeclarationPartIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        HashSet<String> result2 = new HashSet<String>(namedKeys);
        result2.addAll(defaultAssignmentKeys);
        result2.addAll(existingDefaultImportNames);
        result2.addAll(ContainerUtil.filter((Collection)this.getElementsFromResolvedPackages().keySet(), keyFilter::test));
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    public static boolean needToCheckConfigAccess(@NotNull PsiElement element, boolean isTypeScript) {
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(22);
        }
        if (isTypeScript && element instanceof TypeScriptModule && ((TypeScriptModule)element).isExternal()) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        return isTypeScript && (!(file2 instanceof JSModuleStatusOwner) || !((JSModuleStatusOwner)file2).isCommonJSModule());
    }

    public static boolean isAcceptableForImport(@NotNull JSImportPlaceInfo info, @NotNull JSImportPlaceInfo.ImportContext importContext, @NotNull JSElement element) {
        JSElement container;
        if (info == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(23);
        }
        if (importContext == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(24);
        }
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(25);
        }
        if ((container = ES6PsiUtil.getExportScope((PsiElement)element)) == info.getContainer()) {
            return false;
        }
        if (importContext != JSImportPlaceInfo.ImportContext.SPECIFIER && element instanceof TypeScriptModule && ((TypeScriptModule)element).isExternal()) {
            return true;
        }
        if (importContext != JSImportPlaceInfo.ImportContext.BINDING && element instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)element).getAlias() != null) {
            return true;
        }
        if (importContext == JSImportPlaceInfo.ImportContext.SPECIFIER && element instanceof JSPsiElementBase) {
            return ((JSPsiElementBase)element).isExported() && ES6PsiUtil.findExternalModule((PsiElement)element) != null;
        }
        if (importContext == JSImportPlaceInfo.ImportContext.BINDING) {
            if (element instanceof JSElementBase && ((JSElementBase)((Object)element)).isExportedWithDefault()) {
                return true;
            }
            return element instanceof ES6ExportDefaultAssignment;
        }
        if (element instanceof ES6ExportSpecifier && !ES6CreateImportUtil.isAcceptableExportSpecifier((ES6ExportSpecifier)element)) {
            return false;
        }
        return element instanceof JSExportAssignment || (importContext == JSImportPlaceInfo.ImportContext.SPECIFIER ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info));
    }

    @NotNull
    protected Collection<JSElement> removeOverloads(@NotNull Collection<? extends JSElement> candidates) {
        if (candidates == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(26);
        }
        List list2 = ContainerUtil.filter(candidates, el -> !ES6ExportedCandidatesProvider.isOverloadDeclaration(el));
        if (list2 == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(27);
        }
        return list2;
    }

    private void addExternalModuleNames(@NotNull String name, @NotNull List<JSElement> candidates) {
        if (name == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(28);
        }
        if (candidates == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(29);
        }
        if (this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.BINDING) {
            return;
        }
        MultiMap modules2 = this.myAllRegularExternalModules;
        if (modules2 == null) {
            modules2 = MultiMap.create();
            PsiElement myContext = this.myPlaceInfo.getPlace();
            for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(myContext.getProject(), myContext)) {
                String rawName = module.getExternalModuleText();
                if (rawName == null) continue;
                String moduleName = StringUtil.unquoteString((String)rawName).toLowerCase(Locale.ENGLISH);
                modules2.putValue((Object)moduleName, (Object)module);
            }
            this.myAllRegularExternalModules = modules2;
        }
        candidates.addAll(modules2.get((Object)name.toLowerCase(Locale.ENGLISH)));
    }

    private static boolean isOverloadDeclaration(@NotNull JSElement element) {
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(30);
        }
        return element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration();
    }

    @NotNull
    private List<JSImportCandidate> getProjectImports(@NotNull String referenceName) {
        PsiElement node;
        Collection elements;
        if (referenceName == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(31);
        }
        if ((elements = StubIndex.getElements(ES6ImportDeclarationPartIndex.KEY, (Object)referenceName, (Project)(node = this.myPlaceInfo.getPlace()).getProject(), (GlobalSearchScope)this.myProjectImportsScope, ES6ImportExportDeclarationPart.class)).size() == 0) {
            List<JSImportCandidate> list2 = Collections.emptyList();
            if (list2 == null) {
                ES6ExportedCandidatesProvider.$$$reportNull$$$0(32);
            }
            return list2;
        }
        SmartList objects = new SmartList();
        HashSet<Pair<JSImportExportType, String>> visited = new HashSet<Pair<JSImportExportType, String>>();
        boolean acceptsSpecifiersOnly = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.SPECIFIER;
        boolean acceptsDefaultOnly = this.myPlaceInfo.importContext() == JSImportPlaceInfo.ImportContext.BINDING;
        for (ES6ImportExportDeclarationPart part : elements) {
            ES6ImportPsiUtil.ImportExportType type;
            String text;
            ES6ImportExportDeclaration declaration = part.getDeclaration();
            boolean isDefault = part instanceof ES6ImportedBinding;
            if ((!isDefault ? acceptsDefaultOnly : acceptsSpecifiersOnly) || (text = ES6ExportedCandidatesProvider.getModuleNameFromDeclaration(declaration, type = isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER, visited)) == null) continue;
            ContainerUtil.addIfNotNull((Collection)objects, (Object)this.createImportCandidateForPart(referenceName, part, type, text));
        }
        SmartList smartList = objects;
        if (smartList == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(33);
        }
        return smartList;
    }

    @Nullable
    private JSImportCandidate createImportCandidateForPart(@NotNull String referenceName, @NotNull ES6ImportExportDeclarationPart element, @NotNull JSImportExportType type, @NotNull String text) {
        if (referenceName == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(34);
        }
        if (element == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(35);
        }
        if (type == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(36);
        }
        if (text == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(37);
        }
        PsiElement node = this.myPlaceInfo.getPlace();
        return this.expandElementAndFilter((PsiElement)element, node).map(jsElement -> new ES6FixedImportCandidate(referenceName, (JSElement)jsElement, node, type, StringUtil.unquoteString((String)text)){

            @Override
            public int getPriority() {
                return 3;
            }
        }).orElse(null);
    }

    @NotNull
    private Optional<JSElement> expandElementAndFilter(@NotNull PsiElement toExpand, PsiElement context) {
        if (toExpand == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(38);
        }
        Optional optional = ((StreamEx)((StreamEx)StreamEx.of(ES6PsiUtil.expandElements(context, Collections.singleton(toExpand))).select(JSElement.class).filter(el -> !ES6ExportedCandidatesProvider.isOverloadDeclaration(el))).filter(this.myPlaceFilter)).findAny();
        if (optional == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(39);
        }
        return optional;
    }

    @Contract(value="null,_,_->null")
    private static String getModuleNameFromDeclaration(@Nullable ES6ImportExportDeclaration declaration, @NotNull JSImportExportType type, @NotNull Set<Pair<JSImportExportType, String>> visited) {
        ES6FromClause clause;
        if (type == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(40);
        }
        if (visited == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(41);
        }
        ES6FromClause eS6FromClause = clause = declaration != null ? declaration.getFromClause() : null;
        if (clause == null) {
            return null;
        }
        String text = clause.getReferenceText();
        if (text == null) {
            return null;
        }
        String unquoted = StringUtil.unquoteString((String)text);
        if (!visited.add((Pair<JSImportExportType, String>)Pair.create((Object)type, (Object)unquoted)) || JSModuleFileReferenceSet.isRelative(unquoted)) {
            return null;
        }
        Collection<PsiElement> resolvedElements = clause.resolveReferencedElements();
        if (resolvedElements.size() == 0) {
            return null;
        }
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(resolvedElements);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)item);
        if (file2 == null) {
            return null;
        }
        if (!NodeModuleUtil.hasNodeModulesDirInPath(file2, null)) {
            return null;
        }
        return text;
    }

    @Nullable
    private static VirtualFile getRoot(@NotNull JSImportPlaceInfo placeInfo) {
        VirtualFile directory;
        TypeScriptConfig file2;
        PsiElement place;
        if (placeInfo == null) {
            ES6ExportedCandidatesProvider.$$$reportNull$$$0(42);
        }
        if (DialectDetector.isTypeScript(place = placeInfo.getPlace()) && (file2 = TypeScriptConfigUtil.getConfigForPsiFile(place.getContainingFile())) != null && VfsUtilCore.isAncestor((VirtualFile)(directory = file2.getConfigDirectory()), (VirtualFile)placeInfo.getFile(), (boolean)true)) {
            return directory;
        }
        return NodeModuleUtil.getMainModuleRoot(place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 17: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExpand";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromResolvedPackages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectExportedFromPackages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCandidates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOverloads";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectImports";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElementAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 39: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectExportedFromPackages";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCandidates";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isES6ImportAllowed";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isImportedInProject";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUseImport";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addExportedDefaultAssignmentElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addExportedElements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasNodeModulesInPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "needToCheckConfigAccess";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableForImport";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeOverloads";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addExternalModuleNames";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isOverloadDeclaration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getProjectImports";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createImportCandidateForPart";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "expandElementAndFilter";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameFromDeclaration";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            return new ES6ExportedCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/ES6ExportedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

