/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportPlaceInfo {
    private final ResolveResult @NotNull [] myResults;
    @NotNull
    private final PsiElement myPlace;
    @Nullable
    private final PsiElement myParent;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final PsiElement myContainer;
    @NotNull
    private final ImportContext myImportContext;
    private final boolean myStrictContext;

    @NotNull
    public static ImportContext detectContext(@NotNull PsiElement place) {
        if (place == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(0);
        }
        if (place instanceof XmlTag) {
            ImportContext importContext = ImportContext.TAG;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(1);
            }
            return importContext;
        }
        if (place instanceof ES6ImportSpecifier) {
            ImportContext importContext = ImportContext.SPECIFIER;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(2);
            }
            return importContext;
        }
        if (!(place instanceof ES6ImportedBinding)) {
            ImportContext importContext = ImportContext.SIMPLE;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(3);
            }
            return importContext;
        }
        ES6ImportDeclaration declaration = ((ES6ImportedBinding)place).getDeclaration();
        if (declaration == null) {
            ImportContext importContext = ImportContext.BINDING;
            if (importContext == null) {
                JSImportPlaceInfo.$$$reportNull$$$0(4);
            }
            return importContext;
        }
        ES6NamedImports namedImports = declaration.getNamedImports();
        ImportContext importContext = namedImports != null ? ImportContext.BINDING : ImportContext.SIMPLE;
        if (importContext == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(5);
        }
        return importContext;
    }

    public JSImportPlaceInfo(@NotNull PsiElement place, ResolveResult @NotNull [] results) {
        if (place == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(6);
        }
        if (results == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(7);
        }
        this.myPlace = place;
        this.myParent = place.getParent();
        this.myFile = place.getContainingFile().getOriginalFile().getVirtualFile();
        this.myContainer = ES6PsiUtil.getExportScope(place);
        this.myStrictContext = place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place);
        this.myResults = results;
        this.myImportContext = JSImportPlaceInfo.detectContext(place);
    }

    public JSImportPlaceInfo(@NotNull PsiElement place) {
        if (place == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(8);
        }
        this(place, ResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    public PsiElement getPlace() {
        PsiElement psiElement = this.myPlace;
        if (psiElement == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    public boolean isStrictTypeContext() {
        return this.myStrictContext;
    }

    @Nullable
    public PsiElement getParentElement() {
        return this.myParent;
    }

    @Nullable
    public PsiElement getContainer() {
        return this.myContainer;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    public ResolveResult @NotNull [] getResolveResults() {
        if (this.myResults == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(11);
        }
        return this.myResults;
    }

    public ImportContext importContext() {
        return this.myImportContext;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPlace.getProject();
        if (project == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(12);
        }
        return project;
    }

    public boolean isAvailableForImport(@NotNull PsiElement candidate) {
        if (candidate == null) {
            JSImportPlaceInfo.$$$reportNull$$$0(13);
        }
        if (!ES6PsiUtil.isElementCanBeExported(candidate) && !(candidate instanceof ES6ExportSpecifier)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(this.getPlace());
        if (holder == null) {
            return false;
        }
        if (holder.isTypeScript && !TypeScriptAutoImportUtil.isContextAcceptable(candidate, this)) {
            return false;
        }
        JSElement scope = ES6PsiUtil.getExportScope(candidate);
        if (scope == null || scope == this.getContainer()) {
            return false;
        }
        if (holder.isECMA6) {
            if (!holder.isFlow && candidate instanceof TypeScriptCompileTimeType) {
                return false;
            }
            if (TypeScriptPsiUtil.isAugmentationModule((PsiElement)scope)) {
                return false;
            }
            if (scope instanceof TypeScriptModule ? ((TypeScriptModule)scope).isInternal() && !((TypeScriptModule)scope).isExportedWithDefault() : !(scope instanceof JSModuleStatusOwner) || !((JSModuleStatusOwner)((Object)scope)).isCommonJSModule()) {
                return false;
            }
        }
        return TypeScriptAutoImportUtil.isExportedElement(candidate, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSImportPlaceInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSImportPlaceInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ImportContext {
        SIMPLE,
        SPECIFIER,
        BINDING,
        TAG;

    }
}

