/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.openapi.util.NlsContexts;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintOptionGroup {
    private final @NlsContexts.Label String myTitle;
    private final @NlsContexts.HintText String myDescription;
    private final Map<JSHintOption, @Nls String> myHtmlDescriptionByOptionMap;

    public JSHintOptionGroup(@NotNull @NlsContexts.Label String title, @NotNull @NlsContexts.HintText String description2) {
        if (title == null) {
            JSHintOptionGroup.$$$reportNull$$$0(0);
        }
        if (description2 == null) {
            JSHintOptionGroup.$$$reportNull$$$0(1);
        }
        this.myTitle = title;
        this.myDescription = JSHintOptionGroup.htmlWrap(description2);
        this.myHtmlDescriptionByOptionMap = new EnumMap<JSHintOption, String>(JSHintOption.class);
    }

    @NotNull
    @NlsContexts.Label
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            JSHintOptionGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsContexts.HintText
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            JSHintOptionGroup.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<JSHintOption> getOptions() {
        Set<JSHintOption> set = this.myHtmlDescriptionByOptionMap.keySet();
        if (set == null) {
            JSHintOptionGroup.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Nullable
    @Nls
    public String getHtmlDescriptionByOption(@NotNull JSHintOption option) {
        if (option == null) {
            JSHintOptionGroup.$$$reportNull$$$0(5);
        }
        return this.myHtmlDescriptionByOptionMap.get(option);
    }

    public String toString() {
        return "(title: " + this.myTitle + ")";
    }

    public void add(@NotNull JSHintOption option, @NlsContexts.HintText @NotNull String description2) {
        if (option == null) {
            JSHintOptionGroup.$$$reportNull$$$0(6);
        }
        if (description2 == null) {
            JSHintOptionGroup.$$$reportNull$$$0(7);
        }
        this.myHtmlDescriptionByOptionMap.put(option, JSHintOptionGroup.htmlWrap(description2));
    }

    @NlsContexts.HintText
    private static String htmlWrap(@NlsContexts.HintText @NotNull String bodyHtml) {
        String openingTags;
        if (bodyHtml == null) {
            JSHintOptionGroup.$$$reportNull$$$0(8);
        }
        if (bodyHtml.startsWith(openingTags = "<html><body>")) {
            return bodyHtml;
        }
        return openingTags + bodyHtml + "</body></html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintOptionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlDescriptionByOption";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "htmlWrap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

