/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionsOnSave.ActionOnSaveBackedByOwnConfigurable;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionsOnSaveConfigurable;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.ESLintActionOnSave;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintPanel;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintConfigurable
extends UntypedJSLinterConfigurable {
    public static final String ID = "settings.javascript.linters.eslint";

    public EslintConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public EslintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(1);
        }
        super(project, fullModeDialog);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message("settings.javascript.linters.eslint.configurable.name", new Object[0]);
    }

    @Override
    @NotNull
    protected NewEslintView createView() {
        return new NewEslintView(this.getProject(), this.getDisplayName(), new EslintPanel(this.getProject(), this.isFullModeDialog(), false));
    }

    public void reset() {
        NewEslintView view = this.getEslintView();
        if (view == null) {
            return;
        }
        view.setExtendedState(this.loadUiState());
        view.reset();
        this.resizeDialogToFitPreferredSize(view);
    }

    public void apply() {
        NewEslintView view = this.getEslintView();
        if (view == null) {
            return;
        }
        ExtendedLinterState extendedStateFromUi = view.getExtendedState();
        EslintState eslintStateFromUi = (EslintState)extendedStateFromUi.getState();
        boolean isStandardJS = EslintPanel.isStandardJs(eslintStateFromUi.getNodePackageRef());
        if (isStandardJS) {
            NodePackage nodePackage = Objects.requireNonNull(eslintStateFromUi.getNodePackageRef().getConstantPackage());
            StandardJSState standardJsState = new StandardJSState(nodePackage);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), standardJsState), StandardJSConfiguration.class);
            EslintState eslintState = new EslintState.Builder(EslintState.DEFAULT).setFilesPattern(eslintStateFromUi.getFilesPattern()).setRunOnSave(eslintStateFromUi.isRunOnSave()).build();
            this.setExtendedState(ExtendedLinterState.create(false, eslintState), EslintConfiguration.class);
        } else {
            this.setExtendedState(ExtendedLinterState.create(false, StandardJSState.DEFAULT), StandardJSConfiguration.class);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), eslintStateFromUi), EslintConfiguration.class);
        }
        view.apply();
        EslintLanguageServiceManager.getInstance(this.myProject).terminateServices();
        StandardJSLanguageServiceManager.getInstance(this.myProject).terminateServices();
    }

    @Override
    public boolean isModified() {
        NewEslintView view = this.getEslintView();
        if (view == null) {
            return false;
        }
        return !this.loadUiState().equals(view.getExtendedState()) || view.isModified();
    }

    private NewEslintView getEslintView() {
        return (NewEslintView)this.myView;
    }

    @NotNull
    private ExtendedLinterState<EslintState> loadUiState() {
        ExtendedLinterState eslintExtendedState = this.getExtendedState(EslintConfiguration.class);
        ExtendedLinterState standardJsExtendedState = this.getExtendedState(StandardJSConfiguration.class);
        EslintState eslintState = (EslintState)eslintExtendedState.getState();
        StandardJSState standardJSState = (StandardJSState)standardJsExtendedState.getState();
        boolean isStandardJS = standardJsExtendedState.isEnabled();
        EslintState uiState = isStandardJS ? new EslintState.Builder().setEslintPackage(NodePackageRef.create(standardJSState.getNodePackage())).setFilesPattern(eslintState.getFilesPattern()).setRunOnSave(eslintState.isRunOnSave()).build() : eslintState;
        ExtendedLinterState<EslintState> extendedLinterState = ExtendedLinterState.create(eslintExtendedState.isEnabled() || standardJsExtendedState.isEnabled(), uiState);
        if (extendedLinterState == null) {
            EslintConfigurable.$$$reportNull$$$0(2);
        }
        return extendedLinterState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUiState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class EsLintOnSaveActionInfo
    extends ActionOnSaveBackedByOwnConfigurable<EslintConfigurable> {
        EsLintOnSaveActionInfo(@NotNull ActionOnSaveContext context) {
            if (context == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(0);
            }
            super(context, EslintConfigurable.ID, EslintConfigurable.class);
        }

        @NotNull
        public String getActionOnSaveName() {
            String string = JavaScriptBundle.message("eslint.run.on.save.checkbox.on.actions.on.save.page", new Object[0]);
            if (string == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected boolean isApplicableAccordingToStoredState() {
            return EslintConfiguration.getInstance(this.getProject()).isEnabled() || StandardJSConfiguration.getInstance(this.getProject()).isEnabled();
        }

        protected boolean isApplicableAccordingToUiState(@NotNull EslintConfigurable configurable) {
            JCheckBox runOnSaveCheckBox;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(2);
            }
            return (runOnSaveCheckBox = configurable.getEslintView().myRunOnSaveCheckBox).isVisible() && runOnSaveCheckBox.isEnabled();
        }

        @Nullable
        protected ActionOnSaveComment getCommentAccordingToStoredState() {
            ExtendedLinterState state2 = EslintConfiguration.getInstance(this.getProject()).getExtendedState();
            if (!state2.isEnabled()) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.disabled.comment", new Object[0]));
            }
            String propertyName = "js.linters.configure.manually.selectedeslint";
            if (NewLinterView.isValidAutomaticState((JSNpmLinterState)state2.getState()) && !PropertiesComponent.getInstance((Project)this.getProject()).getBoolean(propertyName, false)) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.auto.configuration.comment", new Object[0]));
            }
            return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.manual.configuration.comment", new Object[0]));
        }

        @Nullable
        protected ActionOnSaveComment getCommentAccordingToUiState(@NotNull EslintConfigurable configurable) {
            ExtendedLinterState state2;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(3);
            }
            if (!(state2 = configurable.getEslintView().getExtendedState()).isEnabled()) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.disabled.comment", new Object[0]));
            }
            if (((EslintState)state2.getState()).equals(configurable.getEslintView().getStateWithConfiguredAutomatically())) {
                return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.auto.configuration.comment", new Object[0]));
            }
            return ActionOnSaveComment.info((String)JavaScriptBundle.message("eslint.run.on.save.manual.configuration.comment", new Object[0]));
        }

        protected boolean isActionOnSaveEnabledAccordingToStoredState() {
            return ESLintActionOnSave.isFixOnSaveEnabled(this.getProject());
        }

        protected boolean isActionOnSaveEnabledAccordingToUiState(@NotNull EslintConfigurable configurable) {
            JCheckBox runOnSaveCheckBox;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(4);
            }
            return (runOnSaveCheckBox = configurable.getEslintView().myRunOnSaveCheckBox).isVisible() && runOnSaveCheckBox.isEnabled() && runOnSaveCheckBox.isSelected();
        }

        protected void setActionOnSaveEnabled(@NotNull EslintConfigurable configurable, boolean enabled) {
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(5);
            }
            JCheckBox runOnSaveCheckBox = configurable.getEslintView().myRunOnSaveCheckBox;
            runOnSaveCheckBox.setSelected(enabled);
        }

        @NotNull
        public List<? extends ActionLink> getActionLinks() {
            String linkText = (String)this.getValueFromSavedStateOrFromUiState(this::getOpenEsLintPageTextAccordingToStoredState, EsLintOnSaveActionInfo::getOpenEsLintPageTextAccordingToUiState);
            List<ActionLink> list2 = Collections.singletonList(this.createGoToPageInSettingsLink(linkText, EslintConfigurable.ID));
            if (list2 == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        private String getOpenEsLintPageTextAccordingToStoredState() {
            ExtendedLinterState state2 = EslintConfiguration.getInstance(this.getProject()).getExtendedState();
            String string = state2.isEnabled() ? IdeBundle.message((String)"actions.on.save.link.configure", (Object[])new Object[0]) : JavaScriptBundle.message("eslint.run.on.save.link.enable.eslint", new Object[0]);
            if (string == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        private static String getOpenEsLintPageTextAccordingToUiState(@NotNull EslintConfigurable configurable) {
            ExtendedLinterState state2;
            if (configurable == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(8);
            }
            String string = (state2 = configurable.getEslintView().getExtendedState()).isEnabled() ? IdeBundle.message((String)"actions.on.save.link.configure", (Object[])new Object[0]) : JavaScriptBundle.message("eslint.run.on.save.link.enable.eslint", new Object[0]);
            if (string == null) {
                EsLintOnSaveActionInfo.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$EsLintOnSaveActionInfo";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$EsLintOnSaveActionInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionOnSaveName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionLinks";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOpenEsLintPageTextAccordingToStoredState";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOpenEsLintPageTextAccordingToUiState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicableAccordingToUiState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentAccordingToUiState";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isActionOnSaveEnabledAccordingToUiState";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionOnSaveEnabled";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getOpenEsLintPageTextAccordingToUiState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NewEslintView
    extends NewLinterView<EslintState> {
        private final EslintPanel myEslintPanel;
        private JPanel myRunForFilesPanel;
        private JTextField myRunForFilesField;
        private JCheckBox myRunOnSaveCheckBox;
        private boolean myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled;

        NewEslintView(Project project, String displayName, EslintPanel eslintPanel) {
            super(project, displayName, eslintPanel.getComponent(), ".eslintrc.*");
            this.myEslintPanel = eslintPanel;
        }

        @Override
        protected void addBottomComponents(@NotNull FormBuilder builder) {
            if (builder == null) {
                NewEslintView.$$$reportNull$$$0(0);
            }
            this.myRunForFilesField = new JBTextField();
            this.myRunForFilesPanel = UI.PanelFactory.panel((JComponent)this.myRunForFilesField).withLabel(JavaScriptBundle.message("eslint.run.for.files.label", new Object[0])).withComment(JavaScriptBundle.message("eslint.files.pattern.comment", new Object[0]), false).createPanel();
            this.myRunOnSaveCheckBox = new JCheckBox(JavaScriptBundle.message("eslint.run.on.save", new Object[0]));
            JPanel runOnSavePanel = new JPanel(new BorderLayout(JBUI.scale((int)16), 0));
            runOnSavePanel.add((Component)this.myRunOnSaveCheckBox, "West");
            runOnSavePanel.add((Component)ActionsOnSaveConfigurable.createGoToActionsOnSavePageLink(), "Center");
            builder.addComponent((JComponent)this.myRunForFilesPanel, 8);
            builder.addComponent((JComponent)runOnSavePanel);
        }

        @Override
        protected void setState(@NotNull EslintState state2) {
            if (state2 == null) {
                NewEslintView.$$$reportNull$$$0(1);
            }
            this.myEslintPanel.setState(state2);
            this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled = state2.isRunOnSave();
            this.myRunForFilesField.setText(state2.getFilesPattern());
            this.myRunOnSaveCheckBox.setSelected(state2.isRunOnSave());
        }

        @Override
        @NotNull
        protected EslintState getStateWithConfiguredAutomatically() {
            EslintState eslintState = new EslintState.Builder(EslintState.DEFAULT).setFilesPattern(this.myRunForFilesField.getText().trim()).setRunOnSave(this.myRunOnSaveCheckBox.isSelected()).build();
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(2);
            }
            return eslintState;
        }

        @Override
        protected void handleEnabledStatusChanged(boolean enabled) {
            this.myEslintPanel.handleEnableStatusChanged(enabled);
            for (Component c : UIUtil.uiTraverser((Component)this.myRunForFilesPanel).traverse()) {
                c.setEnabled(enabled);
            }
            boolean checkBoxWasEnabled = this.myRunOnSaveCheckBox.isEnabled();
            this.myRunOnSaveCheckBox.setEnabled(enabled);
            if (checkBoxWasEnabled && !enabled) {
                this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled = this.myRunOnSaveCheckBox.isSelected();
                this.myRunOnSaveCheckBox.setSelected(false);
            }
            if (!checkBoxWasEnabled && enabled) {
                this.myRunOnSaveCheckBox.setSelected(this.myRunOnSaveCheckBoxWasSelectedBeforeItBecameDisabled);
            }
        }

        @Override
        @NotNull
        protected EslintState getState() {
            EslintState.Builder builder = this.myEslintPanel.buildEslintState();
            builder.setFilesPattern(this.myRunForFilesField.getText().trim());
            builder.setRunOnSave(this.myRunOnSaveCheckBox.isEnabled() && this.myRunOnSaveCheckBox.isSelected());
            EslintState eslintState = builder.build();
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(3);
            }
            return eslintState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateWithConfiguredAutomatically";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addBottomComponents";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

