/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFixesReferenceErrorUpdater
implements JSUnresolvedReferenceErrorUpdater {
    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] results, boolean inTypeContext) {
        if (info == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(0);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(1);
        }
        if (results == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(2);
        }
        if (!DialectDetector.isTypeScript((PsiElement)node)) {
            return;
        }
        if (TypeScriptFixesReferenceErrorUpdater.fixNullabilityError(info, node, results, inTypeContext)) {
            return;
        }
        if (this.fixDistinctError(info, node, results)) {
            return;
        }
        if (node.getQualifier() == null && results.length == 0 && this.isAcceptableImportContext((PsiElement)node)) {
            info.addAll(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getReferenceName(), (PsiElement)node));
        }
    }

    @Override
    public void updateError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSXmlLiteralExpression node) {
        if (info == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(3);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(4);
        }
        if (!DialectDetector.isTypeScript((PsiElement)node) || !this.isAcceptableImportContext((PsiElement)node)) {
            return;
        }
        info.addAll(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getName(), (PsiElement)node));
    }

    protected boolean isAcceptableImportContext(@NotNull PsiElement node) {
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(5);
        }
        if (node.getContainingFile() instanceof JSFile) {
            return true;
        }
        JSElement scope = ES6PsiUtil.getExportScope(node);
        return scope != null;
    }

    private boolean fixDistinctError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] results) {
        if (info == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(6);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(7);
        }
        if (results == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(8);
        }
        if (results.length != 1) {
            return false;
        }
        JSResolveResult result2 = (JSResolveResult)ObjectUtils.tryCast((Object)results[0], JSResolveResult.class);
        if (result2 == null) {
            return false;
        }
        String resolveProblemKey = result2.getResolveProblemKey();
        PsiElement element = result2.getElement();
        if (resolveProblemKey == "javascript.element.need.to.be.included.to.config" && element != null) {
            info.addAll(JSFixFactory.getInstance().typeScriptConfigFixes(node, element));
            return true;
        }
        if (TypeScriptFixesReferenceErrorUpdater.isAcceptableResolveKey(node, resolveProblemKey, element) && this.isAcceptableImportContext((PsiElement)node)) {
            info.addAll(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getReferenceName(), (PsiElement)node));
            return true;
        }
        return false;
    }

    public static boolean isAcceptableResolveKey(@NotNull JSReferenceExpression node, @Nullable String resolveProblemKey, @Nullable PsiElement element) {
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(9);
        }
        return (resolveProblemKey == "javascript.element.is.not.accessible.message" || resolveProblemKey == "javascript.element.need.to.be.exported") && element instanceof TypeScriptImportStatement && node.getQualifier() == null;
    }

    private static boolean fixNullabilityError(@NotNull JSUnresolvedReferenceErrorUpdater.ErrorInfo info, @NotNull JSReferenceExpression node, ResolveResult @NotNull [] results, boolean inTypeContext) {
        if (info == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(10);
        }
        if (node == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(11);
        }
        if (results == null) {
            TypeScriptFixesReferenceErrorUpdater.$$$reportNull$$$0(12);
        }
        if (results.length != 0 || inTypeContext || node.getQualifier() == null) {
            return false;
        }
        JSType type = JSResolveUtil.getExpressionJSType(node.getQualifier());
        JSTypeCastUtil.NullableState nullableState = JSTypeCastUtil.getNullableState(type);
        if (nullableState == JSTypeCastUtil.NullableState.NOT_NULLABLE) {
            return false;
        }
        JSType typeWithoutNull = JSTypeUtils.removeNullableComponents(type);
        String refName = node.getReferenceName();
        if (typeWithoutNull != null && refName != null && typeWithoutNull != type && typeWithoutNull.asRecordType().hasProperty(refName)) {
            if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL_AND_UNDEFINED) {
                info.updateMessage(JavaScriptBundle.message("javascript.unresolved.variable.null.or.undefined.qualifier.message", refName));
            } else if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL) {
                info.updateMessage(JavaScriptBundle.message("javascript.unresolved.variable.null.qualifier.message", refName));
            } else {
                info.updateMessage(JavaScriptBundle.message("javascript.unresolved.variable.undefined.qualifier.message", refName));
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/TypeScriptFixesReferenceErrorUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateError";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableImportContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fixDistinctError";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableResolveKey";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "fixNullabilityError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

