/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSInspectionUiService;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJQueryEfficiencyInspection
extends JSInspection {
    private static final boolean JQUERY_ENABLED = true;
    public boolean myAllowAttributeAndPseudoSelectors = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return JSInspectionUiService.getInstance().createSingleCheckboxOptionsPanel(JavaScriptBundle.message("js.jquery.efficiency.inspection.allow.attribute.and.pseudo.selectors", new Object[0]), (InspectionProfileEntry)this, "myAllowAttributeAndPseudoSelectors");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            @Override
            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression[] arguments;
                String name;
                JSReferenceExpression refExpr;
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && (refExpr = (JSReferenceExpression)methodExpression).getQualifier() == null && ("jQuery".equals(name = refExpr.getReferencedName()) || "$".equals(name)) && (arguments = node.getArguments()).length == 1) {
                    JSExpression selector = arguments[0];
                    JSLiteralExpression firstLiteral = null;
                    JSExpression leftmostLiteral = selector;
                    while (leftmostLiteral instanceof JSBinaryExpression) {
                        leftmostLiteral = ((JSBinaryExpression)leftmostLiteral).getLOperand();
                    }
                    if (leftmostLiteral instanceof JSLiteralExpression) {
                        firstLiteral = (JSLiteralExpression)leftmostLiteral;
                    }
                    if (firstLiteral != null && firstLiteral.isQuotedLiteral()) {
                        JSElement scope;
                        JSExpression[] occurrences;
                        JSStatement statement;
                        String selectorText = firstLiteral.getText();
                        if (JavaScriptReferenceContributor.isRawHtmlJQuery(selectorText)) {
                            return;
                        }
                        if (PsiTreeUtil.findChildOfType((PsiElement)firstLiteral, OuterLanguageElement.class) != null) {
                            return;
                        }
                        if (!JSJQueryEfficiencyInspection.this.myAllowAttributeAndPseudoSelectors) {
                            if (selectorText.contains("[")) {
                                holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.jquery.efficiency.inspection.attribute.used.message", new Object[0]), new LocalQuickFix[0]);
                            }
                            if (selectorText.contains(":")) {
                                holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.jquery.efficiency.inspection.pseudoselector.used.message", new Object[0]), new LocalQuickFix[0]);
                            }
                        }
                        if ((statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSStatement.class, (boolean)false)) != null && !(statement.getParent() instanceof JSIfStatement) && (occurrences = JSUtils.findExpressionOccurrences((PsiElement)(scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{JSExecutionScope.class, JSBlockStatement.class})), (Pair<JSExpression, TextRange>)Pair.create((Object)node, null), false)).length > 1) {
                            holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.jquery.efficiency.inspection.duplicated.selector", new Object[0]), new LocalQuickFix[0]);
                        }
                    }
                }
                super.visitJSCallExpression(node);
            }
        };
    }
}

