/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JSIndexPatternBuilder;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.BaseFilterLexerUtil;
import com.intellij.psi.impl.cache.impl.IdAndToDoScannerBasedOnFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileContent;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class JSIdAndTodoScanner
implements IdAndToDoScannerBasedOnFilterLexer {
    private static final Key<JSScanContent> SCAN_CONTENT_KEY = Key.create((String)"js.scan.content");
    private static final int MIN_WORD_LENGTH = SystemProperties.getIntProperty((String)"idea.js.literal.word.min.length", (int)4);
    private static final int MAX_WORD_LENGTH = SystemProperties.getIntProperty((String)"idea.js.literal.word.max.length", (int)50);
    @NotNull
    private final DialectOptionHolder myDialectOptionHolder;
    private Object2IntMap<String> myStringLiteralWords;

    private JSIdAndTodoScanner(@NotNull DialectOptionHolder dialectOptionHolder) {
        if (dialectOptionHolder == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(0);
        }
        this.myStringLiteralWords = null;
        this.myDialectOptionHolder = dialectOptionHolder;
    }

    @NotNull
    static Map<String, Integer> getStringLiteralWords(@NotNull FileContent inputData) {
        JSScanContent data;
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(1);
        }
        if ((data = (JSScanContent)inputData.getUserData(SCAN_CONTENT_KEY)) == null) {
            data = JSIdAndTodoScanner.doScanContent(inputData);
            inputData.putUserData(SCAN_CONTENT_KEY, (Object)data);
        }
        Map<String, Integer> words = data.getStringLiteralWords();
        if (data.isAllContentUsed()) {
            inputData.putUserData(SCAN_CONTENT_KEY, null);
        }
        Map<String, Integer> map = words;
        if (map == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    static BaseFilterLexerUtil.ScanContent getIdAndTodoScanContent(@NotNull FileContent inputData) {
        JSScanContent data;
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(3);
        }
        if ((data = (JSScanContent)inputData.getUserData(SCAN_CONTENT_KEY)) == null) {
            data = JSIdAndTodoScanner.doScanContent(inputData);
            inputData.putUserData(SCAN_CONTENT_KEY, (Object)data);
        }
        BaseFilterLexerUtil.ScanContent content = data.getScanContent();
        if (data.isAllContentUsed()) {
            inputData.putUserData(SCAN_CONTENT_KEY, null);
        }
        BaseFilterLexerUtil.ScanContent scanContent = content;
        if (scanContent == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(4);
        }
        return scanContent;
    }

    @NotNull
    private static JSScanContent doScanContent(@NotNull FileContent inputData) {
        JSLanguageDialect dialect;
        if (inputData == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(5);
        }
        DialectOptionHolder dialectOptionHolder = JSLanguageLevel.DEFAULT.getDialect().getOptionHolder();
        Project project = inputData.getProject();
        if (project != null && (dialect = DialectDetector.getLanguageDialect(inputData.getFile(), project)) != null) {
            dialectOptionHolder = dialect.getOptionHolder();
        }
        JSIdAndTodoScanner scanner = new JSIdAndTodoScanner(dialectOptionHolder);
        BaseFilterLexerUtil.ScanContent scanContent = BaseFilterLexerUtil.doScanContent((FileContent)inputData, (IdAndToDoScannerBasedOnFilterLexer)scanner, (boolean)true, (boolean)true, (IndexPattern[])IndexPatternUtil.getIndexPatterns());
        if (scanner.myStringLiteralWords == null) {
            Logger.getInstance(JSIdAndTodoScanner.class).error("JSFilterLexer.start was not called");
            scanner.myStringLiteralWords = new Object2IntOpenHashMap();
        }
        return new JSScanContent(scanContent, (Map<String, Integer>)scanner.myStringLiteralWords);
    }

    @NotNull
    public Lexer createLexer(@NotNull OccurrenceConsumer consumer) {
        if (consumer == null) {
            JSIdAndTodoScanner.$$$reportNull$$$0(6);
        }
        return new JSFilterLexer(this.myDialectOptionHolder, consumer);
    }

    static int getVersion() {
        return 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralWords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdAndTodoScanContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralWords";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIdAndTodoScanContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doScanContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSScanContent {
        @NotNull
        private final BaseFilterLexerUtil.ScanContent myScanContent;
        @NotNull
        private final Map<String, Integer> myStringLiteralWords;
        private int myScanContentAccessCount;
        private boolean myStringLiteralWordsAccessed;

        private JSScanContent(@NotNull BaseFilterLexerUtil.ScanContent scanContent, @NotNull Map<String, Integer> stringLiteralWords) {
            if (scanContent == null) {
                JSScanContent.$$$reportNull$$$0(0);
            }
            if (stringLiteralWords == null) {
                JSScanContent.$$$reportNull$$$0(1);
            }
            this.myScanContentAccessCount = 0;
            this.myStringLiteralWordsAccessed = false;
            this.myScanContent = scanContent;
            this.myStringLiteralWords = stringLiteralWords;
        }

        @NotNull
        public BaseFilterLexerUtil.ScanContent getScanContent() {
            ++this.myScanContentAccessCount;
            BaseFilterLexerUtil.ScanContent scanContent = this.myScanContent;
            if (scanContent == null) {
                JSScanContent.$$$reportNull$$$0(2);
            }
            return scanContent;
        }

        @NotNull
        public Map<String, Integer> getStringLiteralWords() {
            this.myStringLiteralWordsAccessed = true;
            Map<String, Integer> map = this.myStringLiteralWords;
            if (map == null) {
                JSScanContent.$$$reportNull$$$0(3);
            }
            return map;
        }

        public boolean isAllContentUsed() {
            return this.myStringLiteralWordsAccessed && this.myScanContentAccessCount >= 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scanContent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringLiteralWords";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner$JSScanContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner$JSScanContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScanContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringLiteralWords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class JSFilterLexer
    extends BaseFilterLexer {
        private JSFilterLexer(DialectOptionHolder dialectOptionHolder, OccurrenceConsumer occurrenceConsumer) {
            if (dialectOptionHolder == null) {
                JSFilterLexer.$$$reportNull$$$0(0);
            }
            super((Lexer)new JSDirectiveCommentLexer((Lexer)new JSFlexAdapter(dialectOptionHolder, true)), occurrenceConsumer);
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                JSFilterLexer.$$$reportNull$$$0(1);
            }
            JSIdAndTodoScanner.this.myStringLiteralWords = new Object2IntOpenHashMap();
            super.start(buffer, startOffset, endOffset, initialState);
        }

        public void advance() {
            IElementType tokenType = this.myDelegate.getTokenType();
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType)) {
                this.addOccurrenceInToken(1);
            } else if (tokenType == JSTokenTypes.XML_TAG_NAME || tokenType == JSTokenTypes.XML_NAME) {
                this.scanWordsInToken(1, false, false);
            } else if (JSTokenTypes.STRING_LITERALS.contains(tokenType) || tokenType == JSTokenTypes.STRING_TEMPLATE_PART) {
                CharSequence charSequence;
                this.scanWordsInToken(12, true, false);
                if ((JSTokenTypes.STRING_LITERALS.contains(tokenType) || tokenType == JSTokenTypes.STRING_TEMPLATE_PART && this.hasNoInterpolations()) && !StringUtil.contains((CharSequence)(charSequence = this.getTokenSequence()), (CharSequence)" ") && charSequence.length() < 4096) {
                    String originalText = charSequence.toString();
                    String text = JSStringUtil.replaceUnicodeEscapeSequences(originalText);
                    boolean unicodeFound = text != originalText;
                    List words = StringUtil.getWordIndicesIn((String)text);
                    for (TextRange word : words) {
                        if (MIN_WORD_LENGTH > word.getLength() || word.getLength() > MAX_WORD_LENGTH) continue;
                        int wordOffset = unicodeFound ? 0 : word.getStartOffset();
                        JSIdAndTodoScanner.this.myStringLiteralWords.putIfAbsent((Object)word.substring(text), this.getTokenStart() + wordOffset);
                    }
                }
            } else if (JSIndexPatternBuilder.Holder.COMMENTS_FOR_INDEXING.contains(tokenType) && !this.isSourceMapComment(tokenType)) {
                this.scanWordsInToken(2, false, false);
                this.advanceTodoItemCountsInToken();
            } else if (!JSExtendedLanguagesTokenSetProvider.SKIP_WORDS_SCAN_SET.contains(tokenType)) {
                this.scanWordsInToken(16, false, false);
            }
            this.myDelegate.advance();
        }

        private boolean isSourceMapComment(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                JSFilterLexer.$$$reportNull$$$0(2);
            }
            if (tokenType != JSTokenTypes.END_OF_LINE_COMMENT) {
                return false;
            }
            if (this.getTokenEnd() - this.getTokenStart() < "//# sourceMappingURL=data:application/json;".length()) {
                return false;
            }
            return StringUtil.startsWith((CharSequence)this.getTokenSequence(), (CharSequence)"//# sourceMappingURL=data:application/json;");
        }

        private boolean hasNoInterpolations() {
            int prevOffset = this.getTokenStart() - 1;
            int nextOffset = this.getTokenEnd();
            CharSequence text = this.getBufferSequence();
            return prevOffset >= 0 && text.charAt(prevOffset) == '`' && nextOffset < text.length() && text.charAt(nextOffset) == '`';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialectOptionHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JSIdAndTodoScanner$JSFilterLexer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "start";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSourceMapComment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

