/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixes;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.JSReplaceImplementsExtendsKeyword;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.highlighting.JSAddTypeMembersByLiteralFix;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.inspections.AssignParameterToFieldAction;
import com.intellij.lang.javascript.inspections.CreateJSFieldFromParameterAction;
import com.intellij.lang.javascript.inspections.DownloadLibraryQuickFix;
import com.intellij.lang.javascript.inspections.ES6CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.inspections.ES6MakeFunctionAsyncFix;
import com.intellij.lang.javascript.inspections.JSMoveToScopeStartIntentionAction;
import com.intellij.lang.javascript.inspections.JSRemoveElementLocalQuickFix;
import com.intellij.lang.javascript.inspections.JSReplaceForEachWithForOfFix;
import com.intellij.lang.javascript.inspections.JSSuppressByCommentFix;
import com.intellij.lang.javascript.inspections.JSXCreateComponentFix;
import com.intellij.lang.javascript.intentions.TypeScriptDisableSmartCastIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.AddSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.CreateInheritanceFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionFromArgumentIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSParameterIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.ES6InsertAwaitFix;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAddRemoveSharpFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureWithDelegationUpdateFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeTypeFix;
import com.intellij.lang.javascript.validation.fixes.JSCreateArgumentStubsFix;
import com.intellij.lang.javascript.validation.fixes.JSInitializeParameterFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertCastFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertModifierFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertPrimitiveWrapperFix;
import com.intellij.lang.javascript.validation.fixes.JSJoinDeclarationAndAssignmentFix;
import com.intellij.lang.javascript.validation.fixes.JSRemoveInitializerQuickFix;
import com.intellij.lang.javascript.validation.fixes.JSRemoveReadonlyModifierFix;
import com.intellij.lang.javascript.validation.fixes.JSSetElementVisibilityFix;
import com.intellij.lang.javascript.validation.fixes.MakeMethodStaticFix;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.lang.javascript.validation.fixes.RemoveUnusedAssignmentFix;
import com.intellij.lang.javascript.validation.fixes.RenameReferenceFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptAddGenericArgumentsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementAllMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptInsertTypeGuardFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptRemoveGenericArgumentsFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptWrapWithGenericTypeFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddFileToConfigFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.intentions.TypeScriptChangeConstructorAccessRightsFix;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidatorImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.fix.RenameFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSFixFactoryImpl
extends JSFixFactory {
    @Override
    public LocalQuickFix createImplementMembersFix(JSExpression expr, boolean requiredOnly) {
        if (DialectDetector.isTypeScript((PsiElement)expr)) {
            return new TypeScriptImplementAllMembersFix((PsiElement)expr, false, requiredOnly);
        }
        return null;
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement changeTypeFix(JSNamedElement var, String expressionType, String nameKey) {
        return new JSChangeTypeFix(var, expressionType, nameKey);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction element, @Nullable JSArgumentList argumentList) {
        return new JSChangeSignatureFix(element, argumentList, true);
    }

    @Override
    public LocalQuickFix createArgumentStubsFix(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(0);
        }
        return new JSCreateArgumentStubsFix(callExpression);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction function2, @NotNull Map<String, String> parameterTypeOverrides, @Nullable String overriddenReturnType) {
        if (parameterTypeOverrides == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(1);
        }
        JSChangeSignatureFix fix = new JSChangeSignatureFix(function2, null, true, true);
        fix.setReturnType(overriddenReturnType);
        fix.setParameterTypes(parameterTypeOverrides);
        return fix;
    }

    @Override
    public LocalQuickFix createInheritanceFix(JSClass expectedClass, PsiElement actualClass) {
        return new CreateInheritanceFix(actualClass, expectedClass.getQualifiedName(), expectedClass.isInterface());
    }

    @Override
    public LocalQuickFix jsInsertCastFix(String type, @NotNull JSExpression expression) {
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(2);
        }
        return new JSInsertCastFix(type, expression);
    }

    @Override
    public LocalQuickFix jsInsertPrimitiveWrapperFix(String type, @NotNull JSExpression expr) {
        if (expr == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(3);
        }
        return new JSInsertPrimitiveWrapperFix(type, expr);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement removeUnusedAssignmentFix(PsiElement assignment, boolean allInDestructuring) {
        return new RemoveUnusedAssignmentFix(assignment, allInDestructuring);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement removeASTNodeFix(@NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String propKey, boolean fixNewLines, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (propKey == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(6);
        }
        return new RemoveASTNodeFix(propKey, fixNewLines, startElement, endElement);
    }

    @Override
    public LocalQuickFix renameReferenceFix() {
        return new RenameReferenceFix();
    }

    @Override
    public LocalQuickFix createJSVariableIntentionAction(String name, boolean field, boolean constant, boolean isModuleScope) {
        return new CreateJSVariableIntentionAction(name, field, constant, isModuleScope);
    }

    @Override
    public LocalQuickFix createJSParameterIntentionAction(String referencedName) {
        return new CreateJSParameterIntentionAction(referencedName);
    }

    @Override
    public LocalQuickFix createJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope, boolean isAsync) {
        return new CreateJSFunctionIntentionAction(name, isMethod, isModuleScope, isAsync);
    }

    @Override
    public LocalQuickFix createJSFunctionFromArgumentIntentionAction(String name, JSExpression qualifier, boolean ecma) {
        return new CreateJSFunctionFromArgumentIntentionAction(name, qualifier, ecma);
    }

    @Override
    public LocalQuickFix createClassOrInterfaceFix(PsiElement expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(expression);
        if (holder == null) {
            return QuickFixes.EMPTY_FIX;
        }
        if (holder.isECMA4) {
            if (expression instanceof JSReferenceExpression) {
                return new ActionScriptCreateClassOrInterfaceFix((JSReferenceExpression)expression, isInterface, constructorArguments, expectedType);
            }
            return QuickFixes.EMPTY_FIX;
        }
        PsiElement parent = expression.getParent();
        return new ES6CreateClassOrInterfaceFix(expression, isInterface, constructorArguments, parent instanceof TypeScriptTypeArgumentsListOwner ? ((TypeScriptTypeArgumentsListOwner)parent).getTypeArgumentList() : null, expectedType);
    }

    @Override
    public LocalQuickFix createClassComponentFix(@NotNull JSXmlLiteralExpression expression) {
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(7);
        }
        return new JSXCreateComponentFix(expression, ReactExtractComponentHandlerBase.ComponentType.Class);
    }

    @Override
    public LocalQuickFix createFunctionalComponentFix(@NotNull JSXmlLiteralExpression expression) {
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(8);
        }
        return new JSXCreateComponentFix(expression, ReactExtractComponentHandlerBase.ComponentType.Function);
    }

    @Override
    public IntentionAction addSuperInvocationFix(JSFunction constructor, @Nullable JSFunction superConstructor) {
        return new AddSuperInvocationFix(constructor, superConstructor);
    }

    @Override
    public LocalQuickFix changeSignatureWithDelegationUpdateFix(JSFunction element, @NotNull JSFunction functionToTakeParamsFrom, @NotNull JSCallExpression node) {
        if (functionToTakeParamsFrom == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(9);
        }
        if (node == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(10);
        }
        return new JSChangeSignatureWithDelegationUpdateFix(element, functionToTakeParamsFrom, node);
    }

    @Override
    public LocalQuickFix makeMethodStaticFix() {
        return new MakeMethodStaticFix();
    }

    @Override
    public FixAndIntentionAction assignParameterToFieldAction(FixAndIntentionAction action, String fieldName, String parameterName, String className2) {
        return new AssignParameterToFieldAction(action, fieldName, parameterName, className2);
    }

    @Override
    public LocalQuickFix downloadLibraryQuickFix() {
        return new DownloadLibraryQuickFix();
    }

    @Override
    public LocalQuickFix jsMoveToScopeStartIntentionAction(boolean statement) {
        return new JSMoveToScopeStartIntentionAction(statement);
    }

    @Override
    public FixAndIntentionAction removeElementLocalQuickFix(String elementDescription) {
        return new JSRemoveElementLocalQuickFix(elementDescription);
    }

    @Override
    public void addFixesForFields(JSFunction node, PsiElement highlightedElement, String name, List<LocalQuickFix> fixes) {
        PsiElement element = JSResolveUtil.findParent((PsiElement)node);
        if (element instanceof JSClass) {
            FixAndIntentionAction intentionAction;
            String fieldName2;
            String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(node.isSetProperty() ? node.getName() : name, (PsiElement)node);
            String string = fieldName2 = node.isSetProperty() ? null : JSRefactoringUtil.transformVarNameToAccessorName(name, (PsiElement)node);
            if (StringUtil.equals((CharSequence)fieldName, (CharSequence)fieldName2)) {
                fieldName2 = null;
            }
            String className2 = ((JSClass)element).getName();
            boolean noField = ((JSClass)element).findFieldByName(fieldName) == null;
            String existingField = fieldName;
            if (noField && fieldName2 != null) {
                noField = ((JSClass)element).findFieldByName(fieldName2) == null;
                existingField = fieldName2;
            }
            CreateJSFieldFromParameterAction action = null;
            if (noField) {
                if (fieldName2 != null) {
                    action = new CreateJSFieldFromParameterAction(fieldName2);
                    action.registerElementRefForFix(highlightedElement, null);
                    intentionAction = JSFixFactoryImpl.assignParameterToFieldAction(name, fieldName2, className2, action);
                    intentionAction.registerElementRefForFix(highlightedElement, null);
                    fixes.add(intentionAction);
                }
                action = new CreateJSFieldFromParameterAction(fieldName);
                action.registerElementRefForFix(highlightedElement, null);
            }
            intentionAction = JSFixFactoryImpl.assignParameterToFieldAction(name, noField ? fieldName : existingField, className2, action);
            intentionAction.registerElementRefForFix(highlightedElement, null);
            fixes.add(intentionAction);
        }
    }

    private static FixAndIntentionAction assignParameterToFieldAction(String parameterName, String fieldName, String className2, FixAndIntentionAction action) {
        return JSFixFactoryImpl.getInstance().assignParameterToFieldAction(action, fieldName, parameterName, className2);
    }

    @Override
    public LocalQuickFix typeScriptImplementMembersFix(JSClass aClass, boolean requiredOnly) {
        return new TypeScriptImplementAllMembersFix(aClass, false, requiredOnly);
    }

    @Override
    public LocalQuickFix typeScriptImplementMembersAbstractFix(JSClass aClass) {
        return new TypeScriptImplementAllMembersFix(aClass, true, false);
    }

    @Override
    public LocalQuickFix createInsertTypeGuardFix(@NotNull PsiElement element, @NotNull JSType type, @NotNull TypeScriptTypeGuardFixHelper.JSTypeGuardFixData data) {
        if (element == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(11);
        }
        if (type == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(12);
        }
        if (data == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(13);
        }
        return new TypeScriptInsertTypeGuardFix(element, type, data);
    }

    @Override
    public InspectionJSFix renameFix() {
        return new RenameFix();
    }

    @Override
    @NotNull
    public List<LocalQuickFix> typeScriptAddImportStatementFix(String name, @NotNull PsiElement context) {
        if (context == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(14);
        }
        if (name == null) {
            List<LocalQuickFix> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFixFactoryImpl.$$$reportNull$$$0(15);
            }
            return list2;
        }
        TypeScriptAddImportStatementFix fix = new TypeScriptAddImportStatementFix(name, context);
        if (!fix.isAvailable(context.getProject(), null, context.getContainingFile())) {
            List<LocalQuickFix> list3 = Collections.emptyList();
            if (list3 == null) {
                JSFixFactoryImpl.$$$reportNull$$$0(16);
            }
            return list3;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new LocalQuickFix[]{fix, fix.createImportAllFix()});
        if (arrayList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Override
    public FixAndIntentionAction replaceImplementsKeywordByExtendsFix(@NotNull JSReferenceList referenceList) {
        if (referenceList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(18);
        }
        return new JSReplaceImplementsExtendsKeyword(referenceList);
    }

    @Override
    public LocalQuickFix createAddTypeMembersByLiteralFix(JSObjectLiteralExpression expression, Collection<String> names, JSClass clazz) {
        return new JSAddTypeMembersByLiteralFix(clazz, expression, names);
    }

    @Override
    @NotNull
    public List<LocalQuickFix> typeScriptConfigFixes(JSElement placeExpression, PsiElement resolveResult) {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new LocalQuickFix[]{new TypeScriptAddFileToConfigFix(placeExpression, resolveResult)});
        if (arrayList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public TypeScriptReferencePathValidator typeScriptReferencePathValidator() {
        TypeScriptReferencePathValidator typeScriptReferencePathValidator = TypeScriptReferencePathValidatorImpl.INSTANCE;
        if (typeScriptReferencePathValidator == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(20);
        }
        return typeScriptReferencePathValidator;
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement createChangeVisibilityFix(@NotNull JSAttributeListOwner method, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (method == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(21);
        }
        return new JSSetElementVisibilityFix(method, visibility, namespace);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement createAddRemoveSharpFix(@NotNull JSReferenceExpression expression, boolean remove) {
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(22);
        }
        return new JSAddRemoveSharpFix(expression, remove);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement insertModifier(@NotNull JSAttributeListOwner method, @NotNull JSAttributeList.ModifierType modifier) {
        if (method == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(23);
        }
        if (modifier == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(24);
        }
        return new JSInsertModifierFix(method, modifier);
    }

    @Override
    @NotNull
    public SuppressQuickFix suppressByCommentFix(@NotNull HighlightDisplayKey key, @NotNull Class<? extends JSSuppressionHolder> holderClass, @NotNull @IntentionName String text) {
        if (key == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(25);
        }
        if (holderClass == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(26);
        }
        if (text == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(27);
        }
        return new JSSuppressByCommentFix(key, holderClass, text);
    }

    @Override
    public LocalQuickFix createConstructorFix(@NotNull JSCallExpression callExpression, @NotNull JSClass targetClass) {
        DialectOptionHolder holder;
        if (callExpression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(28);
        }
        if (targetClass == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(29);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)callExpression)) == null) {
            return QuickFixes.EMPTY_FIX;
        }
        return new ES6CreateConstructorFix(callExpression, targetClass);
    }

    @Override
    public LocalQuickFix insertUseStrict(@NotNull JSExecutionScope executionScope) {
        if (executionScope == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(30);
        }
        return new LocalQuickFixOnPsiElement((PsiElement)executionScope){

            @NotNull
            public String getFamilyName() {
                String string = JavaScriptBundle.message("js.strict.mode.inspection.fix", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getText() {
                String string = this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (startElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                String quote = JSCodeStyleSettings.getQuote(startElement);
                String semicolon = JSCodeStyleSettings.getSemicolon(startElement);
                String useStrictStmt = quote + "use strict" + quote + semicolon + "\n";
                Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                assert (document2 != null);
                document2.insertString(startElement.getTextOffset(), (CharSequence)useStrictStmt);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public LocalQuickFix implementJSDocMethodsFix(@NotNull String className2, @NotNull Map<JSMethodToImplement.MethodKey, JSMethodToImplement> methods2) {
        if (className2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(31);
        }
        if (methods2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(32);
        }
        return new ImplementJSDocMethodsFix(className2, methods2);
    }

    @Override
    @NotNull
    public LocalQuickFix removeInitializerFix() {
        return new JSRemoveInitializerQuickFix();
    }

    @Override
    @NotNull
    public LocalQuickFix changeConstructorAccessRightsFix(@NotNull JSFunction node, @NotNull JSAttributeList.AccessType accessType) {
        if (node == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(33);
        }
        if (accessType == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(34);
        }
        return new TypeScriptChangeConstructorAccessRightsFix(node, accessType);
    }

    @Override
    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createMakeFunctionAsyncFix(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(35);
        }
        return new ES6MakeFunctionAsyncFix(function2);
    }

    @Override
    public LocalQuickFix createForEachToForOfFix() {
        return new JSReplaceForEachWithForOfFix();
    }

    @Override
    @NotNull
    public LocalQuickFixAndIntentionActionOnPsiElement createInitializeParameterFix(JSParameterListElement parameter, String value) {
        return new JSInitializeParameterFix(parameter, value);
    }

    @Override
    public LocalQuickFix createJoinDeclarationAndAssignmentFix(JSVariable node, JSReferenceExpression expression) {
        return new JSJoinDeclarationAndAssignmentFix(node, expression);
    }

    @Override
    public LocalQuickFix createInsertAwaitFix(JSExpression expression, boolean isAsyncGenerator) {
        return new ES6InsertAwaitFix(expression, isAsyncGenerator);
    }

    @Override
    public LocalQuickFix createWrapWithGenericTypeFix(@NotNull String className2, @NotNull TypeScriptType element) {
        if (className2 == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(36);
        }
        if (element == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(37);
        }
        return new TypeScriptWrapWithGenericTypeFix(className2, element);
    }

    @Override
    public JSFixFactory.FixWithComponent disableSmartCastFix() {
        return new TypeScriptDisableSmartCastIntention();
    }

    @Override
    @NotNull
    public LocalQuickFix addGenericArgumentFix(@NotNull TypeScriptTypeArgumentsListOwner element) {
        if (element == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(38);
        }
        return new TypeScriptAddGenericArgumentsFix(element);
    }

    @Override
    @NotNull
    public LocalQuickFix removeGenericArgumentFix(@NotNull JSElement element) {
        if (element == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(39);
        }
        return new TypeScriptRemoveGenericArgumentsFix(element);
    }

    @Override
    @NotNull
    public LocalQuickFix removeReadonlyModifierFix(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(40);
        }
        return new JSRemoveReadonlyModifierFix(element);
    }

    @Override
    public boolean isShowSmartCastText() {
        return !EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeOverrides";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionToTakeParamsFrom";
                break;
            }
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holderClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionScope";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptAddImportStatementFix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptConfigFixes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptReferencePathValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentStubsFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureFix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jsInsertCastFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "jsInsertPrimitiveWrapperFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeASTNodeFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClassComponentFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionalComponentFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureWithDelegationUpdateFix";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInsertTypeGuardFix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "typeScriptAddImportStatementFix";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplementsKeywordByExtendsFix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createChangeVisibilityFix";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAddRemoveSharpFix";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "insertModifier";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "suppressByCommentFix";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorFix";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "insertUseStrict";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "implementJSDocMethodsFix";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "changeConstructorAccessRightsFix";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createMakeFunctionAsyncFix";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createWrapWithGenericTypeFix";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentFix";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeGenericArgumentFix";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeReadonlyModifierFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

