/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptorImpl;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptReactTagUtil {
    private static final String TSX_TAG_NAMESPACE = "JSX.IntrinsicElements";
    public static final Key<CachedValue<ConcurrentMap<String, TypeScriptPropertySignature>>> CACHED_VALUE_KEY = Key.create((String)"tsx.resolve.tag");

    public static boolean hasTagsNamespace(@NotNull PsiElement context) {
        JSClass elementsClass;
        if (context == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(0);
        }
        return (elementsClass = TypeScriptClassResolver.getInstance().findAnyClassByQName(TSX_TAG_NAMESPACE, JSResolveUtil.getResolveScope(context))) != null && elementsClass.isInterface();
    }

    private static boolean isForceOptional(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        return !type.isSourceStrict() || type instanceof JSContextualUnionType;
    }

    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@Nullable JSType type) {
        return TypeScriptReactTagUtil.getXmlAttributeDescriptors(type, (Condition<? super JSRecordType.PropertySignature>)Conditions.alwaysTrue());
    }

    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@Nullable JSType type, @NotNull Condition<? super JSRecordType.PropertySignature> filter) {
        if (filter == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(1);
        }
        ArrayList members = new ArrayList();
        boolean forceOptional = TypeScriptReactTagUtil.isForceOptional(type);
        TypeScriptReactTagUtil.processAttributes(type, (Processor<? super JSRecordType.PropertySignature>)((Processor)signature -> {
            if (!filter.value(signature)) {
                return true;
            }
            members.add(TypeScriptReactTagUtil.createAttributeDescriptor(signature, forceOptional));
            return true;
        }));
        return members.toArray(XmlAttributeDescriptor.EMPTY);
    }

    public static XmlAttributeDescriptor @NotNull [] getXmlAttributeDescriptors(@NotNull TypeScriptPropertySignature property) {
        if (property == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(2);
        }
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = TypeScriptReactTagUtil.getXmlAttributeDescriptors(property.getJSType());
        if (xmlAttributeDescriptorArray == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(3);
        }
        return xmlAttributeDescriptorArray;
    }

    @Nullable
    public static TypeScriptPropertySignature resolveTag(@NotNull XmlTag tag) {
        if (tag == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(4);
        }
        if (JSXResolveUtil.isComponentName(tag.getName())) {
            return null;
        }
        JSElement scope = ES6PsiUtil.getExportScope((PsiElement)tag);
        if (scope == null) {
            return null;
        }
        ConcurrentMap value = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)scope, CACHED_VALUE_KEY, () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakKeyWeakValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}));
        return value.computeIfAbsent(tag.getName(), arg_0 -> TypeScriptReactTagUtil.lambda$resolveTag$2((PsiElement)scope, arg_0));
    }

    @Nullable
    private static TypeScriptPropertySignature findPropertySignature(PsiElement scope, String tagName) {
        return TypeScriptReactTagUtil.getAllTags(scope).get(tagName);
    }

    @NotNull
    public static Map<String, TypeScriptPropertySignature> getAllTags(@NotNull PsiElement context) {
        JSElement scopeElement;
        if (context == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(5);
        }
        if ((scopeElement = ES6PsiUtil.getNonStrictExportScope(context)) == null) {
            Map<String, TypeScriptPropertySignature> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptReactTagUtil.$$$reportNull$$$0(6);
            }
            return map;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)scopeElement, () -> TypeScriptReactTagUtil.lambda$getAllTags$3((PsiElement)scopeElement));
        if (map == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public static GlobalSearchScope getScopeForTags(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(8);
        }
        GlobalSearchScope result2 = JSResolveUtil.getResolveScope(context);
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        GlobalSearchScope globalSearchScope = holder != null && holder.isECMA6 && !holder.isTypeScript ? TypeScriptReactTagUtil.unionWithReactLibrary(context.getProject(), result2) : result2;
        if (globalSearchScope == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    public static XmlAttributeDescriptor createAttributeDescriptor(@NotNull JSRecordType.PropertySignature signature, boolean forceOptional) {
        if (signature == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(10);
        }
        boolean optional = forceOptional || signature.isOptional();
        JSRecordType.MemberSource source2 = signature.getMemberSource();
        XmlAttributeDescriptor xmlAttributeDescriptor = ReactAttributeDescriptorImpl.create(signature.getMemberName(), source2.getSingleElement(), signature.getJSType(), optional);
        if (xmlAttributeDescriptor == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(11);
        }
        return xmlAttributeDescriptor;
    }

    public static void processAttributes(@NotNull TypeScriptPropertySignature propertyTag, @NotNull Processor<? super JSRecordType.PropertySignature> processor) {
        if (propertyTag == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(13);
        }
        TypeScriptReactTagUtil.processAttributes(propertyTag.getJSType(), processor);
    }

    public static void processAttributes(@Nullable JSType type, @NotNull Processor<? super JSRecordType.PropertySignature> processor) {
        if (processor == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(14);
        }
        if (type == null) {
            return;
        }
        List<JSRecordType.TypeMember> typeMembers = type.asRecordType().getTypeMembers();
        for (JSRecordType.TypeMember member : typeMembers) {
            if (member instanceof JSRecordType.PropertySignature && !processor.process((Object)((JSRecordType.PropertySignature)member))) break;
        }
    }

    public static GlobalSearchScope unionWithReactLibrary(Project project, @Nullable GlobalSearchScope scope) {
        if (scope == null) {
            return null;
        }
        return scope.uniteWith(TypeScriptReactTagUtil.getReactLibraryScope(project));
    }

    @NotNull
    public static GlobalSearchScope getReactLibraryScope(Project project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        if (globalSearchScope == null) {
            TypeScriptReactTagUtil.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$getAllTags$3(PsiElement scopeElement) {
        GlobalSearchScope scope = TypeScriptReactTagUtil.getScopeForTags(scopeElement);
        Project project = scopeElement.getProject();
        Collection elements = StubIndex.getElements(JSNamespaceMembersIndex.KEY, (Object)TSX_TAG_NAMESPACE, (Project)project, (GlobalSearchScope)scope, JSElement.class);
        HashMap<String, TypeScriptPropertySignature> map = new HashMap<String, TypeScriptPropertySignature>();
        for (JSElement element : elements) {
            String name;
            if (!(element instanceof TypeScriptPropertySignature) || (name = element.getName()) == null) continue;
            map.put(name, (TypeScriptPropertySignature)element);
        }
        return CachedValueProvider.Result.create(Collections.unmodifiableMap(map), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    }

    private static /* synthetic */ TypeScriptPropertySignature lambda$resolveTag$2(PsiElement scope, String tagName) {
        return TypeScriptReactTagUtil.findPropertySignature(scope, tagName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyTag";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactTagUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlAttributeDescriptors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForTags";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReactLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasTagsNamespace";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getXmlAttributeDescriptors";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForTags";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeDescriptor";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

