/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceBase;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReference
extends JSModuleReferenceBase
implements HighlightSeverityHolder {
    private static final String[] PLATFORMS = new String[]{"ios", "android", "web", "native"};
    private static final String[] DOT_PLATFORMS = ArrayUtil.toStringArray((Collection)ContainerUtil.map((Object[])PLATFORMS, el -> "." + el));
    private final NotNullLazyValue<String[]> myExtensionsValue;
    private final String myNewFileTemplateName;
    private final boolean myIsSoft;

    public JSModuleReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions, String newFileTemplateName, boolean isSoft) {
        if (fileReferenceSet == null) {
            JSModuleReference.$$$reportNull$$$0(0);
        }
        super(text, offset, textRange, fileReferenceSet, implicitExtensions);
        this.myExtensionsValue = NotNullLazyValue.lazy(() -> {
            PsiElement element = this.getElement();
            String[] extensions = super.getImplicitExtensions();
            return JSModuleReference.getExtensionsWithPlatforms(element, extensions);
        });
        this.myNewFileTemplateName = newFileTemplateName;
        this.myIsSoft = isSoft;
    }

    public JSModuleReference(String text, int offset, @NotNull TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, @Nullable String newFileTemplateName, boolean isSoft) {
        if (textRange == null) {
            JSModuleReference.$$$reportNull$$$0(1);
        }
        if (fileReferenceSet == null) {
            JSModuleReference.$$$reportNull$$$0(2);
        }
        super(text, offset, textRange, fileReferenceSet);
        this.myExtensionsValue = NotNullLazyValue.lazy(() -> {
            PsiElement element = this.getElement();
            String[] extensions = super.getImplicitExtensions();
            return JSModuleReference.getExtensionsWithPlatforms(element, extensions);
        });
        this.myNewFileTemplateName = newFileTemplateName;
        this.myIsSoft = isSoft;
    }

    public String getNewFileTemplateName() {
        return this.myNewFileTemplateName != null ? this.myNewFileTemplateName : super.getNewFileTemplateName();
    }

    public boolean isSoft() {
        return this.myIsSoft;
    }

    @Override
    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem psiFileSystemItem, @NotNull Collection<ResolveResult> resolveResults, boolean caseSensitive) {
        if (referenceText == null) {
            JSModuleReference.$$$reportNull$$$0(3);
        }
        if (psiFileSystemItem == null) {
            JSModuleReference.$$$reportNull$$$0(4);
        }
        if (resolveResults == null) {
            JSModuleReference.$$$reportNull$$$0(5);
        }
        int size = resolveResults.size();
        super.innerResolveInContext(referenceText, psiFileSystemItem, resolveResults, caseSensitive);
        if (resolveResults.size() == size && psiFileSystemItem instanceof PsiDirectory && this.isLast()) {
            if (!psiFileSystemItem.isValid()) {
                return;
            }
            if (resolveResults.size() == 0 && this.isAcceptableEmptyReference(referenceText)) {
                this.simpleInnerResolveInContext(referenceText, psiFileSystemItem, resolveResults, caseSensitive);
            }
        }
    }

    @Override
    protected NodeModuleDirectorySearchProcessor getNodeModuleSearchProcessor() {
        return NodeModuleDirectorySearchProcessor.PROCESSOR;
    }

    @Override
    public String[] getImplicitExtensions() {
        return (String[])this.myExtensionsValue.getValue();
    }

    @Override
    protected void innerResolveWithoutImplicitExtensions(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSModuleReference.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSModuleReference.$$$reportNull$$$0(7);
        }
        if (results == null) {
            JSModuleReference.$$$reportNull$$$0(8);
        }
        if (TypeScriptFileImportsResolver.hasJsExtension(referenceText)) {
            this.innerResolveWithExtensions(FileUtilRt.getNameWithoutExtension((String)referenceText), context, results, caseSensitive, TypeScriptUtil.TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS);
        }
        super.innerResolveWithoutImplicitExtensions(referenceText, context, results, caseSensitive);
    }

    @Override
    protected boolean shouldStopImplicitExtensionProcessing(@NotNull String currentExtension) {
        if (currentExtension == null) {
            JSModuleReference.$$$reportNull$$$0(9);
        }
        for (String platform : DOT_PLATFORMS) {
            if (!currentExtension.startsWith(platform)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        if (highlightSeverity == null) {
            JSModuleReference.$$$reportNull$$$0(10);
        }
        return highlightSeverity;
    }

    private static boolean isReactPlatform(@Nullable String platform) {
        if (platform == null) {
            return false;
        }
        for (String s : PLATFORMS) {
            if (!s.equalsIgnoreCase(platform)) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(String platform, String extension) {
        return "." + platform + "." + extension;
    }

    private static String @NotNull [] getPlatforms(@NotNull String extension) {
        if (extension == null) {
            JSModuleReference.$$$reportNull$$$0(11);
        }
        String[] result2 = new String[PLATFORMS.length];
        for (int i2 = 0; i2 < PLATFORMS.length; ++i2) {
            result2[i2] = JSModuleReference.getExtension(PLATFORMS[i2], extension);
        }
        if (result2 == null) {
            JSModuleReference.$$$reportNull$$$0(12);
        }
        return result2;
    }

    @NotNull
    public static String[] getExtensionsWithPlatforms(@Nullable PsiElement element, @NotNull String[] defaultExtensions) {
        String extension;
        if (defaultExtensions == null) {
            JSModuleReference.$$$reportNull$$$0(13);
        }
        if (element != null) {
            String fileNameWithExtension = element.getContainingFile().getName();
            extension = FileUtilRt.getExtension((String)fileNameWithExtension);
            if (StringUtil.isEmpty((String)extension)) {
                if (defaultExtensions == null) {
                    JSModuleReference.$$$reportNull$$$0(14);
                }
                return defaultExtensions;
            }
            String fileName = fileNameWithExtension.substring(0, fileNameWithExtension.length() - extension.length());
            String platform = FileUtilRt.getExtension((String)fileName);
            if (JSModuleReference.isReactPlatform(platform)) {
                String[] stringArray = (String[])ArrayUtil.prepend((Object)JSModuleReference.getExtension(platform, extension), (Object[])defaultExtensions);
                if (stringArray == null) {
                    JSModuleReference.$$$reportNull$$$0(15);
                }
                return stringArray;
            }
        } else {
            extension = "js";
        }
        String[] stringArray = ArrayUtil.mergeArrays((String[])JSModuleReference.getPlatforms(extension), (String[])defaultExtensions);
        if (stringArray == null) {
            JSModuleReference.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileSystemItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentExtension";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/amd/JSModuleReference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/amd/JSModuleReference";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferenceSeverity";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatforms";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionsWithPlatforms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveWithoutImplicitExtensions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopImplicitExtensionProcessing";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPlatforms";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionsWithPlatforms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

