/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import org.jetbrains.annotations.NotNull;

public class JSUsageTypeProvider
implements UsageTypeProvider {
    public static final UsageType STRING_LITERAL = new UsageType(JavaScriptBundle.messagePointer("js.usage.type.string", new Object[0]));
    public static final UsageType CALL_EXPRESSION = new UsageType(JavaScriptBundle.messagePointer("js.usage.type.call", new Object[0]));

    public UsageType getUsageType(@NotNull PsiElement element) {
        if (element == null) {
            JSUsageTypeProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof ES6ImportedBinding || element instanceof ES6ImportSpecifier) {
            return UsageType.CLASS_IMPORT;
        }
        PsiElement parent = element.getParent();
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral() || parent instanceof JSLiteralExpression && ((JSLiteralExpression)parent).isQuotedLiteral()) {
            if (element.getParent() instanceof ES6ImportCall) {
                return UsageType.CLASS_IMPORT;
            }
            return STRING_LITERAL;
        }
        if (!(element instanceof JSReferenceExpression)) {
            return null;
        }
        if (parent instanceof JSReferenceListMember) {
            return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
        }
        if (parent instanceof JSNewExpression) {
            return UsageType.CLASS_NEW_OPERATOR;
        }
        if (parent instanceof JSCallExpression) {
            return CALL_EXPRESSION;
        }
        if (parent instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            if (operationSign == JSTokenTypes.INSTANCEOF_KEYWORD || operationSign == JSTokenTypes.IS_KEYWORD) {
                return UsageType.CLASS_INSTANCE_OF;
            }
            if (operationSign == JSTokenTypes.AS_KEYWORD) {
                return UsageType.CLASS_CAST_TO;
            }
        } else {
            if (parent instanceof JSImportStatement) {
                return UsageType.CLASS_IMPORT;
            }
            if (parent instanceof JSReferenceExpression) {
                PsiElement resolve = ((JSReferenceExpression)element).resolve();
                if (resolve instanceof JSClass) {
                    return UsageType.CLASS_STATIC_MEMBER_ACCESS;
                }
            } else {
                if (parent instanceof JSParameter) {
                    return parent.getParent() instanceof JSParameterList ? UsageType.CLASS_METHOD_PARAMETER_DECLARATION : UsageType.CLASS_CATCH_CLAUSE_PARAMETER_DECLARATION;
                }
                if (parent instanceof JSFunction) {
                    return UsageType.CLASS_METHOD_RETURN_TYPE;
                }
                if (parent instanceof JSVariable) {
                    if (JSResolveUtil.findParent(parent) instanceof JSClass) {
                        return UsageType.CLASS_FIELD_DECLARATION;
                    }
                    return UsageType.CLASS_LOCAL_VAR_DECLARATION;
                }
                if (parent instanceof TypeScriptImportStatement || parent instanceof ES6ImportedBinding || parent instanceof ES6ExportSpecifierAlias) {
                    return UsageType.CLASS_IMPORT;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/findUsages/JSUsageTypeProvider", "getUsageType"));
    }
}

