/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypescriptConstructorChecker
extends JSConstructorChecker {
    public TypescriptConstructorChecker(@NotNull JSAnnotatorProblemReporter problemReporter) {
        if (problemReporter == null) {
            TypescriptConstructorChecker.$$$reportNull$$$0(0);
        }
        super(problemReporter);
    }

    @Override
    public void checkConstructor(@NotNull JSFunction constructor, @NotNull JSClass jsClass) {
        if (constructor == null) {
            TypescriptConstructorChecker.$$$reportNull$$$0(1);
        }
        if (jsClass == null) {
            TypescriptConstructorChecker.$$$reportNull$$$0(2);
        }
        if (constructor instanceof TypeScriptFunction && ((TypeScriptFunction)constructor).isOverloadDeclaration()) {
            return;
        }
        JSAttributeList list2 = jsClass.getAttributeList();
        if (list2 != null && TypeScriptPsiUtil.isAmbientDeclaration(jsClass)) {
            return;
        }
        super.checkConstructor(constructor, jsClass);
    }

    @Override
    protected boolean isBaseConstructorCallValid(@NotNull JSFunction constructor, @NotNull JSClass jsClass, @Nullable JSCallExpression baseConstructorCall) {
        if (constructor == null) {
            TypescriptConstructorChecker.$$$reportNull$$$0(3);
        }
        if (jsClass == null) {
            TypescriptConstructorChecker.$$$reportNull$$$0(4);
        }
        if (!super.isBaseConstructorCallValid(constructor, jsClass, baseConstructorCall)) {
            return false;
        }
        boolean hasPropertyParameters = ContainerUtil.or((Object[])constructor.getParameterVariables(), TypeScriptPsiUtil::isFieldParameter);
        boolean hasInitializedFields = ContainerUtil.or((Object[])jsClass.getFields(), field -> field.getInitializer() != null);
        JSBlockStatement constructorBody = constructor.getBlock();
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)baseConstructorCall, JSStatement.class);
        if (statement == null) {
            return true;
        }
        List constructorBodyDeclarations = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)constructorBody, JSElement.class);
        int statementIndex = constructorBodyDeclarations.indexOf(statement);
        if ((hasInitializedFields || hasPropertyParameters) && statementIndex != 0) {
            String message = JavaScriptBundle.message("typescript.validation.message.base.constructor.must.be.first.statement", new Object[0]);
            this.myProblemReporter.registerGenericError((PsiElement)baseConstructorCall, message, new IntentionAction[0]);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemReporter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypescriptConstructorChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isBaseConstructorCallValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

