/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSImportType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptUtil {
    public static final FileType[] TYPESCRIPT_FILE_TYPES_ARRAY = new FileType[]{TypeScriptFileType.INSTANCE, TypeScriptJSXFileType.INSTANCE};
    public static final Collection<FileType> TYPESCRIPT_FILE_TYPES = ContainerUtil.newArrayList((Object[])TYPESCRIPT_FILE_TYPES_ARRAY);
    public static final String TYPESCRIPT_FILE_EXTENSION = ".ts";
    public static final String TYPESCRIPT_JSX_FILE_EXTENSION = ".tsx";
    public static final String[] TYPESCRIPT_EXTENSIONS_WITHOUT_DTS = new String[]{".ts", ".tsx"};
    public static final String TYPESCRIPT_DECLARATIONS_FILE_EXTENSION = ".d.ts";
    public static final String[] TYPESCRIPT_EXTENSIONS = new String[]{".d.ts", ".ts", ".tsx"};
    public static final String LIB_PREFIX = "lib.";
    public static final String[] TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS = new String[]{".d.ts"};
    public static final String COMPILER_DIRECTORY_NAME = "jsLanguageServicesImpl";
    public static final Function<PsiElement, TypeScriptInterface> TYPESCRIPT_INTERFACE_FILTER = element -> element instanceof TypeScriptInterface ? (TypeScriptInterface)element : null;
    public static final String TYPINGS = "typings";
    public static final String TS_CONFIG = "tsconfig";
    public static final String TYPES = "types";
    public static final String EXTERNAL = "external";

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> resolveConstructorFunctions(@NotNull TypeScriptClass clazz, @Nullable PsiElement methodExpression) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(0);
        }
        HashSet<TypeScriptClass> visitedClasses = new HashSet<TypeScriptClass>();
        ArrayDeque<TypeScriptClass> classQueue = new ArrayDeque<TypeScriptClass>();
        if (methodExpression != null) {
            PsiElement parent = methodExpression.getParent();
            if (!(methodExpression instanceof JSNewExpression) && !(parent instanceof JSNewExpression)) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(1);
                }
                return list2;
            }
        }
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            TypeScriptClass currentClass;
            JSClass rawClass = (JSClass)classQueue.poll();
            if (!(rawClass instanceof TypeScriptClass) || !visitedClasses.add(currentClass = (TypeScriptClass)rawClass)) continue;
            Object[] constructors = currentClass.getConstructors();
            if (constructors.length > 0) {
                List list3 = ContainerUtil.map((Object[])constructors, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list3 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(2);
                }
                return list3;
            }
            Collection<JSFunction> indirectConstructors = currentClass.getIndirectSuperConstructors();
            if (!indirectConstructors.isEmpty()) {
                List list4 = ContainerUtil.map(indirectConstructors, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list4 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(3);
                }
                return list4;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        List list5 = ContainerUtil.emptyList();
        if (list5 == null) {
            TypeScriptUtil.$$$reportNull$$$0(4);
        }
        return list5;
    }

    @Nullable
    public static VirtualFile findFileByReferencePath(@NotNull PsiFile file2, @NotNull String referencePath) {
        ConcurrentMap refPathToVirtualFile;
        Object value;
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(5);
        }
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(6);
        }
        if ((value = (refPathToVirtualFile = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            ConcurrentHashMap result2 = new ConcurrentHashMap();
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{file2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        })).get(referencePath)) == null) {
            VirtualFile result2 = TypeScriptUtil.calcFileByReferencePath(file2.getProject(), file2.getVirtualFile(), referencePath);
            refPathToVirtualFile.put(referencePath, result2 == null ? ObjectUtils.NULL : result2);
            return result2;
        }
        return TypeScriptUtil.getValue(value);
    }

    @Nullable
    private static VirtualFile getValue(@NotNull Object object) {
        if (object == null) {
            TypeScriptUtil.$$$reportNull$$$0(7);
        }
        if (object instanceof VirtualFile) {
            return (VirtualFile)object;
        }
        return null;
    }

    @Nullable
    public static VirtualFile calcFileByReferencePath(Project project, @Nullable VirtualFile virtualFile, @NotNull String referencePath) {
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile result2 = null;
        referencePath = referencePath.replace('\\', '/');
        VirtualFile dir = virtualFile.getParent();
        if (referencePath.startsWith(".")) {
            if (dir != null) {
                result2 = TypeScriptUtil.getFileByRelativePath(referencePath, dir);
            }
        } else {
            VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile, true);
            return TypeScriptUtil.findForContentRoot(referencePath, contentRootForFile, dir);
        }
        return result2;
    }

    @Nullable
    private static VirtualFile findForContentRoot(@NotNull String referencePath, @Nullable VirtualFile contentRoot, @Nullable VirtualFile startFrom) {
        VirtualFile contentRootParent;
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(9);
        }
        VirtualFile imported = null;
        VirtualFile virtualFile = contentRootParent = contentRoot != null && contentRoot.isDirectory() ? contentRoot.getParent() : null;
        while (imported == null && startFrom != null) {
            ProgressManager.checkCanceled();
            imported = TypeScriptUtil.getFileByRelativePath(referencePath, startFrom);
            if (imported != null) {
                return imported;
            }
            if (contentRootParent != null && startFrom.equals(contentRootParent)) break;
            startFrom = startFrom.getParent();
        }
        return imported;
    }

    private static VirtualFile getFileByRelativePath(@NotNull String referencePath, VirtualFile currentParent) {
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(10);
        }
        boolean isJs = TypeScriptFileImportsResolver.hasJsExtension(referencePath);
        String original = referencePath;
        VirtualFile imported = null;
        if (isJs) {
            referencePath = FileUtil.getNameWithoutExtension((String)referencePath);
        } else {
            imported = currentParent.findFileByRelativePath(referencePath);
        }
        if (imported == null || imported.isDirectory()) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_DECLARATIONS_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_JSX_FILE_EXTENSION);
        }
        if (imported == null && isJs) {
            imported = currentParent.findFileByRelativePath(original);
        }
        return imported;
    }

    public static ResolveResult @NotNull [] findExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleText) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(11);
        }
        if (unquotedEscapedModuleText == null) {
            TypeScriptUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String quoted = StringUtil.wrapWithDoubleQuote((String)JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleText));
        String unifiedName = CommonJSUtil.unifyModuleName(quoted);
        GlobalSearchScope scope = TypeScriptUtil.createScopeWithFilterByNodeModules((PsiElement)refFile, (PsiElement)refFile);
        Collection<JSQualifiedNamedElement> modules2 = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(refFile.getProject(), unifiedName, scope);
        if (!modules2.isEmpty()) {
            ArrayList<JSResolveResult> result2 = new ArrayList<JSResolveResult>();
            for (JSNamedElement jSNamedElement : modules2) {
                if (!(jSNamedElement instanceof TypeScriptModule) || ((TypeScriptModule)jSNamedElement).isAugmentation()) continue;
                result2.add(new JSResolveResult((PsiElement)jSNamedElement));
            }
            if (!ContainerUtil.isEmpty(result2)) {
                ResolveResult[] resolveResultArray = result2.toArray(ResolveResult.EMPTY_ARRAY);
                if (resolveResultArray == null) {
                    TypeScriptUtil.$$$reportNull$$$0(13);
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            TypeScriptUtil.$$$reportNull$$$0(14);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static ResolveResult[] findPatternBasedExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleName, @NotNull Project project) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(15);
        }
        if (unquotedEscapedModuleName == null) {
            TypeScriptUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String unquotedModuleName = JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleName);
        Collection<TypeScriptModule> patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(project, (PsiElement)refFile);
        List patterns = ContainerUtil.map(patternExternalModules, module -> JSPathMappingsUtil.createPatternForString(StringUtil.unquoteString((String)module.getExternalModuleText()), false));
        Pair path2 = JSPathMappingsUtil.findMaxElementByPaths(unquotedModuleName, patterns);
        if (path2 != null && path2.getFirst() != null) {
            ArrayList<JSResolveResult> resultPatternModules = new ArrayList<JSResolveResult>();
            String pattern2 = StringUtil.wrapWithDoubleQuote((String)((JSModulePattern)path2.getFirst()).getPattern());
            for (TypeScriptModule module2 : patternExternalModules) {
                if (!pattern2.equals(module2.getExternalModuleText())) continue;
                resultPatternModules.add(new JSResolveResult((PsiElement)module2));
            }
            return resultPatternModules.toArray(ResolveResult.EMPTY_ARRAY);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static Collection<TypeScriptModule> getAllRegularExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(18);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"reg", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner, owner), TypeScriptModule.class);
    }

    @NotNull
    public static GlobalSearchScope createScopeWithFilterByNodeModules(@NotNull PsiElement context, @NotNull PsiElement excludeNodeModules) {
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(19);
        }
        if (excludeNodeModules == null) {
            TypeScriptUtil.$$$reportNull$$$0(20);
        }
        return TypeScriptUtil.createFilterByNodeModuleScope(JSResolveUtil.getResolveScope(context), excludeNodeModules);
    }

    public static Collection<TypeScriptModule> getAllPatternExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(21);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"pat", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner, owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getAllAugmentationModules(@NotNull Project project, @NotNull PsiElement scopeElement) {
        GlobalSearchScope scope;
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(22);
        }
        if (scopeElement == null) {
            TypeScriptUtil.$$$reportNull$$$0(23);
        }
        IdFilter filter = (scope = TypeScriptUtil.buildScopeByElement(scopeElement)) instanceof GlobalSearchScopeWithIdFilter ? ((GlobalSearchScopeWithIdFilter)scope).getFilter() : null;
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"aug", (Project)project, (GlobalSearchScope)scope, (IdFilter)filter, TypeScriptModule.class);
    }

    @NotNull
    private static GlobalSearchScope buildScopeByElement(@NotNull PsiElement scopeElement) {
        VirtualFile file2;
        if (scopeElement == null) {
            TypeScriptUtil.$$$reportNull$$$0(24);
        }
        if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)scopeElement)) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                TypeScriptUtil.$$$reportNull$$$0(25);
            }
            return globalSearchScope;
        }
        if (scopeElement instanceof JsonFile) {
            String name = ((JsonFile)scopeElement).getName();
            if ("package.json".equals(name)) {
                GlobalSearchScope globalSearchScope = TypeScriptUtil.createPackageJsonScope(file2);
                if (globalSearchScope == null) {
                    TypeScriptUtil.$$$reportNull$$$0(26);
                }
                return globalSearchScope;
            }
            return TypeScriptUtil.createConfigScope(scopeElement.getProject(), file2);
        }
        return TypeScriptUtil.createPsiElementScope(scopeElement, file2);
    }

    @Nullable
    public static VirtualFile getPackageJsonOutsideNodeModules(VirtualFile virtualFile) {
        VirtualFile startFile = JSLibraryUtil.findAncestorLibraryDir(virtualFile, "node_modules");
        if (startFile == null) {
            startFile = virtualFile;
        }
        VirtualFile packageJson = JSLibraryUtil.findConfigFile(startFile, "package.json");
        return packageJson;
    }

    @NotNull
    private static GlobalSearchScope createPsiElementScope(@NotNull PsiElement scopeElement, @NotNull VirtualFile file2) {
        if (scopeElement == null) {
            TypeScriptUtil.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(28);
        }
        TypeScriptConfigService.IntPredicate predicate = TypeScriptConfigService.Provider.get(scopeElement.getProject()).getFilterId(file2);
        return new GlobalSearchScopeWithIdFilter(JSResolveUtil.getResolveScope(scopeElement), predicate);
    }

    @NotNull
    private static GlobalSearchScope createConfigScope(@NotNull Project project, @NotNull VirtualFile configFile) {
        TypeScriptConfigService service;
        TypeScriptConfig config2;
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(29);
        }
        if (configFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(30);
        }
        if ((config2 = (service = TypeScriptConfigService.Provider.get(project)).parseConfigFile(configFile)) != null) {
            GlobalSearchScope globalSearchScope = service.createConfigScope(config2);
            if (globalSearchScope == null) {
                TypeScriptUtil.$$$reportNull$$$0(31);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            TypeScriptUtil.$$$reportNull$$$0(32);
        }
        return globalSearchScope;
    }

    private static GlobalSearchScope createPackageJsonScope(@NotNull VirtualFile packageJson) {
        VirtualFile topDirectory;
        if (packageJson == null) {
            TypeScriptUtil.$$$reportNull$$$0(33);
        }
        if ((topDirectory = packageJson.getParent()) == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VfsUtilCore.isAncestor((VirtualFile)topDirectory, (VirtualFile)file2, (boolean)true)) {
                    return true;
                }
                VirtualFile currentFilePackageJson = TypeScriptUtil.getPackageJsonOutsideNodeModules(file2);
                if (currentFilePackageJson != null) {
                    VirtualFile currentRoot = currentFilePackageJson.getParent();
                    return VfsUtilCore.isAncestor((VirtualFile)currentRoot, (VirtualFile)topDirectory, (boolean)false);
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Collection<JSClass> getNonStrictParents(@NotNull JSClass clazz, boolean includeInterfaces) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(34);
        }
        ArrayList<JSClass> result2 = new ArrayList<JSClass>();
        JSClassUtils.processClassesInHierarchy(clazz, includeInterfaces, (aClass, typeSubstitutor, fromImplements) -> {
            result2.add(aClass);
            return true;
        });
        ArrayList<JSClass> arrayList = result2;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Contract(value="null->null")
    public static String convertToExternalModuleText(@Nullable String unifiedModuleName) {
        if (unifiedModuleName == null) {
            return null;
        }
        if (unifiedModuleName.startsWith("module:")) {
            String sub = unifiedModuleName.substring("module:".length());
            return JSStringUtil.isDoubleQuotedString(sub) ? sub : StringUtil.wrapWithDoubleQuote((String)sub);
        }
        return null;
    }

    public static void resolveNameToClassesOverAliases(@Nullable String name, @NotNull PsiElement context, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(36);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(37);
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveTypeName(name, context);
        for (PsiElement psiElement : result2.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)psiElement, resultCollection, visitedAliases);
                continue;
            }
            resultCollection.add((JSClass)psiElement);
        }
    }

    public static void resolveAliasToClass(@NotNull TypeScriptTypeAlias alias, @NotNull Collection<JSClass> resultCollection, @Nullable Collection<JSClass> visitedAliases) {
        TypeScriptType declaration;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(38);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(39);
        }
        if ((declaration = alias.getTypeDeclaration()) instanceof TypeScriptSingleType && !TypeScriptUtil.hasTypeArguments((TypeScriptSingleType)declaration)) {
            if (visitedAliases == null) {
                visitedAliases = new HashSet<JSClass>();
            }
            if (!visitedAliases.add(alias)) {
                return;
            }
            TypeScriptSingleType singleType = (TypeScriptSingleType)declaration;
            TypeScriptUtil.resolveNameToClassesOverAliases(singleType.getQualifiedTypeName(), alias, resultCollection, visitedAliases);
        } else {
            resultCollection.add(alias);
        }
    }

    private static boolean hasTypeArguments(@NotNull TypeScriptSingleType singleType) {
        if (singleType == null) {
            TypeScriptUtil.$$$reportNull$$$0(40);
        }
        return singleType.getTypeArguments().length > 0;
    }

    @NotNull
    public static Iterable<JSNamedElement> getNamedMembers(@NotNull JSClass aClass) {
        if (aClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(41);
        }
        Iterable<? extends JSElement> members = aClass.getMembers();
        ArrayList<JSNamedElement> namedElements = new ArrayList<JSNamedElement>();
        for (JSElement jSElement : members) {
            if (!(jSElement instanceof JSNamedElement)) continue;
            namedElements.add((JSNamedElement)jSElement);
        }
        ArrayList<JSNamedElement> arrayList = namedElements;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyGenericsToType(@NotNull JSType typeInParentClass, @Nullable JSClass surroundClass, @Nullable JSClass parentClass) {
        if (typeInParentClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(43);
        }
        if (parentClass != null && surroundClass != null && DialectDetector.isTypeScript(surroundClass)) {
            JSType jSType = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(surroundClass, (List<? extends JSType>)ContainerUtil.emptyList(), parentClass, typeInParentClass);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(44);
            }
            return jSType;
        }
        JSType jSType = typeInParentClass;
        if (jSType == null) {
            TypeScriptUtil.$$$reportNull$$$0(45);
        }
        return jSType;
    }

    @NotNull
    public static String buildParameterTypeListStringWithApplyingGenerics(TypeScriptFunction function2, @Nullable PsiElement surroundClass) {
        TypeScriptTypeParameterList list2;
        JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)function2);
        if (classOfContext != null && (list2 = function2.getTypeParameterList()) != null) {
            String join = StringUtil.join((Object[])list2.getTypeParameters(), parameter -> {
                JSType jsType2 = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
                if (surroundClass instanceof JSClass) {
                    jsType2 = TypeScriptUtil.applyGenericsToType(jsType2, (JSClass)surroundClass, classOfContext);
                }
                return jsType2.getTypeText(JSType.TypeTextFormat.CODE);
            }, (String)", ");
            Object object = StringUtil.isEmpty((String)join) ? "" : "<" + join + ">";
            if (object == null) {
                TypeScriptUtil.$$$reportNull$$$0(46);
            }
            return object;
        }
        return "";
    }

    @NotNull
    public static Map<TypeScriptMemberInfo, JSClass> getUnimplementedMembers(@NotNull JSClass jsClass, boolean includeOptional) {
        Map<TypeScriptMemberInfo, JSClass> infos;
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(47);
        }
        if ((infos = TypeScriptUtil.getMemberInfos(jsClass, includeOptional)).isEmpty()) {
            return new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        }
        LinkedHashMap<TypeScriptMemberInfo, JSClass> result2 = new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        infos.forEach((cur, curClass) -> {
            if (cur.getKind() == TypeScriptMemberInfo.Kind.UNIMPLEMENTED) {
                result2.put((TypeScriptMemberInfo)cur, (JSClass)curClass);
            }
        });
        LinkedHashMap<TypeScriptMemberInfo, JSClass> linkedHashMap = result2;
        if (linkedHashMap == null) {
            TypeScriptUtil.$$$reportNull$$$0(48);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Map<TypeScriptMemberInfo, JSClass> getMemberInfos(@NotNull JSClass jsClass, boolean includeOptional) {
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(49);
        }
        ArrayList implementedInterfaces = new ArrayList();
        HashMap<JSClass, JSTypeSubstitutor> typeSubstitutors = new HashMap<JSClass, JSTypeSubstitutor>();
        JSClassUtils.processClassesInHierarchy(jsClass, true, (aClass, typeSubstitutor, fromImplements) -> {
            if ((includeOptional || fromImplements || TypeScriptPsiUtil.isAbstractElement(aClass)) && aClass != jsClass) {
                implementedInterfaces.add(aClass);
            }
            typeSubstitutors.put(aClass, typeSubstitutor);
            return true;
        });
        JSTypeSource source2 = JSTypeSourceFactory.createTypeSource(jsClass, DialectDetector.isTypeScript(jsClass));
        LinkedHashMap<TypeScriptMemberInfo, JSClass> membersToImplement = new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        for (JSClass implementedInterface : implementedInterfaces) {
            TypeScriptUtil.fillUnimplementedInterfaceMembers(jsClass, implementedInterface, membersToImplement, typeSubstitutors, source2, includeOptional);
        }
        LinkedHashMap<TypeScriptMemberInfo, JSClass> linkedHashMap = membersToImplement;
        if (linkedHashMap == null) {
            TypeScriptUtil.$$$reportNull$$$0(50);
        }
        return linkedHashMap;
    }

    private static void fillUnimplementedInterfaceMembers(@NotNull JSClass jsClass, @NotNull JSClass implementedInterface, @NotNull Map<TypeScriptMemberInfo, JSClass> membersToImplement, @NotNull Map<JSClass, JSTypeSubstitutor> typeSubstitutors, @NotNull JSTypeSource source2, boolean includeOptional) {
        List<TypeScriptMemberInfo> implementedMembers;
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(51);
        }
        if (implementedInterface == null) {
            TypeScriptUtil.$$$reportNull$$$0(52);
        }
        if (membersToImplement == null) {
            TypeScriptUtil.$$$reportNull$$$0(53);
        }
        if (typeSubstitutors == null) {
            TypeScriptUtil.$$$reportNull$$$0(54);
        }
        if (source2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(55);
        }
        if ((implementedMembers = TypeScriptUtil.getImplementedMembers(jsClass, implementedInterface, typeSubstitutors)).isEmpty()) {
            return;
        }
        JSRecordType classType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, true, TypeScriptPsiUtil.isAbstractElement(jsClass), false);
        classType = (JSRecordType)classType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)type -> TypeScriptUtil.replaceThisType(type, jsClass, source2)));
        JSRecordType objectType = null;
        for (TypeScriptMemberInfo implementedMember : implementedMembers) {
            TypeScriptMemberInfo.Kind errorForObjectMember;
            ProcessingContext context;
            boolean memberIsAlreadyAdded = false;
            for (TypeScriptMemberInfo member : membersToImplement.keySet()) {
                if (member.getMember() == null || !member.getMember().isEquivalentTo(implementedMember.getMember(), null, true)) continue;
                memberIsAlreadyAdded = true;
                break;
            }
            if (memberIsAlreadyAdded) continue;
            JSRecordType.TypeMember typeMember = includeOptional ? TypeScriptUtil.overrideOptionalFlagForTypeMember(implementedMember.getMember()) : implementedMember.getMember();
            TypeScriptMemberInfo.Kind implementationError = TypeScriptUtil.getImplementationError(typeMember = typeMember == null ? null : typeMember.copyTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)type1 -> TypeScriptUtil.replaceThisType(type1, jsClass, source2))), classType, context = JSTypeComparingContextService.createProcessingContextWithCallEnvironment(jsClass));
            if (implementationError == null) continue;
            if (objectType == null) {
                List<JSClass> objectClasses = TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                for (JSClass objectClass : objectClasses) {
                    JSRecordType currentObjectType = TypeScriptTypeParser.buildTypeFromClass(objectClass, false, false, false, false);
                    if (objectType == null) {
                        objectType = currentObjectType;
                        continue;
                    }
                    List objectTypeMembers = ContainerUtil.concat(objectType.getTypeMembers(), currentObjectType.getTypeMembers());
                    objectType = new JSRecordTypeImpl(objectType.getSource(), objectTypeMembers);
                }
                if (objectType == null) {
                    objectType = new JSRecordTypeImpl(source2, Collections.emptyList());
                }
            }
            if ((errorForObjectMember = TypeScriptUtil.getImplementationError(typeMember, objectType, context)) == null) continue;
            if (implementationError == TypeScriptMemberInfo.Kind.INCOMPATIBLE || errorForObjectMember == TypeScriptMemberInfo.Kind.INCOMPATIBLE) {
                implementedMember = TypeScriptMemberInfo.create(implementedMember.getMember(), implementedMember.getElement(), TypeScriptMemberInfo.Kind.INCOMPATIBLE);
            }
            membersToImplement.put(implementedMember, implementedInterface);
        }
    }

    @Nullable
    private static TypeScriptMemberInfo.Kind getImplementationError(@Nullable JSRecordType.TypeMember baseMember, @NotNull JSRecordType inheritedClassType, @NotNull ProcessingContext context) {
        if (inheritedClassType == null) {
            TypeScriptUtil.$$$reportNull$$$0(56);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(57);
        }
        if (baseMember instanceof JSRecordType.PropertySignature) {
            JSRecordType.PropertySignature inheritedSignature = inheritedClassType.findPropertySignature(((JSRecordType.PropertySignature)baseMember).getMemberName());
            boolean isBaseOptional = ((JSRecordType.PropertySignature)baseMember).isOptional();
            if (inheritedSignature == null) {
                return isBaseOptional ? null : TypeScriptMemberInfo.Kind.UNIMPLEMENTED;
            }
            if (inheritedSignature.isOptional() && !TypeScriptUtil.isInitializedParameterProperty(inheritedSignature) && !isBaseOptional) {
                return TypeScriptMemberInfo.Kind.INCOMPATIBLE;
            }
            JSType type = ((JSRecordType.PropertySignature)baseMember).getJSType();
            if (type == null) {
                return null;
            }
            return type.isDirectlyAssignableType(inheritedSignature.getJSType(), context) ? null : TypeScriptMemberInfo.Kind.INCOMPATIBLE;
        }
        if (baseMember instanceof JSRecordType.IndexSignature) {
            JSRecordType.IndexSignature inheritedIndexer = inheritedClassType.findIndexer(((JSRecordType.IndexSignature)baseMember).getIndexSignatureKind());
            if (inheritedIndexer == null) {
                return TypeScriptMemberInfo.Kind.UNIMPLEMENTED;
            }
            return ((JSRecordType.IndexSignature)baseMember).getMemberType().isDirectlyAssignableType(inheritedIndexer.getMemberType(), context) ? null : TypeScriptMemberInfo.Kind.INCOMPATIBLE;
        }
        return TypeScriptMemberInfo.Kind.UNIMPLEMENTED;
    }

    private static boolean isInitializedParameterProperty(@NotNull JSRecordType.PropertySignature signature) {
        PsiElement element;
        if (signature == null) {
            TypeScriptUtil.$$$reportNull$$$0(58);
        }
        if ((element = signature.getMemberSource().getSingleElement()) instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)element)) {
            return ((JSParameter)element).getInitializerOrStub() != null;
        }
        return false;
    }

    @NotNull
    private static List<TypeScriptMemberInfo> getImplementedMembers(@NotNull JSClass jsClass, @NotNull JSClass implementedInterface, @NotNull Map<JSClass, JSTypeSubstitutor> typeSubstitutors) {
        JSType typeDeclaration;
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(59);
        }
        if (implementedInterface == null) {
            TypeScriptUtil.$$$reportNull$$$0(60);
        }
        if (typeSubstitutors == null) {
            TypeScriptUtil.$$$reportNull$$$0(61);
        }
        ArrayList<TypeScriptMemberInfo> implementedMembers = new ArrayList<TypeScriptMemberInfo>();
        if (implementedInterface instanceof TypeScriptInterface) {
            TypeScriptObjectType body = ((TypeScriptInterface)implementedInterface).getBody();
            if (body == null) {
                ArrayList<TypeScriptMemberInfo> arrayList = implementedMembers;
                if (arrayList == null) {
                    TypeScriptUtil.$$$reportNull$$$0(62);
                }
                return arrayList;
            }
            for (TypeScriptTypeMember typeMember : body.getTypeMembers()) {
                JSRecordType.TypeMember interfaceTypeMember = TypeScriptTypeMemberParser.buildTypeMember(typeMember);
                if (interfaceTypeMember == null) continue;
                implementedMembers.add(TypeScriptMemberInfo.create(interfaceTypeMember, typeMember));
            }
        } else if (implementedInterface instanceof TypeScriptClass) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(implementedInterface, true);
            for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(implementedInterface)) {
                JSRecordType.TypeMember member = TypeScriptTypeMemberParser.buildTypeMemberFromElement(implementedInterface, (PsiElement)classMember, false, typeSource, typeSubstitutors.get(implementedInterface));
                if (member == null) continue;
                implementedMembers.add(TypeScriptMemberInfo.create(member, classMember));
            }
        } else if (implementedInterface instanceof TypeScriptTypeAlias && (typeDeclaration = ((TypeScriptTypeAlias)implementedInterface).getParsedTypeDeclaration()) != null) {
            if (JSTypeUtils.hasForeignGenericParameter(typeDeclaration)) {
                JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExtendClass(jsClass, implementedInterface);
                typeDeclaration = JSTypeUtils.applyGenericArguments(typeDeclaration, substitutor);
            }
            JSRecordType recordType = typeDeclaration.asRecordType();
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                if (!(member instanceof JSRecordType.PropertySignature)) continue;
                String name = ((JSRecordType.PropertySignature)member).getMemberName();
                JSType type = ((JSRecordType.PropertySignature)member).getJSType();
                implementedMembers.add(TypeScriptMemberInfo.create(member, new JSLocalImplicitElementImpl(name, type, implementedInterface, JSImplicitElement.Type.Property)));
            }
        }
        ArrayList<TypeScriptMemberInfo> arrayList = implementedMembers;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    private static JSType replaceThisType(JSType type, JSClass jsClass, JSTypeSource source2) {
        if (type instanceof TypeScriptGenericThisTypeImpl) {
            String name = jsClass.getQualifiedName();
            if (name != null) {
                return new TypeScriptGenericThisTypeImpl(type.getSource(), JSNamedTypeFactory.createType(name, source2, JSTypeContext.INSTANCE));
            }
            if (jsClass instanceof JSClassExpression) {
                return new TypeScriptGenericThisTypeImpl(type.getSource(), TypeScriptTypeParser.buildTypeFromClass(jsClass, false));
            }
        }
        return type;
    }

    @NotNull
    private static JSRecordType.TypeMember overrideOptionalFlagForTypeMember(JSRecordType.TypeMember member) {
        JSRecordType.PropertySignature propertySignature;
        if (member instanceof JSRecordType.PropertySignature && (propertySignature = (JSRecordType.PropertySignature)member).isOptional()) {
            return new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getJSType(), false, propertySignature.isConst(), propertySignature.getMemberSource());
        }
        JSRecordType.TypeMember typeMember = member;
        if (typeMember == null) {
            TypeScriptUtil.$$$reportNull$$$0(64);
        }
        return typeMember;
    }

    public static boolean isTypeScriptMethod(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof TypeScriptCallSignature);
    }

    public static boolean isTypeScriptProperty(PsiElement element) {
        return element instanceof TypeScriptPropertySignature || element instanceof JSVariable;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(65);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(66);
        }
        JSType type = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context), JSContext.INSTANCE);
        return TypeScriptUtil.getShortestTypeNameInContext(type, context);
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(67);
        }
        if (!((type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(type))) instanceof JSNamedType) || context == null || type instanceof JSPrimitiveType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(68);
            }
            return string;
        }
        String text = type.getResolvedTypeText();
        return TypeScriptUtil.getShortestTypeNameInContextForQualifiedName(context, text);
    }

    @NotNull
    public static String getShortestTypeNameInContextForQualifiedName(@NotNull PsiElement context, @NotNull String startQName) {
        String currentName;
        JSQualifiedNameImpl name;
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(69);
        }
        if (startQName == null) {
            TypeScriptUtil.$$$reportNull$$$0(70);
        }
        if ((name = JSQualifiedNameImpl.fromQualifiedName(startQName)).getParent() == null) {
            String string = startQName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(71);
            }
            return string;
        }
        String result2 = null;
        Object qName = null;
        boolean hasNonIdentifiers = false;
        for (JSQualifiedName current = name; !(current == null || !StringUtil.isEmpty(result2) && StringUtil.equals((CharSequence)startQName, result2) || TypeScriptUtil.hasAmbientExternalModuleInQName(currentName = current.getName())); current = current.getParent()) {
            if (qName == null) {
                qName = currentName;
            } else if (StringUtil.isJavaIdentifier((String)qName)) {
                qName = currentName + "." + (String)qName;
            } else {
                hasNonIdentifiers = true;
                qName = currentName + "[\"" + (String)qName + "\"]";
            }
            result2 = TypeScriptImportHandler.getInstance().getQualifiedNameResolvedType((String)qName, context);
        }
        if (result2 != null && (StringUtil.equals((CharSequence)startQName, result2) || hasNonIdentifiers)) {
            String string = qName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(72);
            }
            return string;
        }
        String string = startQName;
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    public static boolean hasAmbientExternalModuleInQName(@Nullable String value) {
        return value != null && value.startsWith("module:");
    }

    @NotNull
    public static JSType getBaseTypeOfEnumLiteralType(@NotNull JSResolvableType type) {
        String text;
        JSQualifiedNameImpl name;
        JSQualifiedName parent;
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(74);
        }
        if ((parent = (name = JSQualifiedNameImpl.fromQualifiedName(text = type.getResolvedTypeText())).getParent()) != null) {
            String qualifiedName = parent.getQualifiedName();
            JSType jSType = JSNamedType.createType(qualifiedName, type.getSource(), JSTypeContext.INSTANCE);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(75);
            }
            return jSType;
        }
        JSResolvableType jSResolvableType = type;
        if (jSResolvableType == null) {
            TypeScriptUtil.$$$reportNull$$$0(76);
        }
        return jSResolvableType;
    }

    @NotNull
    public static File getTypeScriptExternalFolderFile() {
        return new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), EXTERNAL);
    }

    @NotNull
    public static File getTypeScriptCompilerFolderFile() throws RuntimeException {
        try {
            String jarPath = PathUtil.getJarPathForClass(TypeScriptUtil.class);
            if (!jarPath.endsWith(".jar")) {
                URL resource = TypeScriptUtil.class.getClassLoader().getResource(COMPILER_DIRECTORY_NAME);
                if (resource == null) {
                    throw new RuntimeException("Cannot find file compiler implementation");
                }
                return new File(URLUtil.decode((String)resource.getPath()));
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, COMPILER_DIRECTORY_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean resolveIsStrict(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptUtil.$$$reportNull$$$0(77);
        }
        return TypeScriptUtil.isStrictResolveQualifier(node.getQualifier());
    }

    public static boolean isStrictResolveQualifier(@Nullable JSExpression qualifier) {
        JSType jsType2;
        if (TypeScriptUtil.isValidThisQualifier(qualifier) || TypeScriptUtil.isValidSuperQualifier(qualifier) || qualifier == null) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((JSReferenceExpression)qualifier).multiResolve(false)) {
                PsiElement resolve = result2.getElement();
                if (!(resolve instanceof TypeScriptModule) && !(resolve instanceof TypeScriptImportStatement) && !(resolve instanceof ES6ImportedBinding) && !(resolve instanceof ES6ImportSpecifierAlias) && !(resolve instanceof JSFile)) continue;
                return true;
            }
        }
        if (TypeScriptUtil.isStrictType(jsType2 = JSResolveUtil.getExpressionJSType(qualifier))) {
            return !TypeScriptUtil.isImportType(jsType2) || TypeScriptUtil.isStrictType(jsType2.substitute());
        }
        return false;
    }

    public static boolean isImportType(@Nullable JSType jsType2) {
        return jsType2 instanceof JSImportType;
    }

    public static boolean isValidSuperQualifier(JSExpression qualifier) {
        return qualifier instanceof JSSuperExpression && JSResolveUtil.getClassOfContext((PsiElement)qualifier) != null;
    }

    public static boolean isValidThisQualifier(JSExpression qualifier) {
        return qualifier instanceof JSThisExpression && JSContextResolver.findContextElement((PsiElement)qualifier) instanceof JSClass;
    }

    public static ProblemHighlightType getProblemHighlightTypeForType(@Nullable JSType type) {
        if (TypeScriptUtil.isStrictType(type)) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static boolean isStrictType(@Nullable JSType jsType2) {
        return jsType2 != null && !JSTypeUtils.hasAnyTypeOrNotStrictType(jsType2) && !(jsType2 instanceof JSNullType);
    }

    public static boolean isUnderNodeModules(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(78);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(79);
        }
        return JSLibraryUtil.hasDirectoryInPath(file2, JSLibraryUtil.LIBRARY_DIR_NAMES, project.getBaseDir());
    }

    public static boolean isDefinitionFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(80);
        }
        return TypeScriptUtil.isDefinitionFile(file2.getNameSequence());
    }

    public static boolean isDefinitionFile(@NotNull CharSequence fileName) {
        int dtslength;
        int length;
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(81);
        }
        if ((length = fileName.length()) <= (dtslength = TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.length())) {
            return false;
        }
        for (int i2 = 0; i2 < dtslength; ++i2) {
            char ch = fileName.charAt(i2 + length - dtslength);
            if ('A' <= ch && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            if (ch == TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static JSRecordType getFunctionTypeMembers(@Nullable PsiElement source2) {
        if (source2 == null || !DialectDetector.isTypeScript(source2)) {
            return null;
        }
        return TypeScriptUtil.getTypeMembers(source2, JSTypeUtils.getFunctionTypeName(source2.getContainingFile(), false));
    }

    private static JSRecordType getTypeMembers(@NotNull PsiElement source2, @NotNull String className2) {
        if (source2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(82);
        }
        if (className2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(83);
        }
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>();
        JSElement context = ES6PsiUtil.getNonStrictExportScope(source2);
        if (context == null) {
            context = source2;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(className2, (PsiElement)context);
        for (PsiElement psiElement : elements) {
            JSElement container = ES6PsiUtil.getExportScope(psiElement);
            if (!(psiElement instanceof JSClass) || container == null || ES6PsiUtil.isExternalModule((PsiElement)container) || TypeScriptModuleAccessibilityChecker.INSTANCE.check((PsiElement)context, psiElement) != null) continue;
            JSRecordType current = TypeScriptTypeParser.buildTypeFromClass((JSClass)psiElement, false);
            members.addAll(current.getTypeMembers());
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)context, true), members);
    }

    @NotNull
    public static GlobalSearchScope createFilterByNodeModuleScope(@NotNull GlobalSearchScope scope, @NotNull PsiElement context) {
        if (scope == null) {
            TypeScriptUtil.$$$reportNull$$$0(84);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(85);
        }
        if (context instanceof PsiFile) {
            context = ((PsiFile)context).getOriginalFile();
        }
        final VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)context);
        final ProjectFileIndex index = ProjectFileIndex.getInstance((Project)context.getProject());
        Object resultScope = contextFile == null ? scope : new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                VirtualFile currentNodeModules = JSLibraryUtil.findAncestorLibraryDir(file2, "node_modules");
                if (currentNodeModules == null) {
                    return true;
                }
                VirtualFile parentDir = currentNodeModules.getParent();
                boolean isPartOfProject = index.isInContent(parentDir) || index.isInLibrary(parentDir);
                return !isPartOfProject || VfsUtilCore.isAncestor((VirtualFile)parentDir, (VirtualFile)contextFile, (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$2", "contains"));
            }
        };
        return DialectDetector.isTypeScript(context) ? resultScope : TypeScriptUtil.excludeTsGlobalDeclarationsFromNodeModules((GlobalSearchScope)resultScope, context.getProject());
    }

    @Nullable
    public static JSRecordType getTypeAliasRecordTypeForSubstitutor(@NotNull TypeScriptTypeAlias alias, @Nullable JSTypeSubstitutor substitutor) {
        JSType typeToProcess;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(86);
        }
        return (typeToProcess = JSTypeUtils.applyGenericArguments(alias.getParsedTypeDeclaration(), substitutor)) == null ? null : typeToProcess.asRecordType();
    }

    public static boolean isDefinitionFile(@Nullable PsiFile file2) {
        return file2 != null && TypeScriptUtil.isDefinitionFile(file2.getName());
    }

    public static int getTypePrecedence(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            TypeScriptUtil.$$$reportNull$$$0(87);
        }
        if (declaration instanceof TypeScriptParenthesizedType) {
            return 0;
        }
        if (declaration instanceof TypeScriptSingleType) {
            return 1;
        }
        if (declaration instanceof TypeScriptArrayType) {
            return 2;
        }
        if (declaration instanceof TypeScriptTypeOperator) {
            return 3;
        }
        if (declaration instanceof TypeScriptUnionOrIntersectionType) {
            TypeScriptUnionOrIntersectionType unionOrIntersection = (TypeScriptUnionOrIntersectionType)declaration;
            return unionOrIntersection.isIntersectionType() ? 4 : 5;
        }
        if (declaration instanceof TypeScriptFunctionType) {
            return 6;
        }
        return -1;
    }

    public static PsiElement evaluateThisFromFunction(TypeScriptFunction function2) {
        JSType thisType = TypeScriptUtil.evaluateThisTypeFromFunction(function2);
        if (thisType == null) {
            return null;
        }
        PsiElement sourceElement = thisType.getSourceElement();
        if (!(sourceElement instanceof TypeScriptType)) {
            return sourceElement;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof JSParameter) {
            return parent;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getInitializer() instanceof JSObjectLiteralExpression) {
            JSType originalType = ((TypeScriptType)sourceElement).getJSType();
            if (originalType instanceof JSResolvableType) {
                Collection<? extends PsiElement> declarations = ((JSResolvableType)originalType).resolveType().getDeclarations();
                if (declarations.size() == 1) {
                    return declarations.iterator().next();
                }
            } else {
                Collection<? extends PsiElement> declarations;
                JSType type = originalType.substitute();
                if (type instanceof JSResolvableType && (declarations = ((JSResolvableType)type).resolveType().getDeclarations()).size() == 1) {
                    return declarations.iterator().next();
                }
            }
        }
        return sourceElement;
    }

    @Nullable
    public static JSType evaluateThisTypeFromFunction(TypeScriptFunction function2) {
        TypeScriptTypeEvaluator evaluator = new TypeScriptTypeEvaluator(new JSEvaluateContext(function2.getContainingFile()), new JSSimpleTypeProcessor());
        JSType thisType = evaluator.computeThisType(function2);
        if (thisType == null) {
            return null;
        }
        return thisType;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name, @NotNull String extension) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(88);
        }
        if (extension == null) {
            TypeScriptUtil.$$$reportNull$$$0(89);
        }
        CharSequence charSequence = name.subSequence(0, name.length() - extension.length());
        if (charSequence == null) {
            TypeScriptUtil.$$$reportNull$$$0(90);
        }
        return charSequence;
    }

    public static boolean isES6LibName(@NotNull String libraryName) {
        if (libraryName == null) {
            TypeScriptUtil.$$$reportNull$$$0(91);
        }
        if ((libraryName = StringUtil.toLowerCase((String)libraryName)).startsWith("esnext")) {
            return true;
        }
        if (!libraryName.startsWith("es")) {
            return false;
        }
        int indexOfEnd = libraryName.indexOf(".");
        if (indexOfEnd == -1) {
            indexOfEnd = libraryName.length();
        }
        try {
            String index = libraryName.substring(2, indexOfEnd);
            int parsedValue = Integer.parseInt(index);
            if (index.length() == 1 && parsedValue >= 6) {
                return true;
            }
            if (index.length() == 4 && parsedValue >= 2015) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptUtil.class).debug((Throwable)e);
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope excludeTsGlobalDeclarationsFromNodeModules(@NotNull GlobalSearchScope scope, final @NotNull Project project) {
        if (scope == null) {
            TypeScriptUtil.$$$reportNull$$$0(92);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(93);
        }
        final TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(project);
        return new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                CharSequence name = file2.getNameSequence();
                if (!StringUtil.endsWith((CharSequence)name, (CharSequence)TypeScriptUtil.TYPESCRIPT_FILE_EXTENSION)) {
                    return true;
                }
                VirtualFile topDirectory = JSLibraryUtil.getLibraryFolder(file2, "node_modules");
                if (topDirectory == null) {
                    return true;
                }
                return configService.isImplicitIncludedNodeModulesFile(project, file2, topDirectory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$3", "contains"));
            }
        };
    }

    public static boolean isTypeScriptFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(94);
        }
        for (FileType type : TYPESCRIPT_FILE_TYPES_ARRAY) {
            if (!FileTypeManager.getInstance().isFileOfType(file2, type)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getLibraryName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(95);
        }
        int end = fileName.length() - TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.length();
        int start = LIB_PREFIX.length();
        String string = "lib.d.ts".equals(fileName) ? fileName : fileName.substring(start, end);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(96);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 90: 
            case 96: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 90: 
            case 96: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 90: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 5: 
            case 28: 
            case 78: 
            case 80: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleName";
                break;
            }
            case 17: 
            case 22: 
            case 29: 
            case 79: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 19: 
            case 36: 
            case 57: 
            case 66: 
            case 69: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeNodeModules";
                break;
            }
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultCollection";
                break;
            }
            case 38: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInParentClass";
                break;
            }
            case 47: 
            case 49: 
            case 51: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementedInterface";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToImplement";
                break;
            }
            case 54: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutors";
                break;
            }
            case 55: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritedClassType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 65: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startQName";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 81: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 84: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorFunctions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalModule";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "buildScopeByElement";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigScope";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonStrictParents";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedMembers";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGenericsToType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterTypeListStringWithApplyingGenerics";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnimplementedMembers";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberInfos";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedMembers";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideOptionalFlagForTypeMember";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContext";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorFunctions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 90: 
            case 96: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileByReferencePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcFileByReferencePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findForContentRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileByRelativePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPatternBasedExternalModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllRegularExternalModules";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createScopeWithFilterByNodeModules";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllPatternExternalModules";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllAugmentationModules";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildScopeByElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createPsiElementScope";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createConfigScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJsonScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParents";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameToClassesOverAliases";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasToClass";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getNamedMembers";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericsToType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getUnimplementedMembers";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getMemberInfos";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fillUnimplementedInterfaceMembers";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationError";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isInitializedParameterProperty";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedMembers";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContext";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsStrict";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isUnderNodeModules";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isDefinitionFile";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMembers";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createFilterByNodeModuleScope";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAliasRecordTypeForSubstitutor";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getTypePrecedence";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "isES6LibName";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "excludeTsGlobalDeclarationsFromNodeModules";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptFile";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 90: 
            case 96: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface JSClassHierarchyProcessor
    extends JSClassUtils.JSClassHierarchyProcessor {
        public boolean process(@NotNull JSClass var1, @NotNull JSTypeSubstitutor var2, boolean var3);

        @Override
        default public boolean process(@NotNull JSClass aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean fromStaticContext, int depth) {
            if (aClass == null) {
                JSClassHierarchyProcessor.$$$reportNull$$$0(0);
            }
            if (typeSubstitutor == null) {
                JSClassHierarchyProcessor.$$$reportNull$$$0(1);
            }
            if (fromStaticContext) {
                return true;
            }
            return this.process(aClass, typeSubstitutor, fromImplements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeSubstitutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$JSClassHierarchyProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

