/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.actions.JSShowTypeInfoAction;
import com.intellij.lang.javascript.documentation.JSDocBuilderParameterInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQuickNavigateBuilder {
    private static final int INITIALIZER_MAX_LENGTH = 50;

    @Nullable
    @NlsSafe
    public String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        originalElement = JSQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement);
        if (element instanceof JSFunction) {
            return this.createForFunction((JSFunction)element, originalElement);
        }
        if (element instanceof JSClass) {
            return this.createForJSClass((JSClass)element, originalElement, jsDoc);
        }
        if (element instanceof JSFieldVariable) {
            return this.createForVariableOrField((JSFieldVariable)element, originalElement, jsDoc);
        }
        if (element instanceof JSProperty) {
            return this.createForProperty((JSProperty)element, originalElement, jsDoc);
        }
        if (element instanceof JSImplicitElement) {
            return this.createQuickNavigateForJSElement((JSImplicitElement)element, originalElement, "", ObjectKind.SIMPLE_DECLARATION, jsDoc);
        }
        if (element instanceof XmlToken) {
            String xmlAttributeDoc = JSQuickNavigateBuilder.checkAndGetXmlAttributeQuickNavigate(element);
            if (xmlAttributeDoc != null) {
                return xmlAttributeDoc;
            }
            JSTagContextBuilder builder = new JSTagContextBuilder(element, "XmlTag");
            return StringUtil.unquoteString((String)element.getText()) + ":" + builder.typeName;
        }
        return null;
    }

    @Nullable
    @Nls
    public final String getQuickNavigateInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        if (element instanceof JSOffsetBasedImplicitElement) {
            element = ((JSOffsetBasedImplicitElement)element).getElementAtOffset();
        }
        return element == null || DumbService.isDumb((Project)element.getProject()) ? null : this.getQuickNavigateInfoForNavigationElement(element.getNavigationElement(), originalElement, false);
    }

    @Nullable
    protected final String createForProperty(@NotNull JSProperty element, @NotNull PsiElement originalElement, boolean jsDoc) {
        String name;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if ((name = JSPsiImplUtils.getNameOrComputedPropertyName(element, true)) == null) {
            return null;
        }
        JSQualifiedNamedElement parent = element == JSQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement) ? null : JSQuickNavigateBuilder.getPropertyParent(element);
        String qName = parent != null ? parent.getQualifiedName() + "." + name : name;
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor(element, originalElement);
        StringBuilder typePart = new StringBuilder();
        JSType narrowed = this.getNarrowedType(originalElement, substitutor);
        JSType declared = this.getPropertyType(element);
        JSType toUse = this.appendOptionality(element, declared, narrowed, typePart, originalElement);
        this.appendTypeWithSeparatorForOwner(element, toUse, substitutor, typePart, originalElement, jsDoc);
        JSExpression value = element.getValue();
        ObjectKind kind = value instanceof JSFunctionExpression ? ObjectKind.FUNCTION : ObjectKind.PROPERTY;
        String result2 = JSQuickNavigateBuilder.buildHtmlForProperty(element, qName, jsDoc ? "" : typePart) + (Serializable)((Object)(jsDoc ? typePart : ""));
        return jsDoc ? result2 : JSQuickNavigateBuilder.buildResult(kind, result2, (PsiElement)element, originalElement);
    }

    private static String buildHtmlForProperty(@NotNull JSProperty element, String qName, CharSequence typePart) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        return JSQuickNavigateBuilder.buildHtmlForVariableOrField((PsiElement)element, "", qName, false, typePart);
    }

    @Nullable
    protected JSType getPropertyType(@NotNull JSProperty element) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        return JSTypeUtils.widenLiteralTypes(element.getJSType());
    }

    protected void appendTypeWithSeparatorForOwner(@NotNull JSElement typeOwner, @Nullable JSType toUse, @NotNull JSTypeSubstitutor substitutor, @NotNull StringBuilder builder, @NotNull PsiElement originalElement, boolean jsDoc) {
        String variableOrFieldTypeText;
        if (typeOwner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if ((variableOrFieldTypeText = this.getPresentableTypeText(toUse, substitutor, jsDoc, (PsiElement)typeOwner)) != null) {
            this.appendType((PsiElement)typeOwner, variableOrFieldTypeText, builder);
        }
    }

    @Nullable
    private static JSQualifiedNamedElement getPropertyParent(@NotNull JSProperty property) {
        PsiElement literalContainer;
        PsiElement parent;
        if (property == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        if ((parent = property.getParent()) instanceof JSObjectLiteralExpression && (literalContainer = parent.getParent()) instanceof JSVariable) {
            return (JSVariable)literalContainer;
        }
        return null;
    }

    protected static boolean isFileNameRequired(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        return elementFile == null || !elementFile.equals(originalFile);
    }

    @Nullable
    protected String createForFunction(@NotNull JSFunction function2, @NotNull PsiElement originalElement) {
        if (function2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        List<JSDocBuilderParameterInfo> newParameters = this.mapParametersToInfos(function2);
        JSDocBuilderSimpleInfo newReturnInfo = this.mapReturnTypeToInfo(function2);
        return this.getFunctionDefinitionWithHighlighting(function2, newParameters, newReturnInfo, originalElement, false).toString();
    }

    @Nullable
    protected JSType getNarrowedType(@NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        return null;
    }

    @NotNull
    protected String getFunctionNameWithHtml(@NotNull JSFunctionItem functionItem, @NotNull JSTypeSubstitutor substitutor) {
        if (functionItem == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)functionItem);
        String namespace = this.getParentInfo(parent, functionItem, substitutor);
        Object functionName = JSPsiImplUtils.findFunctionName(functionItem);
        if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            String unqualifiedFunctionName = functionName;
            JSExpression definition2 = ((JSAssignmentExpression)parent).getLOperand();
            if (definition2 instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)definition2).getExpression()) != null) {
                JSExpression qualifierExpression;
                functionName = null;
                if (expression instanceof JSReferenceExpression && (qualifierExpression = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) {
                    JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifierExpression);
                    functionName = (ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : qualifierExpression.getText()) + "." + unqualifiedFunctionName;
                }
                if (functionName == null) {
                    functionName = expression.getText();
                }
                if (namespace != null && ((String)functionName).equals(namespace + "." + unqualifiedFunctionName)) {
                    namespace = null;
                }
            }
        }
        if (functionName == null) {
            functionName = JSFormatUtil.getAnonymousElementPresentation();
        }
        Object object = !StringUtil.isEmpty((String)namespace) ? namespace + this.getQNameSeparator((PsiElement)functionItem) + (String)functionName : functionName;
        if (object == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(19);
        }
        return object;
    }

    @NotNull
    protected String getQNameSeparator(@NotNull PsiElement element) {
        JSAttributeList list2;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(20);
        }
        if (element instanceof JSAttributeListOwner && (list2 = ((JSAttributeListOwner)element).getAttributeList()) != null && list2.hasPrivateSharp()) {
            return ".#";
        }
        return ".";
    }

    @NotNull
    public final CharSequence getFunctionDefinitionWithHighlighting(@NotNull JSFunctionItem functionItem, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, boolean jsDoc) {
        if (functionItem == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        if (parameters == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (returnInfo == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor(functionItem, originalElement);
        String escapedName = this.getFunctionNameWithHtml(functionItem, substitutor);
        CharSequence charSequence = this.getFunctionDefinition(functionItem, escapedName, substitutor, parameters, returnInfo, originalElement, jsDoc);
        if (charSequence == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        return charSequence;
    }

    @NotNull
    protected CharSequence getFunctionDefinition(@NotNull JSFunctionItem functionItem, @NotNull String escapedName, @NotNull JSTypeSubstitutor substitutor, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSDocBuilderSimpleInfo returnInfo, @NotNull PsiElement originalElement, boolean jsDoc) {
        int lengthToWrapAll;
        int paramsStart;
        if (functionItem == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (escapedName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        if (parameters == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        if (returnInfo == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        StringBuilder currentBuilder = new StringBuilder();
        currentBuilder.append("(");
        parameters = jsDoc ? parameters : this.expandParameters(functionItem, parameters, substitutor);
        PsiElement parent = JSResolveUtil.findParent((PsiElement)functionItem);
        boolean shouldAppendFunctionKeyword = this.shouldAppendFunctionKeyword(functionItem, parent);
        StringBuilder modifiers = new StringBuilder();
        this.appendFunctionAttributes(functionItem, modifiers, shouldAppendFunctionKeyword);
        if (functionItem.isGetProperty()) {
            modifiers.append("get ");
        }
        if (functionItem.isSetProperty()) {
            modifiers.append("set ");
        }
        int alignment = (paramsStart = currentBuilder.length() + escapedName.length() + modifiers.length()) >= (lengthToWrapAll = 10) ? 4 : paramsStart;
        ArrayList<JSHtmlHighlightingUtil.TextPlaceholder> placeholders = new ArrayList<JSHtmlHighlightingUtil.TextPlaceholder>();
        int lastLineStart = escapedName.length();
        for (JSDocBuilderParameterInfo parameterInfo : parameters) {
            boolean firstArg;
            boolean bl = firstArg = currentBuilder.length() == 1;
            if (!firstArg) {
                lastLineStart = currentBuilder.length();
                if (!jsDoc) {
                    currentBuilder.append(", ");
                } else {
                    currentBuilder.append(",\n");
                    StringUtil.repeatSymbol((Appendable)currentBuilder, (char)' ', (int)alignment);
                }
            } else if (jsDoc && paramsStart >= lengthToWrapAll) {
                lastLineStart = currentBuilder.length();
                currentBuilder.append("\n");
                StringUtil.repeatSymbol((Appendable)currentBuilder, (char)' ', (int)alignment);
            }
            JSParameterItem key = parameterInfo.getParameterItem();
            currentBuilder.append(JSParameterInfoHandler.getSignatureForParameter(key, substitutor, t -> {
                if (t != null && !t.isSourceStrict()) {
                    t = null;
                }
                t = this.getTypeWithAppliedSubstitutor((JSType)t, substitutor);
                JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(t, parameterInfo.hasFiredEvents, "$$Type$$Parameter" + this.hashCode());
                placeholders.add(holder);
                return holder.getHolderText().toString();
            }));
        }
        currentBuilder.append(")");
        StringBuilder returnTypeBuilder = new StringBuilder();
        if (returnInfo.hasType()) {
            currentBuilder.append(": ");
            if (jsDoc && currentBuilder.length() - lastLineStart > 80) {
                currentBuilder.append("\n");
                StringUtil.repeatSymbol((Appendable)currentBuilder, (char)' ', (int)2);
            }
            JSType narrowedGetterType = functionItem.isGetProperty() ? this.getNarrowedType(originalElement, substitutor) : null;
            JSType returnType = this.getReturnTypeForQuickNavigate(functionItem, functionItem.isSetProperty(), returnInfo.type, substitutor);
            JSType type = this.appendOptionality(functionItem, returnType, narrowedGetterType, returnTypeBuilder, originalElement);
            if (!functionItem.isGetProperty()) {
                type = returnType;
            }
            JSHtmlHighlightingUtil.TextPlaceholder placeholder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(type, returnInfo.hasFiredEvents, "$$Type$$Unique");
            ContainerUtil.addIfNotNull(placeholders, (Object)placeholder);
            currentBuilder.append(placeholder.getHolderText());
        }
        String s = JSHtmlHighlightingUtil.getFunctionHtmlHighlighting(functionItem, escapedName, shouldAppendFunctionKeyword, modifiers, currentBuilder, placeholders) + returnTypeBuilder.toString();
        if (jsDoc) {
            String string = s;
            if (string == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = JSQuickNavigateBuilder.buildResult(this.getFunctionKind(functionItem, JSPsiImplUtils.isGetterOrSetter(functionItem), shouldAppendFunctionKeyword), s, (PsiElement)functionItem, originalElement);
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    protected Collection<JSDocBuilderParameterInfo> expandParameters(@NotNull JSFunctionItem functionItem, @NotNull Collection<JSDocBuilderParameterInfo> parameters, @NotNull JSTypeSubstitutor substitutor) {
        if (functionItem == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        if (parameters == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        Collection<JSDocBuilderParameterInfo> collection = parameters;
        if (collection == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @NotNull
    public static String buildHtmlForFunction(@NotNull PsiElement context, @NotNull CharSequence modifiers, @NotNull CharSequence qName, boolean hasFunctionKeyword, @NotNull CharSequence parametersWithReturnType) {
        if (context == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        if (modifiers == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        if (qName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        if (parametersWithReturnType == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        String prefix = hasFunctionKeyword ? "" : "class Foo { ";
        String finalText = prefix + modifiers + "$$Name$$" + parametersWithReturnType;
        int beforeNameLength = prefix.length() + modifiers.length();
        TextRange toHighlight = new TextRange(beforeNameLength, beforeNameLength + "$$Name$$".length());
        return JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(context, qName, prefix, finalText, toHighlight);
    }

    @NotNull
    protected ObjectKind getFunctionKind(@NotNull JSFunctionItem function2, boolean isGetterOrSetter, boolean shouldAppendKeyword) {
        if (function2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(42);
        }
        if (isGetterOrSetter) {
            ObjectKind objectKind = ObjectKind.PROPERTY;
            if (objectKind == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(43);
            }
            return objectKind;
        }
        if (function2 instanceof JSFunction && ((JSFunction)function2).isConstructor()) {
            ObjectKind objectKind = ObjectKind.SIMPLE_DECLARATION;
            if (objectKind == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(44);
            }
            return objectKind;
        }
        ObjectKind objectKind = shouldAppendKeyword ? ObjectKind.SIMPLE_DECLARATION : ObjectKind.FUNCTION;
        if (objectKind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(45);
        }
        return objectKind;
    }

    protected static String buildResult(@NotNull ObjectKind kind, @NotNull String objectText, @NotNull PsiElement element, @NotNull PsiElement originalElement) {
        boolean needFileName;
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(46);
        }
        if (objectText == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(47);
        }
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(48);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(49);
        }
        if (!(needFileName = JSQuickNavigateBuilder.isFileNameRequired(element, originalElement))) {
            return kind.toPrefix() + objectText;
        }
        PsiFile psiFile = element.getContainingFile();
        String fileNameText = "(" + psiFile.getName() + ")";
        String kindText = kind.toPrefix();
        return kindText + objectText + JSQuickNavigateBuilder.buildAdditionalInformationText(fileNameText);
    }

    @NotNull
    protected final String createForVariableOrField(@NotNull JSFieldVariable variableOrField, PsiElement originalElement, boolean jsDoc) {
        String prefix;
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(50);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variableOrField);
        StringBuilder modifiers = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor(variableOrField, originalElement);
        this.appendAttrList(variableOrField, modifiers);
        boolean hasVarPrefix = false;
        if (variableOrField instanceof JSVariable && !(prefix = this.getVarPrefix((JSVariable)variableOrField)).isEmpty()) {
            hasVarPrefix = true;
            modifiers.append(prefix);
        }
        String parentInfo = this.getParentInfo(parent, variableOrField, substitutor);
        String name = JSDocumentationBuilder.getNameForDocumentation(variableOrField);
        Object qName = "";
        if (!StringUtil.isEmpty((String)parentInfo)) {
            qName = parentInfo;
            if (!StringUtil.startsWithChar((CharSequence)name, (char)'[')) {
                qName = (String)qName + this.getQNameSeparator((PsiElement)variableOrField);
            }
        }
        qName = (String)qName + name;
        StringBuilder typeAndInitializer = new StringBuilder();
        JSType declaredType = this.getVariableOrFieldType(variableOrField);
        JSType narrowedType = this.getNarrowedType(originalElement, substitutor);
        JSType type = this.appendOptionality(variableOrField, declaredType, narrowedType, typeAndInitializer, originalElement);
        this.appendTypeWithSeparatorForOwner(variableOrField, type, substitutor, typeAndInitializer, originalElement, jsDoc);
        if (variableOrField instanceof JSVariable && variableOrField.hasInitializer() && !jsDoc) {
            this.appendVariableInitializer((JSVariable)variableOrField, typeAndInitializer);
        }
        ObjectKind kind = this.getFieldOrVariableKind(variableOrField);
        String textWithHighlighting = JSQuickNavigateBuilder.buildHtmlForVariableOrField((PsiElement)variableOrField, modifiers.toString(), (CharSequence)qName, hasVarPrefix, jsDoc ? "" : typeAndInitializer);
        if (jsDoc) {
            String string = textWithHighlighting + typeAndInitializer;
            if (string == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = JSQuickNavigateBuilder.buildResult(kind, textWithHighlighting, (PsiElement)variableOrField, originalElement);
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    protected List<JSDocBuilderParameterInfo> mapParametersToInfos(@NotNull JSFunctionItem parsedFunction) {
        if (parsedFunction == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(53);
        }
        List list2 = StreamEx.of((Object[])parsedFunction.getParameters()).map(JSDocBuilderParameterInfo::new).toList();
        if (list2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(54);
        }
        return list2;
    }

    @NotNull
    protected JSDocBuilderSimpleInfo mapReturnTypeToInfo(@NotNull JSFunctionItem parsedFunction) {
        if (parsedFunction == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(55);
        }
        JSDocBuilderSimpleInfo newReturnInfo = new JSDocBuilderSimpleInfo();
        newReturnInfo.setJSType(parsedFunction.getReturnType());
        JSDocBuilderSimpleInfo jSDocBuilderSimpleInfo = newReturnInfo;
        if (jSDocBuilderSimpleInfo == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(56);
        }
        return jSDocBuilderSimpleInfo;
    }

    @Nullable
    protected JSType appendOptionality(@NotNull JSElement variableLikeElement, @Nullable JSType declaredType, @Nullable JSType narrowedType, @NotNull StringBuilder builder, @NotNull PsiElement originalElement) {
        JSType toUse;
        if (variableLikeElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(57);
        }
        if (builder == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(58);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(59);
        }
        JSType jSType = toUse = narrowedType == null ? declaredType : narrowedType;
        if (variableLikeElement instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)variableLikeElement)).isOptional()) {
            builder.append("?");
            if (!(narrowedType == null || declaredType instanceof JSUnionType && TypeScriptTypeRelations.isUnionWithUndefinedType(declaredType))) {
                toUse = JSCompositeTypeImpl.optimizeTypeIfComposite(narrowedType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
            }
        }
        return toUse;
    }

    @NotNull
    public static String buildHtmlForVariableOrField(@NotNull PsiElement owner, @NotNull CharSequence modifiers, @NotNull CharSequence escapedName, boolean hasVarPrefix, @NotNull CharSequence typeAndInitializer) {
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(60);
        }
        if (modifiers == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(61);
        }
        if (escapedName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(62);
        }
        if (typeAndInitializer == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(63);
        }
        String prefix = hasVarPrefix ? "" : (owner instanceof JSParameter ? "function f( " : "class { ");
        String finalText = prefix + modifiers + "$$Name$$" + typeAndInitializer;
        int modifiersWithPrefixLength = modifiers.length() + prefix.length();
        TextRange toHighlight = new TextRange(modifiersWithPrefixLength, modifiersWithPrefixLength + "$$Name$$".length());
        return JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(owner, escapedName, prefix, finalText, toHighlight);
    }

    @NotNull
    public static String getQuickNavigateHtmlHighlighting(@NotNull PsiElement owner, @NotNull CharSequence escapedName, @NotNull String prefixToExclude, @NotNull String finalText, @Nullable TextRange toHighlight) {
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(64);
        }
        if (escapedName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(65);
        }
        if (prefixToExclude == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(66);
        }
        if (finalText == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(67);
        }
        CharSequence result2 = ApplicationManager.getApplication().isUnitTestMode() ? null : JSHtmlHighlightingUtil.tryGetHtmlHighlighting(owner, finalText, toHighlight, prefixToExclude.length(), finalText.length());
        result2 = result2 == null ? XmlStringUtil.escapeString((String)finalText.substring(prefixToExclude.length()), (boolean)false) : result2.toString().replace("font-style:italic;", "");
        String string = result2.toString().replace("$$Name$$", escapedName);
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    protected ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(69);
        }
        ObjectKind objectKind = variableOrField instanceof JSParameter ? ObjectKind.PARAMETER : ObjectKind.SIMPLE_DECLARATION;
        if (objectKind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(70);
        }
        return objectKind;
    }

    private static String buildAdditionalInformationText(@NotNull String text) {
        if (text == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(71);
        }
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        Color color = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getDefaultAttributes().getForegroundColor();
        StringBuilder result2 = new StringBuilder();
        result2.append(" <span");
        result2.append(" style=\"");
        Font font = StartupUiUtil.getLabelFont();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (font != null) {
                result2.append("font-size:").append(font.getSize()).append("pt").append(";");
            }
            if (color != null) {
                result2.append("color:").append(ColorUtil.toHex((Color)color)).append(";");
            }
        }
        result2.append("\">");
        result2.append(text);
        result2.append("</span>");
        return result2.toString();
    }

    @Nullable
    public String createForJSClass(@NotNull JSClass jsClass, PsiElement originalElement, boolean jsDoc) {
        String qName;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(72);
        }
        if ((qName = jsClass.getQualifiedName()) == null) {
            return null;
        }
        StringBuilder attributesAndKeyword = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        this.appendClassAttributes(jsClass, originalElement, packageName, attributesAndKeyword);
        qName = this.getClassQualifiedName(jsClass, packageName);
        StringBuilder extendsImplements = new StringBuilder();
        this.appendClassExtendsAndImplements(jsClass, originalElement, packageName, extendsImplements);
        String htmlForClass = JSQuickNavigateBuilder.buildHtmlForClass(jsClass, attributesAndKeyword, qName, extendsImplements);
        return jsDoc ? htmlForClass : JSQuickNavigateBuilder.buildResult(ObjectKind.SIMPLE_DECLARATION, htmlForClass, jsClass, originalElement);
    }

    private static String buildHtmlForClass(@NotNull JSClass jsClass, CharSequence attributesAndKeyword, String qName, CharSequence extendsImplements) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(73);
        }
        String finalText = attributesAndKeyword + "$$Name$$" + extendsImplements;
        TextRange range = new TextRange(attributesAndKeyword.length(), attributesAndKeyword.length() + "$$Name$$".length());
        return JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(jsClass, qName, "", finalText, range);
    }

    @Nullable
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(74);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(75);
        }
        if (parent instanceof JSClass) {
            return StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
        }
        return "";
    }

    @Nullable
    private static String checkAndGetXmlAttributeQuickNavigate(@NotNull PsiElement element) {
        PsiElement xmlAttribute;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(76);
        }
        String xmlAttributeDoc = null;
        Object object = element.getParent() instanceof XmlAttribute ? element.getParent() : (xmlAttribute = element.getParent() instanceof XmlAttributeValue && element.getParent().getParent() instanceof XmlAttribute ? element.getParent().getParent() : null);
        if (xmlAttribute != null) {
            String value = StringUtil.unquoteString((String)StringUtil.notNullize((String)((XmlAttribute)xmlAttribute).getValue()));
            xmlAttributeDoc = ((XmlAttribute)xmlAttribute).getName() + " " + value;
        }
        return xmlAttributeDoc;
    }

    @Nullable
    protected JSType getReturnTypeForQuickNavigate(@NotNull JSFunctionItem function2, boolean set, JSType returnType, @NotNull JSTypeSubstitutor substitutor) {
        if (function2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(77);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(78);
        }
        if (!set) {
            JSType type = returnType;
            if (type instanceof JSFunctionReturnWrapperType) {
                type = type.substitute();
            }
            if (!JSFormatUtil.isPossiblyPresentableType(type, (PsiElement)function2, true)) {
                return null;
            }
            return this.getTypeWithAppliedSubstitutor(type, substitutor);
        }
        JSParameterItem[] parameters = function2.getParameters();
        if (parameters.length > 0) {
            return this.getTypeWithAppliedSubstitutor(parameters[0].getInferredType(), substitutor);
        }
        return null;
    }

    @Nullable
    protected String getPresentableTypeText(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor, boolean jsDoc, @Nullable PsiElement context) {
        JSType type;
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(79);
        }
        if ((type = this.getTypeWithAppliedSubstitutor(rawType, substitutor)) == null) {
            return null;
        }
        if (jsDoc) {
            return JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(JSQuickNavigateBuilder.expandTypeForPresentation(type, false), context, false).toString();
        }
        if (type.isJavaScript() && type instanceof JSEvaluableOnlyType) {
            return null;
        }
        type = JSQuickNavigateBuilder.expandTypeForPresentation(type, false);
        return type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
    }

    @NotNull
    private static JSType expandTypeForPresentation(@NotNull JSType type, boolean nested) {
        if (type == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(80);
        }
        if (type instanceof JSEvaluableType || type instanceof JSUnionOrIntersectionType || type instanceof JSGenericTypeImpl || type instanceof JSTypeImpl && ((JSTypeImpl)type).getJSTypedef() instanceof JSEvaluableType) {
            return nested ? type.substitute() : JSQuickNavigateBuilder.simplifyGenericArguments(type.substitute());
        }
        JSType jSType = type;
        if (jSType == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(81);
        }
        return jSType;
    }

    @NotNull
    private static JSType simplifyGenericArguments(@NotNull JSType type) {
        if (type == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(82);
        }
        if (type instanceof JSGenericTypeImpl) {
            List nested = ContainerUtil.map(((JSGenericTypeImpl)type).getArguments(), el -> JSQuickNavigateBuilder.expandTypeForPresentation(el, true));
            return new JSGenericTypeImpl(type.getSource(), ((JSGenericTypeImpl)type).getType(), nested);
        }
        JSType jSType = type;
        if (jSType == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(83);
        }
        return jSType;
    }

    @Nullable
    protected JSType getTypeWithAppliedSubstitutor(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(84);
        }
        return JSTypeUtils.applyGenericArguments(JSTypeUtils.applyCompositeMapping(rawType, (Function<? super JSType, ? extends JSType>)((Function)el -> JSArrayType.GenericArrayBuilder.asArrayIfGenericType(JSCompositeTypeImpl.optimizeTypeIfComposite(el)))), substitutor);
    }

    protected void appendFunctionAttributes(@NotNull JSFunctionItem functionItem, @NotNull StringBuilder result2, boolean shouldAppendKeyword) {
        if (functionItem == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(85);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(86);
        }
        if (functionItem instanceof JSFunction) {
            JSFunction function2 = (JSFunction)functionItem;
            this.appendAttrList(function2, result2);
            if (shouldAppendKeyword) {
                result2.append(function2.getKind() == JSFunction.FunctionKind.DECORATOR ? "decorator @" : "function ");
            }
        } else if (shouldAppendKeyword) {
            result2.append("function ");
        }
    }

    protected boolean shouldAppendFunctionKeyword(@NotNull JSFunctionItem function2, @Nullable PsiElement parent) {
        if (function2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(87);
        }
        if (JSPsiImplUtils.isGetterOrSetter(function2)) {
            return false;
        }
        if (function2 instanceof JSFunctionProperty || function2 instanceof TypeScriptFunctionSignature || function2 instanceof TypeScriptFunctionType) {
            return false;
        }
        return !(parent instanceof JSClass);
    }

    protected void appendAttrList(@NotNull JSAttributeListOwner owner, @NotNull StringBuilder result2) {
        JSElement exportScope;
        JSAttributeList attributeList;
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(88);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(89);
        }
        if ((attributeList = owner.getAttributeList()) == null) {
            return;
        }
        JSAttributeList.AccessType type = attributeList.getAccessType();
        String visibilityOrExportPart = null;
        JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
        if (jsClass != null) {
            visibilityOrExportPart = this.formatVisibility(owner, attributeList, type);
        } else if (owner instanceof JSQualifiedNamedElement && ((exportScope = ES6PsiUtil.getExportScope((PsiElement)owner)) instanceof TypeScriptModule || ES6PsiUtil.isExternalModule((PsiElement)exportScope))) {
            if (((JSQualifiedNamedElement)((Object)owner)).isExported()) {
                visibilityOrExportPart = "export";
            } else if (ES6ImportHandler.isExportedWithDefault((PsiElement)owner)) {
                visibilityOrExportPart = "export default";
            }
        }
        if (visibilityOrExportPart != null) {
            result2.append(visibilityOrExportPart);
            result2.append(" ");
        }
        this.appendPlainModifierList(attributeList, result2);
    }

    @Nullable
    protected String formatVisibility(@NotNull JSAttributeListOwner owner, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.AccessType type) {
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(90);
        }
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(91);
        }
        if (type == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(92);
        }
        return JSFormatUtil.formatVisibility(type, (PsiElement)owner);
    }

    protected void appendPlainModifierList(@NotNull JSAttributeList attributeList, @NotNull StringBuilder result2) {
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(93);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(94);
        }
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.ASYNC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.STATIC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.GENERATOR);
    }

    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(95);
        }
        return JSShowTypeInfoAction.getTypeForDocumentation((PsiElement)variable);
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement el, @NotNull PsiElement originalElement) {
        if (el == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(96);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(97);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(98);
        }
        return jSTypeSubstitutor;
    }

    protected void appendType(@NotNull PsiElement context, @Nullable String typeText, @NotNull StringBuilder builder) {
        if (context == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(99);
        }
        if (builder == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(100);
        }
        if (!StringUtil.isEmpty((String)typeText)) {
            builder.append(JSSymbolPresentationProvider.getDefaultTypeSeparator(context)).append(typeText);
        }
    }

    protected void appendClassAttributes(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(101);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(102);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(103);
        }
        this.appendAttrList(jsClass, result2);
        result2.append(jsClass.isInterface() ? "interface " : "class ");
    }

    protected String getClassQualifiedName(@NotNull JSClass jsClass, @Nullable String packageOrModule) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(104);
        }
        return !StringUtil.isEmpty((String)packageOrModule) ? packageOrModule + "." + jsClass.getName() : jsClass.getName();
    }

    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, PsiElement originalElement, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        String implementsList;
        String extendsList;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(105);
        }
        if (packageNameOrEmptyString == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(106);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(107);
        }
        if ((extendsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getExtendsList(), packageNameOrEmptyString)) == null && this.isIncludeObjectInExtendsList() && !"Object".equals(jsClass.getName())) {
            extendsList = "Object";
        }
        if (extendsList != null) {
            result2.append(" extends ").append(extendsList);
        }
        if ((implementsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getImplementsList(), packageNameOrEmptyString)) != null) {
            result2.append("\nimplements ").append(implementsList);
        }
    }

    protected boolean isIncludeObjectInExtendsList() {
        return false;
    }

    @Nullable
    private static String generateReferenceTargetList(@Nullable JSReferenceList implementsList, @NotNull String packageName) {
        String[] referenceExpressionTexts;
        if (packageName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(108);
        }
        if (implementsList == null) {
            return null;
        }
        StringBuilder result2 = null;
        for (String refExprText : referenceExpressionTexts = implementsList.getReferenceTexts()) {
            refExprText = JSImportHandlingUtil.resolveTypeName(refExprText, (PsiElement)implementsList);
            if (result2 == null) {
                result2 = new StringBuilder();
            } else {
                result2.append(", ");
            }
            refExprText = StringUtil.notNullize((String)refExprText);
            String referencedPackageName = StringUtil.getPackageName((String)refExprText);
            result2.append(referencedPackageName.equals(packageName) ? refExprText.substring(refExprText.lastIndexOf(46) + 1) : refExprText);
        }
        return result2 == null ? null : result2.toString();
    }

    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        JSVarStatement statement;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(109);
        }
        JSVarStatement.VarKeyword keyword = (statement = variable.getStatement()) != null ? statement.getVarKeyword() : null;
        return keyword != null ? keyword.getText() + " " : "";
    }

    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        JSExpression initializer;
        Object initializerText;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(110);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(111);
        }
        if ((initializerText = variable.getLiteralOrReferenceInitializerText()) == null && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            if (((String)initializerText).length() > 50) {
                initializerText = ((String)initializerText).substring(0, 50) + " ...";
            }
            result2.append(" = ").append((String)initializerText);
        }
    }

    protected static void appendModifierWithSpace(@NotNull StringBuilder result2, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(112);
        }
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(113);
        }
        if (modifier == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(114);
        }
        if (attributeList.hasModifier(modifier)) {
            result2.append(modifier.keyword).append(" ");
        }
    }

    @Nullable
    protected String createQuickNavigateForJSElement(@NotNull JSElement element, @NotNull PsiElement originalElement, @NotNull String declaration, @NotNull ObjectKind kind, boolean jsDoc) {
        String qName;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(115);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(116);
        }
        if (declaration == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(117);
        }
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(118);
        }
        String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : element.getName();
        if (StringUtil.isEmpty((String)qName)) {
            return null;
        }
        StringBuilder attributesAndDeclaration = new StringBuilder();
        if (element instanceof JSAttributeListOwner) {
            this.appendAttrList((JSAttributeListOwner)element, attributesAndDeclaration);
        }
        attributesAndDeclaration.append(declaration);
        Object result2 = JSQuickNavigateBuilder.buildHtmlForJSElement(element, attributesAndDeclaration, qName, !declaration.isEmpty());
        JSType declared = this.getJSElementType(element, originalElement);
        if (declared != null) {
            JSTypeSubstitutor substitutor = this.getTypeSubstitutor(element, originalElement);
            JSType narrowedType = this.getNarrowedType(originalElement, substitutor);
            StringBuilder builder = new StringBuilder();
            JSType type = this.appendOptionality(element, declared, narrowedType, builder, originalElement);
            this.appendTypeWithSeparatorForOwner(element, type, substitutor, builder, originalElement, true);
            result2 = (String)result2 + builder;
        }
        return jsDoc ? result2 : JSQuickNavigateBuilder.buildResult(kind, (String)result2, (PsiElement)element, originalElement);
    }

    @Nullable
    protected JSType getJSElementType(@NotNull JSElement element, @NotNull PsiElement originalElement) {
        PsiElement el;
        ResolveResult[] results;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(119);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(120);
        }
        if (element instanceof JSTypeOwner) {
            return ((JSTypeOwner)((Object)element)).getJSType();
        }
        if (element instanceof ES6ImportedBinding && (results = ((ES6ImportedBinding)element).multiResolve(false)).length == 1 && (el = results[0].getElement()) instanceof JSExpression) {
            return JSResolveUtil.getElementJSType(el);
        }
        return null;
    }

    private static String buildHtmlForJSElement(@NotNull JSElement element, CharSequence prefix, String qName, boolean hasDeclaration) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(121);
        }
        if (hasDeclaration) {
            String finalText = prefix + "$$Name$$";
            TextRange range = new TextRange(prefix.length(), prefix.length() + "$$Name$$".length());
            return JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting((PsiElement)element, qName, "", finalText, range);
        }
        return prefix + JSQuickNavigateBuilder.buildHtmlForName(element, qName);
    }

    @NotNull
    private static String buildHtmlForName(@NotNull JSElement element, @NotNull String name) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(122);
        }
        if (name == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(123);
        }
        String result2 = ApplicationManager.getApplication().isUnitTestMode() ? null : JSHtmlHighlightingUtil.tryGetHtmlHighlightingForName((PsiElement)element, name);
        String string = result2 == null ? XmlStringUtil.escapeString((String)name, (boolean)false) : result2;
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(124);
        }
        return string;
    }

    @Contract(value="!null->!null")
    protected static PsiElement getOriginalElementOrParentIfLeaf(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement) {
            PsiFile file2 = originalElement.getContainingFile();
            int offset = ((LeafPsiElement)originalElement).getStartOffset();
            PsiElement candidate = originalElement;
            ASTNode node = originalElement.getNode();
            if (offset > 0 && !JSQuickNavigateBuilder.isIdentifier(node) && (candidate = file2.findElementAt(offset - 1)) != null) {
                node = candidate.getNode();
            }
            if (candidate != null && JSQuickNavigateBuilder.isIdentifier(node)) {
                return candidate.getParent();
            }
        }
        return originalElement;
    }

    private static boolean isIdentifier(@NotNull ASTNode node) {
        if (node == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(125);
        }
        return JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 68: 
            case 70: 
            case 81: 
            case 83: 
            case 98: 
            case 124: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 68: 
            case 70: 
            case 81: 
            case 83: 
            case 98: 
            case 124: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 24: 
            case 31: 
            case 49: 
            case 59: 
            case 97: 
            case 102: 
            case 116: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 7: 
            case 16: 
            case 18: 
            case 28: 
            case 36: 
            case 75: 
            case 78: 
            case 79: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: 
            case 58: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: 
            case 42: 
            case 77: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 17: 
            case 21: 
            case 26: 
            case 34: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 19: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 68: 
            case 70: 
            case 81: 
            case 83: 
            case 98: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 22: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnInfo";
                break;
            }
            case 27: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedName";
                break;
            }
            case 38: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersWithReturnType";
                break;
            }
            case 46: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectText";
                break;
            }
            case 50: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedFunction";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableLikeElement";
                break;
            }
            case 60: 
            case 64: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAndInitializer";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixToExclude";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalText";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 72: 
            case 73: 
            case 101: 
            case 104: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 80: 
            case 82: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 86: 
            case 89: 
            case 94: 
            case 103: 
            case 107: 
            case 111: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 91: 
            case 93: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 95: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionNameWithHtml";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDefinitionWithHighlighting";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDefinition";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "expandParameters";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionKind";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createForVariableOrField";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "mapParametersToInfos";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "mapReturnTypeToInfo";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickNavigateHtmlHighlighting";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldOrVariableKind";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTypeForPresentation";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "simplifyGenericArguments";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlForName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createForProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeWithSeparatorForOwner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyParent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameRequired";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createForFunction";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionNameWithHtml";
                break;
            }
            case 19: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 68: 
            case 70: 
            case 81: 
            case 83: 
            case 98: 
            case 124: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getQNameSeparator";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDefinitionWithHighlighting";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDefinition";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "expandParameters";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForFunction";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionKind";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "buildResult";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createForVariableOrField";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "mapParametersToInfos";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "mapReturnTypeToInfo";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionality";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForVariableOrField";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateHtmlHighlighting";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrVariableKind";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "buildAdditionalInformationText";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createForJSClass";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForClass";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetXmlAttributeQuickNavigate";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeForQuickNavigate";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableTypeText";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "expandTypeForPresentation";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "simplifyGenericArguments";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithAppliedSubstitutor";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributes";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "shouldAppendFunctionKeyword";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "appendAttrList";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "formatVisibility";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "appendPlainModifierList";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "appendType";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributes";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getClassQualifiedName";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "generateReferenceTargetList";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "appendModifierWithSpace";
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSElement";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getJSElementType";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForJSElement";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForName";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 25: 
            case 32: 
            case 33: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 68: 
            case 70: 
            case 81: 
            case 83: 
            case 98: 
            case 124: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ObjectKind {
        SIMPLE_DECLARATION{

            @Override
            @NotNull
            public String toPrefix() {
                return "";
            }
        }
        ,
        PROPERTY{

            @Override
            @NotNull
            public String toPrefix() {
                return "(property) ";
            }
        }
        ,
        PARAMETER{

            @Override
            @NotNull
            public String toPrefix() {
                return "(parameter) ";
            }
        }
        ,
        FUNCTION{

            @Override
            @NotNull
            public String toPrefix() {
                return "(function) ";
            }
        }
        ,
        METHOD{

            @Override
            @NotNull
            public String toPrefix() {
                return "(method) ";
            }
        }
        ,
        IMPORT_SPECIFIER{

            @Override
            @NotNull
            public String toPrefix() {
                return "(named import) ";
            }

            @Override
            @NotNull
            public String toJSDocPrefix() {
                return "import ";
            }
        }
        ,
        IMPORT_DEFAULT{

            @Override
            @NotNull
            public String toPrefix() {
                return "(default import) ";
            }

            @Override
            @NotNull
            public String toJSDocPrefix() {
                return "import ";
            }
        }
        ,
        IMPORT_ALL{

            @Override
            @NotNull
            public String toPrefix() {
                return "(namespace import) ";
            }
        }
        ,
        EXPORT{

            @Override
            @NotNull
            public String toPrefix() {
                return "(export element) ";
            }
        };


        @NotNull
        public abstract String toPrefix();

        @NotNull
        public String toJSDocPrefix() {
            return "";
        }
    }
}

