/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSAddRequireExecutor;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExportedCandidatesProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.ultimate.PluginVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHandlersFactory {
    public static final LanguageExtension<JSHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.handlersFactory");
    private static final JSHandlersFactory DEFAULT_INSTANCE = new JSHandlersFactory();

    public JSHandlersFactory() {
        PluginVerifier.verifyUltimatePlugin();
    }

    @NotNull
    public static JSHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        return JSHandlersFactory.forLanguage(dialect);
    }

    @NotNull
    public static JSHandlersFactory forLanguage(@Nullable Language dialect) {
        JSHandlersFactory dialectSpecificFactory = dialect != null ? (JSHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSHandlersFactory jSHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSHandlersFactory == null) {
            JSHandlersFactory.$$$reportNull$$$0(0);
        }
        return jSHandlersFactory;
    }

    @NotNull
    public JSAddImportExecutor createAddImportExecutor(@Nullable Editor editor, @NotNull PsiElement place) {
        if (place == null) {
            JSHandlersFactory.$$$reportNull$$$0(1);
        }
        return ES6ExportedCandidatesProvider.isES6ImportAllowed(place) ? new ES6AddImportExecutor(editor, place) : new JSAddRequireExecutor(editor, place);
    }

    @NotNull
    public JSCompletionKeywordsContributor newCompletionKeywordsContributor() {
        return new JSCompletionKeywordsContributor();
    }

    @NotNull
    public Class<? extends JSCodeStyleSettings> getCodeStyleSettingsClass() {
        return JSCodeStyleSettings.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSHandlersFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSHandlersFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAddImportExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

