/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeCommandLineOwner;
import com.intellij.javascript.nodejs.execution.NodeBaseRunProfileState;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunProfileState
implements NodeBaseRunProfileState,
NodeCommandLineOwner {
    private final NpmRunSettings myRunSettings;
    private final NodeJsInterpreter myNodeInterpreter;
    private final ExecutionEnvironment myEnvironment;

    public NpmRunProfileState(@NotNull NpmRunSettings runSettings, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runSettings == null) {
            NpmRunProfileState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            NpmRunProfileState.$$$reportNull$$$0(1);
        }
        this.myNodeInterpreter = runSettings.getInterpreterRef().resolveNotNull(environment.getProject());
        this.myRunSettings = runSettings;
        this.myEnvironment = environment;
    }

    @NotNull
    private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable File cwd) {
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(2);
        }
        ConsoleView console = NodeCommandLineUtil.createConsole(processHandler, this.myEnvironment.getProject(), false);
        console.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = console;
        if (consoleView == null) {
            NpmRunProfileState.$$$reportNull$$$0(3);
        }
        return consoleView;
    }

    @Override
    @NotNull
    public ProcessHandler startProcess(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        if (NodeTargetRun.shouldExecuteRunConfigurationsUsingTargetsApi(this.myNodeInterpreter)) {
            NodeTargetRun targetRun = new NodeTargetRun(this.myNodeInterpreter, this.myEnvironment.getProject(), configurator, NodeTargetRun.createOptions(ThreeState.UNSURE, List.of()));
            NpmRunProfileState.configureCommandLine(targetRun, this.myRunSettings.getNodeOptions(), this.myRunSettings.getPackageManagerPackageRef(), this.myRunSettings.getPackageJsonSystemDependentPath(), this.getExecutionCommand(), this.myRunSettings.getScriptNames(), this.myRunSettings.getArguments(), this.myRunSettings.getEnvData());
            ProcessHandler processHandler = targetRun.startProcess();
            if (processHandler == null) {
                NpmRunProfileState.$$$reportNull$$$0(4);
            }
            return processHandler;
        }
        return this.startProcessOld(configurator);
    }

    @Override
    @NotNull
    public ExecutionResult createExecutionResult(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(5);
        }
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ConsoleView console = this.createConsole(processHandler, new File(this.myRunSettings.getPackageJsonSystemDependentPath()).getParentFile());
        console.attachToProcess(processHandler);
        this.foldCommandLine(console, processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    private ProcessHandler startProcessOld(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine(true);
        NodeCommandLineUtil.configureCommandLine(commandLine, configurator, this.myNodeInterpreter, (ThrowableConsumer<? super Boolean, ? extends ExecutionException>)((ThrowableConsumer)debugMode -> NpmRunProfileState.configureCommandLine(commandLine, this.myNodeInterpreter, this.myRunSettings.getNodeOptions(), this.myRunSettings.getPackageManagerPackageRef(), this.myRunSettings.getPackageJsonSystemDependentPath(), this.getExecutionCommand(), this.myRunSettings.getScriptNames(), this.myRunSettings.getArguments(), this.myRunSettings.getEnvData(), this.myEnvironment.getProject())));
        OSProcessHandler oSProcessHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
        if (oSProcessHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(6);
        }
        return oSProcessHandler;
    }

    public static void configureCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter nodeInterpreter, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @NotNull Project project) throws ExecutionException {
        if (commandLine == null) {
            NpmRunProfileState.$$$reportNull$$$0(7);
        }
        if (nodeInterpreter == null) {
            NpmRunProfileState.$$$reportNull$$$0(8);
        }
        if (nodeOptions == null) {
            NpmRunProfileState.$$$reportNull$$$0(9);
        }
        if (npmPackageRef == null) {
            NpmRunProfileState.$$$reportNull$$$0(10);
        }
        if (packageJsonPath == null) {
            NpmRunProfileState.$$$reportNull$$$0(11);
        }
        if (command == null) {
            NpmRunProfileState.$$$reportNull$$$0(12);
        }
        if (scriptNames == null) {
            NpmRunProfileState.$$$reportNull$$$0(13);
        }
        if (scriptArguments == null) {
            NpmRunProfileState.$$$reportNull$$$0(14);
        }
        if (envData == null) {
            NpmRunProfileState.$$$reportNull$$$0(15);
        }
        if (project == null) {
            NpmRunProfileState.$$$reportNull$$$0(16);
        }
        commandLine.withCharset(StandardCharsets.UTF_8);
        File workingDirectory = new File(packageJsonPath).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        envData.configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.addParameters(ParametersListUtil.parse((String)nodeOptions.trim()));
        NodePackage pkg = NpmUtil.resolveRef(npmPackageRef, project, nodeInterpreter);
        if (pkg == null) {
            throw new ExecutionException(JavaScriptBundle.message("npm.dialog.message.cannot.resolve.package.manager", npmPackageRef.getIdentifier()));
        }
        commandLine.addParameter(NpmUtil.getValidNpmCliJsFilePath(pkg));
        boolean yarn = NpmUtil.isYarnAlikePackage(pkg);
        if (command == NpmCommand.PUBLISH && yarn) {
            commandLine.addParameters(new String[]{"npm", "publish"});
        } else {
            commandLine.addParameter(command.getCliOption(yarn));
        }
        if (command == NpmCommand.RUN_SCRIPT) {
            commandLine.addParameters(scriptNames);
        }
        if ((command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST || command == NpmCommand.INSTALL || command == NpmCommand.UPDATE) && pkg.getName().equals("npm")) {
            commandLine.addParameter("--scripts-prepend-node-path=auto");
        }
        commandLine.addParameters(ProgramParametersConfigurator.expandMacrosAndParseParameters((String)scriptArguments));
    }

    @NotNull
    private NpmCommand getExecutionCommand() {
        List<String> scripts;
        if (this.myRunSettings.getCommand() == NpmCommand.RUN_SCRIPT && (scripts = this.myRunSettings.getScriptNames()).size() == 1 && "test".equals(ContainerUtil.getFirstItem(scripts))) {
            NpmCommand npmCommand = NpmCommand.TEST;
            if (npmCommand == null) {
                NpmRunProfileState.$$$reportNull$$$0(17);
            }
            return npmCommand;
        }
        NpmCommand npmCommand = this.myRunSettings.getCommand();
        if (npmCommand == null) {
            NpmRunProfileState.$$$reportNull$$$0(18);
        }
        return npmCommand;
    }

    public static void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData) throws ExecutionException {
        if (targetRun == null) {
            NpmRunProfileState.$$$reportNull$$$0(19);
        }
        if (nodeOptions == null) {
            NpmRunProfileState.$$$reportNull$$$0(20);
        }
        if (npmPackageRef == null) {
            NpmRunProfileState.$$$reportNull$$$0(21);
        }
        if (packageJsonPath == null) {
            NpmRunProfileState.$$$reportNull$$$0(22);
        }
        if (command == null) {
            NpmRunProfileState.$$$reportNull$$$0(23);
        }
        if (scriptNames == null) {
            NpmRunProfileState.$$$reportNull$$$0(24);
        }
        if (scriptArguments == null) {
            NpmRunProfileState.$$$reportNull$$$0(25);
        }
        if (envData == null) {
            NpmRunProfileState.$$$reportNull$$$0(26);
        }
        targetRun.setEnableWrappingWithYarnPnpNode(false);
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.setCharset(StandardCharsets.UTF_8);
        File workingDirectory = new File(packageJsonPath).getParentFile();
        commandLine.setWorkingDirectory(targetRun.path(workingDirectory.getAbsolutePath()));
        targetRun.configureEnvironment(envData);
        commandLine.addParameters(ParametersListUtil.parse((String)nodeOptions.trim()));
        NodePackage pkg = NpmUtil.resolveRef(npmPackageRef, targetRun.getProject(), targetRun.getInterpreter());
        if (pkg == null) {
            throw new ExecutionException(JavaScriptBundle.message("npm.dialog.message.cannot.resolve.package.manager", npmPackageRef.getIdentifier()));
        }
        commandLine.addParameter(NpmUtil.getValidNpmCliJsFilePath(pkg, targetRun.getInterpreter()));
        boolean yarn = NpmUtil.isYarnAlikePackage(pkg);
        if (command == NpmCommand.PUBLISH && yarn) {
            commandLine.addParameters(new String[]{"npm", "publish"});
        } else {
            commandLine.addParameter(command.getCliOption(yarn));
        }
        if (command == NpmCommand.RUN_SCRIPT) {
            commandLine.addParameters(scriptNames);
        }
        if ((command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST || command == NpmCommand.INSTALL || command == NpmCommand.UPDATE) && pkg.getName().equals("npm")) {
            commandLine.addParameter("--scripts-prepend-node-path=auto");
        }
        commandLine.addParameters(ProgramParametersConfigurator.expandMacrosAndParseParameters((String)scriptArguments));
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        List arguments;
        if (consoleView == null) {
            NpmRunProfileState.$$$reportNull$$$0(27);
        }
        if (processHandler == null) {
            NpmRunProfileState.$$$reportNull$$$0(28);
        }
        NodePackageRef npmRef = NpmUtil.DESCRIPTOR.dereferenceIfProjectRef(this.myEnvironment.getProject(), this.myRunSettings.getPackageManagerPackageRef());
        boolean yarn = NpmUtil.isYarnAlikePackageRef(npmRef);
        ConsoleCommandLineFolder folder = new ConsoleCommandLineFolder(NpmManager.getNpmPackagePresentableName(npmRef));
        NpmCommand command = this.getExecutionCommand();
        folder.addPlaceholderText(command.getCliOption(yarn));
        if (command == NpmCommand.RUN_SCRIPT) {
            folder.addPlaceholderTexts(this.myRunSettings.getScriptNames());
        }
        if (!(arguments = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)this.myRunSettings.getArguments().trim())).isEmpty()) {
            folder.addPlaceholderText(ParametersListUtil.join((List)arguments));
        }
        folder.foldCommandLine(consoleView, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 5: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeInterpreter";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackageRef";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptNames";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptArguments";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessOld";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionResult";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

