/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.bower.BowerCommandRun;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BowerCommandLineUtil {
    private static final Logger LOG = Logger.getInstance(BowerCommandLineUtil.class);
    private static final NullableLazyValue<File> TEMP_DIR = NullableLazyValue.createValue(() -> {
        try {
            return FileUtil.createTempDirectory((String)"jetbrains-intellij-bower", null);
        }
        catch (IOException e) {
            LOG.warn("Cannot create temp dir", (Throwable)e);
            return null;
        }
    });

    private BowerCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput runBowerCommand(@Nullable ProgressIndicator indicator, @NotNull BowerSettings settings, String ... commands) throws ExecutionException {
        if (settings == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(0);
        }
        BowerCommandRun bowerCommandRun = BowerCommandLineUtil.startBowerCommand(settings, commands);
        ProcessOutput processOutput = bowerCommandRun.captureOutput(indicator, TimeUnit.MINUTES.toMillis(10L));
        if (processOutput == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @NotNull
    public static BowerCommandRun startBowerCommand(@NotNull BowerSettings settings, String ... commands) throws ExecutionException {
        if (settings == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(2);
        }
        GeneralCommandLine commandLine = BowerCommandLineUtil.createCommandLine(settings);
        commandLine.addParameters(commands);
        LOG.info("Running bower command: " + commandLine.getCommandLineString());
        return new BowerCommandRun((OSProcessHandler)new KillableColoredProcessHandler(commandLine));
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull BowerSettings settings) throws ExecutionException {
        if (settings == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(3);
        }
        NodeJsInterpreter interpreter = settings.getInterpreter();
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        File workingDir = BowerCommandLineUtil.getWorkingDir(settings);
        if (workingDir != null) {
            commandLine.setWorkDirectory(workingDir);
        } else {
            LOG.info("Working directory not specified");
        }
        File mainBowerJsFile = BowerCommandLineUtil.getMainBowerJsFile(settings.getBowerPackage());
        commandLine.setExePath(localInterpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(mainBowerJsFile.getAbsolutePath());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    private static File getMainBowerJsFile(@NotNull NodePackage bowerPackage) throws ExecutionException {
        String errorMessage;
        if (bowerPackage == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(5);
        }
        if ((errorMessage = bowerPackage.getErrorMessage("bower")) != null) {
            throw new ExecutionException(errorMessage);
        }
        String path2 = "bin" + File.separator + "bower";
        File file2 = new File(bowerPackage.getSystemDependentPath(), path2);
        if (!file2.isFile()) {
            throw new ExecutionException(JavaScriptBundle.message("bower.dialog.message.specify.package", path2));
        }
        File file3 = file2;
        if (file3 == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(6);
        }
        return file3;
    }

    @Nullable
    private static File getWorkingDir(@NotNull BowerSettings settings) {
        File bowerConfigFile;
        if (settings == null) {
            BowerCommandLineUtil.$$$reportNull$$$0(7);
        }
        if ((bowerConfigFile = new File(settings.getBowerJsonPath())).isFile()) {
            return bowerConfigFile.getParentFile();
        }
        return (File)TEMP_DIR.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerCommandLineUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bowerPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerCommandLineUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "runBowerCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainBowerJsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runBowerCommand";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startBowerCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMainBowerJsFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

