/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFileElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JavascriptParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        return new JSFlexAdapter(DialectOptionHolder.ECMA_6);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        JSFileElementType jSFileElementType = JSFileElementTypes.FILE;
        if (jSFileElementType == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(0);
        }
        return jSFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSTokenTypes.COMMENTS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JSTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new PsiParser(){

            @NotNull
            public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (builder == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavascriptParserDefinition.this.createJSParser(builder).parseJS(root);
                ASTNode aSTNode = builder.getTreeBuilt();
                if (aSTNode == null) {
                    1.$$$reportNull$$$0(2);
                }
                return aSTNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/JavascriptParserDefinition$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/JavascriptParserDefinition$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parse";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "parse";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public JavaScriptParser<?, ?, ?, ?> createJSParser(@NotNull PsiBuilder builder) {
        Object parser2;
        Language language;
        if (builder == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(4);
        }
        if ((language = this.getFileNodeType().getLanguage()) instanceof JSLanguageDialect && (parser2 = ((JSLanguageDialect)language).createParser(builder)) instanceof JavaScriptParser) {
            JavaScriptParser javaScriptParser = (JavaScriptParser)parser2;
            if (javaScriptParser == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(5);
            }
            return javaScriptParser;
        }
        return new JSXParser(JavaScriptSupportLoader.ECMA_SCRIPT_6, builder);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(6);
        }
        return new JSFileImpl(viewProvider, this.getFileNodeType().getLanguage());
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left instanceof PsiWhiteSpace) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        if (left.getElementType() == JSTokenTypes.BACKQUOTE) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(8);
            }
            return spaceRequirements;
        }
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        if (spaceRequirements == null) {
            JavascriptParserDefinition.$$$reportNull$$$0(9);
        }
        return spaceRequirements;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        Object element;
        IElementType type = node.getElementType();
        if (JSElementTypes.XML_LITERAL_EXPRESSION == type) {
            if (!(node instanceof PsiElement)) {
                throw new AssertionError((Object)("Literal must be PsiElement but was: " + node + " (" + node.getClass() + ")"));
            }
            PsiElement psiElement = (PsiElement)node;
            if (psiElement == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        if (type instanceof PsiGenerator && (element = ((PsiGenerator)type).construct(node)) != null) {
            Object t = element;
            if (t == null) {
                JavascriptParserDefinition.$$$reportNull$$$0(11);
            }
            return t;
        }
        if (type == JSTokenTypes.DOC_COMMENT) {
            return new JSDocCommentImpl(node);
        }
        return new ASTWrapperPsiElement(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JavascriptParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JavascriptParserDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSParser";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createJSParser";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

