/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.impl.JSNodeModulesHandlerScope;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportScope
extends JSNodeModulesHandlerScope {
    @NotNull
    private final ProjectFileIndex myIndex;
    @NotNull
    private final Set<VirtualFile> myPredefinedLibraryFiles;
    @NotNull
    private final VirtualFile myDirectoryOfContext;
    @Nullable
    private final VirtualFile myGlobalNodeModules;
    @NotNull
    private final PsiManager myPsiManager;
    @Nullable
    private final VirtualFile myAutoInstalledTyping;

    public JSImportScope(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull GlobalSearchScope baseScope, @Nullable JSModuleStatusOwner.ModuleStatus status) {
        if (project == null) {
            JSImportScope.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            JSImportScope.$$$reportNull$$$0(1);
        }
        if (baseScope == null) {
            JSImportScope.$$$reportNull$$$0(2);
        }
        super(project, contextFile, baseScope, status);
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myIndex = ProjectFileIndex.getInstance((Project)project);
        HashSet<VirtualFile> predefinedLibraryFiles = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles());
        predefinedLibraryFiles.addAll(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        this.myPredefinedLibraryFiles = predefinedLibraryFiles;
        this.myDirectoryOfContext = contextFile.getParent();
        VirtualFile globalCandidate = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        this.myGlobalNodeModules = globalCandidate == null || !globalCandidate.isValid() ? null : globalCandidate.getParent();
        String dir = TypeScriptExternalDefinitionsRegistry.Companion.getRootDefinitionsDir();
        this.myAutoInstalledTyping = dir != null ? contextFile.getFileSystem().findFileByPath(dir) : null;
    }

    @Override
    protected boolean isAcceptableProjectFile(@NotNull VirtualFile toCheck) {
        if (toCheck == null) {
            JSImportScope.$$$reportNull$$$0(3);
        }
        return super.isAcceptableProjectFile(toCheck) && !this.myIndex.isInLibrary(toCheck) && !this.myPredefinedLibraryFiles.contains(toCheck);
    }

    @Override
    protected boolean isAcceptableNodeModulesFile(@NotNull VirtualFile toCheck, @NotNull NodeModuleUtil.NodeModuleStructure structure) {
        Project project;
        if (toCheck == null) {
            JSImportScope.$$$reportNull$$$0(4);
        }
        if (structure == null) {
            JSImportScope.$$$reportNull$$$0(5);
        }
        if ((project = this.getProject()) != null && NodeCoreLibraryManager.getInstance(project).isCoreModuleLibraryFile(toCheck)) {
            return true;
        }
        if (!super.isAcceptableNodeModulesFile(toCheck, structure) || !this.isAcceptableModuleStatus(toCheck, this.myPsiManager)) {
            return false;
        }
        if (this.myAutoInstalledTyping != null && VfsUtilCore.isAncestor((VirtualFile)this.myAutoInstalledTyping, (VirtualFile)toCheck, (boolean)true)) {
            return true;
        }
        VirtualFile nodeModules = structure.nodeModules;
        if (this.myGlobalNodeModules != null && nodeModules.equals(this.myGlobalNodeModules)) {
            return true;
        }
        VirtualFile parent = JSImportScope.findTopNodeModules(nodeModules).getParent();
        if (parent == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)this.myDirectoryOfContext, (boolean)false);
    }

    @NotNull
    private static VirtualFile findTopNodeModules(@NotNull VirtualFile nodeModules) {
        if (nodeModules == null) {
            JSImportScope.$$$reportNull$$$0(6);
        }
        for (VirtualFile parent = nodeModules; parent != null; parent = parent.getParent()) {
            if (!StringUtil.equals((CharSequence)parent.getNameSequence(), (CharSequence)"node_modules")) continue;
            nodeModules = parent;
        }
        VirtualFile virtualFile = nodeModules;
        if (virtualFile == null) {
            JSImportScope.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    private boolean isAcceptableModuleStatus(@NotNull VirtualFile file2, @NotNull PsiManager manager2) {
        PsiFile psiFile;
        if (file2 == null) {
            JSImportScope.$$$reportNull$$$0(8);
        }
        if (manager2 == null) {
            JSImportScope.$$$reportNull$$$0(9);
        }
        if (!((psiFile = manager2.findFile(file2)) instanceof JSModuleStatusOwner)) {
            return false;
        }
        if (this.myStatus == null) {
            return ((JSModuleStatusOwner)psiFile).isCommonJSModule();
        }
        JSModuleStatusOwner.ModuleStatus currentStatus = ((JSModuleStatusOwner)psiFile).getModuleStatus();
        return this.myStatus == JSModuleStatusOwner.ModuleStatus.ES6 ? TypeScriptUtil.isDefinitionFile(file2) || this.myStatus == currentStatus : this.myStatus == currentStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSImportScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopNodeModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableProjectFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTopNodeModules";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableModuleStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

