/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSAddRequireExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportedElementDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ImportPsiUtil {
    public static final String DEFAULT = "default";
    public static final TokenSet ES6_IMPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION});
    public static final TokenSet IMPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.IMPORT_STATEMENT, ES6ElementTypes.IMPORT_DECLARATION});
    public static final CreateImportExportInfo BARE_INFO = new CreateImportExportInfo("", "", ImportExportType.BARE);
    private static final Logger LOGGER = Logger.getInstance(ES6ImportPsiUtil.class);
    public static final Comparator<String> IMPORT_FROM_PART_COMPARATOR = (fromClauseText1, fromClauseText2) -> {
        if (fromClauseText1 != null) {
            if (fromClauseText2 == null) {
                return 1;
            }
            if (!fromClauseText1.startsWith(".") && fromClauseText2.startsWith(".")) {
                return -1;
            }
            if (fromClauseText1.startsWith(".") && !fromClauseText2.startsWith(".")) {
                return 1;
            }
        }
        return StringUtil.compare((String)fromClauseText1, (String)fromClauseText2, (boolean)true);
    };

    @Nullable
    public static ES6ImportDeclaration findExistingES6ImportByFromText(@NotNull PsiElement[] declarations, @NotNull JSImportDescriptor importDescriptor) {
        String unquotedModule;
        if (importDescriptor == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(0);
        }
        if (declarations == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(1);
        }
        if (!(unquotedModule = importDescriptor.getModuleName()).isEmpty()) {
            for (PsiElement declaration : declarations) {
                String fromText;
                if (!(declaration instanceof ES6ImportDeclaration) || !unquotedModule.equals(fromText = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportDeclaration)declaration)) || !ES6ImportPsiUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration, importDescriptor)) continue;
                return (ES6ImportDeclaration)declaration;
            }
        }
        return null;
    }

    public static boolean isAcceptableAsExistingImport(@NotNull ES6ImportDeclaration declaration, @NotNull JSImportDescriptor info) {
        boolean infoTypeContext;
        ES6ImportExportDeclaration.ImportExportPrefixKind kind;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(2);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(3);
        }
        if ((kind = declaration.getImportExportPrefixKind()) == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPEOF) {
            return false;
        }
        JSImportExportType type = info.getImportType();
        if (type.isBare()) {
            return true;
        }
        boolean hasTypeKeyword = kind == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE;
        ES6ImportExportDeclaration.ImportExportPrefixKind prefixKind = info.getImportExportPrefixKind();
        boolean bl = infoTypeContext = prefixKind == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE || prefixKind == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE_OR_SIMPLE;
        if (infoTypeContext != hasTypeKeyword) {
            if (!DialectDetector.isTypeScript((PsiElement)declaration)) {
                return false;
            }
            if (hasTypeKeyword) {
                return false;
            }
        }
        if (declaration.getImportModuleText() != null) {
            return false;
        }
        if (declaration.getImportSpecifiers().length > 0) {
            return true;
        }
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        return bindings.length == 0 || bindings.length == 1 && !bindings[0].isNamespaceImport();
    }

    public static boolean tryToAddImportToExistingDeclaration(@NotNull ES6ImportDeclaration declaration, @NotNull JSImportedElementDescriptor info) {
        ASTNode node;
        ASTNode typeChild;
        JSImportExportType type;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(4);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(5);
        }
        if ((type = info.getImportType()).isBare()) {
            return true;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
            return false;
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = info.getImportExportPrefixKind();
        if (declaration.getImportExportPrefixKind() == ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE && kind != ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE && kind != ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT_TYPE_OR_SIMPLE && (typeChild = (node = declaration.getNode()).findChildByType(JSTokenTypes.TYPE_KEYWORD)) != null) {
            declaration = (ES6ImportDeclaration)WriteCommandAction.writeCommandAction((Project)declaration.getProject(), (PsiFile[])new PsiFile[]{declaration.getContainingFile()}).withName(JavaScriptBundle.message("remove.type.prefix", new Object[0])).compute(() -> {
                node.removeChild(typeChild);
                return (ES6ImportDeclaration)node.getPsi();
            });
        }
        if (type.isDefault()) {
            ES6ImportedBinding[] bindings = declaration.getImportedBindings();
            String importedBindingName = info.getImportedName();
            if (bindings.length == 0) {
                return ES6ImportPsiUtil.insertBinding(declaration, importedBindingName) != null;
            }
            if (importedBindingName != null) {
                for (ES6ImportedBinding binding : bindings) {
                    if (!importedBindingName.equals(binding.getName())) continue;
                    return true;
                }
            }
        }
        if (type.isSpecifier()) {
            return ES6ImportPsiUtil.insertImportSpecifier(declaration, info) != null;
        }
        return false;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findPlaceByModuleName(@NotNull PsiElement scope, @NotNull String moduleName) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(6);
        }
        if (moduleName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(7);
        }
        if (!JSCodeStyleSettings.getSettings((PsiElement)scope).IMPORT_SORT_MODULE_NAME) {
            return ES6ImportPsiUtil.findPlaceForImport(scope);
        }
        List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations(scope);
        if (declarations.isEmpty()) {
            return ES6ImportPsiUtil.findPlaceForImport(scope);
        }
        Function function2 = el -> ES6ImportPsiUtil.getUnquotedFromClauseText(el);
        int position = ES6ImportPsiUtil.getInsertAfterPosition(declarations, function2, IMPORT_FROM_PART_COMPARATOR, moduleName);
        if (position == -1) {
            List<PsiElement> comments;
            ES6ImportDeclaration importDeclaration;
            ES6ImportDeclaration insertBefore = importDeclaration = declarations.get(0);
            Document document2 = PsiDocumentManager.getInstance((Project)scope.getProject()).getDocument(importDeclaration.getContainingFile());
            if (document2 != null && (comments = JSOptimizeImportUtil.getPrevComments(document2, (PsiElement)importDeclaration)).size() > 0) {
                insertBefore = comments.get(0);
            }
            Pair pair = Pair.create((Object)false, (Object)insertBefore);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)true, (Object)((PsiElement)declarations.get(position)));
        if (pair == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(10);
        }
        return ES6ImportPsiUtil.findAnchorToInsert(scope, IMPORT_ELEMENT_TYPES, true);
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findAnchorToInsert(@NotNull PsiElement scope, TokenSet elementTypesToSkip, boolean first) {
        PsiElement afterWhitespaces;
        ASTNode lBrace;
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(11);
        }
        PsiElement startElement = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            startElement = lBrace.getPsi().getNextSibling();
        }
        if (startElement == null) {
            Pair pair = Pair.create((Object)true, null);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(12);
            }
            return pair;
        }
        PsiElement currentChild = startElement;
        PsiElement psiElement = afterWhitespaces = scope instanceof JSFile && currentChild instanceof PsiWhiteSpace ? PsiTreeUtil.skipWhitespacesForward((PsiElement)startElement) : null;
        if (afterWhitespaces != null) {
            currentChild = afterWhitespaces;
        }
        PsiElement lastElement = null;
        while (currentChild != null) {
            if (elementTypesToSkip.contains(currentChild.getNode().getElementType())) {
                lastElement = currentChild;
            } else if (lastElement == null && ES6ImportPsiUtil.shouldInsertImportBeforeElement(currentChild)) break;
            currentChild = currentChild.getNextSibling();
        }
        if (afterWhitespaces != null && afterWhitespaces == currentChild) {
            Pair pair = Pair.create((Object)false, (Object)startElement);
            if (pair == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(13);
            }
            return pair;
        }
        PsiElement place = lastElement;
        if (place == null) {
            if (!first) {
                ASTNode rBrace;
                place = scope.getLastChild();
                if (scope instanceof TypeScriptModule && (rBrace = scope.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
                    place = rBrace.getPsi().getPrevSibling();
                }
                Pair pair = Pair.create((Object)true, (Object)place);
                if (pair == null) {
                    ES6ImportPsiUtil.$$$reportNull$$$0(14);
                }
                return pair;
            }
            place = currentChild;
        }
        Pair pair = Pair.create((Object)(lastElement != null ? 1 : 0), (Object)place);
        if (pair == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(15);
        }
        return pair;
    }

    private static boolean shouldInsertImportBeforeElement(@Nullable PsiElement currentChild) {
        return !(currentChild instanceof PsiWhiteSpace) && !JSPsiImplUtils.isCompilerDirectiveStatement(currentChild) && !(currentChild instanceof PsiComment);
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6Import(@NotNull PsiElement placeModule, @NotNull JSImportDescriptor importDescriptor) {
        PsiElement[] declarations;
        if (placeModule == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(16);
        }
        if (importDescriptor == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(17);
        }
        if ((declarations = JSResolveUtil.getStubbedChildren(placeModule, ES6_IMPORT_DECLARATION)).length == 0) {
            return null;
        }
        ES6ImportDeclaration result2 = ES6ImportPsiUtil.findExistingES6ImportByFromText(declarations, importDescriptor);
        if (result2 != null) {
            return result2;
        }
        return ES6ImportPsiUtil.findExistingES6ImportByFromModules(declarations, importDescriptor);
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6ImportByFromModules(PsiElement @NotNull [] declarations, @NotNull JSImportDescriptor descriptor2) {
        JSModuleDescriptor moduleDescriptor;
        PsiElement module;
        if (descriptor2 == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(18);
        }
        if (declarations == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(19);
        }
        if ((module = (moduleDescriptor = descriptor2.getModuleDescriptor()).getModule()) == null) {
            return null;
        }
        for (PsiElement declaration : declarations) {
            Collection<PsiElement> resolvedElements;
            ES6ImportDeclaration es6Import;
            ES6FromClause clause;
            if (!(declaration instanceof ES6ImportDeclaration) || (clause = (es6Import = (ES6ImportDeclaration)declaration).getFromClause()) == null || !(resolvedElements = clause.resolveReferencedElements()).contains(module) || !ES6ImportPsiUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration, descriptor2)) continue;
            return es6Import;
        }
        return null;
    }

    public static String getExportedElementName(@NotNull JSElement element) {
        PsiElement parent;
        String name;
        if (element == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(20);
        }
        if ((name = element.getName()) == null && element instanceof JSExpression && (parent = element.getContext()) instanceof JSExportAssignment) {
            element = (JSElement)parent;
        }
        if (element instanceof JSExportAssignment) {
            String fileName = element.getContainingFile().getName();
            return JSFileReference.getFileNameWithoutExtension(fileName, JSFileReference.IMPLICIT_EXTENSIONS);
        }
        if (element instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)element).getDeclaredName();
        }
        return name;
    }

    @NotNull
    public static String getQuote(@NotNull PsiElement context, @Nullable ASTNode stringLiteralNode) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(21);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        if (settings.FORCE_QUOTE_STYlE || stringLiteralNode == null) {
            String string = JSCodeStyleSettings.getQuote(context);
            if (string == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        String text = stringLiteralNode.getText();
        String string = StringUtil.isEmpty((String)text) ? "\"" : String.valueOf(text.charAt(0));
        if (string == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static boolean isFlowTypeDefinition(@Nullable PsiElement current) {
        return current != null && DialectDetector.isFlow(current) && current instanceof TypeScriptCompileTimeType;
    }

    @NotNull
    public static String wrapWithQuotesFromSettings(String externalModuleName, @NotNull PsiElement context) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(24);
        }
        String quote = JSCodeStyleSettings.getQuote(context);
        Object object = externalModuleName = quote + (String)externalModuleName + quote;
        if (object == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(25);
        }
        return object;
    }

    @NotNull
    public static List<ES6ImportDeclaration> getImportDeclarations(@NotNull PsiElement scope) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(26);
        }
        List list2 = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)scope, ES6ImportDeclaration.class);
        if (list2 == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    public static ES6ExistingImports getExistingImports(@NotNull PsiElement scope, @NotNull String fromReferenceText) {
        if (scope == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(28);
        }
        if (fromReferenceText == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(29);
        }
        List<ES6ImportDeclaration> elements = ES6ImportPsiUtil.getImportDeclarations(scope);
        ArrayList<ES6ImportDeclaration> result2 = new ArrayList<ES6ImportDeclaration>(elements.size());
        for (ES6ImportDeclaration declaration : elements) {
            String quotedFromClauseText = ES6ImportPsiUtil.getFromClauseText(declaration);
            if (quotedFromClauseText == null || !fromReferenceText.equals(JSStringUtil.unquoteStringLiteralValue(quotedFromClauseText))) continue;
            result2.add(declaration);
        }
        return new ES6ExistingImports(result2);
    }

    @Nullable
    public static String getFromClauseText(@Nullable ES6ImportExportDeclaration declaration) {
        ES6FromClause clause;
        ES6FromClause eS6FromClause = clause = declaration == null ? null : declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        return StringUtil.nullize((String)clause.getReferenceText());
    }

    @Nullable
    public static String getUnquotedFromClauseOrModuleText(@NotNull ES6ImportExportDeclaration declaration) {
        String text;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(30);
        }
        if ((text = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration)) != null) {
            return text;
        }
        String moduleText = declaration instanceof ES6ImportDeclaration ? ((ES6ImportDeclaration)declaration).getImportModuleText() : null;
        return moduleText == null ? null : JSStringUtil.unquoteStringLiteralValue(moduleText);
    }

    @Nullable
    public static String getUnquotedFromClauseText(@NotNull ES6ImportExportDeclaration declaration) {
        String fromClauseText;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(31);
        }
        return (fromClauseText = ES6ImportPsiUtil.getFromClauseText(declaration)) == null ? null : JSStringUtil.unquoteStringLiteralValue(fromClauseText);
    }

    @Nullable
    public static ES6ImportedBinding insertBinding(@NotNull ES6ImportDeclaration declaration, String name) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(32);
        }
        assert (declaration.getImportedBindings().length == 0);
        ASTNode originalDeclarationNode = declaration.getNode();
        ASTNode importKeyword = originalDeclarationNode.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
        assert (importKeyword != null);
        boolean needComma = declaration.getImportSpecifiers().length > 0;
        ES6ImportDeclaration tempDeclaration = JSPsiElementFactory.createJSSourceElement("import " + name + (needComma ? ", {}" : "") + " from ''", (PsiElement)declaration, ES6ImportDeclaration.class);
        ES6ImportedBinding binding = (ES6ImportedBinding)ArrayUtil.getFirstElement((Object[])tempDeclaration.getImportedBindings());
        assert (binding != null);
        Project project = declaration.getProject();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{declaration.getContainingFile()}).withName(JavaScriptBundle.message("add.import.binding.to.import", new Object[0])).run(() -> {
            if (needComma) {
                ES6NamedImports imports = tempDeclaration.getNamedImports();
                assert (imports != null);
                declaration.addRangeAfter((PsiElement)binding, imports.getPrevSibling(), importKeyword.getPsi());
            } else {
                declaration.addAfter((PsiElement)binding, importKeyword.getPsi());
            }
        });
        return (ES6ImportedBinding)ArrayUtil.getFirstElement((Object[])declaration.getImportedBindings());
    }

    @Nullable
    public static ES6ImportSpecifier insertImportSpecifier(@NotNull ES6ImportDeclaration declaration, @NotNull CreateImportExportInfo info) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(33);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(34);
        }
        return ES6ImportPsiUtil.insertImportSpecifier(declaration, (JSImportedElementDescriptor)info);
    }

    @Nullable
    public static ES6ImportSpecifier insertImportSpecifier(@NotNull ES6ImportDeclaration declaration, @NotNull JSImportedElementDescriptor info) {
        ES6ImportSpecifier specifier;
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(35);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(36);
        }
        Project project = declaration.getProject();
        String importedName = info.getImportedName();
        String exportedName = info.getExportedName();
        if (importedName == null && exportedName == null) {
            return null;
        }
        String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
        String actualImportedName = (String)ObjectUtils.coalesce((Object)importedName, (Object)exportedName);
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        if (specifiers.length > 0 && (specifier = ES6ImportPsiUtil.findImportSpecifierByReferenceName(declaration, actualImportedName)) != null) {
            LOGGER.warn("Import specifier with name '" + actualImportedName + "' already exists");
            return specifier;
        }
        InsertPlaceInDeclaration insertPlace = ES6ImportPsiUtil.getSpecifierInsertPlace(declaration, actualExportedName);
        if (insertPlace == null) {
            return null;
        }
        JSImportExportType type = info.getImportType();
        String importText = type.isSpecifier() ? ES6ImportPsiUtil.getImportExportPartText(info, true, JSCodeStyleSettings.getSettings((PsiElement)declaration).SPACES_WITHIN_IMPORTS) : "{default as " + actualImportedName + "}";
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(info.getPrefix() + " " + importText, (PsiElement)declaration);
        if (importNode == null) {
            return null;
        }
        PsiElement anchor = insertPlace.getAnchor();
        if (anchor == null) {
            return null;
        }
        ArrayList<PsiElement> elementsToAdd = new ArrayList<PsiElement>();
        ASTNode namedPart = importNode.findChildByType((IElementType)ES6ElementTypes.NAMED_IMPORTS);
        assert (namedPart != null);
        PsiElement host = insertPlace.host();
        if (insertPlace.hasSpecifiers()) {
            ASTNode specifier2;
            if (insertPlace.needCommaBefore()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement((PsiElement)declaration));
            }
            if (ES6ImportPsiUtil.isInvalid(specifier2 = namedPart.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER))) {
                return null;
            }
            elementsToAdd.add(specifier2.getPsi());
            if (insertPlace.needCommaAfter()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement((PsiElement)declaration));
            }
        } else {
            PsiElement namedImports = namedPart.getPsi().copy();
            if (insertPlace.needCommaBefore()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement((PsiElement)declaration));
            }
            elementsToAdd.add(namedImports);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{declaration.getContainingFile()}).withName(JavaScriptBundle.message("add.import.specifier.to.import", new Object[0])).run(() -> {
            PsiElement currentAnchor = anchor;
            for (PsiElement element : elementsToAdd) {
                currentAnchor = host.addAfter(element, currentAnchor);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat((PsiElement)declaration);
        });
        return ES6ImportPsiUtil.findImportSpecifierByReferenceName(declaration, actualImportedName);
    }

    @Nullable
    public static ES6ImportSpecifier findImportSpecifierByReferenceName(@NotNull ES6ImportDeclaration element, @NotNull String referenceName) {
        ES6ImportSpecifier[] specifiers;
        if (element == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(37);
        }
        if (referenceName == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(38);
        }
        for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
            if (!referenceName.equals(importSpecifier.getDeclaredName())) continue;
            return importSpecifier;
        }
        return null;
    }

    @Contract(value="null->true")
    private static boolean isInvalid(@Nullable ASTNode node) {
        return node == null;
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull String name, @NotNull PsiElement targetElement, @Nullable Editor editor) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(40);
        }
        if (targetElement == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(41);
        }
        boolean isDefault = targetElement instanceof JSExportAssignment || targetElement instanceof JSElementBase && ((JSElementBase)targetElement).isExportedWithDefault();
        ImportExportType importType = isDefault ? ImportExportType.DEFAULT : ImportExportType.SPECIFIER;
        ES6ImportPsiUtil.insertJSImport(contextToInsert, name, importType, targetElement, editor);
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull String name, @NotNull ImportExportType type, @NotNull PsiElement targetElementOrFile, @Nullable Editor editor) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(42);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(43);
        }
        if (type == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(44);
        }
        if (targetElementOrFile == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(45);
        }
        CreateImportExportInfo info = new CreateImportExportInfo(name, name, type, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        ES6ImportPsiUtil.insertJSImport(contextToInsert, info, targetElementOrFile, editor);
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull JSImportedElementDescriptor info, @NotNull PsiElement targetElementOrFile, @Nullable Editor editor) {
        PsiFile placeFile;
        JSImportCandidateDescriptor descriptor2;
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(46);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(47);
        }
        if (targetElementOrFile == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(48);
        }
        JSImportCandidateDescriptor jSImportCandidateDescriptor = descriptor2 = info instanceof JSImportCandidateDescriptor ? (JSImportCandidateDescriptor)info : ES6ImportPsiUtil.createDescriptor(contextToInsert, info, targetElementOrFile);
        if (descriptor2 == null) {
            return;
        }
        JSAddImportExecutor executor = descriptor2.getSourceType() == JSImportCandidate.SourceType.COMMONJS && (placeFile = contextToInsert.getContainingFile()) instanceof JSFile && ((JSModuleStatusOwner)placeFile).getModuleStatus() != JSModuleStatusOwner.ModuleStatus.ES6 ? new JSAddRequireExecutor(editor, contextToInsert) : JSHandlersFactory.forElement(contextToInsert).createAddImportExecutor(editor, contextToInsert);
        executor.createImports(descriptor2);
    }

    @Nullable
    private static JSImportCandidateDescriptor createDescriptor(@NotNull PsiElement contextToInsert, @NotNull JSImportedElementDescriptor info, @NotNull PsiElement targetElementOrFile) {
        if (contextToInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(49);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(50);
        }
        if (targetElementOrFile == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(51);
        }
        String exportedName = info.getExportedName();
        String importedName = info.getImportedName();
        String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
        String actualImportedName = (String)ObjectUtils.coalesce((Object)importedName, (Object)exportedName);
        if (actualExportedName == null) {
            return null;
        }
        PsiFile targetFile = targetElementOrFile.getContainingFile().getOriginalFile();
        if (targetFile.equals(contextToInsert.getContainingFile())) {
            return null;
        }
        JSModuleNameInfo moduleInfo = ES6CreateImportUtil.getExternalFileModuleName(targetElementOrFile, targetFile.getVirtualFile(), contextToInsert, true);
        return moduleInfo == null ? null : new JSImportCandidateDescriptor(JSImportCandidate.SourceType.ES6, moduleInfo, actualImportedName, actualExportedName, info.getImportExportPrefixKind(), info.getImportType());
    }

    @Nullable
    private static InsertPlaceInDeclaration getSpecifierInsertPlace(@NotNull ES6ImportDeclaration declaration, @NotNull String name) {
        if (declaration == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(52);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(53);
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        ES6FromClause clause = declaration.getFromClause();
        boolean hasBindings = bindings.length > 0;
        ASTNode declarationNode = declaration.getNode();
        ASTNode namedImportsNode = declarationNode.findChildByType((IElementType)ES6StubElementTypes.NAMED_IMPORTS);
        if (namedImportsNode == null) {
            PsiElement anchor;
            if (hasBindings) {
                for (ES6ImportedBinding binding : bindings) {
                    if (!binding.isNamespaceImport()) continue;
                    return null;
                }
            }
            PsiElement psiElement = anchor = clause != null ? clause.getPrevSibling() : null;
            if (anchor == null) {
                ASTNode importKeyword = declarationNode.findChildByType(JSTokenTypes.IMPORT_KEYWORD);
                anchor = importKeyword == null ? null : importKeyword.getPsi();
            }
            return ES6ImportPsiUtil.createInsertPlace(anchor, (PsiElement)declaration, hasBindings && !ES6ImportPsiUtil.hasComma(anchor), false, false);
        }
        ES6NamedImports namedImports = (ES6NamedImports)namedImportsNode.getPsi(ES6NamedImports.class);
        if (specifiers.length > 0) {
            boolean needCommaBefore;
            PsiElement anchor;
            return ES6ImportPsiUtil.createInsertPlace(anchor, (PsiElement)namedImports, needCommaBefore, !(needCommaBefore = (anchor = ES6ImportPsiUtil.getSpecifierAnchor(namedImports, specifiers, name)) instanceof ES6ImportExportSpecifier), true);
        }
        ASTNode node = namedImportsNode.findChildByType(JSTokenTypes.LBRACE);
        assert (node != null);
        PsiElement anchor = node.getPsi();
        return ES6ImportPsiUtil.createInsertPlace(anchor, (PsiElement)namedImports, false, false, true);
    }

    @Nullable
    private static PsiElement getSpecifierAnchor(@NotNull ES6NamedImports namedImports, ES6ImportSpecifier @NotNull [] specifiers, @NotNull String name) {
        boolean severalSpecifiers;
        if (namedImports == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(54);
        }
        if (name == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(55);
        }
        if (specifiers == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(56);
        }
        if (!JSCodeStyleSettings.getSettings((PsiElement)namedImports).IMPORT_SORT_MEMBERS) {
            return (PsiElement)ArrayUtil.getLastElement((Object[])specifiers);
        }
        List names = ContainerUtil.map((Object[])specifiers, JSPsiReferenceElement::getReferenceName);
        ArrayList toProcess = new ArrayList(names);
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportMemberComparator((PsiElement)namedImports);
        boolean bl = severalSpecifiers = toProcess.size() > 1;
        if (severalSpecifiers) {
            ContainerUtil.sort(toProcess, comparator);
        }
        if (severalSpecifiers && !toProcess.equals(names)) {
            return (PsiElement)ArrayUtil.getLastElement((Object[])specifiers);
        }
        int index = ES6ImportPsiUtil.getInsertAfterPosition(toProcess, el -> el, comparator, name);
        if (index == -1) {
            ASTNode lbraceNode = namedImports.getNode().findChildByType(JSTokenTypes.LBRACE);
            return lbraceNode == null ? (PsiElement)ArrayUtil.getLastElement((Object[])specifiers) : lbraceNode.getPsi();
        }
        return specifiers[index];
    }

    private static <T> int getInsertAfterPosition(Collection<T> elements, @NotNull Function<? super T, String> mapper, @NotNull Comparator<? super String> comparator, @NotNull String toInsert) {
        if (mapper == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(57);
        }
        if (comparator == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(58);
        }
        if (toInsert == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(59);
        }
        int i2 = -1;
        for (T element : elements) {
            String currentString = (String)mapper.fun(element);
            if (comparator.compare(currentString, toInsert) >= 0) {
                return i2;
            }
            ++i2;
        }
        return elements.size() - 1;
    }

    @NotNull
    private static InsertPlaceInDeclaration createInsertPlace(final @Nullable PsiElement anchor, final @NotNull PsiElement host, final boolean needCommaBefore, final boolean needCommaAfter, final boolean hasSpecifiers) {
        if (host == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(60);
        }
        return new InsertPlaceInDeclaration(){

            @Override
            @NotNull
            public PsiElement host() {
                PsiElement psiElement = host;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElement;
            }

            @Override
            @Nullable
            public PsiElement getAnchor() {
                return anchor;
            }

            @Override
            public boolean needCommaBefore() {
                return needCommaBefore;
            }

            @Override
            public boolean needCommaAfter() {
                return needCommaAfter;
            }

            @Override
            public boolean hasSpecifiers() {
                return hasSpecifiers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$1", "host"));
            }
        };
    }

    public static Comparator<String> getStringImportMemberComparator(@NotNull PsiElement context) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(61);
        }
        return (o1, o2) -> StringUtil.compare((String)o1, (String)o2, (boolean)true);
    }

    public static Comparator<String> getStringImportFromComparator() {
        return IMPORT_FROM_PART_COMPARATOR;
    }

    public static Comparator<ES6ImportSpecifier> getImportMemberComparator(@NotNull PsiElement context) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(62);
        }
        Comparator<String> stringComparator = ES6ImportPsiUtil.getStringImportMemberComparator(context);
        return (o1, o2) -> {
            String name = o1 == null ? null : o1.getReferenceName();
            String name2 = o2 == null ? null : o2.getReferenceName();
            return stringComparator.compare(name, name2);
        };
    }

    @NotNull
    public static JSSourceElement createImportOrExport(@NotNull PsiElement context, @NotNull JSImportDescriptor info) {
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(63);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(64);
        }
        String text = ES6ImportPsiUtil.createImportOrExportText(context, info, true);
        JSSourceElement jSSourceElement = JSPsiElementFactory.createJSSourceElement(text, context, JSSourceElement.class);
        if (jSSourceElement == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(65);
        }
        return jSSourceElement;
    }

    @NotNull
    public static String createImportOrExportText(@NotNull PsiElement context, @NotNull JSImportDescriptor info, boolean withSemicolon) {
        JSImportExportType type;
        if (context == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(66);
        }
        if (info == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(67);
        }
        if (!(type = info.getImportType()).isES6() && DialectDetector.isTypeScript(context)) {
            String string = TypeScriptAutoImportUtil.createTypeScriptImportText(context, info, withSemicolon);
            if (string == null) {
                ES6ImportPsiUtil.$$$reportNull$$$0(68);
            }
            return string;
        }
        String moduleName = info.getModuleName();
        StringBuilder builder = new StringBuilder(info.getPrefix());
        builder.append(" ");
        if (!type.isBare()) {
            JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
            builder.append(ES6ImportPsiUtil.getImportExportPartText(info, true, settings.SPACES_WITHIN_IMPORTS));
            builder.append(" from ");
        }
        String quote = JSCodeStyleSettings.getQuote(context);
        builder.append(quote).append(moduleName).append(quote);
        if (withSemicolon) {
            builder.append(JSCodeStyleSettings.getSemicolon(context));
        }
        String string = builder.toString();
        if (string == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    private static boolean hasComma(PsiElement current) {
        boolean hasComma = false;
        for (PsiElement forComma = current; forComma != null; forComma = forComma.getPrevSibling()) {
            if (ES6ImportPsiUtil.isComma(forComma)) {
                hasComma = true;
                break;
            }
            if (!(forComma instanceof PsiWhiteSpace)) break;
        }
        return hasComma;
    }

    @NotNull
    public static String invertQuote(@NotNull String quote) {
        if (quote == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(70);
        }
        return "'".equals(quote) ? "\"" : "'";
    }

    private static boolean isComma(@NotNull PsiElement forComma) {
        if (forComma == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(71);
        }
        return forComma.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    private static String wrapWithBraces(String text, boolean needSpaces) {
        String space = needSpaces ? " " : "";
        return "{" + space + text + space + "}";
    }

    @Nullable
    public static String getImportExportPartText(@NotNull JSImportedElementDescriptor descriptor2, boolean withFrom, boolean spaces) {
        if (descriptor2 == null) {
            ES6ImportPsiUtil.$$$reportNull$$$0(72);
        }
        String importedName = descriptor2.getImportedName();
        JSImportExportType type = descriptor2.getImportType();
        String exportedName = descriptor2.getExportedName();
        if (type.isSpecifier()) {
            if (exportedName == null) {
                return ES6ImportPsiUtil.wrapWithBraces(importedName, spaces);
            }
            if (importedName == null) {
                return ES6ImportPsiUtil.wrapWithBraces(exportedName, spaces);
            }
            if (importedName.equals(exportedName)) {
                return ES6ImportPsiUtil.wrapWithBraces(importedName, spaces);
            }
            return ES6ImportPsiUtil.wrapWithBraces(exportedName + " as " + importedName, spaces);
        }
        if (type.isBindingAll() && importedName != null) {
            return "* as " + importedName;
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = descriptor2.getImportExportPrefixKind();
        if (type.isDefault() && kind == ES6ImportExportDeclaration.ImportExportPrefixKind.EXPORT && withFrom) {
            return ES6ImportPsiUtil.wrapWithBraces((String)(DEFAULT.equals(exportedName) ? DEFAULT : exportedName + " as default"), spaces);
        }
        return importedName != null ? importedName : exportedName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 65: 
            case 68: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 65: 
            case 68: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDescriptor";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 2: 
            case 4: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 5: 
            case 34: 
            case 36: 
            case 47: 
            case 50: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 65: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeModule";
                break;
            }
            case 18: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 20: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 24: 
            case 61: 
            case 62: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromReferenceText";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 39: 
            case 42: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextToInsert";
                break;
            }
            case 40: 
            case 43: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 45: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElementOrFile";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedImports";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forComma";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findPlaceByModuleName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchorToInsert";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotesFromSettings";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDeclarations";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportOrExport";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportOrExportText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findExistingES6ImportByFromText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableAsExistingImport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToAddImportToExistingDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceByModuleName";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 65: 
            case 68: 
            case 69: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPlaceForImport";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAnchorToInsert";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExistingES6Import";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findExistingES6ImportByFromModules";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExportedElementName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getQuote";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotesFromSettings";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getImportDeclarations";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExistingImports";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedFromClauseOrModuleText";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getUnquotedFromClauseText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "insertBinding";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "insertImportSpecifier";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findImportSpecifierByReferenceName";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "insertJSImport";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getSpecifierInsertPlace";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSpecifierAnchor";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getInsertAfterPosition";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createInsertPlace";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getStringImportMemberComparator";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getImportMemberComparator";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createImportOrExport";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createImportOrExportText";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "invertQuote";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isComma";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getImportExportPartText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 65: 
            case 68: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CreateImportExportInfo
    implements Serializable,
    JSImportedElementDescriptor {
        public static final String IMPORT = "import";
        public static final String IMPORT_TYPE = "import type";
        public static final String EXPORT = "export";
        @Nullable
        private final String myExportedName;
        @Nullable
        private final String myImportedName;
        @NotNull
        private final JSImportExportType myImportType;
        private final ES6ImportExportDeclaration.ImportExportPrefixKind myPrefixKind;

        @Override
        @NotNull
        public JSImportExportType getImportType() {
            JSImportExportType jSImportExportType = this.myImportType;
            if (jSImportExportType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(0);
            }
            return jSImportExportType;
        }

        @Override
        @NotNull
        public ES6ImportExportDeclaration.ImportExportPrefixKind getImportExportPrefixKind() {
            ES6ImportExportDeclaration.ImportExportPrefixKind importExportPrefixKind = this.myPrefixKind;
            if (importExportPrefixKind == null) {
                CreateImportExportInfo.$$$reportNull$$$0(1);
            }
            return importExportPrefixKind;
        }

        @Override
        @Nullable
        public String getExportedName() {
            return this.myExportedName;
        }

        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull JSImportExportType importType, @NotNull ES6ImportExportDeclaration.ImportExportPrefixKind prefixKind) {
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(2);
            }
            if (prefixKind == null) {
                CreateImportExportInfo.$$$reportNull$$$0(3);
            }
            this.myPrefixKind = prefixKind;
            assert (importedName != null || exportedName != null);
            this.myExportedName = exportedName;
            this.myImportedName = importedName;
            this.myImportType = importType;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull ImportExportType importType) {
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(4);
            }
            this(exportedName, importedName, importType, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        }

        public CreateImportExportInfo(@NotNull String importedName, @NotNull JSImportExportType importType) {
            if (importedName == null) {
                CreateImportExportInfo.$$$reportNull$$$0(5);
            }
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(6);
            }
            this(null, importedName, importType, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        }

        public CreateImportExportInfo(@Nullable String importedName) {
            this(null, importedName, ImportExportType.DEFAULT, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        }

        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull JSImportExportType importType) {
            if (importType == null) {
                CreateImportExportInfo.$$$reportNull$$$0(7);
            }
            this(exportedName, importedName, importType, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT);
        }

        @Override
        @Nullable
        public String getImportedName() {
            return this.myImportedName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CreateImportExportInfo info = (CreateImportExportInfo)o;
            if (this.myPrefixKind != info.myPrefixKind) {
                return false;
            }
            if (!Objects.equals(this.myExportedName, info.myExportedName)) {
                return false;
            }
            if (!Objects.equals(this.myImportedName, info.myImportedName)) {
                return false;
            }
            return this.myImportType == info.myImportType;
        }

        public int hashCode() {
            int result2 = this.myExportedName != null ? this.myExportedName.hashCode() : 0;
            result2 = 31 * result2 + (this.myImportedName != null ? this.myImportedName.hashCode() : 0);
            result2 = 31 * result2 + this.myImportType.hashCode();
            result2 = 31 * result2 + this.myPrefixKind.hashCode();
            return result2;
        }

        public String toString() {
            return (String)ObjectUtils.coalesce((Object)ES6ImportPsiUtil.getImportExportPartText(this, true, true), (Object)"<empty>");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixKind";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportExportPrefixKind";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface InsertPlaceInDeclaration {
        @NotNull
        public PsiElement host();

        @Nullable
        public PsiElement getAnchor();

        public boolean needCommaBefore();

        public boolean needCommaAfter();

        public boolean hasSpecifiers();
    }

    public static final class ES6ExistingImports {
        @NotNull
        private final Map<String, ES6ImportSpecifier> mySpecifiers;
        @NotNull
        private final Collection<ES6ImportedBinding> myBindings;
        @NotNull
        private final List<ES6ImportDeclaration> myDeclarations;

        public ES6ExistingImports(@NotNull List<ES6ImportDeclaration> declarations) {
            if (declarations == null) {
                ES6ExistingImports.$$$reportNull$$$0(0);
            }
            this.myDeclarations = new ArrayList<ES6ImportDeclaration>(declarations.size());
            this.mySpecifiers = new HashMap<String, ES6ImportSpecifier>();
            this.myBindings = new ArrayList<ES6ImportedBinding>(declarations.size());
            for (ES6ImportDeclaration declaration : declarations) {
                this.addDeclaration(declaration);
            }
        }

        public void addDeclaration(ES6ImportDeclaration declaration) {
            ES6ImportSpecifier[] specifiers;
            this.myDeclarations.add(declaration);
            for (ES6ImportSpecifier importSpecifier : specifiers = declaration.getImportSpecifiers()) {
                this.mySpecifiers.put(importSpecifier.getReferenceName(), importSpecifier);
            }
            ContainerUtil.addAll(this.myBindings, (Object[])declaration.getImportedBindings());
        }

        public boolean isEmpty() {
            return this.mySpecifiers.isEmpty() && this.myBindings.isEmpty();
        }

        @NotNull
        public Map<String, ES6ImportSpecifier> getSpecifiers() {
            Map<String, ES6ImportSpecifier> map = this.mySpecifiers;
            if (map == null) {
                ES6ExistingImports.$$$reportNull$$$0(1);
            }
            return map;
        }

        @NotNull
        public Collection<ES6ImportedBinding> getBindings() {
            Collection<ES6ImportedBinding> collection = this.myBindings;
            if (collection == null) {
                ES6ExistingImports.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public void addSpecifier(@NotNull ES6ImportSpecifier specifier) {
            if (specifier == null) {
                ES6ExistingImports.$$$reportNull$$$0(3);
            }
            this.mySpecifiers.put(specifier.getReferenceName(), specifier);
        }

        public void addBinding(@NotNull ES6ImportedBinding binding) {
            if (binding == null) {
                ES6ExistingImports.$$$reportNull$$$0(4);
            }
            this.myBindings.add(binding);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declarations";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "specifier";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binding";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpecifiers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBindings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addSpecifier";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addBinding";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ImportExportType implements Serializable,
    JSImportExportType
    {
        SPECIFIER{

            @Override
            public boolean isSpecifier() {
                return true;
            }
        }
        ,
        DEFAULT{

            @Override
            public boolean isDefault() {
                return true;
            }
        }
        ,
        IMPORT_BINDING_ALL{

            @Override
            public boolean isBindingAll() {
                return true;
            }
        }
        ,
        BARE{

            @Override
            public boolean isBare() {
                return true;
            }
        }
        ,
        EXPORT_ALL,
        TS_NS_AND_MODULE{

            @Override
            public boolean isES6() {
                return false;
            }

            @Override
            public boolean isComposite() {
                return true;
            }
        }
        ,
        TS_REQUIRE_IMPORT{

            @Override
            public boolean isTypeScriptRequire() {
                return true;
            }

            @Override
            public boolean isES6() {
                return false;
            }
        }
        ,
        TS_NAMESPACE{

            @Override
            public boolean isES6() {
                return false;
            }

            @Override
            public boolean isNamespace() {
                return true;
            }
        };

    }
}

