/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ExportSpecifierStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportSpecifierImpl
extends ES6ImportExportSpecifierBase<ES6ExportSpecifierStub>
implements ES6ExportSpecifier,
HighlightSeverityHolder {
    public ES6ExportSpecifierImpl(ASTNode node) {
        super(node);
    }

    public ES6ExportSpecifierImpl(ES6ExportSpecifierStub stub) {
        super(stub, ES6ElementTypes.EXPORT_SPECIFIER);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(0);
        }
        if (state2 == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(2);
        }
        if (this.getParent().getParent() != place || "default".equals(this.getReferenceName())) {
            ES6ExportSpecifierAlias alias = this.getAlias();
            if (alias != null) {
                return alias.processDeclarations(processor, state2, lastParent, place);
            }
            return processor.execute((PsiElement)this, state2);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6ExportSpecifier(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    @Nullable
    public ES6ExportSpecifierAlias getAlias() {
        return (ES6ExportSpecifierAlias)this.getStubOrPsiChild(ES6ElementTypes.EXPORT_SPECIFIER_ALIAS);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file2.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (specifier, incompleteCode1) -> ES6PsiUtil.resolveSymbolForSpecifier(specifier, false), true, incompleteCode);
        if (resolveResultArray == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @Override
    @Nullable
    public ES6ExportDeclaration getDeclaration() {
        ES6ImportExportDeclaration declaration = super.getDeclaration();
        return declaration instanceof ES6ExportDeclaration ? (ES6ExportDeclaration)declaration : null;
    }

    @Override
    public boolean isExportDefault() {
        return "default".equals(this.getDeclaredName());
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        ES6FromClause fromClause;
        PsiElement parent = this.getParent();
        if (parent instanceof ES6ImportExportDeclaration && (fromClause = ((ES6ImportExportDeclaration)parent).getFromClause()) == null) {
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            if (highlightSeverity == null) {
                ES6ExportSpecifierImpl.$$$reportNull$$$0(5);
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = super.getUnresolvedReferenceSeverity();
        if (highlightSeverity == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(6);
        }
        return highlightSeverity;
    }

    public void delete() throws IncorrectOperationException {
        ES6ExportDeclaration declaration = this.getDeclaration();
        if (declaration == null) {
            super.delete();
            return;
        }
        ES6ExportSpecifier[] specifiers = declaration.getExportSpecifiers();
        ES6ExportedDefaultBinding binding = declaration.getExportedDefaultBinding();
        if (specifiers.length == 1) {
            if (binding == null) {
                declaration.delete();
            } else {
                boolean result2 = ES6ExportSpecifierImpl.deleteSpecifierAndKeepBinding(declaration.getNode());
                if (!result2) {
                    super.delete();
                }
            }
        } else {
            assert (specifiers.length > 1);
            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)this, (PsiElement[])specifiers);
        }
    }

    public static boolean deleteSpecifierAndKeepBinding(@NotNull ASTNode specifiersHolder) {
        ASTNode startRange;
        if (specifiersHolder == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(7);
        }
        if ((startRange = specifiersHolder.findChildByType(JSTokenTypes.COMMA)) == null) {
            startRange = specifiersHolder.findChildByType(JSTokenTypes.LBRACE);
        }
        ASTNode endRange = specifiersHolder.findChildByType(JSTokenTypes.RBRACE);
        if (startRange == null || endRange == null) {
            return false;
        }
        specifiersHolder.removeRange(startRange, endRange.getTreeNext());
        return true;
    }

    @Override
    public String getName() {
        return this.getAlias() != null ? null : this.getDeclaredName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameIdentifier;
        if (name == null) {
            ES6ExportSpecifierImpl.$$$reportNull$$$0(8);
        }
        if ((nameIdentifier = this.getReferenceElement()) != null) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)this);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, JSChangeUtil.createNameIdentifier(this.getProject(), name, dialect));
        }
        return this;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return PlatformIcons.EXPORT_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiersHolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferenceSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteSpecifierAndKeepBinding";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

