/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.completion.JSImportCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportExportDefaultCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement position;
        PsiElement parent;
        if (parameters == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!((parent = (position = parameters.getPosition()).getParent()) instanceof ES6ImportedBinding)) {
            return;
        }
        ES6ImportedBinding binding = (ES6ImportedBinding)parent;
        ES6ImportDeclaration declaration = binding.getDeclaration();
        if (declaration == null) {
            return;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause != null) {
            PsiFile originalFile = parameters.getOriginalFile();
            PsiElement atOffset = originalFile.findElementAt(parameters.getOffset());
            boolean insertWhitespace = !(atOffset instanceof PsiWhiteSpace);
            ES6ImportExportDefaultCompletionProvider.addCompletionForDefaultName(binding, declaration, result2, insertWhitespace);
        } else {
            ES6ImportExportDefaultCompletionProvider.addExportedElementsForDefaultName(binding, result2);
        }
    }

    private static void addExportedElementsForDefaultName(@NotNull ES6ImportedBinding binding, @NotNull CompletionResultSet result2) {
        if (binding == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(4);
        }
        JSImportCompletionUtil.addExportedVariants(binding, (Collection<LookupElement>)ContainerUtil.emptyList(), result2);
    }

    private static void addCompletionForDefaultName(@NotNull ES6ImportedBinding binding, @NotNull ES6ImportDeclaration declaration, @NotNull CompletionResultSet result2, boolean insertWhitespace) {
        Collection<PsiElement> elements;
        if (binding == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(5);
        }
        if (declaration == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(7);
        }
        if ((elements = ES6PsiUtil.resolveDefaultExport(declaration)).size() != 1) {
            return;
        }
        Object item = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (item == null) {
            return;
        }
        if (item instanceof ES6ExportDefaultAssignment) {
            item = ((ES6ExportDefaultAssignment)item).getStubSafeElement();
        }
        String processedName = null;
        if (item instanceof JSElement) {
            JSExpression qualifier;
            if (item instanceof JSQualifiedNamedElement) {
                String name;
                processedName = name = ((JSElement)item).getName();
                ES6ImportExportDefaultCompletionProvider.addLookupItem(item, result2, name, insertWhitespace);
            } else if (item instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)item).getQualifier()) == null) {
                String name;
                PsiElement resolved = ((JSReferenceExpression)item).resolve();
                if (resolved == null) {
                    resolved = item;
                }
                processedName = name = ((JSReferenceExpression)item).getReferenceName();
                ES6ImportExportDefaultCompletionProvider.addLookupItem(resolved, result2, name, insertWhitespace);
            }
            item = item.getContainingFile();
        }
        if (item instanceof JSFile) {
            String rawFileName = ((JSFile)item).getName();
            String exactFileName = StringUtil.capitalize((String)JSFileReference.getFileNameWithoutExtension(rawFileName, JSFileReference.IMPLICIT_EXTENSIONS));
            if (StringUtil.isEmpty((String)exactFileName) || processedName != null && StringUtil.equalsIgnoreCase((CharSequence)processedName, (CharSequence)exactFileName)) {
                return;
            }
            ES6ImportExportDefaultCompletionProvider.addLookupItem(item, result2, exactFileName, insertWhitespace);
        }
    }

    private static void addLookupItem(@NotNull PsiElement item, @NotNull CompletionResultSet result2, @Nullable String name, boolean insertWhitespace) {
        if (item == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            ES6ImportExportDefaultCompletionProvider.$$$reportNull$$$0(9);
        }
        if (name == null || !StringUtil.isJavaIdentifier((String)name)) {
            return;
        }
        LookupElementBuilder element = JSLookupUtilImpl.createLookupElement(item, name);
        if (insertWhitespace) {
            element = element.withInsertHandler(AddSpaceInsertHandler.INSTANCE);
        }
        result2.addElement((LookupElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6ImportExportDefaultCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addExportedElementsForDefaultName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionForDefaultName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

