/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.lang.Language;
import com.intellij.lang.css.linter.stylelint.StylelintFixResult;
import com.intellij.lang.css.linter.stylelint.StylelintPackage;
import com.intellij.lang.css.linter.stylelint.StylelintResultParser;
import com.intellij.lang.css.linter.stylelint.StylelintSessionData;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.css.linter.stylelint.StylelintUtil;
import com.intellij.lang.css.linter.stylelint.config.StylelintConfigFileChangeTracker;
import com.intellij.lang.css.linter.stylelint.config.StylelintUnsavedConfigFileManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.ThreeState;
import com.intellij.util.TimeoutUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintExternalRunner {
    private static final Logger LOG = Logger.getInstance(StylelintExternalRunner.class);
    private static final String FORMAT_PARAMETER = "-f";
    private static final String JSON_FORMAT = "json";
    private static final String SYNTAX = "--syntax";
    private static final String CONFIG = "--config";
    private static final String STDIN_FILENAME = "--stdin-filename";
    private static final String FIX = "--fix";
    @NlsSafe
    private static final String DEFAULT_ERROR_PREFIX = "Error: ";
    private final boolean myIsOnTheFly;
    private final boolean myRunStylelintFix;

    public StylelintExternalRunner(boolean isOnTheFly, boolean runStylelintFix) {
        this.myIsOnTheFly = isOnTheFly;
        this.myRunStylelintFix = runStylelintFix;
    }

    @Nullable
    public JSLinterAnnotationResult execute(@NotNull JSLinterInput<StylelintState> input) {
        boolean canRun;
        VirtualFile fileToLint;
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(0);
        }
        if (!(fileToLint = input.getVirtualFile()).isValid() || fileToLint.getParent() == null) {
            return null;
        }
        StylelintState state2 = input.getState();
        Project project = input.getProject();
        if (project.isDisposed()) {
            return null;
        }
        VirtualFile workingDirectory = (VirtualFile)ReadAction.compute(() -> StylelintUtil.findWorkingDirectory(fileToLint));
        if (workingDirectory == null) {
            return null;
        }
        if (this.myIsOnTheFly) {
            ((StylelintConfigFileChangeTracker)project.getService(StylelintConfigFileChangeTracker.class)).startIfNeeded();
        }
        boolean bl = canRun = !this.myIsOnTheFly || (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return false;
            }
            Collection<VirtualFile> configs = StylelintUtil.getPossibleConfigs(workingDirectory);
            return ((StylelintUnsavedConfigFileManager)project.getService(StylelintUnsavedConfigFileManager.class)).requestSaveIfNeeded(configs);
        }) != false;
        if (!canRun) {
            LOG.debug("Stylelint postponed because of unsaved configs");
            return null;
        }
        NodeJsInterpreter interpreter = state2.getInterpreterRef().resolve(project);
        JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage(project, interpreter, state2.getStylelintPackage(), "stylelint", fileToLint);
        if (error != null) {
            return JSLinterAnnotationResult.create(input, error, null);
        }
        StylelintPackage stylelintPackage = StylelintPackage.fromNodePackage(project, state2.getStylelintPackage());
        StylelintSessionData sessionData = new StylelintSessionData(interpreter, stylelintPackage, workingDirectory, state2.getConfigFilePath(), fileToLint, input.getFileContent(), StylelintExternalRunner.suggestSyntax(input.getPsiFile()), this.myRunStylelintFix);
        return StylelintExternalRunner.stylelint(input, sessionData);
    }

    @Nullable
    private static String suggestSyntax(@NotNull PsiFile file2) {
        if (file2 == null) {
            StylelintExternalRunner.$$$reportNull$$$0(1);
        }
        if (file2 instanceof StylesheetFile) {
            Language language = file2.getLanguage();
            String languageId = language.getID();
            if ("LESS".equals(languageId)) {
                return "less";
            }
            if ("SCSS".equals(languageId)) {
                return "scss";
            }
        }
        return null;
    }

    private static JSLinterAnnotationResult stylelint(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(2);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(3);
        }
        long startNanoTime = System.nanoTime();
        JSLinterAnnotationResult result2 = StylelintExternalRunner.runProcess(input, sessionData);
        StylelintExternalRunner.logEnd(startNanoTime, result2.getErrors().size());
        return result2;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private static JSLinterAnnotationResult runProcess(@NotNull JSLinterInput<StylelintState> input, @NotNull StylelintSessionData sessionData) {
        block16: {
            block15: {
                if (input == null) {
                    StylelintExternalRunner.$$$reportNull$$$0(4);
                }
                if (sessionData == null) {
                    StylelintExternalRunner.$$$reportNull$$$0(5);
                }
                progressTitle = CssBundle.message((String)"css.stylelint.starting.process.progress.title", (Object[])new Object[0]);
                processWithCmdLine = (ProcessWithCmdLine)NodeProgressUtil.runExecutionUnderProgress(input.getProject(), progressTitle, (ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$runProcess$2(com.intellij.lang.javascript.linter.JSLinterInput com.intellij.lang.css.linter.stylelint.StylelintSessionData ), ()Lcom/intellij/javascript/nodejs/execution/ProcessWithCmdLine;)(input, (StylelintSessionData)sessionData));
                processHandler = processWithCmdLine.getProcessHandler();
                commandLine = processWithCmdLine.getCommandLine();
                StylelintExternalRunner.logStart(sessionData, processWithCmdLine.getCommandLinePresentation());
                if (StylelintExternalRunner.supportStdinClosing(sessionData.getInterpreter())) {
                    try {
                        StylelintExternalRunner.writeFileContentToStdin((ProcessHandler)processHandler, sessionData, commandLine.getCharset());
                    }
                    catch (IOException e) {
                        StylelintExternalRunner.LOG.warn((Throwable)e);
                        output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler);
                        output.appendStderr("\n" + e.getMessage() + "\n");
                        return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, processWithCmdLine, output);
                    }
                }
                if (!StringUtil.isEmptyOrSpaces((String)(stderr = (output = StylelintExternalRunner.captureOutput((BaseOSProcessHandler)processHandler)).getStderr()))) {
                    return StylelintExternalRunner.createFileLevelWarning(stderr, input, processWithCmdLine, output);
                }
                stylelintResultParser = new StylelintResultParser();
                stdout = output.getStdout();
                if (!sessionData.isRunStylelintFix()) break block15;
                v0 = StylelintFixResult.create(stdout);
                {
                    catch (ExecutionException e) {
                        return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input);
                    }
                }
                if (v0 == null) {
                    StylelintExternalRunner.$$$reportNull$$$0(6);
                }
                return v0;
            }
            errors = stylelintResultParser.parse(stdout);
            if (errors != null) ** GOTO lbl43
            if (!StringUtil.isEmptyOrSpaces((String)stdout)) break block16;
            v1 = JSLinterAnnotationResult.createLinterResult(input, Collections.emptyList(), null);
            if (v1 == null) {
                StylelintExternalRunner.$$$reportNull$$$0(7);
            }
            return v1;
        }
        try {
            return StylelintExternalRunner.createFileLevelWarning(stdout, input, processWithCmdLine, output);
lbl43:
            // 1 sources

            v2 = JSLinterAnnotationResult.createLinterResult(input, errors, null);
        }
        catch (Exception e) {
            return StylelintExternalRunner.createFileLevelWarning(e.getMessage(), input, processWithCmdLine, output);
        }
        if (v2 == null) {
            StylelintExternalRunner.$$$reportNull$$$0(8);
        }
        return v2;
    }

    private static void writeFileContentToStdin(@NotNull ProcessHandler processHandler, @NotNull StylelintSessionData sessionData, @NotNull Charset charset) throws IOException {
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(9);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(10);
        }
        if (charset == null) {
            StylelintExternalRunner.$$$reportNull$$$0(11);
        }
        String content = sessionData.getFileToLintContent();
        try (OutputStream stdin = Objects.requireNonNull(processHandler.getProcessInput());){
            stdin.write(content.getBytes(charset));
            stdin.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write file content to stdin\n\n" + content, e);
        }
    }

    @NotNull
    private static ProcessWithCmdLine startProcess(@NotNull Project project, @NotNull StylelintSessionData sessionData) throws ExecutionException {
        if (project == null) {
            StylelintExternalRunner.$$$reportNull$$$0(12);
        }
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(13);
        }
        NodeTargetRun targetRun = new NodeTargetRun(sessionData.getInterpreter(), project, null, NodeTargetRun.createOptions(ThreeState.NO, List.of()));
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        File workDirectory = VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getWorkingDir());
        targetRun.configureEnvironment(EnvironmentVariablesData.DEFAULT);
        commandLineBuilder.setWorkingDirectory(targetRun.path(workDirectory.getAbsolutePath()));
        sessionData.getStylelintPackage().addMainEntryJsFile(targetRun);
        if (sessionData.isRunStylelintFix()) {
            commandLineBuilder.addParameter(FIX);
        } else {
            commandLineBuilder.addParameters(new String[]{FORMAT_PARAMETER, JSON_FORMAT});
        }
        String configFilePath = FileUtil.toSystemDependentName((String)sessionData.getConfigFilePath());
        if (!configFilePath.isEmpty()) {
            commandLineBuilder.addParameters(new String[]{CONFIG, configFilePath});
        }
        if (sessionData.getSyntax() != null) {
            commandLineBuilder.addParameters(new String[]{SYNTAX, sessionData.getSyntax()});
        }
        String pathToLint = FileUtil.toSystemDependentName((String)sessionData.getFileToLint().getPath());
        if (StylelintExternalRunner.supportStdinClosing(targetRun.getInterpreter())) {
            String relativePath = FileUtil.getRelativePath((String)workDirectory.getAbsolutePath(), (String)pathToLint, (char)File.separatorChar);
            if (relativePath != null) {
                commandLineBuilder.addParameters(new String[]{STDIN_FILENAME, relativePath});
            }
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
            commandLineBuilder.addParameter(targetRun.path(pathToLint));
        }
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        if (processWithCmdLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(14);
        }
        return processWithCmdLine;
    }

    @NotNull
    private static ProcessOutput captureOutput(@NotNull BaseOSProcessHandler processHandler) {
        if (processHandler == null) {
            StylelintExternalRunner.$$$reportNull$$$0(15);
        }
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        catcher.run();
        ProcessOutput processOutput = catcher.getOutput();
        if (processOutput == null) {
            StylelintExternalRunner.$$$reportNull$$$0(16);
        }
        return processOutput;
    }

    private static boolean supportStdinClosing(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            StylelintExternalRunner.$$$reportNull$$$0(17);
        }
        return !NodeJsRemoteInterpreter.isDocker(interpreter);
    }

    @NotNull
    private static JSLinterAnnotationResult createFileLevelWarning(@NotNull @InspectionMessage String message, @NotNull JSLinterInput<StylelintState> input) {
        if (message == null) {
            StylelintExternalRunner.$$$reportNull$$$0(18);
        }
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(19);
        }
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(message), null);
        if (jSLinterAnnotationResult == null) {
            StylelintExternalRunner.$$$reportNull$$$0(20);
        }
        return jSLinterAnnotationResult;
    }

    @NotNull
    private static JSLinterAnnotationResult createFileLevelWarning(@NotNull String message, @NotNull JSLinterInput<StylelintState> input, @NotNull ProcessWithCmdLine processWithCmdLine, @NotNull ProcessOutput output) {
        if (message == null) {
            StylelintExternalRunner.$$$reportNull$$$0(21);
        }
        if (input == null) {
            StylelintExternalRunner.$$$reportNull$$$0(22);
        }
        if (processWithCmdLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(23);
        }
        if (output == null) {
            StylelintExternalRunner.$$$reportNull$$$0(24);
        }
        JsqtViewProcessOutputAction detailsAction = new JsqtViewProcessOutputAction(JavaScriptBundle.message("javascript.linter.error.failed.to.lint", input.getVirtualFile().getPath()), JavaScriptLanguageIcons.FileTypes.Stylelint, processWithCmdLine.buildGeneralCommandLine(), (ProcessHandler)processWithCmdLine.getProcessHandler(), output);
        String errorMessage = StringUtil.splitByLines((String)message)[0];
        errorMessage = StringUtil.trimStart((String)errorMessage, (String)DEFAULT_ERROR_PREFIX);
        errorMessage = StringUtil.decapitalize((String)errorMessage);
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(errorMessage, detailsAction).withIcon(JavaScriptLanguageIcons.FileTypes.Stylelint), null);
        if (jSLinterAnnotationResult == null) {
            StylelintExternalRunner.$$$reportNull$$$0(25);
        }
        return jSLinterAnnotationResult;
    }

    private static void logStart(@NotNull StylelintSessionData sessionData, @NotNull String commandLine) {
        if (sessionData == null) {
            StylelintExternalRunner.$$$reportNull$$$0(26);
        }
        if (commandLine == null) {
            StylelintExternalRunner.$$$reportNull$$$0(27);
        }
        String stylelintVersion = sessionData.getStylelintPackage().getVersionStr();
        String fileToLintPath = sessionData.getFileToLint().getPath();
        LOG.debug(String.format("Running stylelint@%s at %s$ %s", stylelintVersion, fileToLintPath, commandLine));
    }

    private static void logEnd(long startTime, int resultSize) {
        long durationMillis = TimeoutUtil.getDurationMillis((long)startTime);
        LOG.debug(String.format(CssBundle.message((String)"css.stylelint.message.prefix", (Object[])new Object[0]) + " done in %d ms, found %d problems", durationMillis, resultSize));
    }

    private static /* synthetic */ ProcessWithCmdLine lambda$runProcess$2(JSLinterInput input, StylelintSessionData sessionData) throws ExecutionException {
        return StylelintExternalRunner.startProcess(input.getProject(), sessionData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processWithCmdLine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/linter/stylelint/StylelintExternalRunner";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "captureOutput";
                break;
            }
            case 20: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLevelWarning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "suggestSyntax";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stylelint";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 20: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeFileContentToStdin";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "captureOutput";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "supportStdinClosing";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createFileLevelWarning";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "logStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

