/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.codeInsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.javascript.web.symbols.WebSymbolsRegistry;
import com.intellij.javascript.web.symbols.WebSymbolsRegistryManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J=\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0012J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0004J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\u0002H$\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/web/codeInsight/WebSymbolsCompletionProviderBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "position", "", "name", "", "registry", "Lcom/intellij/javascript/web/symbols/WebSymbolsRegistry;", "context", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/codeInsight/completion/CompletionResultSet;ILjava/lang/String;Lcom/intellij/javascript/web/symbols/WebSymbolsRegistry;Lcom/intellij/psi/PsiElement;)V", "Lcom/intellij/util/ProcessingContext;", "getContext", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "intellij.javascript.web"})
public abstract class WebSymbolsCompletionProviderBase<T extends PsiElement>
extends CompletionProvider<CompletionParameters> {
    protected final void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiElement psiElement2 = psiElement.getOriginalElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parameters.position.originalElement");
        T t = this.getContext(psiElement2);
        if (t == null) {
            return;
        }
        T psiContext = t;
        WebSymbolsRegistry registry = WebSymbolsRegistryManager.Companion.get$default(WebSymbolsRegistryManager.Companion, psiContext, false, 2, null);
        PsiElement psiElement3 = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parameters.position");
        int elementOffset = UtilsKt.getStartOffset((PsiElement)psiElement3);
        int position = 0;
        String name = null;
        if (parameters.getOffset() > elementOffset) {
            position = parameters.getOffset() - elementOffset;
            Editor editor = parameters.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"parameters.editor");
            String string = editor.getDocument().getText(new TextRange(elementOffset, parameters.getOffset()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.editor.docume\u2026fset, parameters.offset))");
            name = string;
        } else {
            position = 0;
            name = "";
        }
        this.addCompletions(parameters, result2, position, name, registry, psiContext);
    }

    @Nullable
    protected abstract T getContext(@NotNull PsiElement var1);

    protected abstract void addCompletions(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2, int var3, @NotNull String var4, @NotNull WebSymbolsRegistry var5, @NotNull T var6);
}

