/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class NodePackage {
    private static final Logger LOG = Logger.getInstance(NodePackage.class);
    @NotNull
    private final String mySystemDependentPath;
    @Nullable
    private Path myDir;

    public NodePackage(@NotNull Path path2) {
        if (path2 == null) {
            NodePackage.$$$reportNull$$$0(0);
        }
        this(LocalFilePath.toLocalPath(path2));
        this.myDir = path2;
    }

    public NodePackage(@NotNull String path2) {
        if (path2 == null) {
            NodePackage.$$$reportNull$$$0(1);
        }
        if (!(this instanceof YarnPnpNodePackage) && path2.startsWith("yarn:")) {
            LOG.warn(new Throwable("Unexpected " + this.getClass() + " is created for " + path2));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Created " + this.getClass() + " for " + path2);
        }
        path2 = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path2), (char)'/');
        this.mySystemDependentPath = FileUtil.toSystemDependentName((String)path2);
    }

    @NotNull
    public String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath);
        if (string == null) {
            NodePackage.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getSystemDependentPath() {
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEmptyPath() {
        return this.mySystemDependentPath.isEmpty();
    }

    @NotNull
    public String getName() {
        int ind = this.mySystemDependentPath.lastIndexOf(File.separatorChar);
        if (ind >= 0) {
            int prev = this.mySystemDependentPath.lastIndexOf(File.separatorChar, ind - 1);
            if (prev >= 0 && this.mySystemDependentPath.charAt(prev + 1) == '@') {
                String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath.substring(prev + 1));
                if (string == null) {
                    NodePackage.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.mySystemDependentPath.substring(ind + 1);
            if (string == null) {
                NodePackage.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean nameMatches(@NotNull String packageName) {
        String path2;
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(7);
        }
        return (path2 = this.getSystemIndependentPath()).endsWith(packageName) && StringUtil.isChar((CharSequence)path2, (int)(path2.length() - packageName.length() - 1), (char)'/');
    }

    @Nullable
    public SemVer getVersion() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return null;
        }
        Path dir = this.getDir();
        if (dir == null) {
            return null;
        }
        return NodePackageVersionUtil.getPackageVersion(dir.toFile());
    }

    @Nullable
    public SemVer getVersion(@Nullable Project project) {
        return this.getVersion();
    }

    @NotNull
    public Promise<SemVer> getVersionPromise(@Nullable Project project) {
        Promise promise = Promises.resolvedPromise((Object)this.getVersion(project));
        if (promise == null) {
            NodePackage.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @Nullable
    private Path getDir() {
        Path file2 = this.myDir;
        if (file2 == null) {
            try {
                file2 = Path.of(this.mySystemDependentPath, new String[0]);
            }
            catch (InvalidPathException e) {
                return null;
            }
            this.myDir = file2;
        }
        return file2;
    }

    @NotNull
    @NlsSafe
    public String getPresentablePath() {
        String userHome = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)SystemProperties.getUserHome()), (char)File.separatorChar);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.mySystemDependentPath;
            if (string == null) {
                NodePackage.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (this.mySystemDependentPath.startsWith(userHome + File.separatorChar)) {
            String string = "~" + this.mySystemDependentPath.substring(userHome.length());
            if (string == null) {
                NodePackage.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isValid() {
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return false;
        }
        Path dir = this.getDir();
        return dir != null && dir.isAbsolute() && Files.isDirectory(dir, new LinkOption[0]);
    }

    public boolean isValid(@NotNull Project project) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(12);
        }
        return this.isValid();
    }

    @Nullable
    @NlsContexts.DialogMessage
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(13);
        }
        return this.getErrorMessage(packageName, false);
    }

    @Nullable
    @NlsContexts.DialogMessage
    public String getErrorMessage(@NotNull String packageName, boolean allowNonExistent) {
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return JavaScriptBundle.message("dialog.message.unspecified.package", packageName);
        }
        if (allowNonExistent) {
            return null;
        }
        Path dir = this.getDir();
        if (dir == null || !dir.isAbsolute() || !Files.isDirectory(dir, new LinkOption[0])) {
            if (dir != null && Files.isRegularFile(dir, new LinkOption[0])) {
                return JavaScriptBundle.message("dialog.message.invalid.package.file.specified.but.directory.with.package.json.expected", packageName);
            }
            return JavaScriptBundle.message("dialog.message.invalid.package.no.such.directory", packageName);
        }
        return null;
    }

    public void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        String message;
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(15);
        }
        if ((message = this.getErrorMessage(packageName)) != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    @Nullable
    public String getAbsolutePackagePathToRequire(@NotNull Project project) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(16);
        }
        return this.getSystemDependentPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return this.mySystemDependentPath.equals(aPackage.mySystemDependentPath);
    }

    public int hashCode() {
        return this.mySystemDependentPath.hashCode();
    }

    @Nullable
    public static NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(17);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(18);
        }
        List<NodePackage> packages = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, null);
        return (NodePackage)ContainerUtil.getFirstItem(packages);
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull List<String> packageNames, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(19);
        }
        if (packageNames == null) {
            NodePackage.$$$reportNull$$$0(20);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageNames).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(21);
        }
        return nodePackage;
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(22);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(23);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageName).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(24);
        }
        return nodePackage;
    }

    public String toString() {
        return this.mySystemDependentPath;
    }

    @Deprecated
    @Nullable
    public File findBinFile() {
        return this.findBinFile(this.getName(), null);
    }

    @Nullable
    public File findBinFile(@NotNull String executableName, @Nullable String failoverBinRelativePath) {
        if (executableName == null) {
            NodePackage.$$$reportNull$$$0(25);
        }
        return this.findBinFile(executableName, failoverBinRelativePath, null);
    }

    @Nullable
    public File findBinFile(@NotNull String executableName, @Nullable String failoverBinRelativePath, @Nullable NodeJsInterpreter interpreter) {
        if (executableName == null) {
            NodePackage.$$$reportNull$$$0(26);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return null;
        }
        Path dir = this.getDir();
        if (dir == null) {
            return null;
        }
        return NodePackage.findBinFile(dir.toFile(), executableName, failoverBinRelativePath, interpreter);
    }

    @Nullable
    private static File findBinFile(@NotNull File packageDir2, @NotNull String executableName, @Nullable String failoverBinRelativePath, @Nullable NodeJsInterpreter interpreter) {
        if (packageDir2 == null) {
            NodePackage.$$$reportNull$$$0(27);
        }
        if (executableName == null) {
            NodePackage.$$$reportNull$$$0(28);
        }
        File packageJsonFile = new File(packageDir2, "package.json");
        File binFile = null;
        if (packageJsonFile.isFile()) {
            VirtualFile vf = (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByIoFile(packageJsonFile));
            String binPath = vf != null ? PackageJsonData.getOrCreate(vf).getBinPath(executableName) : null;
            File file2 = binFile = binPath != null ? new File(packageDir2, binPath) : null;
            if (binFile != null) {
                binFile = binFile.toPath().normalize().toFile();
            }
        }
        if (!(binFile != null && binFile.isFile() || failoverBinRelativePath == null)) {
            binFile = new File(packageDir2, failoverBinRelativePath);
        }
        return binFile != null && (interpreter instanceof NodeJsRemoteInterpreter || binFile.isFile()) ? binFile : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIndependentPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDependentPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionPromise";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreferredPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nameMatches";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateForRunConfiguration";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePackagePathToRequire";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultPackage";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredPackage";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

