/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.javascript.nodejs.settings.NodePackageListProvider;
import com.intellij.javascript.nodejs.settings.NodePackageNames;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.TimeoutUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodePackageListProviderImpl
implements NodePackageListProvider {
    private static final Logger LOG = Logger.getInstance(NodePackageListProviderImpl.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    private static final String ALL_NODE_PACKAGE_NAMES_URL = "https://download.jetbrains.com/idea/nodejs/all-node-package-names-json.gzip";
    private static final String NPM_REGISTRY_ALL_URL = "http://registry.npmjs.org/-/all";
    private static final Object JSON_FILE_LOCK = new Object();
    private final ReentrantLock myUpdateLock = new ReentrantLock();

    private NodePackageListProviderImpl() {
    }

    @Override
    @NotNull
    public List<String> listAllRemotePackageNames() throws IOException {
        NodePackageNames packageNames = this.getAllNodePackageNames();
        List<String> list2 = Collections.unmodifiableList(packageNames.getNames());
        if (list2 == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(0);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private NodePackageNames getAllNodePackageNames() throws IOException {
        File allPackageNamesFile = NodePackageListProviderImpl.getAllPackageNamesJsonFile();
        NodePackageNames names = NodePackageListProviderImpl.readPackageNamesFileWithLock(allPackageNamesFile);
        if (names == null) {
            block10: {
                long beforeLastModified = allPackageNamesFile.lastModified();
                this.myUpdateLock.lock();
                try {
                    if (beforeLastModified != allPackageNamesFile.lastModified()) {
                        names = NodePackageListProviderImpl.readPackageNamesFileWithLock(allPackageNamesFile);
                    }
                    if (names != null) break block10;
                    try {
                        names = NodePackageListProviderImpl.updateSync();
                    }
                    catch (IOException e) {
                        LOG.warn("Cannot update all node packages synchronously", (Throwable)e);
                        throw e;
                    }
                }
                finally {
                    this.myUpdateLock.unlock();
                }
            }
            NodePackageNames nodePackageNames = names;
            if (nodePackageNames == null) {
                NodePackageListProviderImpl.$$$reportNull$$$0(1);
            }
            return nodePackageNames;
        }
        if (!names.isValid()) {
            NodePackageListProviderImpl.logOutdated(names);
            this.updateAsync();
        }
        NodePackageNames nodePackageNames = names;
        if (nodePackageNames == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(2);
        }
        return nodePackageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static NodePackageNames readPackageNamesFileWithLock(@NotNull File allPackageNamesJsonFile) {
        if (allPackageNamesJsonFile == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(3);
        }
        Object object = JSON_FILE_LOCK;
        synchronized (object) {
            if (allPackageNamesJsonFile.isFile()) {
                try {
                    long startNanoTime = System.nanoTime();
                    NodePackageNames names = NodePackageListProviderImpl.readPackageNamesFile(allPackageNamesJsonFile, false);
                    double pastDays = (double)(System.currentTimeMillis() - names.getGenerationTimeMillis()) / (1.0 * (double)TimeUnit.DAYS.toMillis(1L));
                    LOG.info(String.format("%d node packages has been read in %d ms, updated %.2f days ago: %s", names.getNames().size(), TimeoutUtil.getDurationMillis((long)startNanoTime), pastDays, allPackageNamesJsonFile.getAbsolutePath()));
                    return names;
                }
                catch (IOException e) {
                    LOG.warn("Cannot parse " + allPackageNamesJsonFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return null;
    }

    @NotNull
    private static File getAllPackageNamesJsonFile() {
        return new File(PathManager.getSystemPath(), "extLibs" + File.separator + "nodejs" + File.separator + "all-node-package-names.json");
    }

    private void updateAsync() {
        if (!this.myUpdateLock.isLocked()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                LOG.info("Updating all node package names asynchronously ...");
                this.myUpdateLock.lock();
                try {
                    NodePackageListProviderImpl.updateSync();
                }
                catch (Exception e) {
                    LOG.warn("Cannot update all node packages", (Throwable)e);
                }
                finally {
                    this.myUpdateLock.unlock();
                }
            });
        } else {
            LOG.info("Async update was skipped, because another update is in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static NodePackageNames readPackageNamesFile(@NotNull File allPackageNamesFile, boolean gzipped) throws IOException {
        if (allPackageNamesFile == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(4);
        }
        JsonReader reader = NodePackageListProviderImpl.newJsonReader(allPackageNamesFile, gzipped);
        NodePackageNames nodePackageNames = NodePackageListProviderImpl.doReadPackages(reader, allPackageNamesFile);
        NodePackageNames nodePackageNames2 = nodePackageNames;
        if (nodePackageNames2 == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(5);
        }
        return nodePackageNames2;
        finally {
            NodePackageListProviderImpl.closeSilently((Closeable)reader);
        }
    }

    @NotNull
    private static JsonReader newJsonReader(@NotNull File allPackagesJsonFile, boolean gzipped) throws IOException {
        if (allPackagesJsonFile == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(6);
        }
        FilterInputStream inputStream = new BufferedInputStream(new FileInputStream(allPackagesJsonFile), 131072);
        if (gzipped) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException e) {
                NodePackageListProviderImpl.closeSilently(inputStream);
                throw e;
            }
        }
        return new JsonReader((Reader)new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
    }

    @NotNull
    private static NodePackageNames doReadPackages(@NotNull JsonReader reader, @NotNull File jsonFile) throws IOException {
        if (reader == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(7);
        }
        if (jsonFile == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(8);
        }
        reader.beginObject();
        long generationTimeMillis = jsonFile.lastModified();
        ArrayList<String> names = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("_updated".equals(key)) {
                String generatedDateStr = reader.nextString();
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
                try {
                    Date date = format.parse(generatedDateStr);
                    generationTimeMillis = date.getTime();
                }
                catch (ParseException e) {
                    LOG.warn(String.format("Cannot parse generation date '%s' as '%s'", generatedDateStr, DATE_FORMAT), (Throwable)e);
                }
                continue;
            }
            if ("_total_package_count".equals(key)) {
                int totalPackageCount = reader.nextInt();
                names = new ArrayList<String>(totalPackageCount);
                continue;
            }
            if ("package_names".equals(key)) {
                if (names == null) {
                    LOG.warn("Package count not specified");
                    names = new ArrayList();
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    names.add(reader.nextString());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (names == null || names.size() == 0) {
            throw new IOException("No packages found inside " + jsonFile.getAbsolutePath());
        }
        return new NodePackageNames(generationTimeMillis, (List<String>)names);
    }

    private static void closeSilently(@NotNull Closeable closeable) {
        if (closeable == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(9);
        }
        try {
            closeable.close();
        }
        catch (IOException ioe) {
            LOG.warn("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void logOutdated(@NotNull NodePackageNames names) throws IOException {
        if (names == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(10);
        }
        double pastDays = (double)(System.currentTimeMillis() - names.getGenerationTimeMillis()) / (1.0 * (double)TimeUnit.DAYS.toMillis(1L));
        LOG.warn(String.format("Node package names were generated %.2f days ago", pastDays));
    }

    @NotNull
    private static NodePackageNames updateSync() throws IOException {
        NodePackageNames packageNames;
        block5: {
            File gzippedJson = FileUtil.createTempFile((String)"intellij-all-node-package-names-json", (String)".gzip");
            NodePackageListProviderImpl.downloadAndLog(ALL_NODE_PACKAGE_NAMES_URL, gzippedJson);
            packageNames = NodePackageListProviderImpl.readPackageNamesFile(gzippedJson, true);
            FileUtil.delete((File)gzippedJson);
            if (!packageNames.isValid()) break block5;
            NodePackageListProviderImpl.writePackageNamesWithLock(packageNames);
            NodePackageNames nodePackageNames = packageNames;
            if (nodePackageNames == null) {
                NodePackageListProviderImpl.$$$reportNull$$$0(11);
            }
            return nodePackageNames;
        }
        try {
            NodePackageListProviderImpl.logOutdated(packageNames);
        }
        catch (IOException e) {
            LOG.warn("Cannot update all package names", (Throwable)e);
        }
        File allNpmRegistryFile = FileUtil.createTempFile((String)"intellij-all-npm-registry", (String)".json");
        NodePackageListProviderImpl.downloadAndLog(NPM_REGISTRY_ALL_URL, allNpmRegistryFile);
        List<String> names = NodePackageListProviderImpl.extractNames(allNpmRegistryFile);
        FileUtil.delete((File)allNpmRegistryFile);
        NodePackageNames packageNames2 = new NodePackageNames(System.currentTimeMillis(), names);
        NodePackageListProviderImpl.writePackageNamesWithLock(packageNames2);
        NodePackageNames nodePackageNames = packageNames2;
        if (nodePackageNames == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(12);
        }
        return nodePackageNames;
    }

    private static void downloadAndLog(@NotNull String url, @NotNull File file2) throws IOException {
        if (url == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(14);
        }
        LOG.info("Downloading " + url + " to " + file2.getAbsolutePath() + " ...");
        long startTimeMillis = System.currentTimeMillis();
        DownloadUtil.downloadAtomically(null, (String)url, (File)file2);
        LOG.info(String.format("%s downloaded in %d ms", url, System.currentTimeMillis() - startTimeMillis));
    }

    private static List<String> extractNames(@NotNull File jsonFile) throws IOException {
        if (jsonFile == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(15);
        }
        long startTimeMillis = System.currentTimeMillis();
        ArrayList<String> names = new ArrayList<String>();
        try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8), 65536));){
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if ("_updated".equalsIgnoreCase(key)) {
                    reader.skipValue();
                    continue;
                }
                String name = NodePackageListProviderImpl.readPackageName(reader);
                if (name == null) {
                    LOG.warn("Cannot parse info for node package '" + key + "'");
                    continue;
                }
                names.add(name);
            }
            reader.endObject();
            LOG.info(String.format("%d package names extracted in %d ms", names.size(), System.currentTimeMillis() - startTimeMillis));
        }
        return names;
    }

    @Nullable
    private static String readPackageName(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(16);
        }
        reader.beginObject();
        String name = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("name".equals(key)) {
                name = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePackageNamesWithLock(@NotNull NodePackageNames packageNames) throws IOException {
        if (packageNames == null) {
            NodePackageListProviderImpl.$$$reportNull$$$0(17);
        }
        Object object = JSON_FILE_LOCK;
        synchronized (object) {
            File allPackageNamesJsonFile = NodePackageListProviderImpl.getAllPackageNamesJsonFile();
            FileUtil.createParentDirs((File)allPackageNamesJsonFile);
            try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(allPackageNamesJsonFile), StandardCharsets.UTF_8));){
                writer.setIndent(" ");
                writer.beginObject();
                SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                writer.name("_updated").value(df.format(new Date(packageNames.getGenerationTimeMillis())));
                writer.name("_total_package_count").value((long)packageNames.getNames().size());
                writer.name("package_names");
                writer.beginArray();
                for (String name : packageNames.getNames()) {
                    writer.value(name);
                }
                writer.endArray();
                writer.endObject();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodePackageListProviderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPackageNamesJsonFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPackageNamesFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPackagesJsonFile";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllRemotePackageNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodePackageNames";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodePackageListProviderImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackageNamesFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSync";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readPackageNamesFileWithLock";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readPackageNamesFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newJsonReader";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doReadPackages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "closeSilently";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logOutdated";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndLog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readPackageName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writePackageNamesWithLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

