/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.execution.NodeBaseRunProfileState;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeLocalDependenciesAction
extends DumbAwareAction {
    private static final Key<Queue<VirtualFile>> QUEUE_KEY = Key.create((String)"package.json queue to install");
    private static final Key<VirtualFile> CONTEXT_PACKAGE_JSON_KEY = Key.create((String)"package.json associated with package.json");

    public InstallNodeLocalDependenciesAction() {
        super(JavaScriptBundle.messagePointer("action.InstallNodeLocalDependencies.text", new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.Install);
    }

    public @NotNull List<Supplier<@Nls String>> getSynonyms() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new Supplier[]{() -> InstallNodeLocalDependenciesAction.getActionNameByPackageManager("npm"), () -> InstallNodeLocalDependenciesAction.getActionNameByPackageManager("yarn"), () -> InstallNodeLocalDependenciesAction.getActionNameByPackageManager("pnpm")});
        if (arrayList == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    @Nls
    private static String getActionNameByPackageManager(@NotNull String packageName) {
        if (packageName == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(1);
        }
        String string = JavaScriptBundle.message("node.js.quickfix.run.command", NpmManager.getNpmCommandPresentableText(NodePackageRef.create(packageName), NpmCommand.INSTALL)).replace("'", "");
        if (string == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        List<VirtualFile> packageJsonFiles = this.getPackageJsonFiles(e);
        boolean show = project != null && !packageJsonFiles.isEmpty();
        e.getPresentation().setEnabledAndVisible(show);
        if (show) {
            e.getPresentation().setText(JavaScriptBundle.message("node.js.quickfix.run.command", NpmManager.getInstance(project).getNpmInstallPresentableText()));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        List<VirtualFile> packageJsonFiles = this.getPackageJsonFiles(e);
        if (project != null && !packageJsonFiles.isEmpty()) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJsonFiles);
        }
    }

    @NotNull
    protected List<VirtualFile> getPackageJsonFiles(@NotNull AnActionEvent e) {
        Object[] files;
        if (e == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(5);
        }
        if ((files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                InstallNodeLocalDependenciesAction.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter((Object[])files, packageJson -> PackageJsonUtil.isPackageJsonFile(packageJson) && packageJson.isValid());
        if (list3 == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(7);
        }
        return list3;
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(8);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(9);
        }
        InstallNodeLocalDependenciesAction.runAndShowConsole(project, Collections.singletonList(packageJson));
    }

    public static void runAndShowConsole(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles) {
        LinkedList<VirtualFile> queue;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(10);
        }
        if (packageJsonFiles == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(11);
        }
        if ((queue = (LinkedList<VirtualFile>)project.getUserData(QUEUE_KEY)) == null) {
            queue = new LinkedList<VirtualFile>();
            project.putUserData(QUEUE_KEY, queue);
        }
        queue.addAll(packageJsonFiles);
        ApplicationManager.getApplication().invokeLater(() -> InstallNodeLocalDependenciesAction.installNext(project), ModalityState.NON_MODAL);
    }

    private static void installNext(@NotNull Project project) {
        Queue queue;
        VirtualFile packageJson;
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(12);
        }
        VirtualFile virtualFile = packageJson = (queue = (Queue)project.getUserData(QUEUE_KEY)) != null ? (VirtualFile)queue.poll() : null;
        if (packageJson == null) {
            project.putUserData(QUEUE_KEY, null);
            return;
        }
        InstallNodeLocalDependenciesAction.saveFile(packageJson);
        NpmCommand npmCommand = NpmCommand.INSTALL;
        String title = InstallNodeLocalDependenciesAction.getTitle(project, packageJson);
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile((RunProfile)new InstallDepsRunProfile(packageJson, npmCommand, title));
        RunContentDescriptor otherDescriptor = (RunContentDescriptor)ContainerUtil.find((Iterable)RunContentManager.getInstance((Project)project).getAllDescriptors(), d -> {
            VirtualFile contextPackageJson;
            ProcessHandler handler = d.getProcessHandler();
            return handler != null && packageJson.equals(contextPackageJson = (VirtualFile)handler.getUserData(CONTEXT_PACKAGE_JSON_KEY)) && !handler.isProcessTerminated();
        });
        if (otherDescriptor != null) {
            ProcessHandler otherProcessHandler = otherDescriptor.getProcessHandler();
            if (otherProcessHandler != null) {
                otherProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)true);
                GeneralSettings.ProcessCloseConfirmation result2 = TerminateRemoteProcessDialog.show((Project)project, (String)title, (ProcessHandler)otherProcessHandler);
                if (result2 == null) {
                    return;
                }
            }
            builder.contentToReuse(otherDescriptor);
        }
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
    }

    @NotNull
    private static String getTitle(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(13);
        }
        if (packageJson == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(14);
        }
        Object title = NpmManager.getInstance(project).getNpmInstallPresentableText();
        VirtualFile dir = packageJson.getParent();
        if (dir != null) {
            title = (String)title + " in " + JsbtUtil.getRelativePath(project, dir);
        }
        String string = title;
        if (string == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void saveFile(@NotNull VirtualFile file2) {
        FileDocumentManager fileDocumentManager;
        Document doc;
        if (file2 == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(16);
        }
        if ((doc = (fileDocumentManager = FileDocumentManager.getInstance()).getDocument(file2)) != null) {
            fileDocumentManager.saveDocument(doc);
        }
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@NotNull NodeCommandLineConfigurator configurer, @NotNull VirtualFile workingDir, @NotNull NodePackage npmPackage, @NotNull NpmCommand npmCommand, @NotNull ConsoleCommandLineFolder folder) throws ExecutionException {
        if (configurer == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(17);
        }
        if (workingDir == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(18);
        }
        if (npmPackage == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(19);
        }
        if (npmCommand == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(20);
        }
        if (folder == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(21);
        }
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine(true);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.setWorkDirectory(workingDir.getPath());
        commandLine.setCharset(StandardCharsets.UTF_8);
        String cliJsFilePath = NpmUtil.getValidNpmCliJsFilePath(npmPackage);
        commandLine.addParameter(cliJsFilePath);
        folder.addPlaceholderText(NpmManager.getNpmPackagePresentableName(npmPackage));
        commandLine.addParameter(npmCommand.getCliOption(NpmUtil.isYarnAlikePackage(npmPackage)));
        folder.addLastParameterFrom(commandLine);
        if (npmPackage.getName().equals("npm")) {
            commandLine.addParameter("--scripts-prepend-node-path=auto");
        }
        configurer.configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            InstallNodeLocalDependenciesAction.$$$reportNull$$$0(22);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmCommand";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynonyms";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionNameByPackageManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionNameByPackageManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runAndShowConsole";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installNext";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Root
    extends InstallNodeLocalDependenciesAction {
        @Override
        @NotNull
        protected List<VirtualFile> getPackageJsonFiles(@NotNull AnActionEvent e) {
            if (e == null) {
                Root.$$$reportNull$$$0(0);
            }
            Project project = Objects.requireNonNull(e.getProject());
            VirtualFile root = ProjectUtil.guessProjectDir((Project)project);
            List list2 = ContainerUtil.createMaybeSingletonList((Object)PackageJsonUtil.findChildPackageJsonFile(root));
            if (list2 == null) {
                Root.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Project project;
            VirtualFile packageJson;
            if (e == null) {
                Root.$$$reportNull$$$0(2);
            }
            VirtualFile virtualFile = packageJson = (project = e.getProject()) != null ? this.getRootPackageJson(e) : null;
            if (packageJson == null) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                e.getPresentation().setText(JavaScriptBundle.message("action.InstallNodeLocalDependencies$Root.text", NpmManager.getInstance(project).getNpmInstallPresentableText(), JsbtUtil.getRelativePath(project, packageJson)));
            }
        }

        @Nullable
        private VirtualFile getRootPackageJson(@NotNull AnActionEvent e) {
            VirtualFile packageJson;
            if (e == null) {
                Root.$$$reportNull$$$0(3);
            }
            return (packageJson = (VirtualFile)ContainerUtil.getFirstItem(this.getPackageJsonFiles(e))) != null && !super.getPackageJsonFiles(e).contains(packageJson) ? packageJson : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$Root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$Root";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageJsonFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageJsonFiles";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootPackageJson";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyRunProfileState
    implements NodeBaseRunProfileState {
        private final Project myProject;
        private final VirtualFile myPackageJson;
        private final NpmCommand myNpmCommand;
        private final ConsoleCommandLineFolder myFolder;

        private MyRunProfileState(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull NpmCommand npmCommand) {
            if (project == null) {
                MyRunProfileState.$$$reportNull$$$0(0);
            }
            if (packageJson == null) {
                MyRunProfileState.$$$reportNull$$$0(1);
            }
            if (npmCommand == null) {
                MyRunProfileState.$$$reportNull$$$0(2);
            }
            this.myFolder = new ConsoleCommandLineFolder(new String[0]);
            this.myProject = project;
            this.myPackageJson = packageJson;
            this.myNpmCommand = npmCommand;
        }

        @Override
        @NotNull
        public ProcessHandler startProcess(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
            NodePackage pkg = (NodePackage)this.computeWithDetailedInvalidNpmPackageError(() -> NpmManager.getInstance(this.myProject).getPackageOrThrow());
            final VirtualFile workingDirectory = this.myPackageJson.getParent();
            if (workingDirectory == null) {
                throw new ExecutionException(JavaScriptBundle.message("dialog.message.cannot.determine.package.json.directory", new Object[0]));
            }
            ProcessHandler processHandler = this.startProcessUsingTargetsApi(workingDirectory, pkg);
            processHandler.putUserData(CONTEXT_PACKAGE_JSON_KEY, (Object)this.myPackageJson);
            final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(this.myProject).externalUpdateStarted(this.myPackageJson, null);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(this.myProject, NpmManager.getNpmInstallPresentableText(pkg));
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.doWhenRefreshed(workingDirectory, () -> {
                        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(myProject);
                        done.run();
                        DaemonCodeAnalyzer.getInstance((Project)myProject).restart();
                        if (event.getExitCode() == 0) {
                            this.scheduleNextInstall();
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$MyRunProfileState$1", "processTerminated"));
                }
            });
            ProcessHandler processHandler2 = processHandler;
            if (processHandler2 == null) {
                MyRunProfileState.$$$reportNull$$$0(3);
            }
            return processHandler2;
        }

        @NotNull
        private <T> T computeWithDetailedInvalidNpmPackageError(@NotNull ThrowableComputable<T, ExecutionException> computable) throws ExecutionException {
            Object object;
            if (computable == null) {
                MyRunProfileState.$$$reportNull$$$0(4);
            }
            try {
                object = computable.compute();
            }
            catch (ExecutionException e) {
                throw new NpmManager.InvalidNpmPackageException(this.myProject, new HtmlBuilder().append(e.getMessage()).append((HtmlChunk)HtmlChunk.p()) + JavaScriptBundle.message("please.specify.package.manager", new Object[0]), () -> InstallNodeLocalDependenciesAction.runAndShowConsole(this.myProject, this.myPackageJson));
            }
            if (object == null) {
                MyRunProfileState.$$$reportNull$$$0(5);
            }
            return (T)object;
        }

        @NotNull
        private ProcessHandler startProcessUsingTargetsApi(@NotNull VirtualFile workingDirectory, @NotNull NodePackage pkg) throws ExecutionException {
            if (workingDirectory == null) {
                MyRunProfileState.$$$reportNull$$$0(6);
            }
            if (pkg == null) {
                MyRunProfileState.$$$reportNull$$$0(7);
            }
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef().resolveNotNull(this.myProject);
            NodeTargetRun targetRun = new NodeTargetRun(interpreter, this.myProject, null, NodeTargetRun.createOptions(ThreeState.YES, List.of()));
            this.configureCommandLine(interpreter, targetRun, workingDirectory, pkg, this.myNpmCommand, this.myFolder);
            ProcessHandler processHandler = targetRun.startProcess();
            if (processHandler == null) {
                MyRunProfileState.$$$reportNull$$$0(8);
            }
            return processHandler;
        }

        private void configureCommandLine(@NotNull NodeJsInterpreter interpreter, @NotNull NodeTargetRun targetRun, @NotNull VirtualFile workingDir, @NotNull NodePackage npmPackage, @NotNull NpmCommand npmCommand, @NotNull ConsoleCommandLineFolder folder) throws ExecutionException {
            if (interpreter == null) {
                MyRunProfileState.$$$reportNull$$$0(9);
            }
            if (targetRun == null) {
                MyRunProfileState.$$$reportNull$$$0(10);
            }
            if (workingDir == null) {
                MyRunProfileState.$$$reportNull$$$0(11);
            }
            if (npmPackage == null) {
                MyRunProfileState.$$$reportNull$$$0(12);
            }
            if (npmCommand == null) {
                MyRunProfileState.$$$reportNull$$$0(13);
            }
            if (folder == null) {
                MyRunProfileState.$$$reportNull$$$0(14);
            }
            TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
            commandLineBuilder.setWorkingDirectory(targetRun.path(workingDir.getPath()));
            targetRun.configureEnvironment(EnvironmentVariablesData.DEFAULT);
            String cliJsFilePath = (String)this.computeWithDetailedInvalidNpmPackageError(() -> NpmUtil.getValidNpmCliJsFilePath(npmPackage, interpreter));
            commandLineBuilder.addParameter(cliJsFilePath);
            folder.addPlaceholderText(NpmManager.getNpmPackagePresentableName(npmPackage));
            String npmCommandStr = npmCommand.getCliOption(NpmUtil.isYarnAlikePackage(npmPackage));
            commandLineBuilder.addParameter(npmCommandStr);
            folder.addPlaceholderText(npmCommandStr);
            if (npmPackage.getName().equals("npm")) {
                commandLineBuilder.addParameter("--scripts-prepend-node-path=auto");
            }
        }

        @Override
        @NotNull
        public ExecutionResult createExecutionResult(@NotNull ProcessHandler processHandler) {
            if (processHandler == null) {
                MyRunProfileState.$$$reportNull$$$0(15);
            }
            ConsoleView console = this.createConsole(processHandler, this.myPackageJson.getParent());
            console.attachToProcess(processHandler);
            ConsoleProgress.install(console, processHandler);
            this.myFolder.foldCommandLine(console, processHandler);
            return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
        }

        private void doWhenRefreshed(@NotNull VirtualFile dir, @NotNull Runnable onDone) {
            if (dir == null) {
                MyRunProfileState.$$$reportNull$$$0(16);
            }
            if (onDone == null) {
                MyRunProfileState.$$$reportNull$$$0(17);
            }
            new SingleAlarm(() -> ReadAction.run(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet<VirtualFile> refreshDirs = new HashSet<VirtualFile>();
                refreshDirs.add(dir);
                PackageJsonUtil.processUpPackageJsonFiles(this.myProject, dir, (Processor<? super VirtualFile>)((Processor)packageJsonFile -> {
                    ContainerUtil.addIfNotNull((Collection)refreshDirs, (Object)packageJsonFile.getParent());
                    return true;
                }));
                AtomicInteger count = new AtomicInteger(refreshDirs.size());
                for (VirtualFile refreshDir : refreshDirs) {
                    refreshDir.refresh(true, true, () -> {
                        if (count.decrementAndGet() == 0 && !this.myProject.isDisposed()) {
                            onDone.run();
                        }
                    });
                }
            }), 300, (Disposable)JSDisposable.getInstance(this.myProject), Alarm.ThreadToUse.POOLED_THREAD).request();
        }

        private void scheduleNextInstall() {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)JSDisposable.getInstance(this.myProject)).addRequest(() -> InstallNodeLocalDependenciesAction.installNext(this.myProject), 2000);
        }

        @NotNull
        private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable VirtualFile dir) {
            if (processHandler == null) {
                MyRunProfileState.$$$reportNull$$$0(18);
            }
            ConsoleView consoleView = NodeCommandLineUtil.createConsole(processHandler, this.myProject, false);
            consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myProject, dir));
            ConsoleView consoleView2 = consoleView;
            if (consoleView2 == null) {
                MyRunProfileState.$$$reportNull$$$0(19);
            }
            return consoleView2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 2: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmCommand";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$MyRunProfileState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDirectory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pkg";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRun";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDir";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmPackage";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onDone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$MyRunProfileState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcess";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeWithDetailedInvalidNpmPackageError";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcessUsingTargetsApi";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConsole";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 19: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computeWithDetailedInvalidNpmPackageError";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "startProcessUsingTargetsApi";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "configureCommandLine";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createExecutionResult";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "doWhenRefreshed";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "createConsole";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstallDepsRunProfile
    implements RunProfile,
    NodeDebugRunConfiguration {
        private final VirtualFile myPackageJson;
        private final NpmCommand myNpmCommand;
        private final String myTitle;

        InstallDepsRunProfile(@NotNull VirtualFile packageJson, @NotNull NpmCommand npmCommand, @NotNull String title) {
            if (packageJson == null) {
                InstallDepsRunProfile.$$$reportNull$$$0(0);
            }
            if (npmCommand == null) {
                InstallDepsRunProfile.$$$reportNull$$$0(1);
            }
            if (title == null) {
                InstallDepsRunProfile.$$$reportNull$$$0(2);
            }
            this.myPackageJson = packageJson;
            this.myNpmCommand = npmCommand;
            this.myTitle = title;
        }

        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
            if (executor == null) {
                InstallDepsRunProfile.$$$reportNull$$$0(3);
            }
            if (environment == null) {
                InstallDepsRunProfile.$$$reportNull$$$0(4);
            }
            return new MyRunProfileState(environment.getProject(), this.myPackageJson, this.myNpmCommand);
        }

        @NotNull
        public String getName() {
            String string = this.myTitle;
            if (string == null) {
                InstallDepsRunProfile.$$$reportNull$$$0(5);
            }
            return string;
        }

        public Icon getIcon() {
            return AllIcons.Actions.Install;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmCommand";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$InstallDepsRunProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/InstallNodeLocalDependenciesAction$InstallDepsRunProfile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getState";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

