/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.indexing.roots.kind.ProjectFileOrDirOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDetectingProjectFileScanner
implements IndexableFileScanner {
    @NotNull
    public IndexableFileScanner.ScanSession startSession(@NotNull Project project) {
        if (project == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(0);
        }
        AtomicBoolean newNodeModulesScanned = new AtomicBoolean(false);
        IndexableFileScanner.ScanSession scanSession = fileSet -> fileSet instanceof ModuleRootOrigin || fileSet instanceof ProjectFileOrDirOrigin ? fileOrDir -> JSDetectingProjectFileScanner.visitFileForNewNodeModules(project, newNodeModulesScanned, fileSet, fileOrDir) : null;
        if (scanSession == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(1);
        }
        return scanSession;
    }

    private static void visitFileForNewNodeModules(@NotNull Project project, @NotNull AtomicBoolean newNodeModulesScanned, @NotNull IndexableSetOrigin fileSet, @NotNull VirtualFile fileOrDir) {
        Runnable outsideReadActionRunnable;
        if (project == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(2);
        }
        if (newNodeModulesScanned == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(3);
        }
        if (fileSet == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(4);
        }
        if (fileOrDir == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(5);
        }
        if ((outsideReadActionRunnable = (Runnable)ReadAction.compute(() -> {
            if (project.isDisposed() || !fileOrDir.isValid()) {
                return null;
            }
            if (fileOrDir.isDirectory()) {
                VirtualFile pnpJs;
                NodeModulesDirectoryManager manager2;
                if (NodeModulesDirectoryManager.isNodeModulesDir(fileOrDir) && !(manager2 = NodeModulesDirectoryManager.getInstance(project)).isAdded(fileOrDir) && manager2.canAddNodeModulesDir(fileOrDir)) {
                    return () -> {
                        AtomicBoolean atomicBoolean = newNodeModulesScanned;
                        synchronized (atomicBoolean) {
                            if (newNodeModulesScanned.compareAndSet(false, true)) {
                                VirtualFile singleRoot = fileSet instanceof ProjectFileOrDirOrigin ? ((ProjectFileOrDirOrigin)fileSet).getFileOrDir() : null;
                                JSDetectingProjectFileScanner.scanAndAddAllNewNodeModulesDirs(manager2, singleRoot);
                            }
                        }
                    };
                }
                VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(fileOrDir);
                if (packageJson != null) {
                    PackageJsonFileManager.getInstance(project).onPackageJsonAdded(packageJson, false);
                }
                if ((pnpJs = YarnPnpManager.findPnpJsFile(fileOrDir)) != null) {
                    YarnPnpManager.getInstance(project).addPnpJsFile(pnpJs);
                }
            }
            return null;
        })) != null) {
            outsideReadActionRunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanAndAddAllNewNodeModulesDirs(@NotNull NodeModulesDirectoryManager manager2, @Nullable VirtualFile singleRoot) {
        if (manager2 == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(6);
        }
        List nodeModulesDirs = Collections.synchronizedList(new ArrayList());
        AtomicBoolean done = new AtomicBoolean(false);
        try {
            JSDetectingProjectFileScanner.scan(manager2.getProject(), singleRoot, fileOrDir -> {
                if (JSDetectingProjectFileScanner.isNewNodeModules(fileOrDir, manager2)) {
                    if (done.get()) {
                        throw new AssertionError((Object)"Visiting file after scan finished");
                    }
                    nodeModulesDirs.add(fileOrDir);
                    return ContentIteratorEx.Status.SKIP_CHILDREN;
                }
                return ContentIteratorEx.Status.CONTINUE;
            });
        }
        finally {
            done.set(true);
            JSDetectingProjectFileScanner.finish(manager2, new ArrayList<VirtualFile>(nodeModulesDirs));
        }
    }

    private static void scan(@NotNull Project project, @Nullable VirtualFile singleRoot, @NotNull ContentIteratorEx iterator) {
        if (project == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(7);
        }
        if (iterator == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(8);
        }
        if (singleRoot != null) {
            ProjectFileIndex fileIndex = (ProjectFileIndex)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)project));
            fileIndex.iterateContentUnderDirectory(singleRoot, (ContentIterator)iterator);
        } else {
            PushedFilePropertiesUpdaterImpl.scanProject((Project)project, module -> iterator);
        }
    }

    private static boolean isNewNodeModules(@NotNull VirtualFile fileOrDir, @NotNull NodeModulesDirectoryManager manager2) {
        if (fileOrDir == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(9);
        }
        if (manager2 == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(10);
        }
        return (Boolean)ReadAction.compute(() -> fileOrDir.isDirectory() && fileOrDir.isValid() && !manager2.getProject().isDisposed() && NodeModulesDirectoryManager.isNodeModulesDir(fileOrDir) && !manager2.isAdded(fileOrDir) && manager2.canAddNodeModulesDir(fileOrDir));
    }

    private static void finish(@NotNull NodeModulesDirectoryManager manager2, @NotNull List<VirtualFile> nodeModulesDirs) {
        if (manager2 == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(11);
        }
        if (nodeModulesDirs == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(12);
        }
        if (!nodeModulesDirs.isEmpty()) {
            ReadAction.run(() -> {
                if (!manager2.getProject().isDisposed()) {
                    manager2.addNodeModulesDirs(nodeModulesDirs);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodeModulesScanned";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startSession";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitFileForNewNodeModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scanAndAddAllNewNodeModulesDirs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNewNodeModules";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

