/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileCache<T> {
    private final Key<CachedValue<T>> myKey;
    private final AtomicInteger myGlobalModCount;

    public VirtualFileCache(@NotNull String keyName) {
        if (keyName == null) {
            VirtualFileCache.$$$reportNull$$$0(0);
        }
        this.myGlobalModCount = new AtomicInteger(0);
        this.myKey = Key.create((String)keyName);
    }

    @Nullable
    public T getValue(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileCache.$$$reportNull$$$0(1);
        }
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(file2);
        CachedValue<Object> cached = (CachedValue<Object>)this.myKey.get((UserDataHolder)file2);
        long fileModificationStamp = file2.getModificationStamp();
        long documentModificationStamp = document2 != null ? document2.getModificationStamp() : -1L;
        int globalModCount = this.myGlobalModCount.get();
        if (cached == null || cached.myFileModificationStamp != fileModificationStamp || cached.myDocumentModificationStamp != documentModificationStamp || cached.myGlobalModCount != globalModCount) {
            CharSequence text = VirtualFileCache.loadText(file2, document2);
            Object value = text != null ? (Object)this.produceValue(file2, text.toString()) : null;
            cached = new CachedValue<Object>(value, fileModificationStamp, documentModificationStamp, globalModCount);
            this.myKey.set((UserDataHolder)file2, cached);
        }
        return cached.myValue;
    }

    @Nullable
    protected abstract T produceValue(@NotNull VirtualFile var1, @NotNull String var2);

    public void cleanCache() {
        this.myGlobalModCount.incrementAndGet();
    }

    @Nullable
    private static CharSequence loadText(@NotNull VirtualFile file2, @Nullable Document fileDocument) {
        if (file2 == null) {
            VirtualFileCache.$$$reportNull$$$0(2);
        }
        if (fileDocument != null) {
            return fileDocument.getCharsSequence();
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file2);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/VirtualFileCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CachedValue<T> {
        private final T myValue;
        private final long myFileModificationStamp;
        private final long myDocumentModificationStamp;
        private final int myGlobalModCount;

        private CachedValue(@Nullable T value, long fileModificationStamp, long documentModificationStamp, int globalModCount) {
            this.myValue = value;
            this.myFileModificationStamp = fileModificationStamp;
            this.myDocumentModificationStamp = documentModificationStamp;
            this.myGlobalModCount = globalModCount;
        }
    }
}

