/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterManager {
    @NonNls
    private static final String NODEJS_INTERPRETER_PATH = "nodejs_interpreter_path";
    @NonNls
    private static final String NODEJS_INTERPRETER_PATH_STUCK_IN_DEFAULT_PROJECT = "nodejs_interpreter_path.stuck_in_default_project";
    @NonNls
    private static final String NPM_PATH_RESET_FOR_DEFAULT_PROJECT = "nodejs_npm_path_reset_for_default_project";
    private final Project myProject;
    private volatile NodeJsInterpreterRef myInterpreterRef;
    private volatile Boolean myInterpreterAvailable;
    private final List<NodeJsInterpreterChangeListener> myChangeListeners;

    public NodeJsInterpreterManager(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(0);
        }
        this.myChangeListeners = new CopyOnWriteArrayList<NodeJsInterpreterChangeListener>();
        this.myProject = project;
    }

    @NotNull
    public static NodeJsInterpreterManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(1);
        }
        NodeJsInterpreterManager nodeJsInterpreterManager = (NodeJsInterpreterManager)project.getService(NodeJsInterpreterManager.class);
        if (nodeJsInterpreterManager == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterManager;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef interpreterRef = this.myInterpreterRef;
        if (interpreterRef == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String reference = propertiesComponent.getValue(NODEJS_INTERPRETER_PATH);
            interpreterRef = StringUtil.isNotEmpty((String)reference) && !"project".equals(reference) ? NodeJsInterpreterRef.create(reference) : NodeJsLocalInterpreterType.createNodeFromPathRef();
            this.myInterpreterRef = interpreterRef;
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = interpreterRef;
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    public void setInterpreterRef(@Nullable NodeJsInterpreterRef interpreterRef) {
        NodeJsInterpreterRef oldInterpreterRef = this.myInterpreterRef;
        this.myInterpreterRef = interpreterRef;
        this.myInterpreterAvailable = null;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (interpreterRef == null) {
            propertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH);
        } else {
            if (interpreterRef.isProjectRef()) {
                throw new IllegalStateException("Project interpreter cannot be set to itself");
            }
            propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreterRef.getReferenceName());
        }
        this.fireInterpreterChangedIfNeeded(oldInterpreterRef, interpreterRef);
    }

    private void fireInterpreterChangedIfNeeded(@Nullable NodeJsInterpreterRef oldInterpreterRef, @Nullable NodeJsInterpreterRef newInterpreterRef) {
        NodeJsInterpreter newInterpreter;
        if (this.myChangeListeners.isEmpty()) {
            return;
        }
        NodeJsInterpreter oldInterpreter = oldInterpreterRef != null ? oldInterpreterRef.resolveWithoutAliases(this.myProject) : null;
        NodeJsInterpreter nodeJsInterpreter = newInterpreter = newInterpreterRef != null ? newInterpreterRef.resolveWithoutAliases(this.myProject) : null;
        if (!Objects.equals(oldInterpreter, newInterpreter)) {
            for (NodeJsInterpreterChangeListener listener2 : this.myChangeListeners) {
                listener2.interpreterChanged(newInterpreter);
            }
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getInterpreterRef().resolveWithoutAliases(this.myProject);
    }

    public void addChangeListener(@NotNull NodeJsInterpreterChangeListener listener2) {
        if (listener2 == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(4);
        }
        this.myChangeListeners.add(listener2);
    }

    boolean isClonedFromDefaultProject() {
        if (this.myProject.isDefault()) {
            return false;
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        PropertiesComponent defaultProjectPropertiesComponent = PropertiesComponent.getInstance((Project)defaultProject);
        defaultProjectPropertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH_STUCK_IN_DEFAULT_PROJECT);
        defaultProjectPropertiesComponent.unsetValue(NPM_PATH_RESET_FOR_DEFAULT_PROJECT);
        String defaultProjectInterpreterPath = defaultProjectPropertiesComponent.getValue(NODEJS_INTERPRETER_PATH);
        String interpreterPath = PropertiesComponent.getInstance((Project)this.myProject).getValue(NODEJS_INTERPRETER_PATH);
        return defaultProjectInterpreterPath != null && defaultProjectInterpreterPath.equals(interpreterPath);
    }

    public boolean isInterpreterAvailable() {
        Boolean available = this.myInterpreterAvailable;
        if (available == null) {
            this.myInterpreterAvailable = available = Boolean.valueOf(this.getInterpreter() != null);
        }
        return available;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

