/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeInterpreterUtil {
    private NodeInterpreterUtil() {
    }

    @Contract(value="null -> !null")
    @InspectionMessage
    public static String validateAndGetErrorMessage(@Nullable NodeJsInterpreter interpreter) {
        return NodeInterpreterUtil.validateAndGetErrorMessage(interpreter, null);
    }

    @Contract(value="null,_ -> !null")
    @InspectionMessage
    private static String validateAndGetErrorMessage(@Nullable NodeJsInterpreter interpreter, @Nullable Project project) {
        if (interpreter == null) {
            return JavaScriptBundle.message("node.interpreter.unspecified.error.text", new Object[0]);
        }
        return interpreter.validate(project);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter) throws RuntimeConfigurationError {
        NodeInterpreterUtil.checkForRunConfiguration(interpreter, null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter, @Nullable Project project) throws RuntimeConfigurationError {
        String errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter, project);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @NotNull
    public static String convertLocalPathToRemote(@NotNull String path2, @Nullable NodeJsInterpreter interpreter) {
        if (path2 == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(0);
        }
        if (interpreter instanceof WslNodeInterpreter) {
            WSLDistribution distribution = Objects.requireNonNull(((WslNodeInterpreter)interpreter).getDistribution());
            String wslPath = distribution.getWslPath(path2);
            if (wslPath != null) {
                String string = wslPath;
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
            String uncPathToWsl = WslCommandLineConfigurator.convertUncPathToWsl(path2, distribution);
            if (uncPathToWsl != null) {
                String string = uncPathToWsl;
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (!path2.startsWith("\\\\")) {
                String string = FileUtil.toSystemIndependentName((String)path2);
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = path2;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String convertRemotePathToLocal(@NotNull String path2, @Nullable NodeJsInterpreter interpreter) {
        if (path2 == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(5);
        }
        if (interpreter instanceof WslNodeInterpreter) {
            WSLDistribution distribution = Objects.requireNonNull(((WslNodeInterpreter)interpreter).getDistribution());
            String wslPath = distribution.getWindowsPath(path2);
            if (wslPath != null) {
                String string = wslPath;
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (path2.startsWith("/")) {
                String string = WslCommandLineConfigurator.convertWslPathToUnc(path2, distribution);
                if (string == null) {
                    NodeInterpreterUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        String string = path2;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static NodeJsInterpreter getValidInterpreterOrThrow(@Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        String error = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter);
        if (error != null) {
            throw new InvalidNodeInterpreter(error);
        }
        NodeJsInterpreter nodeJsInterpreter = interpreter;
        if (nodeJsInterpreter == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(9);
        }
        return nodeJsInterpreter;
    }

    @NotNull
    public static String toRemoteName(@NotNull String path2, @NotNull NodeTargetRun targetRun) {
        Platform target;
        if (path2 == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(10);
        }
        if (targetRun == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(11);
        }
        if ((target = targetRun.getRequest().getTargetPlatform().getPlatform()) == Platform.UNIX && Platform.current() == Platform.WINDOWS) {
            String string = FileUtil.toSystemIndependentName((String)path2);
            if (string == null) {
                NodeInterpreterUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            NodeInterpreterUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean supportsNodeOptions(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer nodeVersion) {
        NodeJsLocalInterpreter localInterpreter = (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsLocalInterpreter.class);
        if (localInterpreter != null && localInterpreter.isElectron()) {
            return true;
        }
        return nodeVersion == null || nodeVersion.isGreaterOrEqualThan(8, 0, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeInterpreterUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeInterpreterUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLocalPathToRemote";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRemotePathToLocal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidInterpreterOrThrow";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toRemoteName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLocalPathToRemote";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertRemotePathToLocal";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toRemoteName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidNodeInterpreter
    extends ExecutionException {
        public InvalidNodeInterpreter(@NlsContexts.DialogMessage String message) {
            super(message);
        }
    }
}

