/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.util.JsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodePackageVersionUtil {
    private static final Logger LOG = Logger.getInstance(NodePackageVersionUtil.class);
    private static final Map<String, TimestampedVersion> PACKAGE_VERSION_CACHE = Collections.synchronizedMap(new FixedHashMap(10));

    @Nullable
    public static NodePackageVersion getPackageVersion(@NotNull String packageDirPath) {
        if (packageDirPath == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(0);
        }
        return NodePackageVersionUtil.getPackageVersionByPackageJson(new File(packageDirPath, "package.json"));
    }

    @Nullable
    public static SemVer getPackageVersion(@NotNull File packageDir2) {
        NodePackageVersion packageVersion;
        if (packageDir2 == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(1);
        }
        return (packageVersion = NodePackageVersionUtil.getPackageVersionByPackageJson(new File(packageDir2, "package.json"))) != null ? packageVersion.getSemVer() : null;
    }

    @Nullable
    private static NodePackageVersion getPackageVersionByPackageJson(@NotNull File packageJson) {
        if (packageJson == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(2);
        }
        if (!packageJson.isFile()) {
            return null;
        }
        String path2 = packageJson.getAbsolutePath();
        TimestampedVersion r = PACKAGE_VERSION_CACHE.get(path2);
        if (r == null || !r.isUpToDate(packageJson)) {
            NodePackageVersion packageVersion = NodePackageVersionUtil.calc(packageJson);
            r = new TimestampedVersion(packageJson, packageVersion);
            PACKAGE_VERSION_CACHE.put(path2, r);
        }
        return r.getPackageVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static NodePackageVersion calc(@NotNull File packageJson) {
        if (packageJson == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(3);
        }
        JsonReader jsonReader = null;
        try {
            BufferedReader reader = Files.newReader((File)packageJson, (Charset)StandardCharsets.UTF_8);
            jsonReader = new JsonReader((Reader)reader);
            NodePackageVersion nodePackageVersion = NodePackageVersionUtil.parseNodePackageVersion(jsonReader);
            return nodePackageVersion;
        }
        catch (IOException e) {
            LOG.warn("Failed to parse " + packageJson.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Nullable
    private static NodePackageVersion parseNodePackageVersion(@NotNull JsonReader reader) throws IOException {
        JsonToken token;
        if (reader == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(4);
        }
        if ((token = reader.peek()) != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        SemVer semVer = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("version".equals(key)) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (value == null) continue;
                semVer = SemVer.parseFromText((String)value);
                continue;
            }
            if ("name".equals(key)) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return new NodePackageVersion(name, semVer);
    }

    public static int comparePackageVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(5);
        }
        if (version2 == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(6);
        }
        if ((version1 = version1.trim()).equals(version2 = version2.trim())) {
            return 0;
        }
        SemVer ver1 = SemVer.parseFromText((String)version1);
        SemVer ver2 = SemVer.parseFromText((String)version2);
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        int result2 = ver1.compareTo(ver2);
        if (result2 == 0) {
            if (version1.equals(ver1.getParsedVersion())) {
                return 1;
            }
            if (version2.equals(ver2.getParsedVersion())) {
                return -1;
            }
            result2 = PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/NodePackageVersionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageVersionByPackageJson";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseNodePackageVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePackageVersions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TimestampedVersion {
        private final long myFileLastModified;
        private final long myVfsModificationStamp;
        private final NodePackageVersion myPackageVersion;

        private TimestampedVersion(@NotNull File packageJson, @Nullable NodePackageVersion packageVersion) {
            if (packageJson == null) {
                TimestampedVersion.$$$reportNull$$$0(0);
            }
            this.myFileLastModified = packageJson.lastModified();
            this.myVfsModificationStamp = TimestampedVersion.getVfsModificationStamp(packageJson);
            this.myPackageVersion = packageVersion;
        }

        @Nullable
        public NodePackageVersion getPackageVersion() {
            return this.myPackageVersion;
        }

        public boolean isUpToDate(@NotNull File packageJson) {
            if (packageJson == null) {
                TimestampedVersion.$$$reportNull$$$0(1);
            }
            return this.myFileLastModified == packageJson.lastModified() && this.myVfsModificationStamp == TimestampedVersion.getVfsModificationStamp(packageJson);
        }

        private static long getVfsModificationStamp(@NotNull File packageJson) {
            if (packageJson == null) {
                TimestampedVersion.$$$reportNull$$$0(2);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return -1L;
            }
            VirtualFile vfsPackageJson = LocalFileSystem.getInstance().findFileByIoFile(packageJson);
            return vfsPackageJson != null ? vfsPackageJson.getModificationStamp() : -1L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "packageJson";
            objectArray2[1] = "com/intellij/javascript/nodejs/NodePackageVersionUtil$TimestampedVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUpToDate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVfsModificationStamp";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

