/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreterType;
import com.intellij.javascript.nodejs.npm.InstallNodeLocalDependenciesAction;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NodeJsCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "nodejs";
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        String string = JavaScriptBundle.message("js.commandline.configure.nodejs", new Object[0]);
        if (string == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        List<NodeJsDownloadableInterpreter> interpreters;
        if (context == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(1);
        }
        if ((interpreters = NodeJsDownloadableInterpreterType.getInstance().getInterpretersIfActive()).size() > 0) {
            NodeJsDownloadService.install(interpreters.get(0), null);
        }
    }

    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        if (project == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            NodeJsCommandLineInspectionProjectConfigurator.$$$reportNull$$$0(3);
        }
        final CommandLineInspectionProgressReporter logger = context.getLogger();
        Set<VirtualFile> packageJsons = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
        context.getLogger().reportMessage(1, "Detected " + packageJsons.size() + " package.json files under the project to install dependencies");
        double i2 = 0.0;
        ProgressIndicator indicator = context.getProgressIndicator();
        indicator.setIndeterminate(false);
        for (VirtualFile packageJson : packageJsons) {
            double d = i2;
            i2 = d + 1.0;
            indicator.setFraction(d / (double)packageJsons.size());
            if (context.getVirtualFilesFilter().test(packageJson)) {
                logger.reportMessage(2, "File " + packageJson + " is skipped");
                continue;
            }
            try {
                NodeCommandLineConfigurator configurer = NodeCommandLineConfigurator.find(NodeJsInterpreterManager.getInstance(project).getInterpreterRef(), project);
                NodePackage pkg = NpmManager.getInstance(project).getPackageOrThrow();
                VirtualFile dir = packageJson.getParent();
                GeneralCommandLine commandLine = InstallNodeLocalDependenciesAction.createCommandLine(configurer, dir, pkg, NpmCommand.INSTALL, new ConsoleCommandLineFolder(new String[0]));
                OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        logger.reportMessage(3, event.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                processHandler.startNotify();
                processHandler.waitFor();
                dir.refresh(false, true);
            }
            catch (ExecutionException e) {
                logger.reportMessage(1, "Error while running npm install: " + e.getMessage());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeJsCommandLineInspectionProjectConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

