/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReference
extends FileReference
implements JSModuleBaseReference {
    public static final String[] IMPLICIT_EXTENSIONS = new String[]{".coffee", ".ts", ".tsx", ".d.ts", ".d.tsx", ".jsx", ".es6", ".js.flow", ".js", ".json", ".node", ".vue", ".mjs", ".cjs"};
    private static final Map<String[], String[]> ourSortedExtensions = ContainerUtil.createConcurrentSoftMap();
    private final String[] myImplicitExtensions;

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            JSFileReference.$$$reportNull$$$0(0);
        }
        this(text, offset, textRange, fileReferenceSet, IMPLICIT_EXTENSIONS);
    }

    public JSFileReference(String refText, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            JSFileReference.$$$reportNull$$$0(1);
        }
        super(fileReferenceSet, textRange, offset, JSStringUtil.unescapeStringLiteralValue(refText));
        this.myImplicitExtensions = JSFileReference.withCurrentFileExtension(implicitExtensions, fileReferenceSet.getElement());
    }

    protected boolean isPreferImplicitExtension() {
        return false;
    }

    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(3);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(4);
        }
        if (!this.isLast()) {
            this.simpleInnerResolveInContext(referenceText, context, results, caseSensitive);
            return;
        }
        if (this.isAcceptableEmptyReference(referenceText)) {
            this.innerResolveWithoutImplicitExtensions(referenceText, context, results, caseSensitive);
            return;
        }
        int size = results.size();
        if (this.isPreferImplicitExtension()) {
            this.innerResolveWithExtensions(referenceText, context, results, caseSensitive, this.getImplicitExtensions());
            if (size == results.size()) {
                this.innerResolveWithoutImplicitExtensions(referenceText, context, results, caseSensitive);
            }
        } else {
            this.innerResolveWithoutImplicitExtensions(referenceText, context, results, caseSensitive);
            if (size == results.size()) {
                this.innerResolveWithExtensions(referenceText, context, results, caseSensitive, this.getImplicitExtensions());
            }
        }
    }

    protected void innerResolveWithExtensions(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean caseSensitive, String @NotNull [] extensions) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(6);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(7);
        }
        if (extensions == null) {
            JSFileReference.$$$reportNull$$$0(8);
        }
        int size = results.size();
        for (String extension : extensions) {
            if (referenceText.endsWith(extension)) continue;
            this.simpleInnerResolveInContext(referenceText + extension, context, results, caseSensitive);
            if (size != results.size()) {
                this.filterImplicitElementsResolveInContext(referenceText, context, results, caseSensitive);
            }
            if (size != results.size() && this.shouldStopImplicitExtensionProcessing(extension)) break;
        }
    }

    protected void innerResolveWithoutImplicitExtensions(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(10);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(11);
        }
        if (TypeScriptFileImportsResolver.hasJsExtension(referenceText)) {
            int size = results.size();
            String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)referenceText);
            this.innerResolveWithExtensions(nameWithoutExtension, context, results, caseSensitive, TypeScriptFileImportsResolver.TS_EXTENSIONS);
            if (size != results.size()) {
                return;
            }
        }
        SmartList candidates = new SmartList();
        this.simpleInnerResolveInContext(referenceText, context, (Collection<ResolveResult>)candidates, caseSensitive);
        if (!candidates.isEmpty()) {
            this.processDefaultResolveElements((Collection<? extends ResolveResult>)candidates, results);
        }
    }

    protected boolean shouldStopImplicitExtensionProcessing(@NotNull String currentExtension) {
        if (currentExtension == null) {
            JSFileReference.$$$reportNull$$$0(12);
        }
        return true;
    }

    protected boolean isAcceptableEmptyReference(@NotNull String referenceText) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(13);
        }
        return referenceText.isEmpty() && !this.getFileReferenceSet().isEndingSlashNotAllowed();
    }

    protected final void simpleInnerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSFileReference.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(15);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(16);
        }
        super.innerResolveInContext(referenceText, context, results, caseSensitive);
    }

    protected void filterImplicitElementsResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results, boolean sensitive) {
        if (text == null) {
            JSFileReference.$$$reportNull$$$0(17);
        }
        if (context == null) {
            JSFileReference.$$$reportNull$$$0(18);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(19);
        }
    }

    public String[] getImplicitExtensions() {
        return this.myImplicitExtensions;
    }

    protected final void processDefaultResolveElements(@NotNull Collection<? extends ResolveResult> candidates, @NotNull Collection<? super ResolveResult> results) {
        if (candidates == null) {
            JSFileReference.$$$reportNull$$$0(20);
        }
        if (results == null) {
            JSFileReference.$$$reportNull$$$0(21);
        }
        for (ResolveResult resolveResult : candidates) {
            boolean hasNewElements;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiFileSystemItem) || !((PsiFileSystemItem)element).isDirectory()) {
                results.add((ResolveResult)resolveResult);
                continue;
            }
            Collection<ResolveResult> resolvedDirectoryElements = this.resolveDirectory((PsiFileSystemItem)element);
            boolean bl = hasNewElements = !resolvedDirectoryElements.isEmpty();
            if (hasNewElements) {
                results.addAll(resolvedDirectoryElements);
            }
            if (!this.isAllowFolders() || hasNewElements) continue;
            results.add((ResolveResult)resolveResult);
        }
    }

    @NotNull
    protected Collection<ResolveResult> resolveDirectory(@NotNull PsiFileSystemItem directory) {
        if (directory == null) {
            JSFileReference.$$$reportNull$$$0(22);
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            JSFileReference.$$$reportNull$$$0(23);
        }
        return list2;
    }

    protected boolean isAllowFolders() {
        return false;
    }

    @NotNull
    public String getFileNameToCreate() {
        VirtualFile vFile;
        PsiFile psiFile;
        String text = this.getText();
        if (!StringUtil.containsChar((String)text, (char)'.') && this.isLast() && (psiFile = this.getElement().getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
            String string = text + "." + vFile.getExtension();
            if (string == null) {
                JSFileReference.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = super.getFileNameToCreate();
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(25);
        }
        return string;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (this.isLast()) {
            newName = this.fixLastNameForRename(newName);
        }
        return super.rename(this.fixRelativePath(newName));
    }

    @NotNull
    protected String fixLastNameForRename(@NotNull String newName) {
        if (newName == null) {
            JSFileReference.$$$reportNull$$$0(26);
        }
        String string = this.fixExtension(newName);
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private String fixRelativePath(String newName) {
        FileReference firstRef;
        String refText;
        if (!this.getFileReferenceSet().isAbsolutePathReference() && (".".equals(refText = (firstRef = this.getFileReferenceSet().getReference(0)).getText()) || refText != null && refText.startsWith("..")) && !((String)newName).startsWith("..")) {
            newName = "./" + (String)newName;
        }
        String string = newName;
        if (string == null) {
            JSFileReference.$$$reportNull$$$0(28);
        }
        return string;
    }

    protected String fixExtension(String newName) {
        return this.fixExtension(newName, this.getText());
    }

    protected String fixExtension(String newName, String oldRefText) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String newImplicitExtension = JSFileReference.findExtension(newName, extensions);
        String textImplicitExtension = JSFileReference.findExtension(oldRefText, extensions);
        if (newImplicitExtension != null && textImplicitExtension == null || oldRefText.indexOf(46) == -1) {
            int indexNameWithoutExtension;
            int n = indexNameWithoutExtension = newImplicitExtension != null ? newName.length() - newImplicitExtension.length() : newName.lastIndexOf(46);
            if (indexNameWithoutExtension != -1) {
                int lastIndexOfSeparator = newImplicitExtension != null ? -1 : newName.lastIndexOf(47);
                newName = indexNameWithoutExtension > lastIndexOfSeparator ? newName.substring(0, indexNameWithoutExtension) : newName;
            }
        }
        return newName;
    }

    public String @NotNull [] getSortedByLengthImplicitExtensions() {
        String[] extensions = this.getImplicitExtensions();
        Arrays.sort(extensions, Comparator.comparing(String::length).reversed());
        if (extensions == null) {
            JSFileReference.$$$reportNull$$$0(29);
        }
        return extensions;
    }

    protected PsiElement fixRefText(String name) {
        return super.fixRefText(this.fixExtension(name));
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(30);
        }
        return this.bindToElement(element, absolute, this.isRelativeCommonPath());
    }

    protected PsiElement bindToElement(@NotNull PsiElement element, boolean absolute, boolean isRelativeCommonPath) throws IncorrectOperationException {
        String path2;
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(31);
        }
        if (!isRelativeCommonPath && JSFileReference.checkReferencedFileFromNodeModules(element)) {
            return this.getElement();
        }
        if ((!isRelativeCommonPath || absolute) && (path2 = JSFileReference.getPathFromDefaultContext(this.getFileReferenceSet(), element, absolute)) != null) {
            return this.rename(path2);
        }
        return super.bindToElement(element, absolute);
    }

    protected static String getPathFromDefaultContext(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element, boolean absolute) {
        List filteredContexts;
        VirtualFile dstVFile;
        String path2;
        Collection<PsiFileSystemItem> defaultContexts;
        if (referenceSet == null) {
            JSFileReference.$$$reportNull$$$0(32);
        }
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(33);
        }
        if ((defaultContexts = JSFileReference.getDefaultResolveContextsForBind(referenceSet, element)).size() > 0 && (path2 = JSFileReferencesUtil.getShortestPathInContexts(dstVFile = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : null, filteredContexts = ContainerUtil.map(defaultContexts, el -> el.getVirtualFile()), true)) != null) {
            return absolute && referenceSet.absoluteUrlNeedsStartSlash() && !path2.startsWith("/") ? "/" + path2 : path2;
        }
        return null;
    }

    @NotNull
    protected static Collection<PsiFileSystemItem> getDefaultResolveContextsForBind(@NotNull FileReferenceSet referenceSet, @NotNull PsiElement element) {
        if (referenceSet == null) {
            JSFileReference.$$$reportNull$$$0(34);
        }
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(35);
        }
        Collection allDefaultContexts = referenceSet.getDefaultContexts();
        FileReference firstRef = referenceSet.getReference(0);
        PsiFileSystemItem resolvedFirstRef = firstRef.resolve();
        if (resolvedFirstRef != null && resolvedFirstRef != element) {
            PsiFileSystemItem contextDir = resolvedFirstRef.getParent();
            List list2 = allDefaultContexts.contains(contextDir) ? ContainerUtil.createMaybeSingletonList((Object)contextDir) : ContainerUtil.emptyList();
            if (list2 == null) {
                JSFileReference.$$$reportNull$$$0(36);
            }
            return list2;
        }
        return new LinkedHashSet<PsiFileSystemItem>(allDefaultContexts);
    }

    public boolean isRelativeCommonPath() {
        String path2 = this.getFileReferenceSet().getPathString();
        return path2.startsWith(".");
    }

    public static boolean checkReferencedFileFromNodeModules(@NotNull PsiElement element) {
        VirtualFile file2;
        if (element == null) {
            JSFileReference.$$$reportNull$$$0(37);
        }
        return (file2 = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && JSLibraryUtil.hasDirectoryInPath(file2, "node_modules", null);
    }

    @Contract(value="null, _ -> null")
    public static String findExtension(@Nullable CharSequence fileName, String[] extensionsWithDot) {
        Object[] sorted = ourSortedExtensions.get(extensionsWithDot);
        if (sorted == null) {
            Object[] newArray = (String[])extensionsWithDot.clone();
            ContainerUtil.sort((Object[])newArray, Comparator.comparing(el -> -el.length()));
            ourSortedExtensions.put(extensionsWithDot, (String[])newArray);
            sorted = newArray;
        }
        if (fileName == null) {
            return null;
        }
        for (String string : sorted) {
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)string)) continue;
            return string;
        }
        return null;
    }

    @Contract(value="!null,_ -> !null")
    public static String getFileNameWithoutExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        String extension = JSFileReference.findExtension(fileName, extensions);
        return extension != null ? fileName.substring(0, fileName.length() - extension.length()) : FileUtilRt.getNameWithoutExtension((String)fileName);
    }

    @Contract(value="null -> null")
    public static String findImplicitExtension(@Nullable String fileName) {
        return JSFileReference.findExtension(fileName, IMPLICIT_EXTENSIONS);
    }

    public static String[] withCurrentFileExtension(String[] implicitExtensions, PsiElement element) {
        String extension;
        PsiFile file2 = element.getContainingFile();
        if (element instanceof CssElement && !(file2 instanceof StylesheetFile)) {
            CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)element, CssStylesheet.class);
            LanguageFileType fileType = stylesheet != null ? stylesheet.getLanguage().getAssociatedFileType() : null;
            extension = fileType != null ? fileType.getDefaultExtension() : null;
        } else {
            extension = FileUtilRt.getExtension((String)file2.getName());
        }
        return !StringUtil.isEmpty((String)extension) && !ArrayUtil.contains((Object)implicitExtensions, (Object[])new Serializable[]{extension}) ? (String[])ArrayUtil.append((Object[])implicitExtensions, (Object)("." + extension)) : implicitExtensions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentExtension";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSFileReference";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSFileReference";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectory";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLastNameForRename";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "fixRelativePath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedByLengthImplicitExtensions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultResolveContextsForBind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveWithExtensions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveWithoutImplicitExtensions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopImplicitExtensionProcessing";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEmptyReference";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "simpleInnerResolveInContext";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterImplicitElementsResolveInContext";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultResolveElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectory";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 36: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fixLastNameForRename";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromDefaultContext";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResolveContextsForBind";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencedFileFromNodeModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

