/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishConfigBase;
import com.intellij.javaee.oss.glassfish.server.GlassfishConfigNames;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfigProcessor;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class GlassfishVirtualServersConfig
extends GlassfishConfigBase
implements GlassfishConfigNames {
    private static final GlassfishConfigBase.GlassfishConfigFactoryBase<GlassfishVirtualServersConfig> FACTORY = new GlassfishConfigBase.GlassfishConfigFactoryBase<GlassfishVirtualServersConfig>(){

        @NotNull
        public GlassfishVirtualServersConfig createConfig(GlassfishLocalModel data) {
            return new GlassfishVirtualServersConfig(data);
        }
    };
    private final List<String> myVirtualServers = new ArrayList<String>();

    private GlassfishVirtualServersConfig(GlassfishLocalModel model) {
        super(model);
    }

    protected void update(GlassfishLocalModel data) {
        this.myVirtualServers.clear();
        new GlassfishDomainConfigProcessor(this.getDomainConfig()){

            @Override
            protected void doProcessConfig(File file, Document doc, Element serverConfig) throws IOException {
                Element httpService = serverConfig.getChild("http-service");
                if (httpService == null) {
                    return;
                }
                List virtualServers = 2.getChildren((Element)httpService, (String)"virtual-server");
                for (Element virtualServer : virtualServers) {
                    String virtualServerId = virtualServer.getAttributeValue("id");
                    if ("__asadmin".equals(virtualServerId)) continue;
                    GlassfishVirtualServersConfig.this.myVirtualServers.add(virtualServerId);
                }
            }
        }.processConfig();
    }

    public static List<String> get(GlassfishLocalModel model) {
        GlassfishVirtualServersConfig config = FACTORY.get(model);
        return config != null ? config.myVirtualServers : Collections.emptyList();
    }
}

