/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfigProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public abstract class GlassfishJavaConfigProcessor
extends GlassfishDomainConfigProcessor {
    private static final Logger LOG = Logger.getInstance(GlassfishJavaConfigProcessor.class);
    @NonNls
    private static final String JAVA_CONFIG_ELEMENT = "java-config";

    public GlassfishJavaConfigProcessor(GlassfishDomainConfig domainConfig) {
        super(domainConfig);
    }

    @Override
    protected void doProcessConfig(File file, Document doc, Element serverConfig) throws IOException, JDOMException {
        Element javaConfig = GlassfishJavaConfigProcessor.getOrCreateChild((Element)serverConfig, (String)JAVA_CONFIG_ELEMENT);
        Ref save = new Ref((Object)false);
        this.doProcessJavaConfig(file, doc, serverConfig, javaConfig, (Ref<Boolean>)save);
        if (((Boolean)save.get()).booleanValue()) {
            File tmp = FileUtil.createTempFile((File)file.getParentFile(), (String)file.getName(), null, (boolean)true);
            JDOMUtil.writeDocument((Document)doc, (File)tmp, (String)"\n");
            LOG.assertTrue(file.delete());
            LOG.assertTrue(tmp.renameTo(file));
        }
    }

    protected abstract void doProcessJavaConfig(File var1, Document var2, Element var3, Element var4, Ref<Boolean> var5) throws IOException, JDOMException;
}

