/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.admin;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.VendorSpecificAgent;
import com.intellij.javaee.oss.glassfish.server.GlassfishExtensions;
import com.intellij.javaee.oss.glassfish.server.GlassfishRemoteModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishServerModel;
import com.intellij.javaee.oss.server.JavaeeDeploymentModelWithContext;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.ui.packaging.EarArtifactType;
import com.intellij.javaee.ui.packaging.EjbJarArtifactType;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Glassfish3AdminServerBase
extends JavaeeAgentAdminServerBase {
    private final boolean mySecured;
    private final GlassfishServerModel myServerModel;
    private final boolean mySpecifyName;

    protected Glassfish3AdminServerBase(@NotNull AgentProxyFactory agentProxyFactory, @NotNull List<File> libraries, @NotNull String specificsJarPath, @NotNull String agentClassName, boolean secured, @NotNull GlassfishServerModel serverModel, boolean specifyName, @NotNull Consumer<RemoteAgentManager.Builder<VendorSpecificAgent>> builderInitializer) throws Exception {
        if (agentProxyFactory == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(0);
        }
        if (libraries == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(1);
        }
        if (specificsJarPath == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(2);
        }
        if (agentClassName == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(3);
        }
        if (serverModel == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(4);
        }
        if (builderInitializer == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(5);
        }
        super(Glassfish3AdminServerBase.createAgentProxy(agentProxyFactory, libraries, specificsJarPath, agentClassName, builderInitializer));
        this.mySecured = secured;
        this.myServerModel = serverModel;
        this.mySpecifyName = specifyName;
    }

    private static VendorSpecificAgent createAgentProxy(@NotNull AgentProxyFactory agentProxyFactory, @NotNull List<File> libraries, @NotNull String specificsJarPath, @NotNull String agentClassName, @NotNull Consumer<RemoteAgentManager.Builder<VendorSpecificAgent>> builderInitializer) throws Exception {
        if (agentProxyFactory == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(6);
        }
        if (libraries == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(7);
        }
        if (specificsJarPath == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(8);
        }
        if (agentClassName == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(9);
        }
        if (builderInitializer == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(10);
        }
        RemoteAgentManager.Builder builder = RemoteAgentManager.getInstance().createAgentBuilder((RemoteAgentProxyFactory)agentProxyFactory, VendorSpecificAgent.class, Glassfish3AdminServerBase.class).withRtDependency(ILogger.class).withInstanceLibraries(libraries);
        Glassfish3AdminServerBase.appendModuleDependency(Glassfish3AdminServerBase.appendModuleDependency(builderInitializer, "intellij.javaee.appServers.glassfish.v3.base.agent.rt", specificsJarPath), "intellij.javaee.appServers.glassfish.agent.rt", specificsJarPath).accept((RemoteAgentManager.Builder<VendorSpecificAgent>)builder);
        return (VendorSpecificAgent)builder.buildAgent(agentClassName);
    }

    @NotNull
    protected static Consumer<RemoteAgentManager.Builder<VendorSpecificAgent>> appendModuleDependency(@NotNull Consumer<RemoteAgentManager.Builder<VendorSpecificAgent>> builderInitializer, @NotNull String moduleName, @NotNull String specificsJarPath) {
        if (builderInitializer == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(11);
        }
        if (moduleName == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(12);
        }
        if (specificsJarPath == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(13);
        }
        Consumer<RemoteAgentManager.Builder<VendorSpecificAgent>> consumer = builderInitializer.andThen(builder -> builder.withModuleDependency(moduleName, specificsJarPath));
        if (consumer == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(14);
        }
        return consumer;
    }

    public void start(String host, int port, String username, String password, JavaeeAdminStartCallback callback) throws Exception {
        if (this.myServerModel instanceof GlassfishRemoteModel) {
            GlassfishRemoteModel model = (GlassfishRemoteModel)this.myServerModel;
            host = model.getAdminServerHost();
            port = model.getAdminServerPort();
        }
        super.start(host, port, username, password, callback);
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) {
        String appName = JavaeeDeploymentProvider.getFacetDefinedDeploymentName((DeploymentModel)deployment);
        if (appName != null) {
            String string = appName;
            if (string == null) {
                Glassfish3AdminServerBase.$$$reportNull$$$0(15);
            }
            return string;
        }
        String sourceFilename = source.getName();
        Artifact artifact = deployment.getArtifact();
        if (Glassfish3AdminServerBase.isValidExtension(artifact != null ? artifact.getArtifactType() : null, FileUtilRt.getExtension((String)sourceFilename))) {
            String string = FileUtilRt.getNameWithoutExtension((String)sourceFilename);
            if (string == null) {
                Glassfish3AdminServerBase.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = sourceFilename;
        if (string == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean isValidExtension(@Nullable ArtifactType artifactType, @NotNull String extension) {
        if (extension == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(18);
        }
        GlassfishExtensions extensions = GlassfishExtensions.getInstance();
        if (artifactType != null) {
            return extensions.isValidExtension(artifactType, extension);
        }
        return Registry.is((String)"glassfish.check.external.source.extension", (boolean)true) && Glassfish3AdminServerBase.isValidExtension(extension, extensions, new ArtifactType[]{EarArtifactType.getInstance(), WarArtifactType.getInstance(), EjbJarArtifactType.getInstance(), JarArtifactType.getInstance()});
    }

    private static boolean isValidExtension(@NotNull String extension, @NotNull GlassfishExtensions extensions, ArtifactType ... artifactTypes) {
        if (extension == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(19);
        }
        if (extensions == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(20);
        }
        if (artifactTypes == null) {
            Glassfish3AdminServerBase.$$$reportNull$$$0(21);
        }
        for (ArtifactType artifactType : artifactTypes) {
            if (!extensions.isValidExtension(artifactType, extension)) continue;
            return true;
        }
        return false;
    }

    protected void setupInitParameters(ParametersMap initParameters) {
        boolean isCluster;
        initParameters.put((Object)"is.secured", (Object)Boolean.toString(this.mySecured));
        boolean bl = isCluster = this.myServerModel instanceof GlassfishRemoteModel && ((GlassfishRemoteModel)this.myServerModel).isDeployOnCluster();
        if (!isCluster) {
            initParameters.put((Object)"virtual.server", (Object)this.myServerModel.getVirtualServer());
        }
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) throws Exception {
        GlassfishServerModel serverModel = (GlassfishServerModel)deployment.getCommonModel().getServerModel();
        String sourcePath = source.getAbsolutePath();
        boolean useGlassfishUpload = false;
        if (serverModel instanceof GlassfishRemoteModel) {
            GlassfishRemoteModel remoteServerModel = (GlassfishRemoteModel)serverModel;
            if (remoteServerModel.isDeployOnCluster()) {
                deployParameters.put((Object)"deploy.target", (Object)remoteServerModel.CLUSTER_NAME);
            }
            if (remoteServerModel.isUploadWithGlassfish()) {
                useGlassfishUpload = true;
            } else {
                sourcePath = remoteServerModel.prepareDeployment(sourcePath, false);
            }
        }
        deployParameters.put((Object)"use.glassfish.upload", (Object)Boolean.toString(useGlassfishUpload));
        deployParameters.put((Object)"keep.sessions", (Object)Boolean.toString(serverModel.PRESERVE));
        deployParameters.put((Object)"compatibility", (Object)Boolean.toString(serverModel.COMPATIBILITY));
        JavaeeDeploymentModelWithContext glassfishDeployment = (JavaeeDeploymentModelWithContext)deployment;
        deployParameters.put((Object)"is.default.context.root", (Object)Boolean.toString(glassfishDeployment.isDefaultContextRoot()));
        deployParameters.put((Object)"context.root", (Object)glassfishDeployment.getContextRoot());
        deployParameters.put((Object)"source.path", (Object)sourcePath);
        boolean specifyName = this.mySpecifyName || deployment.getArtifact() == null;
        deployParameters.put((Object)"specify.name", (Object)Boolean.toString(specifyName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentProxyFactory";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificsJarPath";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentClassName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverModel";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderInitializer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/glassfish/admin/Glassfish3AdminServerBase";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/glassfish/admin/Glassfish3AdminServerBase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "appendModuleDependency";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAgentProxy";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendModuleDependency";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isValidExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

