/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopBundle;
import com.intellij.aop.AopCommonIcons;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.AopProvider;
import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.aop.jam.AopIntroductionImpl;
import com.intellij.aop.jam.AopLanguageInjector;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.JamNavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AopJavaAnnotator
extends LineMarkerProviderDescriptor {
    @NlsSafe
    public String getName() {
        return "AOP (Java)";
    }

    public Icon getIcon() {
        return AopCommonIcons.Abstract_advice;
    }

    private static Icon createFromIcon(@NotNull Icon icon) {
        if (icon == null) {
            AopJavaAnnotator.$$$reportNull$$$0(0);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(icon, 0);
        layeredIcon.setIcon(AopCommonIcons.From_arrow, 1);
        return layeredIcon;
    }

    private static Icon createToIcon(@NotNull Icon icon) {
        if (icon == null) {
            AopJavaAnnotator.$$$reportNull$$$0(1);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(icon, 0);
        layeredIcon.setIcon(AopCommonIcons.To_arrow, 1);
        return layeredIcon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            AopJavaAnnotator.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            AopJavaAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            AopJavaAnnotator.$$$reportNull$$$0(4);
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement element = elements.get(i);
            AopJavaAnnotator.annotate(element, result);
        }
    }

    private static void annotate(PsiElement psiElement, Collection<? super LineMarkerInfo<?>> result) {
        if (!(psiElement instanceof PsiIdentifier)) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (method.isConstructor()) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            PsiClass psiClass = method.getContainingClass();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)method);
            if (module != null && psiClass != null) {
                AopAdviceImpl advice;
                List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiClass);
                if (providers.isEmpty()) {
                    return;
                }
                if (AopJavaAnnotator.isAcceptableAdviceMethod(psiClass, providers) && (advice = JamAopModel.getAdvice(method)) != null) {
                    AopJavaAnnotator.annotateAdviceMethod(result, advice, nameIdentifier);
                    return;
                }
                Set<AopAspect> aspects = AopJavaAnnotator.getAspects(psiClass);
                Map<AopAdvice, Integer> boundAdvices = AopJavaAnnotator.addBoundAdvices(method, aspects, providers);
                if (!boundAdvices.isEmpty()) {
                    result.add((LineMarkerInfo<?>)AopJavaAnnotator.addNavigationToBoundAdvices(boundAdvices).createLineMarkerInfo((PsiElement)nameIdentifier));
                }
            }
        } else if (parent instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)parent;
            if (psiClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            List<AopIntroduction> boundIntros = AopJavaAnnotator.getBoundIntroductions(psiClass);
            if (!boundIntros.isEmpty()) {
                result.add((LineMarkerInfo<?>)AopJavaAnnotator.addNavigationToBoundIntroductions(boundIntros).createLineMarkerInfo((PsiElement)nameIdentifier));
            }
        } else if (parent instanceof PsiField) {
            PsiField field = (PsiField)parent;
            PsiIdentifier nameIdentifier = field.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            PsiClass psiClass = field.getContainingClass();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)field);
            if (module != null && psiClass != null) {
                NavigationGutterIconBuilder<PsiElement> builder;
                List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiClass);
                if (providers.isEmpty()) {
                    return;
                }
                AopIntroductionImpl introduction = JamAopModel.getIntroduction(field);
                if (introduction != null && (builder = AopJavaAnnotator.addNavigationToIntroducedClasses(introduction)) != null) {
                    result.add((LineMarkerInfo<?>)builder.createLineMarkerInfo((PsiElement)nameIdentifier));
                }
            }
        }
    }

    private static void annotateAdviceMethod(Collection<? super LineMarkerInfo<?>> result, AopAdviceImpl advice, PsiIdentifier nameIdentifier) {
        PsiPointcutExpression expression = advice.getPointcutExpression();
        if (expression != null) {
            AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder(expression).getAopModel().getAdvisedElementsSearcher();
            result.add((LineMarkerInfo<?>)AopJavaAnnotator.addNavigationToInterceptedMethods(advice, searcher).createLineMarkerInfo((PsiElement)nameIdentifier));
        }
    }

    @NotNull
    public static NavigationGutterIconBuilder<AopIntroduction> addNavigationToBoundIntroductions(List<? extends AopIntroduction> boundIntros) {
        NavigationGutterIconBuilder navigationGutterIconBuilder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)AopJavaAnnotator.createToIcon(AopCommonIcons.Gutter.Introduction), AopIntroduction.class).setTargets(boundIntros).setTooltipText(AopBundle.message("tooltip.text.navigate.to.introductions", new Object[0])).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.introductions", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT);
        if (navigationGutterIconBuilder == null) {
            AopJavaAnnotator.$$$reportNull$$$0(5);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public static NavigationGutterIconBuilder<AopAdvice> addNavigationToBoundAdvices(final Map<AopAdvice, Integer> boundAdvices) {
        ArrayList<AopAdvice> adviceList = new ArrayList<AopAdvice>(boundAdvices.keySet());
        adviceList.sort((o1, o2) -> {
            boolean onTheWayIn = o1.getAdviceType().isOnTheWayIn();
            if (onTheWayIn != o2.getAdviceType().isOnTheWayIn()) {
                return onTheWayIn ? -1 : 1;
            }
            int i1 = (Integer)boundAdvices.get(o1);
            int i2 = (Integer)boundAdvices.get(o2);
            int diff = i2 - i1;
            return onTheWayIn ? -diff : diff;
        });
        final HashMap psi2Advice = new HashMap();
        NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AopJavaAnnotator.createToIcon(AopCommonIcons.Gutter.Abstract_advice), advice -> {
            PsiElement[] psiElements;
            for (PsiElement element : psiElements = JamCommonUtil.getTargetPsiElements((CommonModelElement)advice)) {
                psi2Advice.put(element, advice);
            }
            return Arrays.asList(psiElements);
        }).setTargets(adviceList).setTooltipText(AopBundle.message("tooltip.text.navigate.to.advices", new Object[0])).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.advices", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT).setCellRenderer((PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(){

            public String getElementText(PsiElement element) {
                Integer integer;
                String superText = super.getElementText(element);
                AopAdvice advice = (AopAdvice)psi2Advice.get(element);
                if (advice != null && advice.isValid() && (integer = (Integer)boundAdvices.get(advice)) != null && integer < Integer.MAX_VALUE) {
                    return superText + " (order=" + integer + ")";
                }
                return superText;
            }

            public String getContainerText(PsiElement element, String name) {
                PsiFile file;
                String superText = super.getContainerText(element, name);
                if (StringUtil.isEmpty((String)superText) && (file = element.getContainingFile()) != null) {
                    return "(in " + file.getName() + ")";
                }
                return superText;
            }

            protected int getIconFlags() {
                return 0;
            }
        });
        if (navigationGutterIconBuilder == null) {
            AopJavaAnnotator.$$$reportNull$$$0(6);
        }
        return navigationGutterIconBuilder;
    }

    public static List<AopIntroduction> getBoundIntroductions(PsiClass psiClass) {
        Project project = psiClass.getProject();
        return DumbService.isDumb((Project)project) ? Collections.emptyList() : (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(AopJavaAnnotator.calcBoundIntroductions(psiClass, true), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static List<AopIntroduction> getBoundIntroductionsForModelClass(PsiClass psiClass) {
        Project project = psiClass.getProject();
        return DumbService.isDumb((Project)project) ? Collections.emptyList() : (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(AopJavaAnnotator.calcBoundIntroductions(psiClass, false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static List<AopIntroduction> calcBoundIntroductions(PsiClass psiClass, boolean checkAdvisable) {
        if (psiClass.hasModifierProperty("abstract")) {
            return Collections.emptyList();
        }
        List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiClass);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null || providers.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList boundIntros = new SmartList();
        PsiClassType type = AopJavaAnnotator.createPsiType(psiClass);
        for (AopAspect aspect : AopJavaAnnotator.getAspects(psiClass)) {
            for (AopIntroduction aopIntroduction : aspect.getIntroductions()) {
                AopAdvisedElementsSearcher searcher;
                AopReferenceHolder holder = (AopReferenceHolder)aopIntroduction.getTypesMatching().getValue();
                if (holder == null || holder.accepts((PsiType)type) != PointcutMatchDegree.TRUE || !(searcher = AopPointcutUtil.getHolder((PsiElement)holder).getAopModel().getAdvisedElementsSearcher()).isInherentlyAdvisable(psiClass) || checkAdvisable && !searcher.isAdvisableInModel(psiClass)) continue;
                boundIntros.add(aopIntroduction);
            }
        }
        return boundIntros;
    }

    private static Set<AopAspect> getAspects(PsiClass psiClass) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            HashSet set = new HashSet();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiClass);
            if (module != null && !providers.isEmpty()) {
                AopJavaAnnotator.collectAspects(providers, module, set);
                for (Module module1 : ModuleUtilCore.getAllDependentModules((Module)module)) {
                    AopJavaAnnotator.collectAspects(providers, module1, set);
                }
            }
            return CachedValueProvider.Result.create(set, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static void collectAspects(List<? extends AopProvider> providers, Module module, Set<? super AopAspect> aspects) {
        aspects.addAll(new JamAopModel(module).getAspects());
        for (AopProvider aopProvider : providers) {
            aspects.addAll(aopProvider.getAdditionalAspects(module));
        }
    }

    private static int getAdviceOrder(AopAdvice advice, List<? extends AopProvider> providers) {
        for (AopProvider aopProvider : providers) {
            Integer order = aopProvider.getAdviceOrder(advice);
            if (order == null) continue;
            return order;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isAcceptableAdviceMethod(PsiClass psiClass, List<? extends AopProvider> providers) {
        for (AopProvider aopProvider : providers) {
            if (aopProvider.getAdvisedElementsSearcher(psiClass) == null) continue;
            return true;
        }
        return false;
    }

    private static Map<AopAdvice, Integer> addBoundAdvices(PsiMethod method, Collection<? extends AopAspect> aspects, List<? extends AopProvider> providers) {
        LinkedHashMap<AopAdvice, Integer> boundAdvices = new LinkedHashMap<AopAdvice, Integer>();
        for (AopAspect aopAspect : aspects) {
            for (AopAdvice aopAdvice : aopAspect.getAdvices()) {
                ProgressManager.checkCanceled();
                AopAdvisedElementsSearcher searcher = aopAdvice.getSearcher();
                if (searcher == null || !AopJavaAnnotator.isAdviceAcceptingMethod(aopAdvice, method, searcher, true)) continue;
                boundAdvices.put(aopAdvice, AopJavaAnnotator.getAdviceOrder(aopAdvice, providers));
            }
        }
        return boundAdvices;
    }

    private static PsiClassType createPsiType(PsiClass psiClass) {
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> addNavigationToInterceptedMethods(final AopAdvice advice, final AopAdvisedElementsSearcher searcher) {
        NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AopJavaAnnotator.createFromIcon(advice.getAdviceType().getAdviceIcon())).setTargets(NotNullLazyValue.lazy(() -> {
            if (!advice.isValid()) {
                return Collections.emptyList();
            }
            final HashSet result = new HashSet();
            ContainerUtil.process(searcher.collectAdvisedClasses(), (Processor)new ReadActionProcessor<PsiClass>(){

                public boolean processInReadAction(PsiClass psiClass) {
                    if (advice.isValid()) {
                        for (PsiMethod psiMethod : psiClass.getMethods()) {
                            if (!AopJavaAnnotator.isAdviceAcceptingMethod(advice, psiMethod, searcher, false)) continue;
                            result.add(psiMethod);
                        }
                    }
                    return true;
                }
            });
            return result;
        })).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.methods", new Object[0])).setTooltipText(AopBundle.message("tooltip.text.navigate.to.methods", new Object[0])).setEmptyPopupText(AopBundle.message("empty.popup.text.navigate.to.methods", new Object[0]));
        if (navigationGutterIconBuilder == null) {
            AopJavaAnnotator.$$$reportNull$$$0(7);
        }
        return navigationGutterIconBuilder;
    }

    @Nullable
    public static NavigationGutterIconBuilder<PsiElement> addNavigationToIntroducedClasses(AopIntroduction introduction) {
        final AopReferenceHolder expression = (AopReferenceHolder)introduction.getTypesMatching().getValue();
        if (expression == null) {
            return null;
        }
        final AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder((PsiElement)expression).getAopModel().getAdvisedElementsSearcher();
        NotNullLazyValue targets = NotNullLazyValue.lazy(() -> {
            final HashSet result = new HashSet();
            ContainerUtil.process(searcher.collectAdvisedClasses(), (Processor)new ReadActionProcessor<PsiClass>(){

                public boolean processInReadAction(PsiClass psiClass) {
                    if (expression.accepts((PsiType)AopJavaAnnotator.createPsiType(psiClass)) == PointcutMatchDegree.TRUE && searcher.isInherentlyAdvisable(psiClass) && searcher.isAdvisableInModel(psiClass)) {
                        result.add(psiClass);
                    }
                    return true;
                }
            });
            return result;
        });
        return NavigationGutterIconBuilder.create((Icon)AopJavaAnnotator.createFromIcon(AopCommonIcons.Gutter.Introduction)).setTargets(targets).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.classes", new Object[0])).setTooltipText(AopBundle.message("tooltip.text.navigate.to.classes", new Object[0])).setEmptyPopupText(AopBundle.message("empty.popup.text.navigate.to.classes", new Object[0]));
    }

    public static Map<AopAdvice, Integer> getBoundAdvices(PsiClass psiClass) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            HashMap<AopAdvice, Integer> result = new HashMap<AopAdvice, Integer>();
            List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiClass);
            Set<AopAspect> aspects = AopJavaAnnotator.getAspects(psiClass);
            for (PsiMethod method : psiClass.getMethods()) {
                result.putAll(AopJavaAnnotator.addBoundAdvices(method, aspects, providers));
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean isAdviceAcceptingMethod(AopAdvice advice, PsiMethod method, AopAdvisedElementsSearcher searcher, boolean checkClass) {
        if (!searcher.canBeAdvised(method)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!(!checkClass || containingClass != null && containingClass.getQualifiedName() != null && searcher.isInherentlyAdvisable(containingClass) && AopAdvisedElementsSearcher.isAspectjAdvisable(containingClass))) {
            return false;
        }
        return advice.accepts(method) == PointcutMatchDegree.TRUE && searcher.acceptsBoundMethodHeavy(method) && containingClass != null && (!checkClass || searcher.isAdvisableInModel(containingClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/jam/AopJavaAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/jam/AopJavaAnnotator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToBoundIntroductions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToBoundAdvices";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToInterceptedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

