/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.android.utils.TraceUtils;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.java.IKeywordElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidDependenciesCache;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.OutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUtils
extends CommonAndroidUtil {
    private static final Logger LOG = Logger.getInstance(AndroidUtils.class);
    @NonNls
    public static final String NAMESPACE_KEY = "android";
    @NonNls
    public static final String SYSTEM_RESOURCE_PACKAGE = "android";
    @NonNls
    public static final String VIEW_CLASS_NAME = "android.view.View";
    @NonNls
    public static final String APPLICATION_CLASS_NAME = "android.app.Application";
    @NonNls
    public static final String ACTIVITY_BASE_CLASS_NAME = "android.app.Activity";
    @NonNls
    public static final String R_CLASS_NAME = "R";
    @NonNls
    public static final String MANIFEST_CLASS_NAME = "Manifest";
    @NonNls
    public static final String LAUNCH_ACTION_NAME = "android.intent.action.MAIN";
    @NonNls
    public static final String WALLPAPER_SERVICE_ACTION_NAME = "android.service.wallpaper.WallpaperService";
    @NonNls
    public static final String LAUNCH_CATEGORY_NAME = "android.intent.category.LAUNCHER";
    @NonNls
    public static final String LEANBACK_LAUNCH_CATEGORY_NAME = "android.intent.category.LEANBACK_LAUNCHER";
    @NonNls
    public static final String DEFAULT_CATEGORY_NAME = "android.intent.category.DEFAULT";
    @NonNls
    public static final String WATCHFACE_CATEGORY_NAME = "com.google.android.wearable.watchface.category.WATCH_FACE";
    @NonNls
    public static final String INSTRUMENTATION_RUNNER_BASE_CLASS = "android.app.Instrumentation";
    @NonNls
    public static final String SERVICE_CLASS_NAME = "android.app.Service";
    @NonNls
    public static final String RECEIVER_CLASS_NAME = "android.content.BroadcastReceiver";
    @NonNls
    public static final String PROVIDER_CLASS_NAME = "android.content.ContentProvider";
    @NonNls
    public static final String ANDROID_LIBRARY_PROPERTY = "android.library";
    @NonNls
    public static final String ANDROID_PROJECT_TYPE_PROPERTY = "project.type";
    @NonNls
    public static final String ANDROID_MANIFEST_MERGER_PROPERTY = "manifestmerger.enabled";
    @NonNls
    public static final String ANDROID_DEX_DISABLE_MERGER = "dex.disable.merger";
    @NonNls
    public static final String ANDROID_DEX_FORCE_JUMBO_PROPERTY = "dex.force.jumbo";
    @NonNls
    public static final String ANDROID_TARGET_PROPERTY = "target";
    @NonNls
    public static final String ANDROID_LIBRARY_REFERENCE_PROPERTY_PREFIX = "android.library.reference.";
    @NonNls
    public static final String TAG_LINEAR_LAYOUT = "LinearLayout";
    private static final String[] ANDROID_COMPONENT_CLASSES = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider"};
    private static final Lexer JAVA_LEXER = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);

    private AndroidUtils() {
    }

    public boolean isAndroidProject(@NotNull Project project) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(0);
        }
        return AndroidUtils.hasAndroidFacets(project);
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Module module2, @NotNull VirtualFile file2, @NotNull Class<T> aClass) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            AndroidUtils.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            AndroidUtils.$$$reportNull$$$0(3);
        }
        return AndroidUtils.loadDomElement(module2.getProject(), file2, aClass);
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Class<T> aClass) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            AndroidUtils.$$$reportNull$$$0(5);
        }
        if (aClass == null) {
            AndroidUtils.$$$reportNull$$$0(6);
        }
        return (T)((DomElement)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed() || !file2.isValid()) {
                return null;
            }
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file2);
            if (psiFile2 instanceof XmlFile) {
                return AndroidUtils.loadDomElementWithReadPermission(project, (XmlFile)psiFile2, aClass);
            }
            return null;
        }));
    }

    @Nullable
    public static <T extends DomElement> T loadDomElementWithReadPermission(@NotNull Project project, @NotNull XmlFile xmlFile, @NotNull Class<T> aClass) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(7);
        }
        if (xmlFile == null) {
            AndroidUtils.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            AndroidUtils.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        DomManager domManager = DomManager.getDomManager((Project)project);
        ProgressManager.checkCanceled();
        DomFileElement element2 = domManager.getFileElement(xmlFile, aClass);
        return (T)(element2 == null ? null : element2.getRootElement());
    }

    @Nullable
    public static VirtualFile findSourceRoot(@NotNull Module module2, VirtualFile file2) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(10);
        }
        HashSet sourceRoots = new HashSet();
        Collections.addAll(sourceRoots, ModuleRootManager.getInstance((Module)module2).getSourceRoots());
        while (file2 != null) {
            if (sourceRoots.contains(file2)) {
                return file2;
            }
            file2 = file2.getParent();
        }
        return null;
    }

    @Nullable
    public static String computePackageName(@NotNull Module module2, VirtualFile file2) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(11);
        }
        HashSet sourceRoots = new HashSet();
        Collections.addAll(sourceRoots, ModuleRootManager.getInstance((Module)module2).getSourceRoots());
        VirtualFile projectDir = module2.getProject().getBaseDir();
        ArrayList<String> packages = new ArrayList<String>();
        for (file2 = file2.getParent(); file2 != null && !Objects.equals(projectDir, file2) && !sourceRoots.contains(file2); file2 = file2.getParent()) {
            packages.add(file2.getName());
        }
        if (file2 != null && sourceRoots.contains(file2)) {
            StringBuilder packageName = new StringBuilder();
            for (int i2 = packages.size() - 1; i2 >= 0; --i2) {
                packageName.append((String)packages.get(i2));
                if (i2 <= 0) continue;
                packageName.append('.');
            }
            return packageName.toString();
        }
        return null;
    }

    public static boolean isAbstract(@NotNull PsiClass c) {
        if (c == null) {
            AndroidUtils.$$$reportNull$$$0(12);
        }
        return c.isInterface() || c.hasModifierProperty("abstract");
    }

    @Nullable
    public static Module getAndroidModule(ConfigurationContext context) {
        Module module2 = context.getModule();
        if (module2 == null || AndroidFacet.getInstance((Module)module2) == null) {
            return null;
        }
        return module2;
    }

    public static VirtualFile createChildDirectoryIfNotExist(Project project, VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        return child == null ? parent.createChildDirectory((Object)project, name) : child;
    }

    @Nullable
    public static PsiFile getContainingFile(@NotNull PsiElement element2) {
        if (element2 == null) {
            AndroidUtils.$$$reportNull$$$0(13);
        }
        return element2 instanceof PsiFile ? (PsiFile)element2 : element2.getContainingFile();
    }

    public static void navigateTo(@NotNull PsiElement[] targets, @Nullable RelativePoint pointToShowPopup) {
        if (targets == null) {
            AndroidUtils.$$$reportNull$$$0(14);
        }
        if (targets.length == 0) {
            JComponent renderer2 = HintUtil.createErrorLabel((String)"Empty text");
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(renderer2, renderer2).createPopup();
            if (pointToShowPopup != null) {
                popup2.show(pointToShowPopup);
            }
            return;
        }
        if (targets.length == 1 || pointToShowPopup == null) {
            PsiNavigateUtil.navigate((PsiElement)targets[0]);
        } else {
            DefaultPsiElementCellRenderer renderer3 = new DefaultPsiElementCellRenderer(){

                public String getElementText(PsiElement element2) {
                    PsiFile file2 = AndroidUtils.getContainingFile(element2);
                    return file2 != null ? file2.getName() : super.getElementText(element2);
                }

                public String getContainerText(PsiElement element2, String name) {
                    PsiFile file2 = AndroidUtils.getContainingFile(element2);
                    PsiDirectory dir = file2 != null ? file2.getContainingDirectory() : null;
                    return dir == null ? "" : "(" + dir.getName() + ")";
                }
            };
            JBPopup popup3 = NavigationUtil.getPsiElementPopup((PsiElement[])targets, (PsiElementListCellRenderer)renderer3, null);
            popup3.show(pointToShowPopup);
        }
    }

    @NotNull
    public static ExecutionStatus executeCommand(@NotNull GeneralCommandLine commandLine, final @Nullable OutputProcessor processor, @Nullable WaitingStrategies.Strategy strategy) throws ExecutionException {
        int exitCode;
        if (commandLine == null) {
            AndroidUtils.$$$reportNull$$$0(15);
        }
        LOG.info(commandLine.getCommandLineString());
        OSProcessHandler handler2 = new OSProcessHandler(commandLine);
        ProcessAdapter listener2 = new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (processor != null) {
                    String message2 = event.getText();
                    processor.onTextAvailable(message2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/android/util/AndroidUtils$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (!(strategy instanceof WaitingStrategies.DoNotWait)) {
            handler2.addProcessListener((ProcessListener)listener2);
        }
        handler2.startNotify();
        try {
            if (!(strategy instanceof WaitingStrategies.WaitForever)) {
                if (strategy instanceof WaitingStrategies.WaitForTime) {
                    handler2.waitFor((long)((WaitingStrategies.WaitForTime)strategy).getTimeMs());
                }
            } else {
                handler2.waitFor();
            }
        }
        catch (ProcessCanceledException e) {
            ExecutionStatus executionStatus = ExecutionStatus.ERROR;
            if (executionStatus == null) {
                AndroidUtils.$$$reportNull$$$0(16);
            }
            return executionStatus;
        }
        if (!handler2.isProcessTerminated()) {
            ExecutionStatus executionStatus = ExecutionStatus.TIMEOUT;
            if (executionStatus == null) {
                AndroidUtils.$$$reportNull$$$0(17);
            }
            return executionStatus;
        }
        if (!(strategy instanceof WaitingStrategies.DoNotWait)) {
            handler2.removeProcessListener((ProcessListener)listener2);
        }
        ExecutionStatus executionStatus = (exitCode = handler2.getProcess().exitValue()) == 0 ? ExecutionStatus.SUCCESS : ExecutionStatus.ERROR;
        if (executionStatus == null) {
            AndroidUtils.$$$reportNull$$$0(18);
        }
        return executionStatus;
    }

    @NotNull
    public static String getSimpleNameByRelativePath(@NotNull String relativePath) {
        int index2;
        if (relativePath == null) {
            AndroidUtils.$$$reportNull$$$0(19);
        }
        if ((index2 = (relativePath = FileUtil.toSystemIndependentName((String)relativePath)).lastIndexOf(47)) < 0) {
            String string = relativePath;
            if (string == null) {
                AndroidUtils.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = relativePath.substring(index2 + 1);
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public static String getUnqualifiedName(@NotNull String qualifiedName) {
        int start2;
        if (qualifiedName == null) {
            AndroidUtils.$$$reportNull$$$0(22);
        }
        if ((start2 = qualifiedName.lastIndexOf(46)) == -1 || start2 + 1 == qualifiedName.length()) {
            return null;
        }
        return qualifiedName.substring(start2 + 1);
    }

    @NotNull
    public static AndroidFacet addAndroidFacetInWriteAction(@NotNull Module module2, @NotNull VirtualFile contentRoot, boolean library) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(23);
        }
        if (contentRoot == null) {
            AndroidUtils.$$$reportNull$$$0(24);
        }
        AndroidFacet androidFacet = (AndroidFacet)WriteAction.compute(() -> AndroidUtils.addAndroidFacet(module2, contentRoot, library));
        if (androidFacet == null) {
            AndroidUtils.$$$reportNull$$$0(25);
        }
        return androidFacet;
    }

    @NotNull
    public static AndroidFacet addAndroidFacet(Module module2, @NotNull VirtualFile contentRoot, boolean library) {
        FacetManager facetManager;
        ModifiableFacetModel model2;
        AndroidFacet facet2;
        if (contentRoot == null) {
            AndroidUtils.$$$reportNull$$$0(26);
        }
        if ((facet2 = (AndroidFacet)(model2 = (facetManager = FacetManager.getInstance((Module)module2)).createModifiableModel()).getFacetByType(AndroidFacet.ID)) == null) {
            facet2 = (AndroidFacet)facetManager.createFacet((FacetType)AndroidFacet.getFacetType(), "Android", null);
            AndroidUtils.setUpAndroidFacetConfiguration(facet2, contentRoot.getPath());
            if (library) {
                ((AndroidFacetConfiguration)facet2.getConfiguration()).setProjectType(1);
            }
            model2.addFacet((Facet)facet2);
        }
        model2.commit();
        AndroidFacet androidFacet = facet2;
        if (androidFacet == null) {
            AndroidUtils.$$$reportNull$$$0(27);
        }
        return androidFacet;
    }

    public static void setUpAndroidFacetConfiguration(@NotNull AndroidFacet androidFacet, @NotNull String baseDirectoryPath) {
        if (androidFacet == null) {
            AndroidUtils.$$$reportNull$$$0(28);
        }
        if (baseDirectoryPath == null) {
            AndroidUtils.$$$reportNull$$$0(29);
        }
        AndroidUtils.setUpAndroidFacetConfiguration(androidFacet.getModule(), (AndroidFacetConfiguration)androidFacet.getConfiguration(), baseDirectoryPath);
    }

    public static void setUpAndroidFacetConfiguration(@NotNull Module module2, @NotNull AndroidFacetConfiguration androidFacetConfiguration, @NotNull String baseDirectoryPath) {
        String s;
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(30);
        }
        if (androidFacetConfiguration == null) {
            AndroidUtils.$$$reportNull$$$0(31);
        }
        if (baseDirectoryPath == null) {
            AndroidUtils.$$$reportNull$$$0(32);
        }
        if ((s = AndroidRootUtil.getPathRelativeToModuleDir(module2, baseDirectoryPath)) == null || s.isEmpty()) {
            return;
        }
        AndroidFacetProperties properties2 = androidFacetConfiguration.getState();
        properties2.GEN_FOLDER_RELATIVE_PATH_APT = "/" + s + properties2.GEN_FOLDER_RELATIVE_PATH_APT;
        properties2.GEN_FOLDER_RELATIVE_PATH_AIDL = "/" + s + properties2.GEN_FOLDER_RELATIVE_PATH_AIDL;
        properties2.MANIFEST_FILE_RELATIVE_PATH = "/" + s + properties2.MANIFEST_FILE_RELATIVE_PATH;
        properties2.RES_FOLDER_RELATIVE_PATH = "/" + s + properties2.RES_FOLDER_RELATIVE_PATH;
        properties2.ASSETS_FOLDER_RELATIVE_PATH = "/" + s + properties2.ASSETS_FOLDER_RELATIVE_PATH;
        properties2.LIBS_FOLDER_RELATIVE_PATH = "/" + s + properties2.LIBS_FOLDER_RELATIVE_PATH;
        properties2.PROGUARD_LOGS_FOLDER_RELATIVE_PATH = "/" + s + properties2.PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        for (int i2 = 0; i2 < properties2.RES_OVERLAY_FOLDERS.size(); ++i2) {
            properties2.RES_OVERLAY_FOLDERS.set(i2, "/" + s + properties2.RES_OVERLAY_FOLDERS.get(i2));
        }
    }

    @Nullable
    public static VirtualFile findFileByAbsoluteOrRelativePath(@Nullable VirtualFile baseDir, @NotNull String path2) {
        VirtualFile libDir;
        if (path2 == null) {
            AndroidUtils.$$$reportNull$$$0(33);
        }
        if ((libDir = LocalFileSystem.getInstance().findFileByPath(path2)) != null) {
            return libDir;
        }
        if (baseDir != null) {
            return LocalFileSystem.getInstance().findFileByPath(baseDir.getPath() + "/" + path2);
        }
        return null;
    }

    @Nullable
    public static TargetSelectionMode getDefaultTargetSelectionMode(@NotNull Module module2, @NotNull ConfigurationType type, @NonNls ConfigurationType alternativeType) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(34);
        }
        if (type == null) {
            AndroidUtils.$$$reportNull$$$0(35);
        }
        RunManager runManager = RunManager.getInstance((Project)module2.getProject());
        List configurations = runManager.getConfigurationsList(type);
        TargetSelectionMode alternative = null;
        if (!configurations.isEmpty()) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                AndroidRunConfigurationBase runConfig = (AndroidRunConfigurationBase)configuration;
                TargetSelectionMode targetMode = runConfig.getDeployTargetContext().getTargetSelectionMode();
                if (runConfig.getConfigurationModule() == module2) {
                    return targetMode;
                }
                alternative = targetMode;
            }
        }
        if (alternative != null) {
            return alternative;
        }
        configurations = runManager.getConfigurationsList(alternativeType);
        if (!configurations.isEmpty()) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                return ((AndroidRunConfigurationBase)configuration).getDeployTargetContext().getTargetSelectionMode();
            }
        }
        return null;
    }

    public static boolean equal(@Nullable String s1, @Nullable String s2, boolean distinguishDelimiters) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c1 = s1.charAt(i2);
            char c2 = s2.charAt(i2);
            if (!distinguishDelimiters && (!Character.isLetterOrDigit(c1) || !Character.isLetterOrDigit(c2)) || c1 == c2) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<AndroidFacet> getApplicationFacets(@NotNull Project project) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(36);
        }
        List<AndroidFacet> list = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).stream().filter(facet2 -> ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()).sorted(Comparator.comparing(facet2 -> facet2.getModule().getName())).collect(Collectors.toList());
        if (list == null) {
            AndroidUtils.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    public static List<AndroidFacet> getAndroidLibraryDependencies(@NotNull Module module2) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(38);
        }
        ArrayList<AndroidFacet> depFacets = new ArrayList<AndroidFacet>();
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || !((AndroidFacetConfiguration)depFacet.getConfiguration()).canBeDependency()) continue;
            depFacets.add(depFacet);
        }
        ArrayList<AndroidFacet> arrayList = depFacets;
        if (arrayList == null) {
            AndroidUtils.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    public static List<AndroidFacet> getAndroidResourceDependencies(@NotNull Module module2) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(40);
        }
        return ProjectSystemUtil.getModuleSystem(module2).getResourceModuleDependencies().stream().map(AndroidFacet::getInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module2, boolean androidLibrariesOnly) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(41);
        }
        List<AndroidFacet> list = AndroidDependenciesCache.getInstance(module2).getAllAndroidDependencies(androidLibrariesOnly);
        if (list == null) {
            AndroidUtils.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public static Set<String> getDepLibsPackages(Module module2) {
        HashSet<String> result2 = new HashSet<String>();
        HashSet<Module> visited = new HashSet<Module>();
        if (visited.add(module2)) {
            for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(module2, true)) {
                String aPackage;
                Manifest manifest = Manifest.getMainManifest(depFacet);
                if (manifest == null || (aPackage = (String)manifest.getPackage().getValue()) == null) continue;
                result2.add(aPackage);
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            AndroidUtils.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNewPassword(JPasswordField passwordField, JPasswordField confirmedPasswordField) throws CommitStepException {
        char[] password = passwordField.getPassword();
        char[] confirmedPassword = confirmedPasswordField.getPassword();
        try {
            AndroidUtils.checkPassword(password);
            if (password.length < 6) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.incorrect.password.length", new Object[0]));
            }
            if (!Arrays.equals(password, confirmedPassword)) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.passwords.not.match.error", new Object[0]));
            }
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(confirmedPassword, '\u0000');
        }
    }

    public static void checkPassword(char[] password) throws CommitStepException {
        if (password.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.password.error", new Object[0]));
        }
    }

    public static void reportError(@NotNull Project project, @NotNull String message2) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(44);
        }
        if (message2 == null) {
            AndroidUtils.$$$reportNull$$$0(45);
        }
        AndroidUtils.reportError(project, message2, CommonBundle.getErrorTitle());
    }

    public static void reportError(@NotNull Project project, @NotNull String message2, @NotNull String title) {
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(46);
        }
        if (message2 == null) {
            AndroidUtils.$$$reportNull$$$0(47);
        }
        if (title == null) {
            AndroidUtils.$$$reportNull$$$0(48);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IncorrectOperationException(message2);
        }
        Messages.showErrorDialog((Project)project, (String)message2, (String)title);
    }

    public static void showStackStace(@Nullable Project project, @NotNull Throwable[] throwables) {
        if (throwables == null) {
            AndroidUtils.$$$reportNull$$$0(49);
        }
        final StringBuilder messageBuilder = new StringBuilder();
        for (Throwable t : throwables) {
            if (messageBuilder.length() > 0) {
                messageBuilder.append("\n\n");
            }
            messageBuilder.append(TraceUtils.getStackTrace((Throwable)t));
        }
        DialogWrapper wrapper = new DialogWrapper(project, false){
            {
                super(arg0, arg1);
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel(new BorderLayout());
                JTextArea textArea = new JTextArea(messageBuilder.toString());
                textArea.setEditable(false);
                textArea.setRows(40);
                textArea.setColumns(70);
                panel2.add(ScrollPaneFactory.createScrollPane((Component)textArea));
                return panel2;
            }
        };
        wrapper.setTitle("Stack Trace");
        wrapper.show();
    }

    public static boolean isValidAndroidPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(50);
        }
        return AndroidUtils.validateAndroidPackageName(name) == null;
    }

    public static boolean isValidJavaPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(51);
        }
        int index2 = 0;
        while (true) {
            int index1;
            if ((index1 = name.indexOf(46, index2)) < 0) {
                index1 = name.length();
            }
            if (!AndroidUtils.isIdentifier(name.substring(index2, index1))) {
                return false;
            }
            if (index1 == name.length()) {
                return true;
            }
            index2 = index1 + 1;
        }
    }

    @Nullable
    public static String validateAndroidPackageName(@NotNull String name) {
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(52);
        }
        if (name.isEmpty()) {
            return "Package name is missing";
        }
        String packageManagerCheck = AndroidUtils.validateName(name);
        if (packageManagerCheck != null) {
            return packageManagerCheck;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index2 = 0;
        while (true) {
            String error;
            int index1;
            if ((index1 = name.indexOf(46, index2)) < 0) {
                index1 = name.length();
            }
            if ((error = AndroidUtils.isReservedKeyword(name.substring(index2, index1))) != null) {
                return error;
            }
            if (index1 == name.length()) break;
            index2 = index1 + 1;
        }
        return null;
    }

    @Nullable
    public static String isReservedKeyword(@NotNull String string) {
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(53);
        }
        Lexer lexer = JAVA_LEXER;
        lexer.start((CharSequence)string);
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (lexer.getTokenType() instanceof IKeywordElementType) {
                return "Package names cannot contain Java keywords like '" + string + "'";
            }
            if (string.isEmpty()) {
                return "Package segments must be of non-zero length";
            }
            return string + " is not a valid identifier";
        }
        return null;
    }

    @Nullable
    private static String validateName(String name) {
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i2 = 0; i2 < N; ++i2) {
            char c = name.charAt(i2);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                if (!front) continue;
                if (c == '_') {
                    return "The character '_' cannot be the first character in a package segment";
                }
                return "A digit cannot be the first character in a package segment";
            }
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "The character '" + c + "' is not allowed in Android application package names";
        }
        return hasSep ? null : "The package must have at least one '.' separator";
    }

    public static boolean isIdentifier(@NotNull String candidate) {
        if (candidate == null) {
            AndroidUtils.$$$reportNull$$$0(54);
        }
        return StringUtil.isJavaIdentifier((String)candidate) && !JavaLexer.isKeyword((String)candidate, (LanguageLevel)LanguageLevel.JDK_1_5);
    }

    public static void reportImportErrorToEventLog(String message2, String modName, Project project) {
        AndroidUtils.reportImportErrorToEventLog(message2, modName, project, null);
    }

    public static void reportImportErrorToEventLog(String message2, String modName, Project project, NotificationListener listener2) {
        Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Importing Error", (String)AndroidBundle.message("android.facet.importing.notification.group", new Object[0])), AndroidBundle.message("android.facet.importing.title", modName), message2, NotificationType.ERROR);
        if (listener2 != null) {
            notification.setListener(listener2);
        }
        notification.notify(project);
        LOG.debug(message2);
    }

    public static boolean isPackagePrefix(@NotNull String prefix, @NotNull String name) {
        if (prefix == null) {
            AndroidUtils.$$$reportNull$$$0(55);
        }
        if (name == null) {
            AndroidUtils.$$$reportNull$$$0(56);
        }
        return name.equals(prefix) || name.startsWith(prefix + ".");
    }

    @NotNull
    public static Set<Module> getSetWithBackwardDependencies(@NotNull Module module2) {
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(57);
        }
        Graph graph = ModuleManager.getInstance((Project)module2.getProject()).moduleGraph();
        HashSet<Module> set = new HashSet<Module>();
        GraphAlgorithms.getInstance().collectOutsRecursively(graph, (Object)module2, set);
        HashSet<Module> hashSet = set;
        if (hashSet == null) {
            AndroidUtils.$$$reportNull$$$0(58);
        }
        return hashSet;
    }

    @NotNull
    public static List<String> urlsToOsPaths(@NotNull List<String> urls, @Nullable String sdkHomeCanonicalPath) {
        if (urls == null) {
            AndroidUtils.$$$reportNull$$$0(59);
        }
        if (urls.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AndroidUtils.$$$reportNull$$$0(60);
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(urls.size());
        for (String url : urls) {
            if (sdkHomeCanonicalPath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomeCanonicalPath);
            }
            result2.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            AndroidUtils.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @NotNull
    public static String getAndroidSystemDirectoryOsPath() {
        String string = PathManager.getSystemPath() + File.separator + "android";
        if (string == null) {
            AndroidUtils.$$$reportNull$$$0(62);
        }
        return string;
    }

    public static boolean isAndroidComponent(@NotNull PsiClass c) {
        if (c == null) {
            AndroidUtils.$$$reportNull$$$0(63);
        }
        Project project = c.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (String componentClassName : ANDROID_COMPONENT_CLASSES) {
            PsiClass componentClass = facade.findClass(componentClassName, ProjectScope.getAllScope((Project)project));
            if (componentClass == null || !c.isInheritor(componentClass, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAndroidFacets(@NotNull Project project) {
        ProjectFacetManager facetManager;
        if (project == null) {
            AndroidUtils.$$$reportNull$$$0(64);
        }
        return (facetManager = ProjectFacetManager.getInstance((Project)project)).hasFacets(AndroidFacet.getFacetType().getId()) || facetManager.hasFacets(ApkFacet.getFacetTypeId()) || facetManager.hasFacets(GradleFacet.getFacetTypeId());
    }

    @Nullable
    public static String getDeclaredContextFqcn(@NotNull Module module2, @NotNull XmlFile xmlFile) {
        String context;
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(65);
        }
        if (xmlFile == null) {
            AndroidUtils.$$$reportNull$$$0(66);
        }
        if ((context = AndroidPsiUtils.getRootTagAttributeSafely((XmlFile)xmlFile, (String)"context", (String)"http://schemas.android.com/tools")) != null && !context.isEmpty()) {
            boolean startsWithDot;
            boolean bl = startsWithDot = context.charAt(0) == '.';
            if (startsWithDot || context.indexOf(46) == -1) {
                String pkg = AndroidManifestUtils.getPackageName(module2);
                return startsWithDot ? pkg + context : pkg + "." + context;
            }
            return context;
        }
        return null;
    }

    @Nullable
    public static PsiClass getContextClass(@NotNull Module module2, @NotNull XmlFile xmlFile) {
        String fqn;
        if (module2 == null) {
            AndroidUtils.$$$reportNull$$$0(67);
        }
        if (xmlFile == null) {
            AndroidUtils.$$$reportNull$$$0(68);
        }
        if ((fqn = AndroidUtils.getDeclaredContextFqcn(module2, xmlFile)) != null) {
            Project project = module2.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Nullable
    public static String getRootTagName(@NotNull PsiFile file2) {
        ResourceFolderType folderType;
        if (file2 == null) {
            AndroidUtils.$$$reportNull$$$0(69);
        }
        if (((folderType = IdeResourcesUtil.getFolderType(file2)) == ResourceFolderType.XML || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE) && file2 instanceof XmlFile) {
            XmlTag rootTag = AndroidPsiUtils.getRootTagSafely((XmlFile)((XmlFile)file2));
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 23: 
            case 30: 
            case 34: 
            case 38: 
            case 40: 
            case 41: 
            case 57: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 12: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidUtils";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectoryPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacetConfiguration";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwables";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidUtils";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleNameByRelativePath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndroidFacetInWriteAction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndroidFacet";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFacets";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidLibraryDependencies";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidDependencies";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepLibsPackages";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetWithBackwardDependencies";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "urlsToOsPaths";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidSystemDirectoryOsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadDomElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadDomElementWithReadPermission";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSourceRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computePackageName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleNameByRelativePath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUnqualifiedName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidFacetInWriteAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidFacet";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setUpAndroidFacetConfiguration";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findFileByAbsoluteOrRelativePath";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetSelectionMode";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationFacets";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidLibraryDependencies";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidResourceDependencies";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAllAndroidDependencies";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "showStackStace";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isValidAndroidPackageName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isValidJavaPackageName";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "validateAndroidPackageName";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isReservedKeyword";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isPackagePrefix";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getSetWithBackwardDependencies";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "urlsToOsPaths";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidComponent";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "hasAndroidFacets";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredContextFqcn";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getRootTagName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

