/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.res.AndroidProjectRootListener;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidDependenciesCache
implements Disposable {
    private static final Key<AndroidDependenciesCache> KEY = Key.create((String)AndroidDependenciesCache.class.getName());
    private final Module myModule;
    private final AtomicReference<List<WeakReference<AndroidFacet>>> myAllDependencies;
    private final AtomicReference<List<WeakReference<AndroidFacet>>> myAllLibraryDependencies;

    private AndroidDependenciesCache(@NotNull Module module2) {
        if (module2 == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(0);
        }
        this.myAllDependencies = new AtomicReference();
        this.myAllLibraryDependencies = new AtomicReference();
        this.myModule = module2;
        AndroidProjectRootListener.ensureSubscribed(module2.getProject());
        MessageBusConnection busConnection = module2.getProject().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet2) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                AndroidDependenciesCache.this.dropCache();
            }

            public void facetRemoved(@NotNull Facet facet2) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                AndroidDependenciesCache.this.dropCache();
            }

            public void facetConfigurationChanged(@NotNull Facet facet2) {
                if (facet2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                AndroidDependenciesCache.this.dropCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "org/jetbrains/android/util/AndroidDependenciesCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module2) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                AndroidDependenciesCache.this.dropCache();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module2) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (module2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                AndroidDependenciesCache.this.dropCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/android/util/AndroidDependenciesCache$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
    }

    public synchronized void dropCache() {
        this.myAllDependencies.set(null);
        this.myAllLibraryDependencies.set(null);
    }

    @NotNull
    public static synchronized AndroidDependenciesCache getInstance(@NotNull Module module2) {
        AndroidDependenciesCache cache;
        if (module2 == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(1);
        }
        if ((cache = (AndroidDependenciesCache)module2.getUserData(KEY)) == null) {
            cache = new AndroidDependenciesCache(module2);
            Disposer.register((Disposable)module2, (Disposable)cache);
            module2.putUserData(KEY, (Object)cache);
        }
        AndroidDependenciesCache androidDependenciesCache = cache;
        if (androidDependenciesCache == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(2);
        }
        return androidDependenciesCache;
    }

    @NotNull
    public synchronized List<AndroidFacet> getAllAndroidDependencies(boolean androidLibrariesOnly) {
        return AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, androidLibrariesOnly, this.getListRef(androidLibrariesOnly));
    }

    @NotNull
    private AtomicReference<List<WeakReference<AndroidFacet>>> getListRef(boolean androidLibrariesOnly) {
        AtomicReference<List<WeakReference<AndroidFacet>>> atomicReference = androidLibrariesOnly ? this.myAllLibraryDependencies : this.myAllDependencies;
        if (atomicReference == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(3);
        }
        return atomicReference;
    }

    @NotNull
    private static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module2, boolean androidLibrariesOnly, @NotNull AtomicReference<List<WeakReference<AndroidFacet>>> listRef) {
        if (module2 == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(4);
        }
        if (listRef == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(5);
        }
        if (module2.isDisposed()) {
            List<AndroidFacet> list = Collections.emptyList();
            if (list == null) {
                AndroidDependenciesCache.$$$reportNull$$$0(6);
            }
            return list;
        }
        List refs = listRef.get();
        if (refs == null) {
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            AndroidDependenciesCache.collectAllAndroidDependencies(module2, androidLibrariesOnly, facets, new HashSet<AndroidFacet>());
            refs = ContainerUtil.map((Collection)ContainerUtil.reverse(facets), facet2 -> new WeakReference<AndroidFacet>((AndroidFacet)facet2));
            listRef.set(refs);
        }
        return AndroidDependenciesCache.dereference(refs);
    }

    @NotNull
    private static List<AndroidFacet> dereference(@NotNull List<WeakReference<AndroidFacet>> refs) {
        if (refs == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.mapNotNull(refs, ref -> {
            AndroidFacet facet2 = (AndroidFacet)ref.get();
            if (facet2 == null) {
                AndroidDependenciesCache.logNullReference();
                return null;
            }
            if (facet2.isDisposed()) {
                AndroidDependenciesCache.logDisposedFacet();
                return null;
            }
            AndroidFacet facetFromModule = AndroidFacet.getInstance((Module)facet2.getModule());
            if (facetFromModule == null) {
                AndroidDependenciesCache.logNonAndroidModule();
                return null;
            }
            if (facetFromModule != facet2) {
                AndroidDependenciesCache.logObsoleteFacet();
                return null;
            }
            return facet2;
        });
        if (list == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void logObsoleteFacet() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("obsolete facet");
    }

    private static void logNonAndroidModule() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("non-Android module");
    }

    private static void logDisposedFacet() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("disposed facet");
    }

    private static void logNullReference() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("null in dereference");
    }

    private static void collectAllAndroidDependencies(@NotNull Module module2, boolean androidLibrariesOnly, @NotNull List<AndroidFacet> result2, @NotNull Set<AndroidFacet> visited) {
        AndroidFacet facet2;
        if (module2 == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(10);
        }
        if (visited == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(11);
        }
        boolean isDynamicFeature = (facet2 = AndroidFacet.getInstance((Module)module2)) != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 6;
        OrderEntry[] entries = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        int i2 = entries.length;
        while (--i2 >= 0) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            ProgressManager.checkCanceled();
            OrderEntry orderEntry = entries[i2];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || androidLibrariesOnly && ((AndroidFacetConfiguration)depFacet.getConfiguration()).isAppProject() && !isDynamicFeature || !visited.add(depFacet)) continue;
            List<WeakReference<AndroidFacet>> cachedDepDeps = AndroidDependenciesCache.getInstance(depModule).getListRef(androidLibrariesOnly).get();
            if (cachedDepDeps != null) {
                List<AndroidFacet> depDeps = AndroidDependenciesCache.dereference(cachedDepDeps);
                for (AndroidFacet depDepFacet : depDeps) {
                    if (!visited.add(depDepFacet)) continue;
                    result2.add(depDepFacet);
                }
            } else {
                AndroidDependenciesCache.collectAllAndroidDependencies(depModule, androidLibrariesOnly, result2, visited);
            }
            result2.add(depFacet);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidDependenciesCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listRef";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidDependenciesCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListRef";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dereference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllAndroidDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectAllAndroidDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

