/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.SdkConstants;
import com.android.layoutlib.bridge.MockView;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.classloading.InconvertibleClassError;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ViewLoaderExtension;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLoader {
    private static final Logger LOG = Logger.getInstance(ViewLoader.class);
    private static final int ALLOWED_NESTED_VIEWS = 100;
    @NotNull
    private final Module myModule;
    @NotNull
    private final Map<String, Class<?>> myLoadedClasses;
    @NotNull
    private final Multiset<Class<?>> myLoadingClasses;
    @NotNull
    private final Set<String> myRecentlyModifiedClasses;
    @Nullable
    private final Object myCredential;
    @NotNull
    private final LayoutLibrary myLayoutLibrary;
    @NotNull
    private IRenderLogger myLogger;
    @NotNull
    private final ModuleClassLoader myModuleClassLoader;

    public ViewLoader(@NotNull LayoutLibrary layoutLib, @NotNull AndroidFacet facet2, @NotNull IRenderLogger logger2, @Nullable Object credential, @NotNull ModuleClassLoader classLoader) {
        if (layoutLib == null) {
            ViewLoader.$$$reportNull$$$0(0);
        }
        if (facet2 == null) {
            ViewLoader.$$$reportNull$$$0(1);
        }
        if (logger2 == null) {
            ViewLoader.$$$reportNull$$$0(2);
        }
        if (classLoader == null) {
            ViewLoader.$$$reportNull$$$0(3);
        }
        this.myLoadedClasses = Maps.newHashMap();
        this.myLoadingClasses = HashMultiset.create((int)5);
        this.myRecentlyModifiedClasses = Sets.newHashSetWithExpectedSize((int)5);
        this.myLayoutLibrary = layoutLib;
        this.myModule = facet2.getModule();
        this.myLogger = logger2;
        this.myCredential = credential;
        this.myModuleClassLoader = classLoader;
    }

    public void setLogger(@NotNull IRenderLogger logger2) {
        if (logger2 == null) {
            ViewLoader.$$$reportNull$$$0(4);
        }
        this.myLogger = logger2;
    }

    @Nullable
    private static String getRClassName(@NotNull Module module2) {
        if (module2 == null) {
            ViewLoader.$$$reportNull$$$0(5);
        }
        return (String)ApplicationManager.getApplication().runReadAction(() -> {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null) {
                return null;
            }
            Manifest manifest = Manifest.getMainManifest(facet2);
            if (manifest == null) {
                return null;
            }
            String packageName = (String)manifest.getPackage().getValue();
            return packageName == null ? null : packageName + ".R";
        });
    }

    @Nullable
    public Object loadClass(String className2, Class<?>[] constructorSignature, Object[] constructorArgs) {
        if (SdkConstants.CLASS_RECYCLER_VIEW_ADAPTER.isEquals(className2)) {
            className2 = "com.android.layoutlib.bridge.android.support.Adapter";
            constructorSignature = ArrayUtilRt.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return this.loadClass(className2, constructorSignature, constructorArgs, false);
    }

    @Nullable
    public Object loadView(@NotNull String className2, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        Object aClass;
        if (className2 == null) {
            ViewLoader.$$$reportNull$$$0(6);
        }
        if ((aClass = this.loadClass(className2, constructorSignature, constructorArgs, true)) != null) {
            return aClass;
        }
        try {
            Object o = this.createViewFromSuperclass(className2, constructorSignature, constructorArgs);
            if (o != null) {
                return o;
            }
            return this.createMockView(className2, constructorSignature, constructorArgs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException(className2, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object loadClass(@NotNull String className2, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs, boolean isView) {
        block16: {
            Object object;
            if (className2 == null) {
                ViewLoader.$$$reportNull$$$0(7);
            }
            Class<?> aClass = this.myLoadedClasses.get(className2);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("loadClassA(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
            }
            if (aClass != null) {
                this.checkModified(className2);
                return this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
            }
            aClass = this.loadClass(className2, isView);
            if (aClass == null) break block16;
            this.checkModified(className2);
            if (this.myLoadingClasses.count(aClass) > 100) {
                throw new InstantiationException("The layout involves creation of " + className2 + " over 100 levels deep. Infinite recursion?");
            }
            this.myLoadingClasses.add(aClass);
            try {
                Object viewObject = this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
                this.myLoadedClasses.put(className2, aClass);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  instance created");
                }
                object = viewObject;
            }
            catch (Throwable throwable) {
                try {
                    this.myLoadingClasses.remove(aClass);
                    throw throwable;
                }
                catch (InconvertibleClassError e) {
                    this.myLogger.addIncorrectFormatClass(e.getClassName(), e);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    break block16;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e);
                    }
                    this.myLogger.addBrokenClass(className2, e);
                    break block16;
                }
                catch (InvocationTargetException e) {
                    Throwable cause;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    if ((cause = e.getCause()) instanceof InconvertibleClassError) {
                        InconvertibleClassError error = (InconvertibleClassError)cause;
                        this.myLogger.addIncorrectFormatClass(error.getClassName(), error);
                        break block16;
                    }
                    this.myLogger.addBrokenClass(className2, cause);
                }
            }
            this.myLoadingClasses.remove(aClass);
            return object;
        }
        return null;
    }

    public boolean isClassLoaded(String name) {
        return this.myLoadedClasses.containsKey(name);
    }

    @NotNull
    private List<ViewLoaderExtension> getExtensions() {
        ExtensionsArea area = this.myModule.getProject().getExtensionArea();
        ExtensionPoint point = area.getExtensionPointIfRegistered(ViewLoaderExtension.EP_NAME.getName());
        List list = point == null ? Collections.emptyList() : point.getExtensionList();
        if (list == null) {
            ViewLoader.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void checkModified(@NotNull String fqcn) {
        if (fqcn == null) {
            ViewLoader.$$$reportNull$$$0(9);
        }
        if (DumbService.getInstance((Project)this.myModule.getProject()).isDumb()) {
            return;
        }
        if (this.myModuleClassLoader != null && this.myModuleClassLoader.isSourceModified(fqcn, this.myCredential) && !this.myRecentlyModifiedClasses.contains(fqcn)) {
            this.myRecentlyModifiedClasses.add(fqcn);
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            HtmlBuilder builder2 = problem.getHtmlBuilder();
            String className2 = fqcn.substring(fqcn.lastIndexOf(46) + 1);
            builder2.addLink("The " + className2 + " custom view has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createBuildProjectUrl());
            this.myLogger.addMessage(problem);
        }
    }

    @NotNull
    private MockView createMockView(@NotNull String className2, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        String label;
        if (className2 == null) {
            ViewLoader.$$$reportNull$$$0(10);
        }
        MockView mockView = (MockView)this.createNewInstance(MockView.class, constructorSignature, constructorArgs, true);
        switch (label = ViewLoader.getShortClassName(className2)) {
            case "fragment": {
                label = "<fragment>";
                break;
            }
            case "include": {
                label = "Text";
            }
        }
        mockView.setText((CharSequence)label);
        mockView.setGravity(17);
        MockView mockView2 = mockView;
        if (mockView2 == null) {
            ViewLoader.$$$reportNull$$$0(11);
        }
        return mockView2;
    }

    @NotNull
    public Module getModule() {
        Module module2 = this.myModule;
        if (module2 == null) {
            ViewLoader.$$$reportNull$$$0(12);
        }
        return module2;
    }

    @VisibleForTesting
    @NotNull
    static String getShortClassName(@NotNull String fqcn) {
        if (fqcn == null) {
            ViewLoader.$$$reportNull$$$0(13);
        }
        int first = fqcn.indexOf(46);
        int last = fqcn.lastIndexOf(46);
        if (fqcn.startsWith("android.")) {
            if (last > first) {
                String string = fqcn.substring(0, first) + ".." + fqcn.substring(last);
                if (string == null) {
                    ViewLoader.$$$reportNull$$$0(14);
                }
                return string;
            }
        } else if (last > (first = fqcn.indexOf(46, first + 1)) && first >= 0) {
            String string = fqcn.substring(0, first) + ".." + fqcn.substring(last);
            if (string == null) {
                ViewLoader.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = fqcn;
        if (string == null) {
            ViewLoader.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private Object createNewInstance(@NotNull Class<?> clazz, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorParameters, boolean isView) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        block12: {
            if (clazz == null) {
                ViewLoader.$$$reportNull$$$0(17);
            }
            constructor = null;
            try {
                constructor = clazz.getConstructor(constructorSignature);
            }
            catch (NoSuchMethodException e) {
                int paramsCount;
                if (!isView) {
                    throw e;
                }
                int n = paramsCount = constructorSignature != null ? constructorSignature.length : 0;
                if (paramsCount == 0) {
                    throw e;
                }
                assert (constructorParameters != null);
                for (int i2 = 3; i2 >= 1; --i2) {
                    if (i2 == paramsCount) continue;
                    int k = paramsCount < i2 ? paramsCount : i2;
                    Class[] sig = new Class[i2];
                    System.arraycopy(constructorSignature, 0, sig, 0, k);
                    Object[] params = new Object[i2];
                    System.arraycopy(constructorParameters, 0, params, 0, k);
                    for (int j = k + 1; j <= i2; ++j) {
                        if (j == 2) {
                            sig[j - 1] = this.myLayoutLibrary.getClassLoader().loadClass("android.util.AttributeSet");
                            params[j - 1] = null;
                            continue;
                        }
                        if (j != 3) continue;
                        sig[j - 1] = Integer.TYPE;
                        params[j - 1] = 0;
                    }
                    constructorSignature = sig;
                    constructorParameters = params;
                    try {
                        constructor = clazz.getConstructor(constructorSignature);
                        if (constructor == null) continue;
                        if (constructorSignature.length >= 2) break;
                        LOG.info("wrong_constructor: Custom view " + clazz.getSimpleName() + " is not using the 2- or 3-argument View constructors; XML attributes will not work");
                        this.myLogger.warning("wrongconstructor", String.format("Custom view %1$s is not using the 2- or 3-argument View constructors; XML attributes will not work", clazz.getSimpleName()), null, null);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (constructor != null) break block12;
                throw e;
            }
        }
        constructor.setAccessible(true);
        Object obj = constructor.newInstance(constructorParameters);
        if (obj == null) {
            ViewLoader.$$$reportNull$$$0(18);
        }
        return obj;
    }

    @Nullable
    public Class<?> loadClass(@NotNull String className2, boolean logError2) throws InconvertibleClassError {
        if (className2 == null) {
            ViewLoader.$$$reportNull$$$0(19);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassB(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
        }
        try {
            for (ViewLoaderExtension extension : this.getExtensions()) {
                Class<?> loadedClass = extension.loadClass(className2, this.myModuleClassLoader);
                if (loadedClass == null) continue;
                return loadedClass;
            }
            return this.myModuleClassLoader.loadClass(className2);
        }
        catch (ClassNotFoundException e) {
            if (logError2 && !className2.equals("fragment")) {
                this.myLogger.addMissingClass(className2);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object createViewFromSuperclass(@NotNull String className2, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) {
        if (className2 == null) {
            ViewLoader.$$$reportNull$$$0(20);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("createViewFromSuperClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
        }
        Ref token = new Ref();
        token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
        try {
            Object object = ApplicationManager.getApplication().runReadAction(() -> {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
                PsiClass psiClass = facade.findClass(className2, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
                if (psiClass == null) {
                    return null;
                }
                HashSet<String> visited = new HashSet<String>();
                for (psiClass = psiClass.getSuperClass(); psiClass != null; psiClass = psiClass.getSuperClass()) {
                    Object object;
                    String qName = psiClass.getQualifiedName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  parent " + LogAnonymizerUtil.anonymizeClassName((String)qName));
                    }
                    if (qName == null || !visited.add(qName) || "android.view.View".equals(psiClass.getQualifiedName())) break;
                    if (AndroidUtils.isAbstract(psiClass)) continue;
                    Class<?> aClass = this.myLoadedClasses.get(qName);
                    if (aClass == null && this.myLayoutLibrary.getClassLoader() != null && (aClass = this.myLayoutLibrary.getClassLoader().loadClass(qName)) != null) {
                        this.myLoadedClasses.put(qName, aClass);
                    }
                    if (aClass == null) continue;
                    try {
                        RenderSecurityManager.exitSafeRegion((Boolean)token.get());
                        object = this.createNewInstance(aClass, constructorSignature, constructorArgs, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                            throw throwable;
                        }
                        catch (Throwable e) {
                            LOG.debug(e);
                        }
                    }
                    token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                    return object;
                }
                return null;
            });
            return object;
        }
        finally {
            RenderSecurityManager.exitSafeRegion((Boolean)token.get());
        }
    }

    public void loadAndParseRClassSilently() {
        String rClassName = ViewLoader.getRClassName(this.myModule);
        try {
            if (rClassName == null) {
                LOG.info(String.format("loadAndParseRClass: failed to find manifest package for project %1$s", this.myModule.getProject().getName()));
                return;
            }
            this.myLogger.setResourceClass(rClassName);
            this.loadAndParseRClass(rClassName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.myLogger.setMissingResourceClass();
        }
        catch (InconvertibleClassError e) {
            assert (rClassName != null);
            this.myLogger.addIncorrectFormatClass(rClassName, e);
        }
    }

    @VisibleForTesting
    void loadAndParseRClass(@NotNull String className2) throws ClassNotFoundException, InconvertibleClassError {
        if (className2 == null) {
            ViewLoader.$$$reportNull$$$0(21);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
        }
        Class<?> aClass = this.myLoadedClasses.get(className2);
        ResourceIdManager idManager = ResourceIdManager.get(this.myModule);
        if (aClass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  The R class is not loaded.");
            }
            boolean isClassLoaded = this.myModuleClassLoader.isClassLoaded(className2);
            aClass = this.myModuleClassLoader.loadClass(className2);
            if (!isClassLoaded) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  Class found in module %s, first time load.", LogAnonymizerUtil.anonymize((Module)this.myModule)));
                }
                idManager.resetDynamicIds();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  Class already loaded in module %s.", LogAnonymizerUtil.anonymize((Module)this.myModule)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Class loaded");
            }
            this.myLoadedClasses.put(className2, aClass);
            this.myLogger.setHasLoadedClasses();
        }
        idManager.loadCompiledIds(aClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("END loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName((String)className2)));
        }
    }

    public boolean hasLoadedClass(@NotNull String classFqn) {
        if (classFqn == null) {
            ViewLoader.$$$reportNull$$$0(22);
        }
        return this.myModuleClassLoader.isClassLoaded(classFqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutLib";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/ViewLoader";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/ViewLoader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortClassName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLogger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRClassName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadView";
                break;
            }
            case 7: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkModified";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMockView";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getShortClassName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createNewInstance";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createViewFromSuperclass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadAndParseRClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

